/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractSignedIntegerDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.UnsignedLongDataType;

public class LongDataType
extends AbstractSignedIntegerDataType {
    public static final LongDataType dataType = new LongDataType();

    public LongDataType() {
        this(null);
    }

    public LongDataType(DataTypeManager dtm) {
        super("long", dtm);
    }

    @Override
    public int getLength() {
        return this.getDataOrganization().getLongSize();
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Signed Long Integer (compiler-specific size)";
    }

    @Override
    public String getCDeclaration() {
        return "long";
    }

    @Override
    public UnsignedLongDataType getOppositeSignednessDataType() {
        return UnsignedLongDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public LongDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new LongDataType(dtm);
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return null;
    }
}

