/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.action.DockingAction;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.KeyStroke;

public class NextPreviousWindowAction
extends DockingAction {
    private boolean forward;

    public NextPreviousWindowAction(KeyStroke keybinding, boolean forward) {
        super(forward ? "Next Window" : "Previous Window", "DockingWindows");
        this.forward = forward;
        this.createSystemKeyBinding(keybinding);
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionContext context) {
        int currentIndex;
        Window[] windows = Window.getWindows();
        Window nextWindow = this.findNextValidWindow(windows, currentIndex = this.getIndexForCurrentWindow(windows));
        if (nextWindow != null) {
            nextWindow.toFront();
        }
    }

    private int getIndexForCurrentWindow(Window[] windows) {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        for (int i = 0; i < windows.length; ++i) {
            if (window != windows[i]) continue;
            return i;
        }
        return 0;
    }

    private Window findNextValidWindow(Window[] windows, int currentIndex) {
        int candidateIndex = this.nextIndex(windows, currentIndex);
        while (candidateIndex != currentIndex) {
            if (this.isValid(windows[candidateIndex])) {
                return windows[candidateIndex];
            }
            candidateIndex = this.nextIndex(windows, candidateIndex);
        }
        return null;
    }

    private boolean isValid(Window window) {
        return window.isVisible();
    }

    private int nextIndex(Window[] windows, int index) {
        if (this.forward) {
            int next = index + 1;
            return next >= windows.length ? 0 : next;
        }
        int previous = index - 1;
        return previous < 0 ? windows.length - 1 : previous;
    }
}

