/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootldr;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class AndroidBootLoaderImageInfo
implements StructConverter {
    private String name;
    private int size;

    public AndroidBootLoaderImageInfo(BinaryReader reader) throws IOException {
        this.name = reader.readNextAsciiString(64).trim();
        this.size = reader.readNextInt();
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("img_info", 0);
        struct.add(STRING, 64, "magic", null);
        struct.add(DWORD, "size", null);
        return struct;
    }
}

