/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.lzfse;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.lzfse.LzfseFileSystemFactory;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.SingleFileSystemIndexHelper;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;

@FileSystemInfo(type="lzfse", description="LZFSE", factory=LzfseFileSystemFactory.class, priority=10)
public class LzfseFileSystem
implements GFileSystem {
    private FSRLRoot fsFSRL;
    private SingleFileSystemIndexHelper fsIndex;
    private FileSystemRefManager fsRefManager = new FileSystemRefManager((GFileSystem)this);
    private ByteProvider decompressedProvider;

    public LzfseFileSystem(FSRLRoot fsrlRoot, File decompressedFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Decompressing LZFSE...");
        this.fsFSRL = fsrlRoot;
        String name = "lzfse_decompressed";
        this.decompressedProvider = fsService.pushFileToCache(decompressedFile, this.fsFSRL.appendPath(name), monitor);
        this.fsIndex = new SingleFileSystemIndexHelper((GFileSystem)this, this.fsFSRL, name, this.decompressedProvider.length(), this.decompressedProvider.getFSRL().getMD5());
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    public FileSystemRefManager getRefManager() {
        return this.fsRefManager;
    }

    public boolean isClosed() {
        return this.decompressedProvider == null;
    }

    public void close() throws IOException {
        this.fsRefManager.onClose();
        if (this.decompressedProvider != null) {
            this.decompressedProvider.close();
            this.decompressedProvider = null;
        }
        this.fsIndex.clear();
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException {
        return this.fsIndex.isPayloadFile(file) ? new ByteProviderWrapper(this.decompressedProvider, file.getFSRL()) : null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsIndex.getListing(directory);
    }

    public GFile lookup(String path) throws IOException {
        return this.fsIndex.lookup(path);
    }

    public GFile lookup(String path, Comparator<String> nameComp) throws IOException {
        return this.fsIndex.lookup(null, path, nameComp);
    }
}

