/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import generic.theme.GColor;
import ghidra.app.services.MarkerService;
import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.awt.Color;
import java.math.BigInteger;

public class MarkerServiceBackgroundColorModel
implements ListingBackgroundColorModel {
    private MarkerService markerService;
    private Program program;
    private AddressIndexMap indexMap;
    private Color defaultBackgroundColor = new GColor("color.bg.markerservice");

    public MarkerServiceBackgroundColorModel(MarkerService markerService, Program program, AddressIndexMap indexMap) {
        this.markerService = markerService;
        this.program = program;
        this.indexMap = indexMap;
    }

    public MarkerServiceBackgroundColorModel(MarkerService markerService, AddressIndexMap indexMap) {
        this(markerService, null, indexMap);
    }

    public Color getBackgroundColor(BigInteger index) {
        Address addr = this.indexMap.getAddress(index);
        Color color = null;
        if (addr != null && this.program != null) {
            color = this.markerService.getBackgroundColor(this.program, addr);
        }
        if (color == null) {
            color = this.defaultBackgroundColor;
        }
        return color;
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color c) {
        this.defaultBackgroundColor = c;
    }

    @Override
    public void modelDataChanged(ListingPanel listingPanel) {
        this.program = listingPanel.getProgram();
        this.indexMap = listingPanel.getAddressIndexMap();
    }
}

