/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.cmd.refs.RemoveAllReferencesCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.references.ReferencesPlugin;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;

public class DeleteReferencesAction
extends ListingContextAction {
    static String DEFAULT_MENU_ITEM_NAME = "Delete References";
    static String MEMORY_MENU_ITEM_NAME = "Delete Memory References";
    static String STACK_MENU_ITEM_NAME = "Delete Stack Reference";
    static String REGISTER_MENU_ITEM_NAME = "Delete Register Reference";
    static String EXTERNAL_MENU_ITEM_NAME = "Delete External Reference";
    private ReferencesPlugin plugin;

    public DeleteReferencesAction(ReferencesPlugin plugin) {
        super("Delete References From", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"References", DEFAULT_MENU_ITEM_NAME}, null, "ShowReferences"));
        this.setKeyBindingData(new KeyBindingData(127, 0));
        this.setDescription("Delete all references from a code unit operand");
    }

    @Override
    protected void actionPerformed(ListingActionContext context) {
        int opIndex = -1;
        ProgramLocation loc = context.getLocation();
        if (loc instanceof OperandFieldLocation) {
            opIndex = ((OperandFieldLocation)loc).getOperandIndex();
        }
        RemoveAllReferencesCmd cmd = new RemoveAllReferencesCmd(loc.getAddress(), opIndex);
        this.plugin.getTool().execute((Command)cmd, (DomainObject)context.getProgram());
    }

    @Override
    protected boolean isAddToPopup(ListingActionContext context) {
        ProgramLocation loc = context.getLocation();
        return loc instanceof CodeUnitLocation;
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        int opIndex;
        boolean actionOK = false;
        ProgramLocation loc = context.getLocation();
        if (!(loc instanceof CodeUnitLocation)) {
            return false;
        }
        this.getPopupMenuData().setMenuItemName(DEFAULT_MENU_ITEM_NAME);
        if (loc instanceof MnemonicFieldLocation) {
            opIndex = -1;
        } else if (loc instanceof OperandFieldLocation) {
            opIndex = ((OperandFieldLocation)loc).getOperandIndex();
        } else {
            this.setEnabled(false);
            return false;
        }
        Reference[] refs = context.getProgram().getReferenceManager().getReferencesFrom(context.getAddress(), opIndex);
        if (refs.length != 0) {
            actionOK = true;
            Address toAddr = refs[0].getToAddress();
            if (toAddr.isMemoryAddress()) {
                this.getPopupMenuData().setMenuItemName(MEMORY_MENU_ITEM_NAME);
            } else if (toAddr.isExternalAddress()) {
                this.getPopupMenuData().setMenuItemName(EXTERNAL_MENU_ITEM_NAME);
            } else if (refs[0].isStackReference()) {
                this.getPopupMenuData().setMenuItemName(STACK_MENU_ITEM_NAME);
            } else if (refs[0].getToAddress().isRegisterAddress()) {
                this.getPopupMenuData().setMenuItemName(REGISTER_MENU_ITEM_NAME);
            } else {
                actionOK = false;
            }
        }
        return actionOK;
    }
}

