/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.format.golang.rtti.GoFuncData;
import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.address.Address;
import java.io.IOException;

@StructureMapping(structureName={"runtime.functab"})
public class GoFunctabEntry {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoFunctabEntry> context;
    @FieldMapping(presentWhen="1.18+")
    @MarkupReference(value="getFuncAddress")
    private long entryoff;
    @FieldMapping(presentWhen="-1.17")
    @MarkupReference(value="getFuncAddress")
    private long entry;
    @FieldMapping
    @MarkupReference(value="getFuncData")
    private long funcoff;
    private Address funcAddress;

    public void setEntryoff(long entryoff) {
        this.entryoff = entryoff;
        GoModuledata moduledata = this.getModuledata();
        this.funcAddress = moduledata != null ? moduledata.getText().add(entryoff) : null;
    }

    public void setEntry(long entry) {
        this.entry = entry;
        this.funcAddress = this.programContext.getCodeAddress(entry);
    }

    public Address getFuncAddress() {
        return this.funcAddress;
    }

    @Markup
    public GoFuncData getFuncData() throws IOException {
        GoModuledata moduledata = this.getModuledata();
        return this.funcoff != 0L && moduledata != null ? moduledata.getFuncDataInstance(this.funcoff) : null;
    }

    public long getFuncoff() {
        return this.funcoff;
    }

    private GoModuledata getModuledata() {
        return this.programContext.findContainingModuleByFuncData(this.context.getStructureStart());
    }
}

