/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Method;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_Method;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodList;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC1_MethodList
extends ObjectiveC_MethodList {
    public static final String NAME = "objc_method_list";
    private ObjectiveC1_MethodList obsolete;
    private int method_count;

    ObjectiveC1_MethodList(ObjectiveC1_State state, BinaryReader reader, ObjectiveC_MethodType methodType) throws IOException {
        super(state, reader, NAME);
        if (this._index == 0L) {
            return;
        }
        this.obsolete = new ObjectiveC1_MethodList(state, reader.clone(reader.readNextInt()), methodType);
        this.method_count = reader.readNextInt();
        for (int i = 0; i < this.method_count; ++i) {
            this.methods.add(new ObjectiveC1_Method(state, reader, methodType));
        }
    }

    public ObjectiveC1_MethodList getObsolete() {
        return this.obsolete;
    }

    public int getMethodCount() {
        return this.method_count;
    }

    public static DataType toGenericDataType(ObjectiveC1_State state) throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)struct, (int)state.pointerSize), "obsolete", null);
        struct.add(DWORD, "method_count", null);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_method_list_" + this.method_count + "_", 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        if (this.obsolete == null) {
            struct.add((DataType)PointerDataType.getPointer((DataType)VOID, (int)this._state.pointerSize), "obsolete", null);
        } else {
            DataType obsoleteDT = this.obsolete.toDataType();
            struct.add((DataType)PointerDataType.getPointer((DataType)obsoleteDT, (int)this._state.pointerSize), "obsolete", null);
        }
        struct.add(DWORD, "method_count", null);
        if (this.method_count > 0) {
            DataType dt = ((ObjectiveC_Method)this.methods.get(0)).toDataType();
            struct.add((DataType)new ArrayDataType(dt, this.method_count, dt.getLength()), "method_list", null);
        }
        return struct;
    }
}

