/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public abstract class OmfRecord
implements StructConverter {
    protected int recordType;
    protected int recordLength;
    protected byte[] data;
    protected byte checkSum;
    protected long recordOffset;
    protected BinaryReader dataReader;
    protected long dataEnd;

    public OmfRecord() {
    }

    public OmfRecord(BinaryReader reader) throws IOException {
        this.recordOffset = reader.getPointerIndex();
        this.recordType = reader.readNextUnsignedByte();
        this.recordLength = reader.readNextUnsignedShort();
        this.data = reader.readNextByteArray(this.recordLength - 1);
        this.checkSum = reader.readNextByte();
        this.dataReader = reader.clone(this.recordOffset + 3L);
        this.dataEnd = this.recordOffset + 3L + (long)this.recordLength - 1L;
    }

    public abstract void parseData() throws IOException, OmfException;

    @Override
    public abstract DataType toDataType() throws DuplicateNameException, IOException;

    public int getRecordType() {
        return this.recordType;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public long getRecordOffset() {
        return this.recordOffset;
    }

    public byte getRecordChecksum() {
        return this.checkSum;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte calcCheckSum() throws IOException {
        byte sum = (byte)this.recordType;
        sum = (byte)(sum + ((byte)this.recordLength + (byte)(this.recordLength >> 8)));
        for (byte b : this.data) {
            sum = (byte)(sum + b);
        }
        sum = (byte)(sum + this.checkSum);
        return sum;
    }

    public boolean validCheckSum() throws IOException {
        if (this.checkSum == 0) {
            return true;
        }
        return this.calcCheckSum() == 0;
    }

    public boolean hasBigFields() {
        return (this.recordType & 1) != 0;
    }

    public String toString() {
        return String.format("type: 0x%x, offset: 0x%x, length: 0x%x", this.recordType, this.recordOffset, this.recordLength);
    }
}

