/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.panel;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.widgets.TitledPanel;
import generic.theme.GThemeDefaults;
import ghidra.features.base.codecompare.panel.ComparisonData;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.datastruct.Duo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;

public abstract class CodeComparisonPanel
extends JPanel
implements ExtensionPoint {
    public static final String HELP_TOPIC = "FunctionComparison";
    private static final Color ACTIVE_BORDER_COLOR = GThemeDefaults.Colors.Palette.getColor((String)"lightpink");
    private static final int MINIMUM_PANEL_WIDTH = 50;
    private static final Border NON_ACTIVE_BORDER = BorderFactory.createEmptyBorder(3, 3, 3, 3);
    private static final Border ACTIVE_BORDER = BorderFactory.createMatteBorder(3, 3, 3, 3, ACTIVE_BORDER_COLOR);
    protected String owner;
    protected PluginTool tool;
    protected Duo<ComparisonData> comparisonData = new Duo((Object)ComparisonData.EMPTY, (Object)ComparisonData.EMPTY);
    private Duo<String> titlePrefixes = new Duo((Object)"", (Object)"");
    private Duo<TitledPanel> titlePanels = new Duo();
    protected Duo.Side activeSide = Duo.Side.LEFT;
    private JSplitPane splitPane;
    private ToggleOrientationAction toggleOrientationAction;
    private JComponent northComponent;
    private boolean showTitles = true;

    protected CodeComparisonPanel(String owner, PluginTool tool) {
        this.owner = owner;
        this.tool = tool;
        this.toggleOrientationAction = new ToggleOrientationAction(this.getName());
    }

    public PluginTool getTool() {
        return this.tool;
    }

    public void loadComparisons(ComparisonData left, ComparisonData right) {
        if (this.comparisonData.equals((Object)left, (Object)right)) {
            return;
        }
        this.comparisonData = new Duo((Object)left, (Object)right);
        this.comparisonDataChanged();
        this.updateTitles();
    }

    public void clearComparisons() {
        this.loadComparisons(ComparisonData.EMPTY, ComparisonData.EMPTY);
    }

    public List<DockingAction> getActions() {
        ArrayList<DockingAction> actionList = new ArrayList<DockingAction>();
        actionList.add((DockingAction)this.toggleOrientationAction);
        return actionList;
    }

    public void setShowDataTitles(boolean showTitles) {
        this.showTitles = showTitles;
    }

    public boolean isSideBySide() {
        return this.toggleOrientationAction.isSelected();
    }

    public void setSideBySide(boolean b) {
        this.toggleOrientationAction.setSelected(b);
        this.updateOrientation();
    }

    @Override
    public abstract String getName();

    public abstract void dispose();

    public abstract ActionContext getActionContext(ComponentProvider var1, MouseEvent var2);

    public void programRestored(Program program) {
        this.updateTitles();
    }

    public void programClosed(Program program) {
    }

    public Duo.Side getActiveSide() {
        return this.activeSide;
    }

    public void setTopComponent(JComponent component) {
        if (this.northComponent != null) {
            this.remove(this.northComponent);
        }
        this.northComponent = component;
        if (this.northComponent != null) {
            this.add((Component)this.northComponent, "North");
        }
        this.validate();
    }

    public void setTitlePrefixes(String leftTitlePrefix, String rightTitlePrefix) {
        this.titlePrefixes = new Duo((Object)leftTitlePrefix, (Object)rightTitlePrefix);
        this.updateTitles();
    }

    public Program getProgram(Duo.Side side) {
        return ((ComparisonData)this.comparisonData.get(side)).getProgram();
    }

    public Function getFunction(Duo.Side side) {
        return ((ComparisonData)this.comparisonData.get(side)).getFunction();
    }

    public AddressSetView getAddresses(Duo.Side side) {
        return ((ComparisonData)this.comparisonData.get(side)).getAddressSet();
    }

    public abstract void updateActionEnablement();

    public abstract void setSynchronizedScrolling(boolean var1);

    public abstract JComponent getComparisonComponent(Duo.Side var1);

    protected abstract void comparisonDataChanged();

    private final String getTitle(Duo.Side side) {
        return ((ComparisonData)this.comparisonData.get(side)).getDescription();
    }

    private void updateTitles() {
        this.updateTitle(Duo.Side.LEFT);
        this.updateTitle(Duo.Side.RIGHT);
    }

    private void updateTitle(Duo.Side side) {
        String title = this.showTitles ? this.getTitle(side) : "";
        this.setTitle((TitledPanel)this.titlePanels.get(side), (String)this.titlePrefixes.get(side), title);
    }

    private void updateOrientation() {
        int orientation = this.toggleOrientationAction.isSelected() ? 1 : 0;
        this.splitPane.setOrientation(orientation);
        this.splitPane.setDividerLocation(0.5);
    }

    private void setTitle(TitledPanel titlePanel, String titlePrefix, String title) {
        String htmlPrefix;
        if (!((String)titlePrefix).isEmpty()) {
            titlePrefix = (String)titlePrefix + " ";
        }
        if (title.startsWith(htmlPrefix = "<html>")) {
            titlePanel.setTitleName(htmlPrefix + HTMLUtilities.friendlyEncodeHTML((String)titlePrefix) + title.substring(htmlPrefix.length()));
        } else {
            titlePanel.setTitleName((String)titlePrefix + title);
        }
    }

    protected final void buildPanel() {
        this.setLayout(new BorderLayout());
        TitledPanel leftPanel = new TitledPanel(this.getTitle(Duo.Side.LEFT), this.getComparisonComponent(Duo.Side.LEFT), 5);
        TitledPanel rightPanel = new TitledPanel(this.getTitle(Duo.Side.RIGHT), this.getComparisonComponent(Duo.Side.RIGHT), 5);
        this.titlePanels = new Duo((Object)leftPanel, (Object)rightPanel);
        ((TitledPanel)this.titlePanels.get(Duo.Side.LEFT)).setMinimumSize(new Dimension(50, ((TitledPanel)this.titlePanels.get((Duo.Side)Duo.Side.LEFT)).getMinimumSize().height));
        ((TitledPanel)this.titlePanels.get(Duo.Side.RIGHT)).setMinimumSize(new Dimension(50, ((TitledPanel)this.titlePanels.get((Duo.Side)Duo.Side.RIGHT)).getMinimumSize().height));
        this.splitPane = new JSplitPane(1, true, (Component)this.titlePanels.get(Duo.Side.LEFT), (Component)this.titlePanels.get(Duo.Side.RIGHT));
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setDividerSize(4);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.splitPane, "Center");
        this.updateOrientation();
        this.addMouseAndFocusListeners(Duo.Side.LEFT);
        this.addMouseAndFocusListeners(Duo.Side.RIGHT);
        this.setActiveSide(Duo.Side.LEFT);
    }

    private void addMouseAndFocusListeners(final Duo.Side side) {
        JComponent comp = this.getComparisonComponent(side);
        comp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CodeComparisonPanel.this.setActiveSide(side);
                CodeComparisonPanel.this.updateContextForFocusGained(e.getComponent());
            }
        });
        comp = this.getComparisonComponent(side);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CodeComparisonPanel.this.setActiveSide(side);
            }
        };
        this.addMouseListenerRecursively(comp, mouseListener);
    }

    private void updateContextForFocusGained(Component component) {
        ComponentProvider provider = this.tool.getWindowManager().getProvider(component);
        if (provider != null) {
            provider.contextChanged();
        }
    }

    private void addMouseListenerRecursively(Component component, MouseListener listener) {
        component.addMouseListener(listener);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component child = container.getComponent(i);
                this.addMouseListenerRecursively(child, listener);
            }
        }
    }

    protected void setActiveSide(Duo.Side side) {
        this.activeSide = side;
        this.getComparisonComponent(side).setBorder(ACTIVE_BORDER);
        this.getComparisonComponent(side.otherSide()).setBorder(NON_ACTIVE_BORDER);
    }

    private class ToggleOrientationAction
    extends ToggleDockingAction {
        ToggleOrientationAction(String name) {
            super(name + " Toggle Orientation", CodeComparisonPanel.HELP_TOPIC);
            this.setDescription("<html>Toggle the layout to be either side by side or one above the other");
            this.setHelpLocation(new HelpLocation(CodeComparisonPanel.HELP_TOPIC, "Dual_" + name + "_Toggle_Orientation"));
            this.setEnabled(true);
            MenuData menuData = new MenuData(new String[]{"Show " + name + " Side-by-Side"}, "Orientation");
            this.setMenuBarData(menuData);
            this.setSelected(true);
        }

        public void actionPerformed(ActionContext context) {
            CodeComparisonPanel.this.updateOrientation();
        }
    }
}

