/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress.methods;

import tim.prune.data.DataPoint;
import tim.prune.data.MarkingData;
import tim.prune.data.NumberUtils;
import tim.prune.data.Track;
import tim.prune.function.compress.CompressionMethodType;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.methods.CompressionMethod;

public class WackyPointsMethod
extends CompressionMethod {
    private final double _factor;

    public WackyPointsMethod(double d) {
        this._factor = d;
    }

    public WackyPointsMethod(String string) {
        this._factor = NumberUtils.getDoubleOrZero(WackyPointsMethod.recogniseString(string) ? string.substring(4) : string);
    }

    @Override
    public CompressionMethodType getType() {
        return CompressionMethodType.WACKY_POINTS;
    }

    @Override
    public String getParam() {
        return "" + Math.abs(this._factor);
    }

    @Override
    public int compress(Track track, TrackDetails trackDetails, MarkingData markingData) {
        if (this._factor <= 0.0) {
            return 0;
        }
        int n = track.getNumPoints();
        int n2 = 0;
        double d = this._factor * trackDetails.getMeanRadians();
        DataPoint dataPoint = null;
        DataPoint dataPoint2 = null;
        int n3 = 0;
        while (n3 < n) {
            if (!markingData.isPointMarkedForDeletion(n3)) {
                DataPoint dataPoint3;
                dataPoint = track.getPoint(n3);
                if (!dataPoint.isWaypoint() && !dataPoint.hasMedia() && !trackDetails.isSegmentStart(n3) && !trackDetails.isSegmentEnd(n3) && DataPoint.calculateRadiansBetween(dataPoint2, dataPoint) > d && (dataPoint3 = WackyPointsMethod.getNextTrackPoint(track, n3 + 1, markingData)) != null && DataPoint.calculateRadiansBetween(dataPoint, dataPoint3) > d && DataPoint.calculateRadiansBetween(dataPoint2, dataPoint3) < d) {
                    markingData.markPointForDeletion(n3);
                    ++n2;
                }
                if (!dataPoint.isWaypoint() && !markingData.isPointMarkedForDeletion(n3)) {
                    dataPoint2 = dataPoint;
                }
            }
            ++n3;
        }
        return n2;
    }

    @Override
    public String getSettingsString() {
        return String.valueOf(this.getType().getKey()) + this._factor;
    }

    static boolean recogniseString(String string) {
        return WackyPointsMethod.recogniseString(string, CompressionMethodType.WACKY_POINTS);
    }
}

