/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Binarize an input image by thresholding.


This filter produces an output image whose pixels are either one of
two values ( OutsideValue or InsideValue ), depending on whether the
corresponding input image pixels lie between the two thresholds (
LowerThreshold and UpperThreshold ). Values equal to either threshold
is considered to be between the thresholds.

More precisely \\[ Output(x_i) = \\begin{cases} InsideValue &amp; \\text{if
\\f$LowerThreshold \\leq x_i \\leq UpperThreshold\\f$}
\\\\ OutsideValue &amp; \\text{otherwise} \\end{cases} \\]

This filter is templated over the input image type and the output
image type.

The filter expect both images to have the same number of dimensions.

The default values for LowerThreshold and UpperThreshold are:
LowerThreshold = NumericTraits&lt;TInput&gt;::NonpositiveMin() ; UpperThreshold = NumericTraits&lt;TInput&gt;::max() ; Therefore, generally only one of these needs to be set, depending
on whether the user wants to threshold above or below the desired
threshold.
See:
 itk::simple::BinaryThreshold for the procedural interface

 itk::BinaryThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryThresholdImageFilter.h
*/
public class BinaryThresholdImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryThresholdImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryThresholdImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryThresholdImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryThresholdImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryThresholdImageFilter::~BinaryThresholdImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryThresholdImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryThresholdImageFilter::BinaryThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryThresholdImageFilter() {
    this(SimpleITKJNI.new_BinaryThresholdImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryThresholdImageFilter::SetLowerThreshold(double LowerThreshold)
*/
public  void setLowerThreshold(double LowerThreshold) {
    SimpleITKJNI.BinaryThresholdImageFilter_setLowerThreshold(swigCPtr, this, LowerThreshold);
  }

  /**
double itk::simple::BinaryThresholdImageFilter::GetLowerThreshold() const
*/
public  double getLowerThreshold() {
    return SimpleITKJNI.BinaryThresholdImageFilter_getLowerThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryThresholdImageFilter::SetUpperThreshold(double UpperThreshold)

Set the thresholds. The default lower threshold is NumericTraits&lt;InputPixelType&gt;::NonpositiveMin() . The default upper threshold is NumericTraits&lt;InputPixelType&gt;::max . An exception is thrown if the lower threshold is greater than the
upper threshold.

*/
public  void setUpperThreshold(double UpperThreshold) {
    SimpleITKJNI.BinaryThresholdImageFilter_setUpperThreshold(swigCPtr, this, UpperThreshold);
  }

  /**
double itk::simple::BinaryThresholdImageFilter::GetUpperThreshold() const

Get the threshold values.

*/
public  double getUpperThreshold() {
    return SimpleITKJNI.BinaryThresholdImageFilter_getUpperThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the "inside" pixel value. The default value NumericTraits&lt;OutputPixelType&gt;::max()

*/
public  void setInsideValue(short InsideValue) {
    SimpleITKJNI.BinaryThresholdImageFilter_setInsideValue(swigCPtr, this, InsideValue);
  }

  /**
uint8_t itk::simple::BinaryThresholdImageFilter::GetInsideValue() const

Get the "inside" pixel value.

*/
public  short getInsideValue() {
    return SimpleITKJNI.BinaryThresholdImageFilter_getInsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the "outside" pixel value. The default value NumericTraits&lt;OutputPixelType&gt;::ZeroValue() .

*/
public  void setOutsideValue(short OutsideValue) {
    SimpleITKJNI.BinaryThresholdImageFilter_setOutsideValue(swigCPtr, this, OutsideValue);
  }

  /**
uint8_t itk::simple::BinaryThresholdImageFilter::GetOutsideValue() const

Get the "outside" pixel value.

*/
public  short getOutsideValue() {
    return SimpleITKJNI.BinaryThresholdImageFilter_getOutsideValue(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryThresholdImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryThresholdImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryThresholdImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryThresholdImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryThresholdImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryThresholdImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
