/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import org.jmol.api.JmolMeasurementClient;
import org.jmol.atomdata.RadiusData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Text;
import org.jmol.modelset.TickInfo;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class MeasurementData
implements JmolMeasurementClient {
    private JmolMeasurementClient client;
    public BS bsSelected;
    private Lst<String> measurementStrings;
    private Lst<Float> measurements;
    public Lst<Object> points;
    public boolean mustBeConnected;
    public boolean mustNotBeConnected;
    public TickInfo tickInfo;
    public int tokAction = 12290;
    public RadiusData radiusData;
    public String strFormat;
    public String property;
    public String note;
    public boolean isAll;
    public short colix;
    public Boolean intramolecular;
    public int mad;
    public String thisID;
    public Text text;
    public String units;
    public float fixedValue;
    private Atom[] atoms;
    private float[] minArray;
    private ModelSet ms;
    private boolean allowSelf;
    private Viewer vwr;
    private int iFirstAtom;
    private boolean justOneModel = true;
    public Map<String, Integer> htMin;

    public MeasurementData init(String id, Viewer vwr, Lst<Object> points) {
        this.vwr = vwr;
        this.points = points;
        this.thisID = id;
        return this;
    }

    public MeasurementData setModelSet(ModelSet m) {
        this.ms = m;
        return this;
    }

    public MeasurementData set(int tokAction, Map<String, Integer> htMin, RadiusData radiusData, String property, String strFormat, String units, TickInfo tickInfo, boolean mustBeConnected, boolean mustNotBeConnected, Boolean intramolecular, boolean isAll, int mad, short colix, Text text, float value, BS bsSelected) {
        this.ms = this.vwr.ms;
        this.tokAction = tokAction;
        if (this.points.size() >= 2 && this.points.get(0) instanceof BS && this.points.get(1) instanceof BS) {
            this.justOneModel = this.vwr.ms.getModelBS((BS)this.points.get(0), false).equals(this.vwr.ms.getModelBS((BS)this.points.get(1), false));
        }
        this.bsSelected = bsSelected;
        this.htMin = htMin;
        this.radiusData = radiusData;
        this.property = property;
        this.strFormat = strFormat;
        this.units = units;
        this.tickInfo = tickInfo;
        this.mustBeConnected = mustBeConnected;
        this.mustNotBeConnected = mustNotBeConnected;
        this.intramolecular = intramolecular;
        this.isAll = isAll;
        this.mad = mad;
        this.colix = colix;
        this.text = text;
        this.fixedValue = value;
        return this;
    }

    @Override
    public void processNextMeasure(MeasurementData md, Measurement m) {
        float value = m.getMeasurement(null);
        if (this.htMin != null && !m.isMin(this.htMin) || this.radiusData != null && !m.isInRange(this.radiusData, value)) {
            return;
        }
        if (this.measurementStrings == null && this.measurements == null) {
            float f = this.minArray[this.iFirstAtom];
            m.value = value;
            value = m.fixValue(this.units, false);
            this.minArray[this.iFirstAtom] = 1.0f / f == Float.NEGATIVE_INFINITY ? value : Math.min(f, value);
            return;
        }
        if (this.measurementStrings != null) {
            this.measurementStrings.addLast(m.getStringUsing(this.vwr, this.strFormat, this.units));
        } else {
            this.measurements.addLast(Float.valueOf(m.getMeasurement(null)));
        }
    }

    public Object getMeasurements(boolean asFloatArray, boolean asMinArray) {
        if (asMinArray) {
            this.minArray = new float[((BS)this.points.get(0)).cardinality()];
            for (int i = 0; i < this.minArray.length; ++i) {
                this.minArray[i] = -0.0f;
            }
            this.define(null, this.ms);
            return this.minArray;
        }
        if (asFloatArray) {
            this.allowSelf = true;
            this.measurements = new Lst();
            this.define(null, this.ms);
            return this.measurements;
        }
        this.measurementStrings = new Lst();
        this.define(null, this.ms);
        return this.measurementStrings;
    }

    public void define(JmolMeasurementClient client, ModelSet modelSet) {
        this.client = client == null ? this : client;
        this.atoms = modelSet.at;
        int nPoints = this.points.size();
        if (nPoints < 2) {
            return;
        }
        int modelIndex = -1;
        Point3fi[] pts = new Point3fi[4];
        int[] indices = new int[5];
        Measurement m = new Measurement().setPoints(modelSet, indices, pts, null);
        m.setCount(nPoints);
        m.property = this.property;
        m.strFormat = this.strFormat;
        m.units = this.units;
        m.fixedValue = this.fixedValue;
        int ptLastAtom = -1;
        for (int i = 0; i < nPoints; ++i) {
            Object obj = this.points.get(i);
            if (obj instanceof BS) {
                BS bs = (BS)obj;
                int nAtoms = bs.cardinality();
                if (nAtoms == 0) {
                    return;
                }
                if (nAtoms > 1) {
                    modelIndex = 0;
                }
                ptLastAtom = i;
                if (i == 0) {
                    this.iFirstAtom = 0;
                }
                indices[i + 1] = bs.nextSetBit(0);
                continue;
            }
            pts[i] = (Point3fi)obj;
            indices[i + 1] = -2 - i;
        }
        this.nextMeasure(0, ptLastAtom, m, modelIndex);
    }

    private void nextMeasure(int thispt, int ptLastAtom, Measurement m, int thisModel) {
        int thisAtomIndex;
        if (thispt > ptLastAtom) {
            if (!((!this.allowSelf || this.mustBeConnected || this.mustNotBeConnected) && !m.isValid() || this.mustBeConnected && !m.isConnected(this.atoms, thispt) || this.mustNotBeConnected && m.isConnected(this.atoms, thispt) || this.intramolecular != null && m.isIntramolecular(this.atoms, thispt) != this.intramolecular.booleanValue())) {
                this.client.processNextMeasure(this, m);
            }
            return;
        }
        BS bs = (BS)this.points.get(thispt);
        int[] indices = m.countPlusIndices;
        int n = thisAtomIndex = thispt == 0 ? Integer.MAX_VALUE : indices[thispt];
        if (thisAtomIndex < 0) {
            this.nextMeasure(thispt + 1, ptLastAtom, m, thisModel);
            return;
        }
        boolean haveNext = false;
        int i = bs.nextSetBit(0);
        int pt = 0;
        while (i >= 0) {
            block9: {
                block10: {
                    short modelIndex;
                    block11: {
                        if (i == thisAtomIndex && !this.allowSelf) break block9;
                        modelIndex = this.atoms[i].mi;
                        if (thisModel < 0 || !this.justOneModel) break block10;
                        if (thispt != 0) break block11;
                        thisModel = modelIndex;
                        break block10;
                    }
                    if (thisModel != modelIndex) break block9;
                }
                indices[thispt + 1] = i;
                if (thispt == 0) {
                    this.iFirstAtom = pt;
                }
                haveNext = true;
                this.nextMeasure(thispt + 1, ptLastAtom, m, thisModel);
            }
            i = bs.nextSetBit(i + 1);
            ++pt;
        }
        if (!haveNext) {
            this.nextMeasure(thispt + 1, ptLastAtom, m, thisModel);
        }
    }
}

