/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.jsr223.Utils;

class JRubyContext
implements ScriptContext {
    private static final int[] SCOPES = new int[]{100, 200};
    private static final List<Integer> SCOPE_LIST = Collections.unmodifiableList(Arrays.stream(SCOPES).boxed().collect(Collectors.toList()));
    private final ScriptingContainer container;
    private final List<Integer> scopeList;
    private Bindings globalMap = null;
    private Bindings engineMap = new SimpleBindings();
    private Reader reader = null;
    private Writer writer = null;
    private Writer errorWriter = null;

    JRubyContext(ScriptingContainer container) {
        this.container = container;
        this.scopeList = SCOPE_LIST;
    }

    @Override
    public Object getAttribute(String name2) {
        Object ret = null;
        for (int scope : SCOPES) {
            ret = this.getAttributeFromScope(scope, name2);
            if (ret == null) continue;
            return ret;
        }
        return ret;
    }

    private Object getAttributeFromScope(int scope, String name2) {
        switch (scope) {
            case 100: {
                Object value2 = this.engineMap.get(name2);
                if (value2 == null && Utils.isRubyVariable(this.container, name2)) {
                    value2 = this.container.get(Utils.getReceiver(this), name2);
                    this.engineMap.put(name2, value2);
                }
                return value2;
            }
            case 200: {
                if (this.globalMap == null) {
                    return null;
                }
                return this.globalMap.get(name2);
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    @Override
    public Object getAttribute(String name2, int scope) {
        return this.getAttributeFromScope(scope, name2);
    }

    @Override
    public int getAttributesScope(String name2) {
        for (int scope : SCOPES) {
            Object ret = this.getAttributeFromScope(scope, name2);
            if (ret == null) continue;
            return scope;
        }
        return -1;
    }

    @Override
    public Bindings getBindings(int scope) {
        switch (scope) {
            case 100: {
                return this.engineMap;
            }
            case 200: {
                return this.globalMap;
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public List<Integer> getScopes() {
        return this.scopeList;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Object removeAttribute(String name2, int scope) {
        Bindings bindings = this.getBindings(scope);
        if (bindings == null) {
            return null;
        }
        return bindings.remove(name2);
    }

    @Override
    public void setAttribute(String key2, Object value2, int scope) {
        Bindings bindings = this.getBindings(scope);
        if (bindings == null) {
            return;
        }
        bindings.put(key2, value2);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        switch (scope) {
            case 100: {
                if (bindings == null) {
                    throw new NullPointerException("null bindings in ENGINE scope");
                }
                this.engineMap = bindings;
                break;
            }
            case 200: {
                this.globalMap = bindings;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid scope");
            }
        }
    }

    @Override
    public void setErrorWriter(Writer errorWriter) {
        if (errorWriter == null) {
            return;
        }
        if (this.getErrorWriter() == errorWriter) {
            return;
        }
        this.errorWriter = errorWriter;
    }

    @Override
    public void setReader(Reader reader) {
        if (reader == null) {
            return;
        }
        if (this.getReader() == reader) {
            return;
        }
        this.reader = reader;
    }

    @Override
    public void setWriter(Writer writer) {
        if (writer == null) {
            return;
        }
        if (this.getWriter() == writer) {
            return;
        }
        this.writer = writer;
    }
}

