/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.util.function.Supplier;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.IdentifierValue;
import org.hibernate.engine.spi.VersionValue;
import org.hibernate.mapping.KeyValue;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;

public class UnsavedValueFactory {
    public static IdentifierValue getUnsavedIdentifierValue(KeyValue bootIdMapping, JavaType<?> idJavaType, Getter getter, Supplier<?> templateInstanceAccess) {
        IdentifierValue identifierValue;
        KeyValue.NullValueSemantic nullValueSemantic = bootIdMapping.getNullValueSemantic();
        if (nullValueSemantic == null) {
            identifierValue = UnsavedValueFactory.inferUnsavedIdentifierValue(idJavaType, getter, templateInstanceAccess);
        } else {
            switch (nullValueSemantic) {
                case UNDEFINED: {
                    identifierValue = IdentifierValue.UNDEFINED;
                    break;
                }
                case NULL: {
                    identifierValue = IdentifierValue.NULL;
                    break;
                }
                case ANY: {
                    identifierValue = IdentifierValue.ANY;
                    break;
                }
                case NONE: {
                    identifierValue = IdentifierValue.NONE;
                    break;
                }
                case VALUE: {
                    identifierValue = new IdentifierValue(idJavaType.fromString(bootIdMapping.getNullValue()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal null-value semantic: " + String.valueOf((Object)nullValueSemantic));
                }
            }
        }
        return identifierValue;
    }

    private static IdentifierValue inferUnsavedIdentifierValue(JavaType<?> idJavaType, Getter getter, Supplier<?> templateInstanceAccess) {
        if (getter != null && templateInstanceAccess != null) {
            Object defaultValue = getter.get(templateInstanceAccess.get());
            return new IdentifierValue(defaultValue);
        }
        if (idJavaType instanceof PrimitiveJavaType) {
            PrimitiveJavaType primitiveJavaType = (PrimitiveJavaType)idJavaType;
            return new IdentifierValue(primitiveJavaType.getDefaultValue());
        }
        return IdentifierValue.NULL;
    }

    public static <T> VersionValue getUnsavedVersionValue(KeyValue bootVersionMapping, VersionJavaType<T> versionJavaType, Getter getter, Supplier<?> templateInstanceAccess) {
        VersionValue versionValue;
        KeyValue.NullValueSemantic nullValueSemantic = bootVersionMapping.getNullValueSemantic();
        if (nullValueSemantic == null) {
            versionValue = UnsavedValueFactory.inferUnsavedVersionValue(versionJavaType, getter, templateInstanceAccess);
        } else {
            switch (nullValueSemantic) {
                case UNDEFINED: {
                    versionValue = VersionValue.UNDEFINED;
                    break;
                }
                case NULL: {
                    versionValue = VersionValue.NULL;
                    break;
                }
                case NEGATIVE: {
                    versionValue = VersionValue.NEGATIVE;
                    break;
                }
                case VALUE: {
                    versionValue = new VersionValue(versionJavaType.fromString(bootVersionMapping.getNullValue()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal null-value semantic: " + String.valueOf((Object)nullValueSemantic));
                }
            }
        }
        return versionValue;
    }

    private static VersionValue inferUnsavedVersionValue(VersionJavaType<?> versionJavaType, Getter getter, Supplier<?> templateInstanceAccess) {
        if (getter != null && templateInstanceAccess != null) {
            Object defaultValue = getter.get(templateInstanceAccess.get());
            return Versioning.isNullInitialVersion(defaultValue) ? new VersionValue(defaultValue) : VersionValue.UNDEFINED;
        }
        return VersionValue.UNDEFINED;
    }

    private UnsavedValueFactory() {
    }
}

