/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public final class CommandLineUtil {
    private CommandLineUtil() {
    }

    public static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        boolean inEscape = false;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' \\", true);
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        if (inEscape) {
                            current.append(nextTok);
                            inEscape = false;
                            continue block4;
                        }
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    inEscape = "\\".equals(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        if (inEscape) {
                            current.append(nextTok);
                            inEscape = false;
                            continue block4;
                        }
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    inEscape = "\\".equals(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                if (inEscape) {
                    inEscape = false;
                    current.append(nextTok);
                    continue;
                }
                state = 1;
                continue;
            }
            if ("\"".equals(nextTok)) {
                if (inEscape) {
                    inEscape = false;
                    current.append(nextTok);
                    continue;
                }
                state = 2;
                continue;
            }
            if (" ".equals(nextTok)) {
                if (current.length() == 0) continue;
                tokens.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(nextTok);
            inEscape = "\\".equals(nextTok);
        }
        if (current.length() != 0) {
            tokens.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalStateException("unbalanced quotes in " + toProcess);
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

