/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import jakarta.ws.rs.core.Response;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.serialization.DynamicEntityWriter;
import org.jboss.resteasy.reactive.server.core.serialization.EntityWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class ResponseWriterHandler
implements ServerRestHandler {
    public static final String HEAD = "HEAD";
    private final DynamicEntityWriter dynamicEntityWriter;

    public ResponseWriterHandler(DynamicEntityWriter dynamicEntityWriter) {
        this.dynamicEntityWriter = dynamicEntityWriter;
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        requestContext.requireCDIRequestScope();
        Object entity = requestContext.getResponseEntity();
        if (entity != null && !requestContext.getMethod().equals(HEAD)) {
            EntityWriter entityWriter = requestContext.getEntityWriter();
            if (entityWriter == null) {
                this.dynamicEntityWriter.write(requestContext, entity);
            } else {
                entityWriter.write(requestContext, entity);
            }
        } else {
            if (entity != null) {
                this.setContentTypeIfNecessary(requestContext);
            } else {
                ResponseWriterHandler.clearContentTypeHeader(requestContext);
            }
            ServerSerialisers.encodeResponseHeaders(requestContext);
            requestContext.serverResponse().end();
        }
    }

    private static void clearContentTypeHeader(ResteasyReactiveRequestContext requestContext) {
        requestContext.serverResponse().setResponseHeader((CharSequence)"Content-Type", (CharSequence)null);
    }

    private void setContentTypeIfNecessary(ResteasyReactiveRequestContext requestContext) {
        ServerMediaType serverMediaType;
        if (this.hasBody(requestContext) && requestContext.getTarget() != null && requestContext.getTarget().getProduces() != null && requestContext.getResponseContentType() == null && (serverMediaType = requestContext.getTarget().getProduces()).getSortedOriginalMediaTypes().length > 0) {
            requestContext.serverResponse().setResponseHeader((CharSequence)"Content-Type", serverMediaType.getSortedOriginalMediaTypes()[0].toString());
        }
    }

    private boolean hasBody(ResteasyReactiveRequestContext requestContext) {
        if (requestContext.getMethod().equals(HEAD)) {
            return true;
        }
        if (requestContext.getResponse().isCreated()) {
            int status = requestContext.getResponse().get().getStatus();
            return status != Response.Status.NO_CONTENT.getStatusCode();
        }
        return requestContext.getResponseEntity() != null;
    }
}

