--[[
-- Audio
--]]

local love_audio = {}
function love_audio.newSource( filename, type )
   -- We actually have most of the API implemented on a C level.
   local stream
   if type==nil or type=="static" then
      stream = false
   elseif type=="stream" then
      stream = true
   else
      error("source type must be either 'static' or 'stream'")
   end
   return naev.audio.new( filename, stream )
end
function love_audio.setVolume( _volume ) end -- Don't allow setting master volume
function love_audio.getVolume()
   return naev.audio.getVolume()
end
function love_audio.setPosition( _x, _y, _z ) end -- Don't allow setting position
function love_audio.setEffect( ... )
   return naev.audio.setEffectData( ... )
end
function love_audio.newSoundData( filename )
   return naev.audiodata.new( filename )
end

return love_audio
