/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import oracle.rsi.diagnostics.Diagnosable;
import oracle.rsi.diagnostics.RSIDiagnosable;

class StagingArea
implements Diagnosable {
    private static final String CLASS_NAME = StagingArea.class.getName();
    private final Duration bufferInterval;
    private final int maxRowsPerStagingQueue;
    private final Consumer<List<Object>> stagedItemsConsumer;
    private final ConcurrentHashMap<Long, TLCtx> threadSpecificCtx = new ConcurrentHashMap();

    StagingArea(int n, Duration duration, Consumer<List<Object>> consumer) {
        this.maxRowsPerStagingQueue = n;
        this.bufferInterval = duration;
        this.stagedItemsConsumer = consumer;
    }

    void accept(Object object) {
        TLCtx tLCtx = this.threadSpecificCtx.computeIfAbsent(Thread.currentThread().getId(), l -> new TLCtx());
        tLCtx.accept(object);
    }

    public void flushIfDue(boolean bl) {
        Iterator<Map.Entry<Long, TLCtx>> iterator = this.threadSpecificCtx.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, TLCtx> entry = iterator.next();
            TLCtx tLCtx = entry.getValue();
            if (bl) {
                tLCtx.flush();
                continue;
            }
            if (tLCtx.isBufferFlushDue().booleanValue() || tLCtx.isOwnerThreadTerminated()) {
                tLCtx.flush();
            }
            if (!tLCtx.isOwnerThreadTerminated()) continue;
            iterator.remove();
        }
    }

    void close() {
        this.threadSpecificCtx.clear();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return RSIDiagnosable.getInstance();
    }

    private class TLCtx {
        private final Thread ownerThread = Thread.currentThread();
        private final List<Object> stagingQueue;
        private Instant lastSubmittedToConsumerAt;
        private final AtomicReference<Boolean> writeLock;

        private TLCtx() {
            this.stagingQueue = new ArrayList<Object>(StagingArea.this.maxRowsPerStagingQueue);
            this.lastSubmittedToConsumerAt = Instant.now();
            this.writeLock = new AtomicReference<Boolean>(false);
        }

        private boolean tryAcquireWriteLock() {
            return this.writeLock.compareAndSet(false, true);
        }

        private void releaseWriteLock() {
            this.writeLock.compareAndSet(true, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void accept(Object object) {
            ArrayList<Object> arrayList = null;
            try {
                while (!this.tryAcquireWriteLock()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.stagingQueue.add(object);
                if (this.stagingQueue.size() >= StagingArea.this.maxRowsPerStagingQueue) {
                    String string = "The staging queue is full. Submitting the queue for ingestion.";
                    StagingArea.this.debug(Level.FINEST, CLASS_NAME, "accept", string, null, new Object[0]);
                    arrayList = new ArrayList<Object>(this.stagingQueue.size());
                    arrayList.addAll(this.stagingQueue);
                    this.stagingQueue.clear();
                }
            }
            finally {
                this.releaseWriteLock();
            }
            this.submitToConsumer(arrayList);
        }

        Boolean isBufferFlushDue() {
            Duration duration = Duration.between(this.lastSubmittedToConsumerAt, Instant.now());
            return duration.compareTo(StagingArea.this.bufferInterval) >= 0;
        }

        void flush() {
            if (this.stagingQueue.size() == 0) {
                return;
            }
            ArrayList<Object> arrayList = null;
            try {
                while (!this.tryAcquireWriteLock()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                arrayList = new ArrayList<Object>(this.stagingQueue.size());
                arrayList.addAll(this.stagingQueue);
                this.stagingQueue.clear();
            }
            finally {
                this.releaseWriteLock();
            }
            this.submitToConsumer(arrayList);
        }

        private void submitToConsumer(List<Object> list) {
            if (list != null) {
                StagingArea.this.stagedItemsConsumer.accept(list);
                this.lastSubmittedToConsumerAt = Instant.now();
            }
        }

        boolean isOwnerThreadTerminated() {
            return Thread.State.TERMINATED == this.ownerThread.getState();
        }
    }
}

