/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.sampler.AbstractStreamSampler;
import com.amazon.randomcutforest.sampler.CompactSampler;
import com.amazon.randomcutforest.sampler.ISampled;
import com.amazon.randomcutforest.store.IndexIntervalManager;
import com.amazon.randomcutforest.util.Weighted;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;

public class StreamSampler<P> {
    protected final CompactSampler sampler;
    protected final ArrayList<Weighted<P>> objectList;
    protected final IndexIntervalManager intervalManager;
    protected Optional<P> evicted;
    protected long sequenceNumber = -1L;
    protected long entriesSeen = 0L;
    protected boolean currentlySampling;

    public static Builder<?> builder() {
        return new Builder();
    }

    public StreamSampler(Builder<?> builder) {
        this.sampler = ((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((AbstractStreamSampler.Builder)((CompactSampler.Builder)new CompactSampler.Builder().capacity(builder.capacity)).storeSequenceIndexesEnabled(((Builder)builder).storeSequenceIndexesEnabled)).randomSeed(builder.randomSeed)).initialAcceptFraction(builder.initialAcceptFraction)).timeDecay(builder.timeDecay)).build();
        this.objectList = new ArrayList(builder.capacity);
        this.intervalManager = new IndexIntervalManager(builder.capacity);
        this.evicted = Optional.empty();
        this.currentlySampling = true;
    }

    protected boolean sample(P object, float weight) {
        ++this.sequenceNumber;
        ++this.entriesSeen;
        if (this.currentlySampling && this.sampler.acceptPoint(this.sequenceNumber, weight)) {
            int index;
            Optional<ISampled<Integer>> samplerEvicted = this.sampler.getEvictedPoint();
            if (samplerEvicted.isPresent()) {
                int oldIndex = samplerEvicted.get().getValue();
                this.evicted = Optional.of(this.objectList.get((int)oldIndex).index);
                this.intervalManager.releaseIndex(oldIndex);
            }
            if ((index = this.intervalManager.takeIndex()) < this.objectList.size()) {
                this.objectList.set(index, new Weighted<P>(object, weight));
            } else {
                this.objectList.add(new Weighted<P>(object, weight));
            }
            this.sampler.addPoint(index);
            return true;
        }
        this.evicted = Optional.empty();
        return false;
    }

    public StreamSampler(StreamSampler<P> first, StreamSampler<P> second, int capacity, double timeDecay, long seed) {
        CommonUtils.checkArgument(capacity > 0, "capacity has to be positive");
        double initialAcceptFraction = Math.max(first.sampler.getInitialAcceptFraction(), second.sampler.getInitialAcceptFraction());
        this.objectList = new ArrayList(capacity);
        int[] pointList = new int[capacity];
        float[] weightList = new float[capacity];
        this.intervalManager = new IndexIntervalManager(capacity);
        this.evicted = Optional.empty();
        this.currentlySampling = true;
        double firstUpdate = (double)(-(first.sampler.getMaxSequenceIndex() - first.sampler.getMostRecentTimeDecayUpdate())) * first.sampler.getTimeDecay();
        ArrayList<Weighted<Integer>> list = new ArrayList<Weighted<Integer>>();
        int offset = first.sampler.size();
        int[] firstList = first.sampler.getPointIndexArray();
        float[] firstWeightList = first.sampler.getWeightArray();
        for (int i = 0; i < offset; ++i) {
            list.add(new Weighted<Integer>(firstList[i], (float)((double)firstWeightList[i] + firstUpdate)));
        }
        double secondUpdate = (double)(-(second.sampler.getMaxSequenceIndex() - second.sampler.getMostRecentTimeDecayUpdate())) * second.sampler.getTimeDecay();
        int secondOffset = second.sampler.size();
        int[] secondList = second.sampler.getPointIndexArray();
        float[] secondWeightList = second.sampler.getWeightArray();
        for (int i = 0; i < secondOffset; ++i) {
            list.add(new Weighted<Integer>(secondList[i] + offset, (float)((double)secondWeightList[i] + secondUpdate)));
        }
        list.sort((o1, o2) -> Float.compare(o1.weight, o2.weight));
        int size = Math.min(capacity, list.size());
        for (int j = size - 1; j >= 0; --j) {
            int index;
            pointList[index] = index = this.intervalManager.takeIndex();
            weightList[index] = ((Weighted)list.get((int)j)).weight;
            if ((Integer)((Weighted)list.get((int)j)).index < offset) {
                this.objectList.add(first.objectList.get((Integer)((Weighted)list.get((int)j)).index));
                continue;
            }
            this.objectList.add(second.objectList.get((Integer)((Weighted)list.get((int)j)).index - offset));
        }
        this.sequenceNumber = Math.max(first.sequenceNumber, second.sequenceNumber);
        this.entriesSeen = first.entriesSeen + second.entriesSeen;
        this.sampler = ((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((AbstractStreamSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((AbstractStreamSampler.Builder)((CompactSampler.Builder)new CompactSampler.Builder().capacity(capacity)).storeSequenceIndexesEnabled(false)).randomSeed(seed)).initialAcceptFraction(initialAcceptFraction)).timeDecay(timeDecay)).pointIndex(pointList)).weight(weightList)).randomSeed(seed)).maxSequenceIndex(this.sequenceNumber)).mostRecentTimeDecayUpdate(this.sequenceNumber)).build();
    }

    public boolean isCurrentlySampling() {
        return this.currentlySampling;
    }

    public void pauseSampling() {
        this.currentlySampling = false;
    }

    public void resumeSampling() {
        this.currentlySampling = true;
    }

    public ArrayList<Weighted<P>> getObjectList() {
        return this.objectList;
    }

    public int getCapacity() {
        return this.sampler.getCapacity();
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getEntriesSeen() {
        return this.entriesSeen;
    }

    public static class Builder<T extends Builder<T>> {
        private boolean storeSequenceIndexesEnabled = false;
        protected int capacity = 256;
        protected double timeDecay = 1.0 / (10.0 * (double)this.capacity);
        protected long randomSeed = new Random().nextLong();
        protected double initialAcceptFraction = 1.0;

        public T capacity(int capacity) {
            this.capacity = capacity;
            return (T)this;
        }

        public T randomSeed(long seed) {
            this.randomSeed = seed;
            return (T)this;
        }

        public T initialAcceptFraction(double initialAcceptFraction) {
            this.initialAcceptFraction = initialAcceptFraction;
            return (T)this;
        }

        public T timeDecay(double timeDecay) {
            this.timeDecay = timeDecay;
            return (T)this;
        }

        public T storeSequenceIndexesEnabled(boolean storeSequenceIndexesEnabled) {
            this.storeSequenceIndexesEnabled = storeSequenceIndexesEnabled;
            return (T)this;
        }

        public StreamSampler build() {
            return new StreamSampler(this);
        }

        public double getTimeDecay() {
            return this.timeDecay;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public long getRandomSeed() {
            return this.randomSeed;
        }
    }
}

