/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityBlock;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlocksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlocksResponse;

public class DescribeCapacityBlocksIterable
implements SdkIterable<DescribeCapacityBlocksResponse> {
    private final Ec2Client client;
    private final DescribeCapacityBlocksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCapacityBlocksIterable(Ec2Client client, DescribeCapacityBlocksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCapacityBlocksResponseFetcher();
    }

    public Iterator<DescribeCapacityBlocksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityBlock> capacityBlocks() {
        Function<DescribeCapacityBlocksResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityBlocks() != null) {
                return response.capacityBlocks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCapacityBlocksResponseFetcher
    implements SyncPageFetcher<DescribeCapacityBlocksResponse> {
        private DescribeCapacityBlocksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityBlocksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCapacityBlocksResponse nextPage(DescribeCapacityBlocksResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityBlocksIterable.this.client.describeCapacityBlocks(DescribeCapacityBlocksIterable.this.firstRequest);
            }
            return DescribeCapacityBlocksIterable.this.client.describeCapacityBlocks((DescribeCapacityBlocksRequest)((Object)DescribeCapacityBlocksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

