/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class AdjacencyMatrixAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, AdjacencyMatrixAggregation> {
    @Nonnull
    private final Map<String, Query> filters;
    public static final JsonpDeserializer<AdjacencyMatrixAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AdjacencyMatrixAggregation::setupAdjacencyMatrixAggregationDeserializer);

    private AdjacencyMatrixAggregation(Builder builder) {
        super(builder);
        this.filters = ApiTypeHelper.unmodifiable(builder.filters);
    }

    public static AdjacencyMatrixAggregation of(Function<Builder, ObjectBuilder<AdjacencyMatrixAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.AdjacencyMatrix;
    }

    @Nonnull
    public final Map<String, Query> filters() {
        return this.filters;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.filters)) {
            generator.writeKey("filters");
            generator.writeStartObject();
            for (Map.Entry<String, Query> item0 : this.filters.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAdjacencyMatrixAggregationDeserializer(ObjectDeserializer<Builder> op) {
        AdjacencyMatrixAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::filters, JsonpDeserializer.stringMapDeserializer(Query._DESERIALIZER), "filters");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.filters);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdjacencyMatrixAggregation other = (AdjacencyMatrixAggregation)o;
        return Objects.equals(this.filters, other.filters);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, AdjacencyMatrixAggregation> {
        @Nullable
        private Map<String, Query> filters;

        public Builder() {
        }

        private Builder(AdjacencyMatrixAggregation o) {
            super(o);
            this.filters = Builder._mapCopy(o.filters);
        }

        private Builder(Builder o) {
            super(o);
            this.filters = Builder._mapCopy(o.filters);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder filters(Map<String, Query> map) {
            this.filters = Builder._mapPutAll(this.filters, map);
            return this;
        }

        @Nonnull
        public final Builder filters(String key, Query value) {
            this.filters = Builder._mapPut(this.filters, key, value);
            return this;
        }

        @Nonnull
        public final Builder filters(String key, Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filters(key, fn.apply(new Query.Builder()).build());
        }

        @Override
        @Nonnull
        public AdjacencyMatrixAggregation build() {
            this._checkSingleUse();
            return new AdjacencyMatrixAggregation(this);
        }
    }
}

