/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.utils.Log;

public class PngIOMetadata {
    private static final String copyleft = "Generated by https://plantuml.com";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWithMetadata(RenderedImage image, OutputStream os, String metadata, int dpi, String debugData, int level) throws IOException {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        try {
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            try {
                writeParam.setCompressionMode(2);
                writeParam.setCompressionQuality(PngIOMetadata.levelToQuality(level));
            }
            catch (Throwable t) {
                Log.debug(() -> "Warning: cannot set compression mode/quality");
            }
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
            IIOMetadata meta = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (dpi != 96) {
                PngIOMetadata.addDpi(meta, dpi);
            }
            if (debugData != null) {
                PngIOMetadata.addText(meta, "debug", debugData);
            }
            PngIOMetadata.addText(meta, "copyleft", copyleft);
            if (metadata != null) {
                PngIOMetadata.addiText(meta, "plantuml", metadata);
            }
            Log.debug(() -> "PngIOMetadata pngMetadata=" + meta);
            IIOImage iioImage = new IIOImage(image, null, meta);
            Log.debug(() -> "PngIOMetadata iioImage=" + iioImage);
            try (ImageOutputStream ios = SImageIO.createImageOutputStream(os);){
                writer.setOutput(ios);
                writer.write(null, iioImage, writeParam);
            }
        }
        finally {
            writer.dispose();
        }
    }

    private static float levelToQuality(int level) {
        int L = Math.max(1, Math.min(9, level));
        return 1.0f - (float)(L - 1) / 8.0f;
    }

    private static void addDpi(IIOMetadata meta, double dpi) throws IIOInvalidTreeException {
        IIOMetadataNode dimension = new IIOMetadataNode("Dimension");
        IIOMetadataNode horizontalPixelSize = new IIOMetadataNode("HorizontalPixelSize");
        double value = dpi / 0.0254 / 1000.0;
        horizontalPixelSize.setAttribute("value", Double.toString(value));
        dimension.appendChild(horizontalPixelSize);
        IIOMetadataNode verticalPixelSize = new IIOMetadataNode("VerticalPixelSize");
        verticalPixelSize.setAttribute("value", Double.toString(value));
        dimension.appendChild(verticalPixelSize);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dimension);
        meta.mergeTree("javax_imageio_1.0", root);
    }

    private static void addiText(IIOMetadata meta, String key, String value) throws IIOInvalidTreeException {
        IIOMetadataNode text = new IIOMetadataNode("iTXt");
        IIOMetadataNode entry = new IIOMetadataNode("iTXtEntry");
        entry.setAttribute("keyword", key);
        entry.setAttribute("compressionFlag", "true");
        entry.setAttribute("compressionMethod", "0");
        entry.setAttribute("languageTag", "");
        entry.setAttribute("translatedKeyword", "");
        entry.setAttribute("text", value);
        text.appendChild(entry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
        root.appendChild(text);
        meta.mergeTree("javax_imageio_png_1.0", root);
    }

    private static void addText(IIOMetadata meta, String key, String value) throws IIOInvalidTreeException {
        IIOMetadataNode text = new IIOMetadataNode("tEXt");
        IIOMetadataNode entry = new IIOMetadataNode("tEXtEntry");
        entry.setAttribute("keyword", key);
        entry.setAttribute("value", value);
        text.appendChild(entry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
        root.appendChild(text);
        meta.mergeTree("javax_imageio_png_1.0", root);
    }
}

