// Copyright (C) 2020 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of Qt Widgets Designer. This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT!
// The source files are in qttools/src/designer/data

#ifndef UI4_H
#define UI4_H

#include <qlist.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qxmlstream.h>
#include <qglobal.h>

QT_BEGIN_NAMESPACE

#define QDESIGNER_UILIB_EXTERN Q_DECL_EXPORT
#define QDESIGNER_UILIB_IMPORT Q_DECL_IMPORT

#if defined(QT_DESIGNER_STATIC) || defined(QT_UIC) || defined(QT_UIC3)
#  define QDESIGNER_UILIB_EXPORT
#elif defined(QDESIGNER_UILIB_LIBRARY)
#  define QDESIGNER_UILIB_EXPORT QDESIGNER_UILIB_EXTERN
#else
#  define QDESIGNER_UILIB_EXPORT QDESIGNER_UILIB_IMPORT
#endif

#ifndef QDESIGNER_UILIB_EXPORT
#    define QDESIGNER_UILIB_EXPORT
#endif

#ifdef QFORMINTERNAL_NAMESPACE
namespace QFormInternal
{
#endif


/*******************************************************************************
** Forward declarations
*/

class DomUI;
class DomIncludes;
class DomInclude;
class DomResources;
class DomResource;
class DomActionGroup;
class DomAction;
class DomActionRef;
class DomButtonGroup;
class DomButtonGroups;
class DomCustomWidgets;
class DomHeader;
class DomCustomWidget;
class DomLayoutDefault;
class DomLayoutFunction;
class DomTabStops;
class DomLayout;
class DomLayoutItem;
class DomRow;
class DomColumn;
class DomItem;
class DomWidget;
class DomSpacer;
class DomColor;
class DomGradientStop;
class DomGradient;
class DomBrush;
class DomColorRole;
class DomColorGroup;
class DomPalette;
class DomFont;
class DomPoint;
class DomRect;
class DomLocale;
class DomSizePolicy;
class DomSize;
class DomDate;
class DomTime;
class DomDateTime;
class DomStringList;
class DomResourcePixmap;
class DomResourceIcon;
class DomString;
class DomPointF;
class DomRectF;
class DomSizeF;
class DomChar;
class DomUrl;
class DomProperty;
class DomConnections;
class DomConnection;
class DomConnectionHints;
class DomConnectionHint;
class DomDesignerData;
class DomSlots;
class DomPropertySpecifications;
class DomPropertyToolTip;
class DomStringPropertySpecification;

/*******************************************************************************
** Declarations
*/

class QDESIGNER_UILIB_EXPORT DomUI {
    Q_DISABLE_COPY_MOVE(DomUI)
public:
    DomUI() = default;
    ~DomUI();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeVersion() const { return m_has_attr_version; }
    QString attributeVersion() const { return m_attr_version; }
    void setAttributeVersion(const QString &a) { m_attr_version = a; m_has_attr_version = true; }
    void clearAttributeVersion() { m_has_attr_version = false; }

    bool hasAttributeLanguage() const { return m_has_attr_language; }
    QString attributeLanguage() const { return m_attr_language; }
    void setAttributeLanguage(const QString &a) { m_attr_language = a; m_has_attr_language = true; }
    void clearAttributeLanguage() { m_has_attr_language = false; }

    bool hasAttributeDisplayname() const { return m_has_attr_displayname; }
    QString attributeDisplayname() const { return m_attr_displayname; }
    void setAttributeDisplayname(const QString &a) { m_attr_displayname = a; m_has_attr_displayname = true; }
    void clearAttributeDisplayname() { m_has_attr_displayname = false; }

    bool hasAttributeIdbasedtr() const { return m_has_attr_idbasedtr; }
    bool attributeIdbasedtr() const { return m_attr_idbasedtr; }
    void setAttributeIdbasedtr(bool a) { m_attr_idbasedtr = a; m_has_attr_idbasedtr = true; }
    void clearAttributeIdbasedtr() { m_has_attr_idbasedtr = false; }

    bool hasAttributeLabel() const { return m_has_attr_label; }
    QString attributeLabel() const { return m_attr_label; }
    void setAttributeLabel(const QString &a) { m_attr_label = a; m_has_attr_label = true; }
    void clearAttributeLabel() { m_has_attr_label = false; }

    bool hasAttributeConnectslotsbyname() const { return m_has_attr_connectslotsbyname; }
    bool attributeConnectslotsbyname() const { return m_attr_connectslotsbyname; }
    void setAttributeConnectslotsbyname(bool a) { m_attr_connectslotsbyname = a; m_has_attr_connectslotsbyname = true; }
    void clearAttributeConnectslotsbyname() { m_has_attr_connectslotsbyname = false; }

    bool hasAttributeStdsetdef() const { return m_has_attr_stdsetdef; }
    int attributeStdsetdef() const { return m_attr_stdsetdef; }
    void setAttributeStdsetdef(int a) { m_attr_stdsetdef = a; m_has_attr_stdsetdef = true; }
    void clearAttributeStdsetdef() { m_has_attr_stdsetdef = false; }

    bool hasAttributeStdSetDef() const { return m_has_attr_stdSetDef; }
    int attributeStdSetDef() const { return m_attr_stdSetDef; }
    void setAttributeStdSetDef(int a) { m_attr_stdSetDef = a; m_has_attr_stdSetDef = true; }
    void clearAttributeStdSetDef() { m_has_attr_stdSetDef = false; }

    // child element accessors
    QString elementAuthor() const { return m_author; }
    void setElementAuthor(const QString &a);
    bool hasElementAuthor() const { return m_children & Author; }
    void clearElementAuthor();

    QString elementComment() const { return m_comment; }
    void setElementComment(const QString &a);
    bool hasElementComment() const { return m_children & Comment; }
    void clearElementComment();

    QString elementExportMacro() const { return m_exportMacro; }
    void setElementExportMacro(const QString &a);
    bool hasElementExportMacro() const { return m_children & ExportMacro; }
    void clearElementExportMacro();

    QString elementClass() const { return m_class; }
    void setElementClass(const QString &a);
    bool hasElementClass() const { return m_children & Class; }
    void clearElementClass();

    DomWidget *elementWidget() const { return m_widget; }
    DomWidget *takeElementWidget();
    void setElementWidget(DomWidget *a);
    bool hasElementWidget() const { return m_children & Widget; }
    void clearElementWidget();

    DomLayoutDefault *elementLayoutDefault() const { return m_layoutDefault; }
    DomLayoutDefault *takeElementLayoutDefault();
    void setElementLayoutDefault(DomLayoutDefault *a);
    bool hasElementLayoutDefault() const { return m_children & LayoutDefault; }
    void clearElementLayoutDefault();

    DomLayoutFunction *elementLayoutFunction() const { return m_layoutFunction; }
    DomLayoutFunction *takeElementLayoutFunction();
    void setElementLayoutFunction(DomLayoutFunction *a);
    bool hasElementLayoutFunction() const { return m_children & LayoutFunction; }
    void clearElementLayoutFunction();

    QString elementPixmapFunction() const { return m_pixmapFunction; }
    void setElementPixmapFunction(const QString &a);
    bool hasElementPixmapFunction() const { return m_children & PixmapFunction; }
    void clearElementPixmapFunction();

    DomCustomWidgets *elementCustomWidgets() const { return m_customWidgets; }
    DomCustomWidgets *takeElementCustomWidgets();
    void setElementCustomWidgets(DomCustomWidgets *a);
    bool hasElementCustomWidgets() const { return m_children & CustomWidgets; }
    void clearElementCustomWidgets();

    DomTabStops *elementTabStops() const { return m_tabStops; }
    DomTabStops *takeElementTabStops();
    void setElementTabStops(DomTabStops *a);
    bool hasElementTabStops() const { return m_children & TabStops; }
    void clearElementTabStops();

    DomIncludes *elementIncludes() const { return m_includes; }
    DomIncludes *takeElementIncludes();
    void setElementIncludes(DomIncludes *a);
    bool hasElementIncludes() const { return m_children & Includes; }
    void clearElementIncludes();

    DomResources *elementResources() const { return m_resources; }
    DomResources *takeElementResources();
    void setElementResources(DomResources *a);
    bool hasElementResources() const { return m_children & Resources; }
    void clearElementResources();

    DomConnections *elementConnections() const { return m_connections; }
    DomConnections *takeElementConnections();
    void setElementConnections(DomConnections *a);
    bool hasElementConnections() const { return m_children & Connections; }
    void clearElementConnections();

    DomDesignerData *elementDesignerdata() const { return m_designerdata; }
    DomDesignerData *takeElementDesignerdata();
    void setElementDesignerdata(DomDesignerData *a);
    bool hasElementDesignerdata() const { return m_children & Designerdata; }
    void clearElementDesignerdata();

    DomSlots *elementSlots() const { return m_slots; }
    DomSlots *takeElementSlots();
    void setElementSlots(DomSlots *a);
    bool hasElementSlots() const { return m_children & Slots; }
    void clearElementSlots();

    DomButtonGroups *elementButtonGroups() const { return m_buttonGroups; }
    DomButtonGroups *takeElementButtonGroups();
    void setElementButtonGroups(DomButtonGroups *a);
    bool hasElementButtonGroups() const { return m_children & ButtonGroups; }
    void clearElementButtonGroups();

private:
    // attribute data
    QString m_attr_version;
    bool m_has_attr_version = false;

    QString m_attr_language;
    bool m_has_attr_language = false;

    QString m_attr_displayname;
    bool m_has_attr_displayname = false;

    bool m_attr_idbasedtr = false;
    bool m_has_attr_idbasedtr = false;

    QString m_attr_label;
    bool m_has_attr_label = false;

    bool m_attr_connectslotsbyname = false;
    bool m_has_attr_connectslotsbyname = false;

    int m_attr_stdsetdef = 0;
    bool m_has_attr_stdsetdef = false;

    int m_attr_stdSetDef = 0;
    bool m_has_attr_stdSetDef = false;

    // child element data
    uint m_children = 0;
    QString m_author;
    QString m_comment;
    QString m_exportMacro;
    QString m_class;
    DomWidget *m_widget = nullptr;
    DomLayoutDefault *m_layoutDefault = nullptr;
    DomLayoutFunction *m_layoutFunction = nullptr;
    QString m_pixmapFunction;
    DomCustomWidgets *m_customWidgets = nullptr;
    DomTabStops *m_tabStops = nullptr;
    DomIncludes *m_includes = nullptr;
    DomResources *m_resources = nullptr;
    DomConnections *m_connections = nullptr;
    DomDesignerData *m_designerdata = nullptr;
    DomSlots *m_slots = nullptr;
    DomButtonGroups *m_buttonGroups = nullptr;

    enum Child {
        Author = 1,
        Comment = 2,
        ExportMacro = 4,
        Class = 8,
        Widget = 16,
        LayoutDefault = 32,
        LayoutFunction = 64,
        PixmapFunction = 128,
        CustomWidgets = 256,
        TabStops = 512,
        Includes = 1024,
        Resources = 2048,
        Connections = 4096,
        Designerdata = 8192,
        Slots = 16384,
        ButtonGroups = 32768
    };
};

class QDESIGNER_UILIB_EXPORT DomIncludes {
    Q_DISABLE_COPY_MOVE(DomIncludes)
public:
    DomIncludes() = default;
    ~DomIncludes();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QList<DomInclude *> elementInclude() const { return m_include; }
    void setElementInclude(const QList<DomInclude *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomInclude *> m_include;

    enum Child {
        Include = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomInclude {
    Q_DISABLE_COPY_MOVE(DomInclude)
public:
    DomInclude() = default;
    ~DomInclude();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    QString text() const { return m_text; }
    void setText(const QString &s) { m_text = s; }

    // attribute accessors
    bool hasAttributeLocation() const { return m_has_attr_location; }
    QString attributeLocation() const { return m_attr_location; }
    void setAttributeLocation(const QString &a) { m_attr_location = a; m_has_attr_location = true; }
    void clearAttributeLocation() { m_has_attr_location = false; }

    bool hasAttributeImpldecl() const { return m_has_attr_impldecl; }
    QString attributeImpldecl() const { return m_attr_impldecl; }
    void setAttributeImpldecl(const QString &a) { m_attr_impldecl = a; m_has_attr_impldecl = true; }
    void clearAttributeImpldecl() { m_has_attr_impldecl = false; }

private:
    QString m_text;

    // attribute data
    QString m_attr_location;
    bool m_has_attr_location = false;

    QString m_attr_impldecl;
    bool m_has_attr_impldecl = false;
};

class QDESIGNER_UILIB_EXPORT DomResources {
    Q_DISABLE_COPY_MOVE(DomResources)
public:
    DomResources() = default;
    ~DomResources();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeName() const { return m_has_attr_name; }
    QString attributeName() const { return m_attr_name; }
    void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    void clearAttributeName() { m_has_attr_name = false; }

    // child element accessors
    QList<DomResource *> elementInclude() const { return m_include; }
    void setElementInclude(const QList<DomResource *> &a);

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    // child element data
    uint m_children = 0;
    QList<DomResource *> m_include;

    enum Child {
        Include = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomResource {
    Q_DISABLE_COPY_MOVE(DomResource)
public:
    DomResource() = default;
    ~DomResource();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeLocation() const { return m_has_attr_location; }
    QString attributeLocation() const { return m_attr_location; }
    void setAttributeLocation(const QString &a) { m_attr_location = a; m_has_attr_location = true; }
    void clearAttributeLocation() { m_has_attr_location = false; }

private:
    // attribute data
    QString m_attr_location;
    bool m_has_attr_location = false;
};

class QDESIGNER_UILIB_EXPORT DomActionGroup {
    Q_DISABLE_COPY_MOVE(DomActionGroup)
public:
    DomActionGroup() = default;
    ~DomActionGroup();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeName() const { return m_has_attr_name; }
    QString attributeName() const { return m_attr_name; }
    void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    void clearAttributeName() { m_has_attr_name = false; }

    // child element accessors
    QList<DomAction *> elementAction() const { return m_action; }
    void setElementAction(const QList<DomAction *> &a);

    QList<DomActionGroup *> elementActionGroup() const { return m_actionGroup; }
    void setElementActionGroup(const QList<DomActionGroup *> &a);

    QList<DomProperty *> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

    QList<DomProperty *> elementAttribute() const { return m_attribute; }
    void setElementAttribute(const QList<DomProperty *> &a);

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    // child element data
    uint m_children = 0;
    QList<DomAction *> m_action;
    QList<DomActionGroup *> m_actionGroup;
    QList<DomProperty *> m_property;
    QList<DomProperty *> m_attribute;

    enum Child {
        Action = 1,
        ActionGroup = 2,
        Property = 4,
        Attribute = 8
    };
};

class QDESIGNER_UILIB_EXPORT DomAction {
    Q_DISABLE_COPY_MOVE(DomAction)
public:
    DomAction() = default;
    ~DomAction();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeName() const { return m_has_attr_name; }
    QString attributeName() const { return m_attr_name; }
    void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    void clearAttributeName() { m_has_attr_name = false; }

    bool hasAttributeMenu() const { return m_has_attr_menu; }
    QString attributeMenu() const { return m_attr_menu; }
    void setAttributeMenu(const QString &a) { m_attr_menu = a; m_has_attr_menu = true; }
    void clearAttributeMenu() { m_has_attr_menu = false; }

    // child element accessors
    QList<DomProperty *> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

    QList<DomProperty *> elementAttribute() const { return m_attribute; }
    void setElementAttribute(const QList<DomProperty *> &a);

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    QString m_attr_menu;
    bool m_has_attr_menu = false;

    // child element data
    uint m_children = 0;
    QList<DomProperty *> m_property;
    QList<DomProperty *> m_attribute;

    enum Child {
        Property = 1,
        Attribute = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomActionRef {
    Q_DISABLE_COPY_MOVE(DomActionRef)
public:
    DomActionRef() = default;
    ~DomActionRef();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeName() const { return m_has_attr_name; }
    QString attributeName() const { return m_attr_name; }
    void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    void clearAttributeName() { m_has_attr_name = false; }

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;
};

class QDESIGNER_UILIB_EXPORT DomButtonGroup {
    Q_DISABLE_COPY_MOVE(DomButtonGroup)
public:
    DomButtonGroup() = default;
    ~DomButtonGroup();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeName() const { return m_has_attr_name; }
    QString attributeName() const { return m_attr_name; }
    void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    void clearAttributeName() { m_has_attr_name = false; }

    // child element accessors
    QList<DomProperty *> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

    QList<DomProperty *> elementAttribute() const { return m_attribute; }
    void setElementAttribute(const QList<DomProperty *> &a);

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    // child element data
    uint m_children = 0;
    QList<DomProperty *> m_property;
    QList<DomProperty *> m_attribute;

    enum Child {
        Property = 1,
        Attribute = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomButtonGroups {
    Q_DISABLE_COPY_MOVE(DomButtonGroups)
public:
    DomButtonGroups() = default;
    ~DomButtonGroups();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QList<DomButtonGroup *> elementButtonGroup() const { return m_buttonGroup; }
    void setElementButtonGroup(const QList<DomButtonGroup *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomButtonGroup *> m_buttonGroup;

    enum Child {
        ButtonGroup = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomCustomWidgets {
    Q_DISABLE_COPY_MOVE(DomCustomWidgets)
public:
    DomCustomWidgets() = default;
    ~DomCustomWidgets();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QList<DomCustomWidget *> elementCustomWidget() const { return m_customWidget; }
    void setElementCustomWidget(const QList<DomCustomWidget *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomCustomWidget *> m_customWidget;

    enum Child {
        CustomWidget = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomHeader {
    Q_DISABLE_COPY_MOVE(DomHeader)
public:
    DomHeader() = default;
    ~DomHeader();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    QString text() const { return m_text; }
    void setText(const QString &s) { m_text = s; }

    // attribute accessors
    bool hasAttributeLocation() const { return m_has_attr_location; }
    QString attributeLocation() const { return m_attr_location; }
    void setAttributeLocation(const QString &a) { m_attr_location = a; m_has_attr_location = true; }
    void clearAttributeLocation() { m_has_attr_location = false; }

private:
    QString m_text;

    // attribute data
    QString m_attr_location;
    bool m_has_attr_location = false;
};

class QDESIGNER_UILIB_EXPORT DomCustomWidget {
    Q_DISABLE_COPY_MOVE(DomCustomWidget)
public:
    DomCustomWidget() = default;
    ~DomCustomWidget();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QString elementClass() const { return m_class; }
    void setElementClass(const QString &a);
    bool hasElementClass() const { return m_children & Class; }
    void clearElementClass();

    QString elementExtends() const { return m_extends; }
    void setElementExtends(const QString &a);
    bool hasElementExtends() const { return m_children & Extends; }
    void clearElementExtends();

    DomHeader *elementHeader() const { return m_header; }
    DomHeader *takeElementHeader();
    void setElementHeader(DomHeader *a);
    bool hasElementHeader() const { return m_children & Header; }
    void clearElementHeader();

    DomSize *elementSizeHint() const { return m_sizeHint; }
    DomSize *takeElementSizeHint();
    void setElementSizeHint(DomSize *a);
    bool hasElementSizeHint() const { return m_children & SizeHint; }
    void clearElementSizeHint();

    QString elementAddPageMethod() const { return m_addPageMethod; }
    void setElementAddPageMethod(const QString &a);
    bool hasElementAddPageMethod() const { return m_children & AddPageMethod; }
    void clearElementAddPageMethod();

    int elementContainer() const { return m_container; }
    void setElementContainer(int a);
    bool hasElementContainer() const { return m_children & Container; }
    void clearElementContainer();

    QString elementPixmap() const { return m_pixmap; }
    void setElementPixmap(const QString &a);
    bool hasElementPixmap() const { return m_children & Pixmap; }
    void clearElementPixmap();

    DomSlots *elementSlots() const { return m_slots; }
    DomSlots *takeElementSlots();
    void setElementSlots(DomSlots *a);
    bool hasElementSlots() const { return m_children & Slots; }
    void clearElementSlots();

    DomPropertySpecifications *elementPropertyspecifications() const { return m_propertyspecifications; }
    DomPropertySpecifications *takeElementPropertyspecifications();
    void setElementPropertyspecifications(DomPropertySpecifications *a);
    bool hasElementPropertyspecifications() const { return m_children & Propertyspecifications; }
    void clearElementPropertyspecifications();

private:

    // child element data
    uint m_children = 0;
    QString m_class;
    QString m_extends;
    DomHeader *m_header = nullptr;
    DomSize *m_sizeHint = nullptr;
    QString m_addPageMethod;
    int m_container = 0;
    QString m_pixmap;
    DomSlots *m_slots = nullptr;
    DomPropertySpecifications *m_propertyspecifications = nullptr;

    enum Child {
        Class = 1,
        Extends = 2,
        Header = 4,
        SizeHint = 8,
        AddPageMethod = 16,
        Container = 32,
        Pixmap = 64,
        Slots = 128,
        Propertyspecifications = 256
    };
};

class QDESIGNER_UILIB_EXPORT DomLayoutDefault {
    Q_DISABLE_COPY_MOVE(DomLayoutDefault)
public:
    DomLayoutDefault() = default;
    ~DomLayoutDefault();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeSpacing() const { return m_has_attr_spacing; }
    int attributeSpacing() const { return m_attr_spacing; }
    void setAttributeSpacing(int a) { m_attr_spacing = a; m_has_attr_spacing = true; }
    void clearAttributeSpacing() { m_has_attr_spacing = false; }

    bool hasAttributeMargin() const { return m_has_attr_margin; }
    int attributeMargin() const { return m_attr_margin; }
    void setAttributeMargin(int a) { m_attr_margin = a; m_has_attr_margin = true; }
    void clearAttributeMargin() { m_has_attr_margin = false; }

private:
    // attribute data
    int m_attr_spacing = 0;
    bool m_has_attr_spacing = false;

    int m_attr_margin = 0;
    bool m_has_attr_margin = false;
};

class QDESIGNER_UILIB_EXPORT DomLayoutFunction {
    Q_DISABLE_COPY_MOVE(DomLayoutFunction)
public:
    DomLayoutFunction() = default;
    ~DomLayoutFunction();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeSpacing() const { return m_has_attr_spacing; }
    QString attributeSpacing() const { return m_attr_spacing; }
    void setAttributeSpacing(const QString &a) { m_attr_spacing = a; m_has_attr_spacing = true; }
    void clearAttributeSpacing() { m_has_attr_spacing = false; }

    bool hasAttributeMargin() const { return m_has_attr_margin; }
    QString attributeMargin() const { return m_attr_margin; }
    void setAttributeMargin(const QString &a) { m_attr_margin = a; m_has_attr_margin = true; }
    void clearAttributeMargin() { m_has_attr_margin = false; }

private:
    // attribute data
    QString m_attr_spacing;
    bool m_has_attr_spacing = false;

    QString m_attr_margin;
    bool m_has_attr_margin = false;
};

class QDESIGNER_UILIB_EXPORT DomTabStops {
    Q_DISABLE_COPY_MOVE(DomTabStops)
public:
    DomTabStops() = default;
    ~DomTabStops();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QStringList elementTabStop() const { return m_tabStop; }
    void setElementTabStop(const QStringList &a);

private:

    // child element data
    uint m_children = 0;
    QStringList m_tabStop;

    enum Child {
        TabStop = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomLayout {
    Q_DISABLE_COPY_MOVE(DomLayout)
public:
    DomLayout() = default;
    ~DomLayout();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeClass() const { return m_has_attr_class; }
    QString attributeClass() const { return m_attr_class; }
    void setAttributeClass(const QString &a) { m_attr_class = a; m_has_attr_class = true; }
    void clearAttributeClass() { m_has_attr_class = false; }

    bool hasAttributeName() const { return m_has_attr_name; }
    QString attributeName() const { return m_attr_name; }
    void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    void clearAttributeName() { m_has_attr_name = false; }

    bool hasAttributeStretch() const { return m_has_attr_stretch; }
    QString attributeStretch() const { return m_attr_stretch; }
    void setAttributeStretch(const QString &a) { m_attr_stretch = a; m_has_attr_stretch = true; }
    void clearAttributeStretch() { m_has_attr_stretch = false; }

    bool hasAttributeRowStretch() const { return m_has_attr_rowStretch; }
    QString attributeRowStretch() const { return m_attr_rowStretch; }
    void setAttributeRowStretch(const QString &a) { m_attr_rowStretch = a; m_has_attr_rowStretch = true; }
    void clearAttributeRowStretch() { m_has_attr_rowStretch = false; }

    bool hasAttributeColumnStretch() const { return m_has_attr_columnStretch; }
    QString attributeColumnStretch() const { return m_attr_columnStretch; }
    void setAttributeColumnStretch(const QString &a) { m_attr_columnStretch = a; m_has_attr_columnStretch = true; }
    void clearAttributeColumnStretch() { m_has_attr_columnStretch = false; }

    bool hasAttributeRowMinimumHeight() const { return m_has_attr_rowMinimumHeight; }
    QString attributeRowMinimumHeight() const { return m_attr_rowMinimumHeight; }
    void setAttributeRowMinimumHeight(const QString &a) { m_attr_rowMinimumHeight = a; m_has_attr_rowMinimumHeight = true; }
    void clearAttributeRowMinimumHeight() { m_has_attr_rowMinimumHeight = false; }

    bool hasAttributeColumnMinimumWidth() const { return m_has_attr_columnMinimumWidth; }
    QString attributeColumnMinimumWidth() const { return m_attr_columnMinimumWidth; }
    void setAttributeColumnMinimumWidth(const QString &a) { m_attr_columnMinimumWidth = a; m_has_attr_columnMinimumWidth = true; }
    void clearAttributeColumnMinimumWidth() { m_has_attr_columnMinimumWidth = false; }

    // child element accessors
    QList<DomProperty *> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

    QList<DomProperty *> elementAttribute() const { return m_attribute; }
    void setElementAttribute(const QList<DomProperty *> &a);

    QList<DomLayoutItem *> elementItem() const { return m_item; }
    void setElementItem(const QList<DomLayoutItem *> &a);

private:
    // attribute data
    QString m_attr_class;
    bool m_has_attr_class = false;

    QString m_attr_name;
    bool m_has_attr_name = false;

    QString m_attr_stretch;
    bool m_has_attr_stretch = false;

    QString m_attr_rowStretch;
    bool m_has_attr_rowStretch = false;

    QString m_attr_columnStretch;
    bool m_has_attr_columnStretch = false;

    QString m_attr_rowMinimumHeight;
    bool m_has_attr_rowMinimumHeight = false;

    QString m_attr_columnMinimumWidth;
    bool m_has_attr_columnMinimumWidth = false;

    // child element data
    uint m_children = 0;
    QList<DomProperty *> m_property;
    QList<DomProperty *> m_attribute;
    QList<DomLayoutItem *> m_item;

    enum Child {
        Property = 1,
        Attribute = 2,
        Item = 4
    };
};

class QDESIGNER_UILIB_EXPORT DomLayoutItem {
    Q_DISABLE_COPY_MOVE(DomLayoutItem)
public:
    DomLayoutItem() = default;
    ~DomLayoutItem();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeRow() const { return m_has_attr_row; }
    int attributeRow() const { return m_attr_row; }
    void setAttributeRow(int a) { m_attr_row = a; m_has_attr_row = true; }
    void clearAttributeRow() { m_has_attr_row = false; }

    bool hasAttributeColumn() const { return m_has_attr_column; }
    int attributeColumn() const { return m_attr_column; }
    void setAttributeColumn(int a) { m_attr_column = a; m_has_attr_column = true; }
    void clearAttributeColumn() { m_has_attr_column = false; }

    bool hasAttributeRowSpan() const { return m_has_attr_rowSpan; }
    int attributeRowSpan() const { return m_attr_rowSpan; }
    void setAttributeRowSpan(int a) { m_attr_rowSpan = a; m_has_attr_rowSpan = true; }
    void clearAttributeRowSpan() { m_has_attr_rowSpan = false; }

    bool hasAttributeColSpan() const { return m_has_attr_colSpan; }
    int attributeColSpan() const { return m_attr_colSpan; }
    void setAttributeColSpan(int a) { m_attr_colSpan = a; m_has_attr_colSpan = true; }
    void clearAttributeColSpan() { m_has_attr_colSpan = false; }

    bool hasAttributeAlignment() const { return m_has_attr_alignment; }
    QString attributeAlignment() const { return m_attr_alignment; }
    void setAttributeAlignment(const QString &a) { m_attr_alignment = a; m_has_attr_alignment = true; }
    void clearAttributeAlignment() { m_has_attr_alignment = false; }

    // child element accessors
    enum Kind { Unknown = 0, Widget, Layout, Spacer };
    Kind kind() const { return m_kind; }

    DomWidget *elementWidget() const { return m_widget; }
    DomWidget *takeElementWidget();
    void setElementWidget(DomWidget *a);

    DomLayout *elementLayout() const { return m_layout; }
    DomLayout *takeElementLayout();
    void setElementLayout(DomLayout *a);

    DomSpacer *elementSpacer() const { return m_spacer; }
    DomSpacer *takeElementSpacer();
    void setElementSpacer(DomSpacer *a);

private:
    void clear();

    // attribute data
    int m_attr_row = 0;
    bool m_has_attr_row = false;

    int m_attr_column = 0;
    bool m_has_attr_column = false;

    int m_attr_rowSpan = 0;
    bool m_has_attr_rowSpan = false;

    int m_attr_colSpan = 0;
    bool m_has_attr_colSpan = false;

    QString m_attr_alignment;
    bool m_has_attr_alignment = false;

    // child element data
    Kind m_kind = Unknown;
    DomWidget *m_widget = nullptr;
    DomLayout *m_layout = nullptr;
    DomSpacer *m_spacer = nullptr;
};

class QDESIGNER_UILIB_EXPORT DomRow {
    Q_DISABLE_COPY_MOVE(DomRow)
public:
    DomRow() = default;
    ~DomRow();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QList<DomProperty *> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomProperty *> m_property;

    enum Child {
        Property = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomColumn {
    Q_DISABLE_COPY_MOVE(DomColumn)
public:
    DomColumn() = default;
    ~DomColumn();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QList<DomProperty *> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomProperty *> m_property;

    enum Child {
        Property = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomItem {
    Q_DISABLE_COPY_MOVE(DomItem)
public:
    DomItem() = default;
    ~DomItem();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeRow() const { return m_has_attr_row; }
    int attributeRow() const { return m_attr_row; }
    void setAttributeRow(int a) { m_attr_row = a; m_has_attr_row = true; }
    void clearAttributeRow() { m_has_attr_row = false; }

    bool hasAttributeColumn() const { return m_has_attr_column; }
    int attributeColumn() const { return m_attr_column; }
    void setAttributeColumn(int a) { m_attr_column = a; m_has_attr_column = true; }
    void clearAttributeColumn() { m_has_attr_column = false; }

    // child element accessors
    QList<DomProperty *> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

    QList<DomItem *> elementItem() const { return m_item; }
    void setElementItem(const QList<DomItem *> &a);

private:
    // attribute data
    int m_attr_row = 0;
    bool m_has_attr_row = false;

    int m_attr_column = 0;
    bool m_has_attr_column = false;

    // child element data
    uint m_children = 0;
    QList<DomProperty *> m_property;
    QList<DomItem *> m_item;

    enum Child {
        Property = 1,
        Item = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomWidget {
    Q_DISABLE_COPY_MOVE(DomWidget)
public:
    DomWidget() = default;
    ~DomWidget();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeClass() const { return m_has_attr_class; }
    QString attributeClass() const { return m_attr_class; }
    void setAttributeClass(const QString &a) { m_attr_class = a; m_has_attr_class = true; }
    void clearAttributeClass() { m_has_attr_class = false; }

    bool hasAttributeName() const { return m_has_attr_name; }
    QString attributeName() const { return m_attr_name; }
    void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    void clearAttributeName() { m_has_attr_name = false; }

    bool hasAttributeNative() const { return m_has_attr_native; }
    bool attributeNative() const { return m_attr_native; }
    void setAttributeNative(bool a) { m_attr_native = a; m_has_attr_native = true; }
    void clearAttributeNative() { m_has_attr_native = false; }

    // child element accessors
    QStringList elementClass() const { return m_class; }
    void setElementClass(const QStringList &a);

    QList<DomProperty *> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

    QList<DomProperty *> elementAttribute() const { return m_attribute; }
    void setElementAttribute(const QList<DomProperty *> &a);

    QList<DomRow *> elementRow() const { return m_row; }
    void setElementRow(const QList<DomRow *> &a);

    QList<DomColumn *> elementColumn() const { return m_column; }
    void setElementColumn(const QList<DomColumn *> &a);

    QList<DomItem *> elementItem() const { return m_item; }
    void setElementItem(const QList<DomItem *> &a);

    QList<DomLayout *> elementLayout() const { return m_layout; }
    void setElementLayout(const QList<DomLayout *> &a);

    QList<DomWidget *> elementWidget() const { return m_widget; }
    void setElementWidget(const QList<DomWidget *> &a);

    QList<DomAction *> elementAction() const { return m_action; }
    void setElementAction(const QList<DomAction *> &a);

    QList<DomActionGroup *> elementActionGroup() const { return m_actionGroup; }
    void setElementActionGroup(const QList<DomActionGroup *> &a);

    QList<DomActionRef *> elementAddAction() const { return m_addAction; }
    void setElementAddAction(const QList<DomActionRef *> &a);

    QStringList elementZOrder() const { return m_zOrder; }
    void setElementZOrder(const QStringList &a);

private:
    // attribute data
    QString m_attr_class;
    bool m_has_attr_class = false;

    QString m_attr_name;
    bool m_has_attr_name = false;

    bool m_attr_native = false;
    bool m_has_attr_native = false;

    // child element data
    uint m_children = 0;
    QStringList m_class;
    QList<DomProperty *> m_property;
    QList<DomProperty *> m_attribute;
    QList<DomRow *> m_row;
    QList<DomColumn *> m_column;
    QList<DomItem *> m_item;
    QList<DomLayout *> m_layout;
    QList<DomWidget *> m_widget;
    QList<DomAction *> m_action;
    QList<DomActionGroup *> m_actionGroup;
    QList<DomActionRef *> m_addAction;
    QStringList m_zOrder;

    enum Child {
        Class = 1,
        Property = 2,
        Attribute = 4,
        Row = 8,
        Column = 16,
        Item = 32,
        Layout = 64,
        Widget = 128,
        Action = 256,
        ActionGroup = 512,
        AddAction = 1024,
        ZOrder = 2048
    };
};

class QDESIGNER_UILIB_EXPORT DomSpacer {
    Q_DISABLE_COPY_MOVE(DomSpacer)
public:
    DomSpacer() = default;
    ~DomSpacer();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeName() const { return m_has_attr_name; }
    QString attributeName() const { return m_attr_name; }
    void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    void clearAttributeName() { m_has_attr_name = false; }

    // child element accessors
    QList<DomProperty *> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    // child element data
    uint m_children = 0;
    QList<DomProperty *> m_property;

    enum Child {
        Property = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomColor {
    Q_DISABLE_COPY_MOVE(DomColor)
public:
    DomColor() = default;
    ~DomColor();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeAlpha() const { return m_has_attr_alpha; }
    int attributeAlpha() const { return m_attr_alpha; }
    void setAttributeAlpha(int a) { m_attr_alpha = a; m_has_attr_alpha = true; }
    void clearAttributeAlpha() { m_has_attr_alpha = false; }

    // child element accessors
    int elementRed() const { return m_red; }
    void setElementRed(int a);
    bool hasElementRed() const { return m_children & Red; }
    void clearElementRed();

    int elementGreen() const { return m_green; }
    void setElementGreen(int a);
    bool hasElementGreen() const { return m_children & Green; }
    void clearElementGreen();

    int elementBlue() const { return m_blue; }
    void setElementBlue(int a);
    bool hasElementBlue() const { return m_children & Blue; }
    void clearElementBlue();

private:
    // attribute data
    int m_attr_alpha = 0;
    bool m_has_attr_alpha = false;

    // child element data
    uint m_children = 0;
    int m_red = 0;
    int m_green = 0;
    int m_blue = 0;

    enum Child {
        Red = 1,
        Green = 2,
        Blue = 4
    };
};

class QDESIGNER_UILIB_EXPORT DomGradientStop {
    Q_DISABLE_COPY_MOVE(DomGradientStop)
public:
    DomGradientStop() = default;
    ~DomGradientStop();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributePosition() const { return m_has_attr_position; }
    double attributePosition() const { return m_attr_position; }
    void setAttributePosition(double a) { m_attr_position = a; m_has_attr_position = true; }
    void clearAttributePosition() { m_has_attr_position = false; }

    // child element accessors
    DomColor *elementColor() const { return m_color; }
    DomColor *takeElementColor();
    void setElementColor(DomColor *a);
    bool hasElementColor() const { return m_children & Color; }
    void clearElementColor();

private:
    // attribute data
    double m_attr_position = 0.0;
    bool m_has_attr_position = false;

    // child element data
    uint m_children = 0;
    DomColor *m_color = nullptr;

    enum Child {
        Color = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomGradient {
    Q_DISABLE_COPY_MOVE(DomGradient)
public:
    DomGradient() = default;
    ~DomGradient();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeStartX() const { return m_has_attr_startX; }
    double attributeStartX() const { return m_attr_startX; }
    void setAttributeStartX(double a) { m_attr_startX = a; m_has_attr_startX = true; }
    void clearAttributeStartX() { m_has_attr_startX = false; }

    bool hasAttributeStartY() const { return m_has_attr_startY; }
    double attributeStartY() const { return m_attr_startY; }
    void setAttributeStartY(double a) { m_attr_startY = a; m_has_attr_startY = true; }
    void clearAttributeStartY() { m_has_attr_startY = false; }

    bool hasAttributeEndX() const { return m_has_attr_endX; }
    double attributeEndX() const { return m_attr_endX; }
    void setAttributeEndX(double a) { m_attr_endX = a; m_has_attr_endX = true; }
    void clearAttributeEndX() { m_has_attr_endX = false; }

    bool hasAttributeEndY() const { return m_has_attr_endY; }
    double attributeEndY() const { return m_attr_endY; }
    void setAttributeEndY(double a) { m_attr_endY = a; m_has_attr_endY = true; }
    void clearAttributeEndY() { m_has_attr_endY = false; }

    bool hasAttributeCentralX() const { return m_has_attr_centralX; }
    double attributeCentralX() const { return m_attr_centralX; }
    void setAttributeCentralX(double a) { m_attr_centralX = a; m_has_attr_centralX = true; }
    void clearAttributeCentralX() { m_has_attr_centralX = false; }

    bool hasAttributeCentralY() const { return m_has_attr_centralY; }
    double attributeCentralY() const { return m_attr_centralY; }
    void setAttributeCentralY(double a) { m_attr_centralY = a; m_has_attr_centralY = true; }
    void clearAttributeCentralY() { m_has_attr_centralY = false; }

    bool hasAttributeFocalX() const { return m_has_attr_focalX; }
    double attributeFocalX() const { return m_attr_focalX; }
    void setAttributeFocalX(double a) { m_attr_focalX = a; m_has_attr_focalX = true; }
    void clearAttributeFocalX() { m_has_attr_focalX = false; }

    bool hasAttributeFocalY() const { return m_has_attr_focalY; }
    double attributeFocalY() const { return m_attr_focalY; }
    void setAttributeFocalY(double a) { m_attr_focalY = a; m_has_attr_focalY = true; }
    void clearAttributeFocalY() { m_has_attr_focalY = false; }

    bool hasAttributeRadius() const { return m_has_attr_radius; }
    double attributeRadius() const { return m_attr_radius; }
    void setAttributeRadius(double a) { m_attr_radius = a; m_has_attr_radius = true; }
    void clearAttributeRadius() { m_has_attr_radius = false; }

    bool hasAttributeAngle() const { return m_has_attr_angle; }
    double attributeAngle() const { return m_attr_angle; }
    void setAttributeAngle(double a) { m_attr_angle = a; m_has_attr_angle = true; }
    void clearAttributeAngle() { m_has_attr_angle = false; }

    bool hasAttributeType() const { return m_has_attr_type; }
    QString attributeType() const { return m_attr_type; }
    void setAttributeType(const QString &a) { m_attr_type = a; m_has_attr_type = true; }
    void clearAttributeType() { m_has_attr_type = false; }

    bool hasAttributeSpread() const { return m_has_attr_spread; }
    QString attributeSpread() const { return m_attr_spread; }
    void setAttributeSpread(const QString &a) { m_attr_spread = a; m_has_attr_spread = true; }
    void clearAttributeSpread() { m_has_attr_spread = false; }

    bool hasAttributeCoordinateMode() const { return m_has_attr_coordinateMode; }
    QString attributeCoordinateMode() const { return m_attr_coordinateMode; }
    void setAttributeCoordinateMode(const QString &a) { m_attr_coordinateMode = a; m_has_attr_coordinateMode = true; }
    void clearAttributeCoordinateMode() { m_has_attr_coordinateMode = false; }

    // child element accessors
    QList<DomGradientStop *> elementGradientStop() const { return m_gradientStop; }
    void setElementGradientStop(const QList<DomGradientStop *> &a);

private:
    // attribute data
    double m_attr_startX = 0.0;
    bool m_has_attr_startX = false;

    double m_attr_startY = 0.0;
    bool m_has_attr_startY = false;

    double m_attr_endX = 0.0;
    bool m_has_attr_endX = false;

    double m_attr_endY = 0.0;
    bool m_has_attr_endY = false;

    double m_attr_centralX = 0.0;
    bool m_has_attr_centralX = false;

    double m_attr_centralY = 0.0;
    bool m_has_attr_centralY = false;

    double m_attr_focalX = 0.0;
    bool m_has_attr_focalX = false;

    double m_attr_focalY = 0.0;
    bool m_has_attr_focalY = false;

    double m_attr_radius = 0.0;
    bool m_has_attr_radius = false;

    double m_attr_angle = 0.0;
    bool m_has_attr_angle = false;

    QString m_attr_type;
    bool m_has_attr_type = false;

    QString m_attr_spread;
    bool m_has_attr_spread = false;

    QString m_attr_coordinateMode;
    bool m_has_attr_coordinateMode = false;

    // child element data
    uint m_children = 0;
    QList<DomGradientStop *> m_gradientStop;

    enum Child {
        GradientStop = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomBrush {
    Q_DISABLE_COPY_MOVE(DomBrush)
public:
    DomBrush() = default;
    ~DomBrush();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeBrushStyle() const { return m_has_attr_brushStyle; }
    QString attributeBrushStyle() const { return m_attr_brushStyle; }
    void setAttributeBrushStyle(const QString &a) { m_attr_brushStyle = a; m_has_attr_brushStyle = true; }
    void clearAttributeBrushStyle() { m_has_attr_brushStyle = false; }

    // child element accessors
    enum Kind { Unknown = 0, Color, Texture, Gradient };
    Kind kind() const { return m_kind; }

    DomColor *elementColor() const { return m_color; }
    DomColor *takeElementColor();
    void setElementColor(DomColor *a);

    DomProperty *elementTexture() const { return m_texture; }
    DomProperty *takeElementTexture();
    void setElementTexture(DomProperty *a);

    DomGradient *elementGradient() const { return m_gradient; }
    DomGradient *takeElementGradient();
    void setElementGradient(DomGradient *a);

private:
    void clear();

    // attribute data
    QString m_attr_brushStyle;
    bool m_has_attr_brushStyle = false;

    // child element data
    Kind m_kind = Unknown;
    DomColor *m_color = nullptr;
    DomProperty *m_texture = nullptr;
    DomGradient *m_gradient = nullptr;
};

class QDESIGNER_UILIB_EXPORT DomColorRole {
    Q_DISABLE_COPY_MOVE(DomColorRole)
public:
    DomColorRole() = default;
    ~DomColorRole();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeRole() const { return m_has_attr_role; }
    QString attributeRole() const { return m_attr_role; }
    void setAttributeRole(const QString &a) { m_attr_role = a; m_has_attr_role = true; }
    void clearAttributeRole() { m_has_attr_role = false; }

    // child element accessors
    DomBrush *elementBrush() const { return m_brush; }
    DomBrush *takeElementBrush();
    void setElementBrush(DomBrush *a);
    bool hasElementBrush() const { return m_children & Brush; }
    void clearElementBrush();

private:
    // attribute data
    QString m_attr_role;
    bool m_has_attr_role = false;

    // child element data
    uint m_children = 0;
    DomBrush *m_brush = nullptr;

    enum Child {
        Brush = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomColorGroup {
    Q_DISABLE_COPY_MOVE(DomColorGroup)
public:
    DomColorGroup() = default;
    ~DomColorGroup();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QList<DomColorRole *> elementColorRole() const { return m_colorRole; }
    void setElementColorRole(const QList<DomColorRole *> &a);

    QList<DomColor *> elementColor() const { return m_color; }
    void setElementColor(const QList<DomColor *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomColorRole *> m_colorRole;
    QList<DomColor *> m_color;

    enum Child {
        ColorRole = 1,
        Color = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomPalette {
    Q_DISABLE_COPY_MOVE(DomPalette)
public:
    DomPalette() = default;
    ~DomPalette();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    DomColorGroup *elementActive() const { return m_active; }
    DomColorGroup *takeElementActive();
    void setElementActive(DomColorGroup *a);
    bool hasElementActive() const { return m_children & Active; }
    void clearElementActive();

    DomColorGroup *elementInactive() const { return m_inactive; }
    DomColorGroup *takeElementInactive();
    void setElementInactive(DomColorGroup *a);
    bool hasElementInactive() const { return m_children & Inactive; }
    void clearElementInactive();

    DomColorGroup *elementDisabled() const { return m_disabled; }
    DomColorGroup *takeElementDisabled();
    void setElementDisabled(DomColorGroup *a);
    bool hasElementDisabled() const { return m_children & Disabled; }
    void clearElementDisabled();

private:

    // child element data
    uint m_children = 0;
    DomColorGroup *m_active = nullptr;
    DomColorGroup *m_inactive = nullptr;
    DomColorGroup *m_disabled = nullptr;

    enum Child {
        Active = 1,
        Inactive = 2,
        Disabled = 4
    };
};

class QDESIGNER_UILIB_EXPORT DomFont {
    Q_DISABLE_COPY_MOVE(DomFont)
public:
    DomFont() = default;
    ~DomFont();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QString elementFamily() const { return m_family; }
    void setElementFamily(const QString &a);
    bool hasElementFamily() const { return m_children & Family; }
    void clearElementFamily();

    int elementPointSize() const { return m_pointSize; }
    void setElementPointSize(int a);
    bool hasElementPointSize() const { return m_children & PointSize; }
    void clearElementPointSize();

    int elementWeight() const { return m_weight; }
    void setElementWeight(int a);
    bool hasElementWeight() const { return m_children & Weight; }
    void clearElementWeight();

    bool elementItalic() const { return m_italic; }
    void setElementItalic(bool a);
    bool hasElementItalic() const { return m_children & Italic; }
    void clearElementItalic();

    bool elementBold() const { return m_bold; }
    void setElementBold(bool a);
    bool hasElementBold() const { return m_children & Bold; }
    void clearElementBold();

    bool elementUnderline() const { return m_underline; }
    void setElementUnderline(bool a);
    bool hasElementUnderline() const { return m_children & Underline; }
    void clearElementUnderline();

    bool elementStrikeOut() const { return m_strikeOut; }
    void setElementStrikeOut(bool a);
    bool hasElementStrikeOut() const { return m_children & StrikeOut; }
    void clearElementStrikeOut();

    bool elementAntialiasing() const { return m_antialiasing; }
    void setElementAntialiasing(bool a);
    bool hasElementAntialiasing() const { return m_children & Antialiasing; }
    void clearElementAntialiasing();

    QString elementStyleStrategy() const { return m_styleStrategy; }
    void setElementStyleStrategy(const QString &a);
    bool hasElementStyleStrategy() const { return m_children & StyleStrategy; }
    void clearElementStyleStrategy();

    bool elementKerning() const { return m_kerning; }
    void setElementKerning(bool a);
    bool hasElementKerning() const { return m_children & Kerning; }
    void clearElementKerning();

    QString elementHintingPreference() const { return m_hintingPreference; }
    void setElementHintingPreference(const QString &a);
    bool hasElementHintingPreference() const { return m_children & HintingPreference; }
    void clearElementHintingPreference();

    QString elementFontWeight() const { return m_fontWeight; }
    void setElementFontWeight(const QString &a);
    bool hasElementFontWeight() const { return m_children & FontWeight; }
    void clearElementFontWeight();

private:

    // child element data
    uint m_children = 0;
    QString m_family;
    int m_pointSize = 0;
    int m_weight = 0;
    bool m_italic = false;
    bool m_bold = false;
    bool m_underline = false;
    bool m_strikeOut = false;
    bool m_antialiasing = false;
    QString m_styleStrategy;
    bool m_kerning = false;
    QString m_hintingPreference;
    QString m_fontWeight;

    enum Child {
        Family = 1,
        PointSize = 2,
        Weight = 4,
        Italic = 8,
        Bold = 16,
        Underline = 32,
        StrikeOut = 64,
        Antialiasing = 128,
        StyleStrategy = 256,
        Kerning = 512,
        HintingPreference = 1024,
        FontWeight = 2048
    };
};

class QDESIGNER_UILIB_EXPORT DomPoint {
    Q_DISABLE_COPY_MOVE(DomPoint)
public:
    DomPoint() = default;
    ~DomPoint();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    int elementX() const { return m_x; }
    void setElementX(int a);
    bool hasElementX() const { return m_children & X; }
    void clearElementX();

    int elementY() const { return m_y; }
    void setElementY(int a);
    bool hasElementY() const { return m_children & Y; }
    void clearElementY();

private:

    // child element data
    uint m_children = 0;
    int m_x = 0;
    int m_y = 0;

    enum Child {
        X = 1,
        Y = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomRect {
    Q_DISABLE_COPY_MOVE(DomRect)
public:
    DomRect() = default;
    ~DomRect();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    int elementX() const { return m_x; }
    void setElementX(int a);
    bool hasElementX() const { return m_children & X; }
    void clearElementX();

    int elementY() const { return m_y; }
    void setElementY(int a);
    bool hasElementY() const { return m_children & Y; }
    void clearElementY();

    int elementWidth() const { return m_width; }
    void setElementWidth(int a);
    bool hasElementWidth() const { return m_children & Width; }
    void clearElementWidth();

    int elementHeight() const { return m_height; }
    void setElementHeight(int a);
    bool hasElementHeight() const { return m_children & Height; }
    void clearElementHeight();

private:

    // child element data
    uint m_children = 0;
    int m_x = 0;
    int m_y = 0;
    int m_width = 0;
    int m_height = 0;

    enum Child {
        X = 1,
        Y = 2,
        Width = 4,
        Height = 8
    };
};

class QDESIGNER_UILIB_EXPORT DomLocale {
    Q_DISABLE_COPY_MOVE(DomLocale)
public:
    DomLocale() = default;
    ~DomLocale();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeLanguage() const { return m_has_attr_language; }
    QString attributeLanguage() const { return m_attr_language; }
    void setAttributeLanguage(const QString &a) { m_attr_language = a; m_has_attr_language = true; }
    void clearAttributeLanguage() { m_has_attr_language = false; }

    bool hasAttributeCountry() const { return m_has_attr_country; }
    QString attributeCountry() const { return m_attr_country; }
    void setAttributeCountry(const QString &a) { m_attr_country = a; m_has_attr_country = true; }
    void clearAttributeCountry() { m_has_attr_country = false; }

private:
    // attribute data
    QString m_attr_language;
    bool m_has_attr_language = false;

    QString m_attr_country;
    bool m_has_attr_country = false;
};

class QDESIGNER_UILIB_EXPORT DomSizePolicy {
    Q_DISABLE_COPY_MOVE(DomSizePolicy)
public:
    DomSizePolicy() = default;
    ~DomSizePolicy();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeHSizeType() const { return m_has_attr_hSizeType; }
    QString attributeHSizeType() const { return m_attr_hSizeType; }
    void setAttributeHSizeType(const QString &a) { m_attr_hSizeType = a; m_has_attr_hSizeType = true; }
    void clearAttributeHSizeType() { m_has_attr_hSizeType = false; }

    bool hasAttributeVSizeType() const { return m_has_attr_vSizeType; }
    QString attributeVSizeType() const { return m_attr_vSizeType; }
    void setAttributeVSizeType(const QString &a) { m_attr_vSizeType = a; m_has_attr_vSizeType = true; }
    void clearAttributeVSizeType() { m_has_attr_vSizeType = false; }

    // child element accessors
    int elementHSizeType() const { return m_hSizeType; }
    void setElementHSizeType(int a);
    bool hasElementHSizeType() const { return m_children & HSizeType; }
    void clearElementHSizeType();

    int elementVSizeType() const { return m_vSizeType; }
    void setElementVSizeType(int a);
    bool hasElementVSizeType() const { return m_children & VSizeType; }
    void clearElementVSizeType();

    int elementHorStretch() const { return m_horStretch; }
    void setElementHorStretch(int a);
    bool hasElementHorStretch() const { return m_children & HorStretch; }
    void clearElementHorStretch();

    int elementVerStretch() const { return m_verStretch; }
    void setElementVerStretch(int a);
    bool hasElementVerStretch() const { return m_children & VerStretch; }
    void clearElementVerStretch();

private:
    // attribute data
    QString m_attr_hSizeType;
    bool m_has_attr_hSizeType = false;

    QString m_attr_vSizeType;
    bool m_has_attr_vSizeType = false;

    // child element data
    uint m_children = 0;
    int m_hSizeType = 0;
    int m_vSizeType = 0;
    int m_horStretch = 0;
    int m_verStretch = 0;

    enum Child {
        HSizeType = 1,
        VSizeType = 2,
        HorStretch = 4,
        VerStretch = 8
    };
};

class QDESIGNER_UILIB_EXPORT DomSize {
    Q_DISABLE_COPY_MOVE(DomSize)
public:
    DomSize() = default;
    ~DomSize();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    int elementWidth() const { return m_width; }
    void setElementWidth(int a);
    bool hasElementWidth() const { return m_children & Width; }
    void clearElementWidth();

    int elementHeight() const { return m_height; }
    void setElementHeight(int a);
    bool hasElementHeight() const { return m_children & Height; }
    void clearElementHeight();

private:

    // child element data
    uint m_children = 0;
    int m_width = 0;
    int m_height = 0;

    enum Child {
        Width = 1,
        Height = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomDate {
    Q_DISABLE_COPY_MOVE(DomDate)
public:
    DomDate() = default;
    ~DomDate();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    int elementYear() const { return m_year; }
    void setElementYear(int a);
    bool hasElementYear() const { return m_children & Year; }
    void clearElementYear();

    int elementMonth() const { return m_month; }
    void setElementMonth(int a);
    bool hasElementMonth() const { return m_children & Month; }
    void clearElementMonth();

    int elementDay() const { return m_day; }
    void setElementDay(int a);
    bool hasElementDay() const { return m_children & Day; }
    void clearElementDay();

private:

    // child element data
    uint m_children = 0;
    int m_year = 0;
    int m_month = 0;
    int m_day = 0;

    enum Child {
        Year = 1,
        Month = 2,
        Day = 4
    };
};

class QDESIGNER_UILIB_EXPORT DomTime {
    Q_DISABLE_COPY_MOVE(DomTime)
public:
    DomTime() = default;
    ~DomTime();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    int elementHour() const { return m_hour; }
    void setElementHour(int a);
    bool hasElementHour() const { return m_children & Hour; }
    void clearElementHour();

    int elementMinute() const { return m_minute; }
    void setElementMinute(int a);
    bool hasElementMinute() const { return m_children & Minute; }
    void clearElementMinute();

    int elementSecond() const { return m_second; }
    void setElementSecond(int a);
    bool hasElementSecond() const { return m_children & Second; }
    void clearElementSecond();

private:

    // child element data
    uint m_children = 0;
    int m_hour = 0;
    int m_minute = 0;
    int m_second = 0;

    enum Child {
        Hour = 1,
        Minute = 2,
        Second = 4
    };
};

class QDESIGNER_UILIB_EXPORT DomDateTime {
    Q_DISABLE_COPY_MOVE(DomDateTime)
public:
    DomDateTime() = default;
    ~DomDateTime();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    int elementHour() const { return m_hour; }
    void setElementHour(int a);
    bool hasElementHour() const { return m_children & Hour; }
    void clearElementHour();

    int elementMinute() const { return m_minute; }
    void setElementMinute(int a);
    bool hasElementMinute() const { return m_children & Minute; }
    void clearElementMinute();

    int elementSecond() const { return m_second; }
    void setElementSecond(int a);
    bool hasElementSecond() const { return m_children & Second; }
    void clearElementSecond();

    int elementYear() const { return m_year; }
    void setElementYear(int a);
    bool hasElementYear() const { return m_children & Year; }
    void clearElementYear();

    int elementMonth() const { return m_month; }
    void setElementMonth(int a);
    bool hasElementMonth() const { return m_children & Month; }
    void clearElementMonth();

    int elementDay() const { return m_day; }
    void setElementDay(int a);
    bool hasElementDay() const { return m_children & Day; }
    void clearElementDay();

private:

    // child element data
    uint m_children = 0;
    int m_hour = 0;
    int m_minute = 0;
    int m_second = 0;
    int m_year = 0;
    int m_month = 0;
    int m_day = 0;

    enum Child {
        Hour = 1,
        Minute = 2,
        Second = 4,
        Year = 8,
        Month = 16,
        Day = 32
    };
};

class QDESIGNER_UILIB_EXPORT DomStringList {
    Q_DISABLE_COPY_MOVE(DomStringList)
public:
    DomStringList() = default;
    ~DomStringList();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeNotr() const { return m_has_attr_notr; }
    QString attributeNotr() const { return m_attr_notr; }
    void setAttributeNotr(const QString &a) { m_attr_notr = a; m_has_attr_notr = true; }
    void clearAttributeNotr() { m_has_attr_notr = false; }

    bool hasAttributeComment() const { return m_has_attr_comment; }
    QString attributeComment() const { return m_attr_comment; }
    void setAttributeComment(const QString &a) { m_attr_comment = a; m_has_attr_comment = true; }
    void clearAttributeComment() { m_has_attr_comment = false; }

    bool hasAttributeExtraComment() const { return m_has_attr_extraComment; }
    QString attributeExtraComment() const { return m_attr_extraComment; }
    void setAttributeExtraComment(const QString &a) { m_attr_extraComment = a; m_has_attr_extraComment = true; }
    void clearAttributeExtraComment() { m_has_attr_extraComment = false; }

    bool hasAttributeId() const { return m_has_attr_id; }
    QString attributeId() const { return m_attr_id; }
    void setAttributeId(const QString &a) { m_attr_id = a; m_has_attr_id = true; }
    void clearAttributeId() { m_has_attr_id = false; }

    // child element accessors
    QStringList elementString() const { return m_string; }
    void setElementString(const QStringList &a);

private:
    // attribute data
    QString m_attr_notr;
    bool m_has_attr_notr = false;

    QString m_attr_comment;
    bool m_has_attr_comment = false;

    QString m_attr_extraComment;
    bool m_has_attr_extraComment = false;

    QString m_attr_id;
    bool m_has_attr_id = false;

    // child element data
    uint m_children = 0;
    QStringList m_string;

    enum Child {
        String = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomResourcePixmap {
    Q_DISABLE_COPY_MOVE(DomResourcePixmap)
public:
    DomResourcePixmap() = default;
    ~DomResourcePixmap();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    QString text() const { return m_text; }
    void setText(const QString &s) { m_text = s; }

    // attribute accessors
    bool hasAttributeResource() const { return m_has_attr_resource; }
    QString attributeResource() const { return m_attr_resource; }
    void setAttributeResource(const QString &a) { m_attr_resource = a; m_has_attr_resource = true; }
    void clearAttributeResource() { m_has_attr_resource = false; }

    bool hasAttributeAlias() const { return m_has_attr_alias; }
    QString attributeAlias() const { return m_attr_alias; }
    void setAttributeAlias(const QString &a) { m_attr_alias = a; m_has_attr_alias = true; }
    void clearAttributeAlias() { m_has_attr_alias = false; }

private:
    QString m_text;

    // attribute data
    QString m_attr_resource;
    bool m_has_attr_resource = false;

    QString m_attr_alias;
    bool m_has_attr_alias = false;
};

class QDESIGNER_UILIB_EXPORT DomResourceIcon {
    Q_DISABLE_COPY_MOVE(DomResourceIcon)
public:
    DomResourceIcon() = default;
    ~DomResourceIcon();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    QString text() const { return m_text; }
    void setText(const QString &s) { m_text = s; }

    // attribute accessors
    bool hasAttributeTheme() const { return m_has_attr_theme; }
    QString attributeTheme() const { return m_attr_theme; }
    void setAttributeTheme(const QString &a) { m_attr_theme = a; m_has_attr_theme = true; }
    void clearAttributeTheme() { m_has_attr_theme = false; }

    bool hasAttributeResource() const { return m_has_attr_resource; }
    QString attributeResource() const { return m_attr_resource; }
    void setAttributeResource(const QString &a) { m_attr_resource = a; m_has_attr_resource = true; }
    void clearAttributeResource() { m_has_attr_resource = false; }

    // child element accessors
    DomResourcePixmap *elementNormalOff() const { return m_normalOff; }
    DomResourcePixmap *takeElementNormalOff();
    void setElementNormalOff(DomResourcePixmap *a);
    bool hasElementNormalOff() const { return m_children & NormalOff; }
    void clearElementNormalOff();

    DomResourcePixmap *elementNormalOn() const { return m_normalOn; }
    DomResourcePixmap *takeElementNormalOn();
    void setElementNormalOn(DomResourcePixmap *a);
    bool hasElementNormalOn() const { return m_children & NormalOn; }
    void clearElementNormalOn();

    DomResourcePixmap *elementDisabledOff() const { return m_disabledOff; }
    DomResourcePixmap *takeElementDisabledOff();
    void setElementDisabledOff(DomResourcePixmap *a);
    bool hasElementDisabledOff() const { return m_children & DisabledOff; }
    void clearElementDisabledOff();

    DomResourcePixmap *elementDisabledOn() const { return m_disabledOn; }
    DomResourcePixmap *takeElementDisabledOn();
    void setElementDisabledOn(DomResourcePixmap *a);
    bool hasElementDisabledOn() const { return m_children & DisabledOn; }
    void clearElementDisabledOn();

    DomResourcePixmap *elementActiveOff() const { return m_activeOff; }
    DomResourcePixmap *takeElementActiveOff();
    void setElementActiveOff(DomResourcePixmap *a);
    bool hasElementActiveOff() const { return m_children & ActiveOff; }
    void clearElementActiveOff();

    DomResourcePixmap *elementActiveOn() const { return m_activeOn; }
    DomResourcePixmap *takeElementActiveOn();
    void setElementActiveOn(DomResourcePixmap *a);
    bool hasElementActiveOn() const { return m_children & ActiveOn; }
    void clearElementActiveOn();

    DomResourcePixmap *elementSelectedOff() const { return m_selectedOff; }
    DomResourcePixmap *takeElementSelectedOff();
    void setElementSelectedOff(DomResourcePixmap *a);
    bool hasElementSelectedOff() const { return m_children & SelectedOff; }
    void clearElementSelectedOff();

    DomResourcePixmap *elementSelectedOn() const { return m_selectedOn; }
    DomResourcePixmap *takeElementSelectedOn();
    void setElementSelectedOn(DomResourcePixmap *a);
    bool hasElementSelectedOn() const { return m_children & SelectedOn; }
    void clearElementSelectedOn();

private:
    QString m_text;

    // attribute data
    QString m_attr_theme;
    bool m_has_attr_theme = false;

    QString m_attr_resource;
    bool m_has_attr_resource = false;

    // child element data
    uint m_children = 0;
    DomResourcePixmap *m_normalOff = nullptr;
    DomResourcePixmap *m_normalOn = nullptr;
    DomResourcePixmap *m_disabledOff = nullptr;
    DomResourcePixmap *m_disabledOn = nullptr;
    DomResourcePixmap *m_activeOff = nullptr;
    DomResourcePixmap *m_activeOn = nullptr;
    DomResourcePixmap *m_selectedOff = nullptr;
    DomResourcePixmap *m_selectedOn = nullptr;

    enum Child {
        NormalOff = 1,
        NormalOn = 2,
        DisabledOff = 4,
        DisabledOn = 8,
        ActiveOff = 16,
        ActiveOn = 32,
        SelectedOff = 64,
        SelectedOn = 128
    };
};

class QDESIGNER_UILIB_EXPORT DomString {
    Q_DISABLE_COPY_MOVE(DomString)
public:
    DomString() = default;
    ~DomString();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    QString text() const { return m_text; }
    void setText(const QString &s) { m_text = s; }

    // attribute accessors
    bool hasAttributeNotr() const { return m_has_attr_notr; }
    QString attributeNotr() const { return m_attr_notr; }
    void setAttributeNotr(const QString &a) { m_attr_notr = a; m_has_attr_notr = true; }
    void clearAttributeNotr() { m_has_attr_notr = false; }

    bool hasAttributeComment() const { return m_has_attr_comment; }
    QString attributeComment() const { return m_attr_comment; }
    void setAttributeComment(const QString &a) { m_attr_comment = a; m_has_attr_comment = true; }
    void clearAttributeComment() { m_has_attr_comment = false; }

    bool hasAttributeExtraComment() const { return m_has_attr_extraComment; }
    QString attributeExtraComment() const { return m_attr_extraComment; }
    void setAttributeExtraComment(const QString &a) { m_attr_extraComment = a; m_has_attr_extraComment = true; }
    void clearAttributeExtraComment() { m_has_attr_extraComment = false; }

    bool hasAttributeId() const { return m_has_attr_id; }
    QString attributeId() const { return m_attr_id; }
    void setAttributeId(const QString &a) { m_attr_id = a; m_has_attr_id = true; }
    void clearAttributeId() { m_has_attr_id = false; }

private:
    QString m_text;

    // attribute data
    QString m_attr_notr;
    bool m_has_attr_notr = false;

    QString m_attr_comment;
    bool m_has_attr_comment = false;

    QString m_attr_extraComment;
    bool m_has_attr_extraComment = false;

    QString m_attr_id;
    bool m_has_attr_id = false;
};

class QDESIGNER_UILIB_EXPORT DomPointF {
    Q_DISABLE_COPY_MOVE(DomPointF)
public:
    DomPointF() = default;
    ~DomPointF();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    double elementX() const { return m_x; }
    void setElementX(double a);
    bool hasElementX() const { return m_children & X; }
    void clearElementX();

    double elementY() const { return m_y; }
    void setElementY(double a);
    bool hasElementY() const { return m_children & Y; }
    void clearElementY();

private:

    // child element data
    uint m_children = 0;
    double m_x = 0.0;
    double m_y = 0.0;

    enum Child {
        X = 1,
        Y = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomRectF {
    Q_DISABLE_COPY_MOVE(DomRectF)
public:
    DomRectF() = default;
    ~DomRectF();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    double elementX() const { return m_x; }
    void setElementX(double a);
    bool hasElementX() const { return m_children & X; }
    void clearElementX();

    double elementY() const { return m_y; }
    void setElementY(double a);
    bool hasElementY() const { return m_children & Y; }
    void clearElementY();

    double elementWidth() const { return m_width; }
    void setElementWidth(double a);
    bool hasElementWidth() const { return m_children & Width; }
    void clearElementWidth();

    double elementHeight() const { return m_height; }
    void setElementHeight(double a);
    bool hasElementHeight() const { return m_children & Height; }
    void clearElementHeight();

private:

    // child element data
    uint m_children = 0;
    double m_x = 0.0;
    double m_y = 0.0;
    double m_width = 0.0;
    double m_height = 0.0;

    enum Child {
        X = 1,
        Y = 2,
        Width = 4,
        Height = 8
    };
};

class QDESIGNER_UILIB_EXPORT DomSizeF {
    Q_DISABLE_COPY_MOVE(DomSizeF)
public:
    DomSizeF() = default;
    ~DomSizeF();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    double elementWidth() const { return m_width; }
    void setElementWidth(double a);
    bool hasElementWidth() const { return m_children & Width; }
    void clearElementWidth();

    double elementHeight() const { return m_height; }
    void setElementHeight(double a);
    bool hasElementHeight() const { return m_children & Height; }
    void clearElementHeight();

private:

    // child element data
    uint m_children = 0;
    double m_width = 0.0;
    double m_height = 0.0;

    enum Child {
        Width = 1,
        Height = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomChar {
    Q_DISABLE_COPY_MOVE(DomChar)
public:
    DomChar() = default;
    ~DomChar();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    int elementUnicode() const { return m_unicode; }
    void setElementUnicode(int a);
    bool hasElementUnicode() const { return m_children & Unicode; }
    void clearElementUnicode();

private:

    // child element data
    uint m_children = 0;
    int m_unicode = 0;

    enum Child {
        Unicode = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomUrl {
    Q_DISABLE_COPY_MOVE(DomUrl)
public:
    DomUrl() = default;
    ~DomUrl();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    DomString *elementString() const { return m_string; }
    DomString *takeElementString();
    void setElementString(DomString *a);
    bool hasElementString() const { return m_children & String; }
    void clearElementString();

private:

    // child element data
    uint m_children = 0;
    DomString *m_string = nullptr;

    enum Child {
        String = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomProperty {
    Q_DISABLE_COPY_MOVE(DomProperty)
public:
    DomProperty() = default;
    ~DomProperty();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeName() const { return m_has_attr_name; }
    QString attributeName() const { return m_attr_name; }
    void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    void clearAttributeName() { m_has_attr_name = false; }

    bool hasAttributeStdset() const { return m_has_attr_stdset; }
    int attributeStdset() const { return m_attr_stdset; }
    void setAttributeStdset(int a) { m_attr_stdset = a; m_has_attr_stdset = true; }
    void clearAttributeStdset() { m_has_attr_stdset = false; }

    // child element accessors
    enum Kind { Unknown = 0, Bool, Color, Cstring, Cursor, CursorShape, Enum, Font, IconSet, Pixmap, Palette, Point, Rect, Set, Locale, SizePolicy, Size, String, StringList, Number, Float, Double, Date, Time, DateTime, PointF, RectF, SizeF, LongLong, Char, Url, UInt, ULongLong, Brush };
    Kind kind() const { return m_kind; }

    QString elementBool() const { return m_bool; }
    void setElementBool(const QString &a);

    DomColor *elementColor() const { return m_color; }
    DomColor *takeElementColor();
    void setElementColor(DomColor *a);

    QString elementCstring() const { return m_cstring; }
    void setElementCstring(const QString &a);

    int elementCursor() const { return m_cursor; }
    void setElementCursor(int a);

    QString elementCursorShape() const { return m_cursorShape; }
    void setElementCursorShape(const QString &a);

    QString elementEnum() const { return m_enum; }
    void setElementEnum(const QString &a);

    DomFont *elementFont() const { return m_font; }
    DomFont *takeElementFont();
    void setElementFont(DomFont *a);

    DomResourceIcon *elementIconSet() const { return m_iconSet; }
    DomResourceIcon *takeElementIconSet();
    void setElementIconSet(DomResourceIcon *a);

    DomResourcePixmap *elementPixmap() const { return m_pixmap; }
    DomResourcePixmap *takeElementPixmap();
    void setElementPixmap(DomResourcePixmap *a);

    DomPalette *elementPalette() const { return m_palette; }
    DomPalette *takeElementPalette();
    void setElementPalette(DomPalette *a);

    DomPoint *elementPoint() const { return m_point; }
    DomPoint *takeElementPoint();
    void setElementPoint(DomPoint *a);

    DomRect *elementRect() const { return m_rect; }
    DomRect *takeElementRect();
    void setElementRect(DomRect *a);

    QString elementSet() const { return m_set; }
    void setElementSet(const QString &a);

    DomLocale *elementLocale() const { return m_locale; }
    DomLocale *takeElementLocale();
    void setElementLocale(DomLocale *a);

    DomSizePolicy *elementSizePolicy() const { return m_sizePolicy; }
    DomSizePolicy *takeElementSizePolicy();
    void setElementSizePolicy(DomSizePolicy *a);

    DomSize *elementSize() const { return m_size; }
    DomSize *takeElementSize();
    void setElementSize(DomSize *a);

    DomString *elementString() const { return m_string; }
    DomString *takeElementString();
    void setElementString(DomString *a);

    DomStringList *elementStringList() const { return m_stringList; }
    DomStringList *takeElementStringList();
    void setElementStringList(DomStringList *a);

    int elementNumber() const { return m_number; }
    void setElementNumber(int a);

    float elementFloat() const { return m_float; }
    void setElementFloat(float a);

    double elementDouble() const { return m_double; }
    void setElementDouble(double a);

    DomDate *elementDate() const { return m_date; }
    DomDate *takeElementDate();
    void setElementDate(DomDate *a);

    DomTime *elementTime() const { return m_time; }
    DomTime *takeElementTime();
    void setElementTime(DomTime *a);

    DomDateTime *elementDateTime() const { return m_dateTime; }
    DomDateTime *takeElementDateTime();
    void setElementDateTime(DomDateTime *a);

    DomPointF *elementPointF() const { return m_pointF; }
    DomPointF *takeElementPointF();
    void setElementPointF(DomPointF *a);

    DomRectF *elementRectF() const { return m_rectF; }
    DomRectF *takeElementRectF();
    void setElementRectF(DomRectF *a);

    DomSizeF *elementSizeF() const { return m_sizeF; }
    DomSizeF *takeElementSizeF();
    void setElementSizeF(DomSizeF *a);

    qlonglong elementLongLong() const { return m_longLong; }
    void setElementLongLong(qlonglong a);

    DomChar *elementChar() const { return m_char; }
    DomChar *takeElementChar();
    void setElementChar(DomChar *a);

    DomUrl *elementUrl() const { return m_url; }
    DomUrl *takeElementUrl();
    void setElementUrl(DomUrl *a);

    uint elementUInt() const { return m_UInt; }
    void setElementUInt(uint a);

    qulonglong elementULongLong() const { return m_uLongLong; }
    void setElementULongLong(qulonglong a);

    DomBrush *elementBrush() const { return m_brush; }
    DomBrush *takeElementBrush();
    void setElementBrush(DomBrush *a);

private:
    void clear();

    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    int m_attr_stdset = 0;
    bool m_has_attr_stdset = false;

    // child element data
    Kind m_kind = Unknown;
    QString m_bool;
    DomColor *m_color = nullptr;
    QString m_cstring;
    int m_cursor = 0;
    QString m_cursorShape;
    QString m_enum;
    DomFont *m_font = nullptr;
    DomResourceIcon *m_iconSet = nullptr;
    DomResourcePixmap *m_pixmap = nullptr;
    DomPalette *m_palette = nullptr;
    DomPoint *m_point = nullptr;
    DomRect *m_rect = nullptr;
    QString m_set;
    DomLocale *m_locale = nullptr;
    DomSizePolicy *m_sizePolicy = nullptr;
    DomSize *m_size = nullptr;
    DomString *m_string = nullptr;
    DomStringList *m_stringList = nullptr;
    int m_number = 0;
    float m_float = 0.0;
    double m_double = 0.0;
    DomDate *m_date = nullptr;
    DomTime *m_time = nullptr;
    DomDateTime *m_dateTime = nullptr;
    DomPointF *m_pointF = nullptr;
    DomRectF *m_rectF = nullptr;
    DomSizeF *m_sizeF = nullptr;
    qlonglong m_longLong = 0;
    DomChar *m_char = nullptr;
    DomUrl *m_url = nullptr;
    uint m_UInt = 0;
    qulonglong m_uLongLong = 0;
    DomBrush *m_brush = nullptr;
};

class QDESIGNER_UILIB_EXPORT DomConnections {
    Q_DISABLE_COPY_MOVE(DomConnections)
public:
    DomConnections() = default;
    ~DomConnections();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QList<DomConnection *> elementConnection() const { return m_connection; }
    void setElementConnection(const QList<DomConnection *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomConnection *> m_connection;

    enum Child {
        Connection = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomConnection {
    Q_DISABLE_COPY_MOVE(DomConnection)
public:
    DomConnection() = default;
    ~DomConnection();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QString elementSender() const { return m_sender; }
    void setElementSender(const QString &a);
    bool hasElementSender() const { return m_children & Sender; }
    void clearElementSender();

    QString elementSignal() const { return m_signal; }
    void setElementSignal(const QString &a);
    bool hasElementSignal() const { return m_children & Signal; }
    void clearElementSignal();

    QString elementReceiver() const { return m_receiver; }
    void setElementReceiver(const QString &a);
    bool hasElementReceiver() const { return m_children & Receiver; }
    void clearElementReceiver();

    QString elementSlot() const { return m_slot; }
    void setElementSlot(const QString &a);
    bool hasElementSlot() const { return m_children & Slot; }
    void clearElementSlot();

    DomConnectionHints *elementHints() const { return m_hints; }
    DomConnectionHints *takeElementHints();
    void setElementHints(DomConnectionHints *a);
    bool hasElementHints() const { return m_children & Hints; }
    void clearElementHints();

private:

    // child element data
    uint m_children = 0;
    QString m_sender;
    QString m_signal;
    QString m_receiver;
    QString m_slot;
    DomConnectionHints *m_hints = nullptr;

    enum Child {
        Sender = 1,
        Signal = 2,
        Receiver = 4,
        Slot = 8,
        Hints = 16
    };
};

class QDESIGNER_UILIB_EXPORT DomConnectionHints {
    Q_DISABLE_COPY_MOVE(DomConnectionHints)
public:
    DomConnectionHints() = default;
    ~DomConnectionHints();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QList<DomConnectionHint *> elementHint() const { return m_hint; }
    void setElementHint(const QList<DomConnectionHint *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomConnectionHint *> m_hint;

    enum Child {
        Hint = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomConnectionHint {
    Q_DISABLE_COPY_MOVE(DomConnectionHint)
public:
    DomConnectionHint() = default;
    ~DomConnectionHint();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeType() const { return m_has_attr_type; }
    QString attributeType() const { return m_attr_type; }
    void setAttributeType(const QString &a) { m_attr_type = a; m_has_attr_type = true; }
    void clearAttributeType() { m_has_attr_type = false; }

    // child element accessors
    int elementX() const { return m_x; }
    void setElementX(int a);
    bool hasElementX() const { return m_children & X; }
    void clearElementX();

    int elementY() const { return m_y; }
    void setElementY(int a);
    bool hasElementY() const { return m_children & Y; }
    void clearElementY();

private:
    // attribute data
    QString m_attr_type;
    bool m_has_attr_type = false;

    // child element data
    uint m_children = 0;
    int m_x = 0;
    int m_y = 0;

    enum Child {
        X = 1,
        Y = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomDesignerData {
    Q_DISABLE_COPY_MOVE(DomDesignerData)
public:
    DomDesignerData() = default;
    ~DomDesignerData();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QList<DomProperty *> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomProperty *> m_property;

    enum Child {
        Property = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomSlots {
    Q_DISABLE_COPY_MOVE(DomSlots)
public:
    DomSlots() = default;
    ~DomSlots();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QStringList elementSignal() const { return m_signal; }
    void setElementSignal(const QStringList &a);

    QStringList elementSlot() const { return m_slot; }
    void setElementSlot(const QStringList &a);

private:

    // child element data
    uint m_children = 0;
    QStringList m_signal;
    QStringList m_slot;

    enum Child {
        Signal = 1,
        Slot = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomPropertySpecifications {
    Q_DISABLE_COPY_MOVE(DomPropertySpecifications)
public:
    DomPropertySpecifications() = default;
    ~DomPropertySpecifications();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    QList<DomPropertyToolTip *> elementTooltip() const { return m_tooltip; }
    void setElementTooltip(const QList<DomPropertyToolTip *> &a);

    QList<DomStringPropertySpecification *> elementStringpropertyspecification() const { return m_stringpropertyspecification; }
    void setElementStringpropertyspecification(const QList<DomStringPropertySpecification *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomPropertyToolTip *> m_tooltip;
    QList<DomStringPropertySpecification *> m_stringpropertyspecification;

    enum Child {
        Tooltip = 1,
        Stringpropertyspecification = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomPropertyToolTip {
    Q_DISABLE_COPY_MOVE(DomPropertyToolTip)
public:
    DomPropertyToolTip() = default;
    ~DomPropertyToolTip();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeName() const { return m_has_attr_name; }
    QString attributeName() const { return m_attr_name; }
    void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    void clearAttributeName() { m_has_attr_name = false; }

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;
};

class QDESIGNER_UILIB_EXPORT DomStringPropertySpecification {
    Q_DISABLE_COPY_MOVE(DomStringPropertySpecification)
public:
    DomStringPropertySpecification() = default;
    ~DomStringPropertySpecification();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    bool hasAttributeName() const { return m_has_attr_name; }
    QString attributeName() const { return m_attr_name; }
    void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    void clearAttributeName() { m_has_attr_name = false; }

    bool hasAttributeType() const { return m_has_attr_type; }
    QString attributeType() const { return m_attr_type; }
    void setAttributeType(const QString &a) { m_attr_type = a; m_has_attr_type = true; }
    void clearAttributeType() { m_has_attr_type = false; }

    bool hasAttributeNotr() const { return m_has_attr_notr; }
    QString attributeNotr() const { return m_attr_notr; }
    void setAttributeNotr(const QString &a) { m_attr_notr = a; m_has_attr_notr = true; }
    void clearAttributeNotr() { m_has_attr_notr = false; }

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    QString m_attr_type;
    bool m_has_attr_type = false;

    QString m_attr_notr;
    bool m_has_attr_notr = false;
};


#ifdef QFORMINTERNAL_NAMESPACE
}
#endif

QT_END_NAMESPACE

#endif // UI4_H
