\name{ProcessObject}
\alias{ProcessObject}
\title{ProcessObject}
\Rdversion{1.1}
\docType{class}
\description{
Base class for SimpleITK classes based on ProcessObject.
ProcessObject}
\details{ProcessObject}
%C++ includes: sitkProcessObject.h
\section{Methods}{
\describe{
\item{void Abort():}{
Sets an abort flag on the active process.
Requests the current active process to abort. Additional, progress or
iteration event may occur. If aborted then, an AbortEvent should
occur. The Progress should be set to 1.0 after aborting.
The expected behavior is that not exception should be throw out of
this processes Execute method. Additionally, the results returned are
valid but undefined content. The content may be only partially
updated, uninitialized or the a of size zero.
If there is no active process the method has no effect.
}
\item{int AddCommand(EventEnum event, const std::function< void()> &func):}{
Directly add a callback to observe an event.
This overloaded method can take a C++ lambda function as a second
argument.
}
\item{int AddCommand(EventEnum event, Command &cmd):}{
Add a Command Object to observer the event.
The Command object's Execute method will be invoked when the internal ITK Object has the event. These events only occur during this ProcessObject's Execute method when the ITK filter is running. The command occurs
in the same thread as this objects Execute methods was called in.
An internal reference is made between the Command and this ProcessObject which enable automatic removal of the command when deleted. This
enables both object to exist as stack based object and be
automatically cleaned up.
Unless specified otherwise, it's safe to get any value during
execution. "Measurements" will have valid values only after the
Execute method has returned. "Active Measurements" will have valid
values during events, and access the underlying ITK object.
Deleting a command this object has during a command call-back will
produce undefined behavior.
For more information see the page CommandPage.
The return value is reserved for latter usage.
}
\item{std::string GetName() const =0:}{
return user readable name for the filter
}
\item{float GetProgress() const:}{
An Active Measurement of the progress of execution.
Get the execution progress of the current process object. The progress
is a floating number in [0,1] with 0 meaning no progress and 1 meaning
the filter has completed execution (or aborted).
This is an Active Measurement so it can be accessed during Events
during the execution.
}
\item{bool HasCommand(EventEnum event) const:}{
Query of this object has any registered commands for event.
}
\item{ ProcessObject():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{void RemoveAllCommands():}{
Remove all registered commands.
Calling when this object is invoking anther command will produce
undefined behavior.
}
\item{std::string ToString() const:}{}
\item{ ~ProcessObject():}{
Default Destructor
}
}
}
