//
// Copyright 2017 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

//
// Automatically generated by tools/codegen/core/gen_settings_ids.py
//

#include "src/core/ext/transport/chttp2/transport/http2_settings_manager.h"

#include <grpc/support/port_platform.h>

#include "absl/strings/str_cat.h"
#include "src/core/ext/transport/chttp2/transport/frame.h"
#include "src/core/ext/transport/chttp2/transport/http2_settings.h"
#include "src/core/ext/transport/chttp2/transport/http2_status.h"
#include "src/core/util/useful.h"

namespace grpc_core {

std::optional<Http2SettingsFrame> Http2SettingsManager::MaybeSendUpdate() {
  if (!IsPreviousSettingsPromiseResolved()) {
    return std::nullopt;
  }
  switch (update_state_) {
    case UpdateState::kSending:
      return std::nullopt;
    case UpdateState::kIdle:
      if (local_ == sent_) return std::nullopt;
      break;
    case UpdateState::kFirst:
      break;
  }
  Http2SettingsFrame frame;
  local_.Diff(/*is_first_send=*/update_state_ == UpdateState::kFirst,
              /*old_setting=*/sent_,
              /*cb=*/[&frame](uint16_t key, uint32_t value) {
                frame.settings.emplace_back(key, value);
              });
  sent_ = local_;
  update_state_ = UpdateState::kSending;
  return frame;
}

bool Http2SettingsManager::AckLastSend() {
  if (update_state_ != UpdateState::kSending) return false;
  update_state_ = UpdateState::kIdle;
  acked_ = sent_;
  return true;
}

}  // namespace grpc_core
