/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.PropertyMetadata;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.annotation.JsonPOJOBuilder;
import tools.jackson.databind.deser.AbstractDeserializer;
import tools.jackson.databind.deser.SettableAnyProperty;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.deser.bean.BeanDeserializer;
import tools.jackson.databind.deser.bean.BeanPropertyMap;
import tools.jackson.databind.deser.bean.BuilderBasedDeserializer;
import tools.jackson.databind.deser.impl.ObjectIdReader;
import tools.jackson.databind.deser.impl.ObjectIdValueProperty;
import tools.jackson.databind.deser.impl.ValueInjector;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.util.Annotations;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.IgnorePropertiesUtil;

public class BeanDeserializerBuilder {
    protected final DeserializationConfig _config;
    protected final DeserializationContext _context;
    protected final BeanDescription.Supplier _beanDescRef;
    protected final Map<String, SettableBeanProperty> _properties = new LinkedHashMap<String, SettableBeanProperty>();
    protected SettableBeanProperty[] _propsBasedCreatorParams;
    protected List<ValueInjector> _injectables;
    protected HashMap<String, SettableBeanProperty> _backRefProperties;
    protected HashSet<String> _ignorableProps;
    protected HashSet<String> _includableProps;
    protected ValueInstantiator _valueInstantiator;
    protected ObjectIdReader _objectIdReader;
    protected SettableAnyProperty _anySetter;
    protected boolean _ignoreAllUnknown;
    protected AnnotatedMethod _buildMethod;
    protected JsonPOJOBuilder.Value _builderConfig;

    public BeanDeserializerBuilder(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef) {
        this._beanDescRef = beanDescRef;
        this._context = ctxt;
        this._config = ctxt.getConfig();
    }

    protected BeanDeserializerBuilder(BeanDeserializerBuilder src) {
        this._beanDescRef = src._beanDescRef;
        this._context = src._context;
        this._config = src._config;
        this._properties.putAll(src._properties);
        this._injectables = BeanDeserializerBuilder._copy(src._injectables);
        this._backRefProperties = BeanDeserializerBuilder._copy(src._backRefProperties);
        this._ignorableProps = src._ignorableProps;
        this._includableProps = src._includableProps;
        this._valueInstantiator = src._valueInstantiator;
        this._propsBasedCreatorParams = src._propsBasedCreatorParams;
        this._objectIdReader = src._objectIdReader;
        this._anySetter = src._anySetter;
        this._ignoreAllUnknown = src._ignoreAllUnknown;
        this._buildMethod = src._buildMethod;
        this._builderConfig = src._builderConfig;
    }

    private static HashMap<String, SettableBeanProperty> _copy(HashMap<String, SettableBeanProperty> src) {
        return src == null ? null : new HashMap<String, SettableBeanProperty>(src);
    }

    private static <T> List<T> _copy(List<T> src) {
        return src == null ? null : new ArrayList<T>(src);
    }

    public void addOrReplaceProperty(SettableBeanProperty prop, boolean allowOverride) {
        SettableBeanProperty oldProp = this._properties.put(prop.getName(), prop);
        if (oldProp != null && this._propsBasedCreatorParams != null) {
            int len = this._propsBasedCreatorParams.length;
            for (int i = 0; i < len; ++i) {
                if (this._propsBasedCreatorParams[i] != oldProp) continue;
                this._propsBasedCreatorParams[i] = prop;
            }
        }
    }

    public void addProperty(SettableBeanProperty prop) {
        SettableBeanProperty old = this._properties.put(prop.getName(), prop);
        if (old != null && old != prop) {
            throw new IllegalArgumentException("Duplicate property '" + prop.getName() + "' for " + String.valueOf(this._beanDescRef.getType()));
        }
    }

    public void addBackReferenceProperty(String referenceName, SettableBeanProperty prop) {
        if (this._backRefProperties == null) {
            this._backRefProperties = new HashMap(4);
        }
        if (this._config.canOverrideAccessModifiers()) {
            try {
                prop.fixAccess(this._config);
            }
            catch (IllegalArgumentException e) {
                this._handleBadAccess(e);
            }
        }
        this._backRefProperties.put(referenceName, prop);
    }

    public void addInjectable(PropertyName propName, JavaType propType, Annotations contextAnnotations, AnnotatedMember member, Object valueId, Boolean optional, Boolean useInput) {
        if (this._injectables == null) {
            this._injectables = new ArrayList<ValueInjector>();
        }
        if (this._config.canOverrideAccessModifiers()) {
            try {
                member.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            catch (IllegalArgumentException e) {
                this._handleBadAccess(e);
            }
        }
        this._injectables.add(new ValueInjector(propName, propType, member, valueId, optional, useInput));
    }

    public void addIgnorable(String propName) {
        if (this._ignorableProps == null) {
            this._ignorableProps = new HashSet();
        }
        this._ignorableProps.add(propName);
    }

    public void addIncludable(String propName) {
        if (this._includableProps == null) {
            this._includableProps = new HashSet();
        }
        this._includableProps.add(propName);
    }

    public void addCreatorProperty(SettableBeanProperty prop) {
        this.addProperty(prop);
    }

    public void setAnySetter(SettableAnyProperty s) {
        if (this._anySetter != null && s != null) {
            throw new IllegalStateException("_anySetter already set to non-null");
        }
        this._anySetter = s;
    }

    public void setIgnoreUnknownProperties(boolean ignore) {
        this._ignoreAllUnknown = ignore;
    }

    public void setValueInstantiator(ValueInstantiator inst) {
        this._valueInstantiator = inst;
        this._propsBasedCreatorParams = inst.getFromObjectArguments(this._config);
    }

    public void setObjectIdReader(ObjectIdReader r) {
        this._objectIdReader = r;
    }

    public void setPOJOBuilder(AnnotatedMethod buildMethod, JsonPOJOBuilder.Value config) {
        this._buildMethod = buildMethod;
        this._builderConfig = config;
    }

    public JavaType getType() {
        return this._beanDescRef.getType();
    }

    public Iterator<SettableBeanProperty> getProperties() {
        return this._properties.values().iterator();
    }

    public SettableBeanProperty findProperty(PropertyName propertyName) {
        return this._properties.get(propertyName.getSimpleName());
    }

    public boolean hasProperty(PropertyName propertyName) {
        return this.findProperty(propertyName) != null;
    }

    public SettableBeanProperty removeProperty(PropertyName name) {
        return this._properties.remove(name.getSimpleName());
    }

    public SettableAnyProperty getAnySetter() {
        return this._anySetter;
    }

    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    public List<ValueInjector> getInjectables() {
        return this._injectables;
    }

    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public AnnotatedMethod getBuildMethod() {
        return this._buildMethod;
    }

    public JsonPOJOBuilder.Value getBuilderConfig() {
        return this._builderConfig;
    }

    public boolean hasIgnorable(String name) {
        return IgnorePropertiesUtil.shouldIgnore(name, this._ignorableProps, this._includableProps);
    }

    public ValueDeserializer<?> build() {
        Collection<SettableBeanProperty> props = this._properties.values();
        this._fixAccess(props);
        if (this._objectIdReader != null) {
            props = this._addIdProp(this._properties, new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED));
        }
        return new BeanDeserializer(this, this._beanDescRef, this._constructPropMap(props), (Map<String, SettableBeanProperty>)this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, (Set<String>)this._includableProps, this._anyViews(props));
    }

    public AbstractDeserializer buildAbstract() {
        return new AbstractDeserializer(this, this._backRefProperties, this._properties);
    }

    public ValueDeserializer<?> buildBuilderBased(JavaType valueType, String expBuildMethodName) {
        if (this._buildMethod == null) {
            if (!expBuildMethodName.isEmpty()) {
                this._context.reportBadDefinition(this._beanDescRef.getType(), String.format("Builder class %s does not have build method (name: '%s')", ClassUtil.getTypeDescription(this._beanDescRef.getType()), expBuildMethodName));
            }
        } else {
            Class<?> rawValueType;
            Class<?> rawBuildType = this._buildMethod.getRawReturnType();
            if (rawBuildType != (rawValueType = valueType.getRawClass()) && !rawBuildType.isAssignableFrom(rawValueType) && !rawValueType.isAssignableFrom(rawBuildType)) {
                this._context.reportBadDefinition(this._beanDescRef.getType(), String.format("Build method `%s` has wrong return type (%s), not compatible with POJO type (%s)", this._buildMethod.getFullName(), ClassUtil.getClassDescription(rawBuildType), ClassUtil.getTypeDescription(valueType)));
            }
        }
        this._fixAccess(this._properties.values());
        Collection<SettableBeanProperty> props = this._objectIdReader != null ? this._addIdProp(this._properties, new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED)) : this._properties.values();
        return this.createBuilderBasedDeserializer(valueType, this._constructPropMap(props), this._anyViews(props));
    }

    protected ValueDeserializer<?> createBuilderBasedDeserializer(JavaType valueType, BeanPropertyMap propertyMap, boolean anyViews) {
        return new BuilderBasedDeserializer(this, this._beanDescRef, valueType, propertyMap, this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, this._includableProps, anyViews);
    }

    protected void _fixAccess(Collection<SettableBeanProperty> mainProps) {
        if (this._config.canOverrideAccessModifiers()) {
            for (SettableBeanProperty prop : mainProps) {
                try {
                    prop.fixAccess(this._config);
                }
                catch (IllegalArgumentException e) {
                    this._handleBadAccess(e);
                }
            }
        }
        if (this._anySetter != null) {
            try {
                this._anySetter.fixAccess(this._config);
            }
            catch (IllegalArgumentException e) {
                this._handleBadAccess(e);
            }
        }
        if (this._buildMethod != null) {
            try {
                this._buildMethod.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            catch (IllegalArgumentException e) {
                this._handleBadAccess(e);
            }
        }
    }

    protected Collection<SettableBeanProperty> _addIdProp(Map<String, SettableBeanProperty> props, SettableBeanProperty idProp) {
        String name = idProp.getName();
        ArrayList<SettableBeanProperty> result = new ArrayList<SettableBeanProperty>(props.values());
        if (!props.containsKey(name)) {
            result.add(idProp);
        } else {
            ListIterator<SettableBeanProperty> it = result.listIterator();
            while (!it.next().getName().equals(name)) {
            }
            it.set(idProp);
        }
        return result;
    }

    protected boolean _anyViews(Collection<SettableBeanProperty> props) {
        if (!this._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION)) {
            return true;
        }
        for (SettableBeanProperty prop : props) {
            if (!prop.hasViews()) continue;
            return true;
        }
        return false;
    }

    protected BeanPropertyMap _constructPropMap(Collection<SettableBeanProperty> props) {
        JsonFormat.Value format = this._beanDescRef.findExpectedFormat(null);
        Boolean B = format.getFeature(JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        boolean caseInsensitive = B == null ? this._config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES) : B.booleanValue();
        return BeanPropertyMap.construct(this._config, props, this._collectAliases(props), caseInsensitive);
    }

    protected PropertyName[][] _collectAliases(Collection<SettableBeanProperty> props) {
        PropertyName[][] result = null;
        int i = -1;
        for (SettableBeanProperty prop : props) {
            List<PropertyName> aliases;
            ++i;
            AnnotatedMember member = prop.getMember();
            if (member == null || (aliases = prop.findAliases(this._config)) == null || aliases.isEmpty()) continue;
            if (result == null) {
                result = new PropertyName[props.size()][];
            }
            result[i] = aliases.toArray(new PropertyName[0]);
        }
        return result;
    }

    protected void _handleBadAccess(IllegalArgumentException e0) {
        try {
            this._context.reportBadTypeDefinition(this._beanDescRef.get(), e0.getMessage(), new Object[0]);
        }
        catch (DatabindException e) {
            if (e.getCause() == null) {
                e.initCause(e0);
            }
            throw e;
        }
    }
}

