/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.rules;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.Histogram;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.MemoryLint;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.Rule;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class RetainedSetByClass
extends Rule {
    private MemoryLint context;

    public RetainedSetByClass() {
        super(NbBundle.getMessage(RetainedSetByClass.class, (String)"LBL_RSBC_Name"), NbBundle.getMessage(RetainedSetByClass.class, (String)"LBL_RSBC_Desc"));
    }

    @Override
    public String getHTMLDescription() {
        return NbBundle.getMessage(RetainedSetByClass.class, (String)"LBL_RSBC_LongDesc");
    }

    @Override
    public void perform() {
        Heap heap = this.context.getHeap();
        List classes = heap.getAllClasses();
        Histogram<Histogram.Entry> hist = new Histogram<Histogram.Entry>();
        for (JavaClass cls : classes) {
            Logger.getLogger(RetainedSetByClass.class.getName()).log(Level.FINE, "Executing rule on class {0}.", cls);
            this.performClass(cls, hist);
            if (!this.context.isInterruped()) continue;
            return;
        }
        this.summary(hist);
    }

    @Override
    public void prepare(MemoryLint context) {
        this.context = context;
    }

    @Override
    protected JComponent createCustomizer() {
        return null;
    }

    private void performClass(JavaClass clz, Histogram<Histogram.Entry> hist) {
        Set<Instance> retained = Utils.getRetainedSet(clz.getInstances(), this.context.getHeap());
        String name = clz.getName();
        name = Utils.printClass(this.context, name);
        for (Instance i : retained) {
            hist.add(name, new Histogram.Entry(i.getSize()));
        }
    }

    private void summary(Histogram h) {
        this.context.appendResults(h.toString(0));
    }
}

