/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.locks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.global.TransactionalSupport;
import org.graalvm.visualvm.lib.jfluid.results.BaseCallGraphBuilder;
import org.graalvm.visualvm.lib.jfluid.results.RuntimeCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUProfilingResultListener;
import org.graalvm.visualvm.lib.jfluid.results.locks.LockCCTProvider;
import org.graalvm.visualvm.lib.jfluid.results.locks.LockProfilingResultListener;
import org.graalvm.visualvm.lib.jfluid.results.locks.LockRuntimeCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.locks.MonitorInfo;
import org.graalvm.visualvm.lib.jfluid.results.locks.ThreadInfo;
import org.graalvm.visualvm.lib.jfluid.results.locks.ThreadInfos;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryProfilingResultsListener;

public class LockGraphBuilder
extends BaseCallGraphBuilder
implements LockProfilingResultListener,
LockCCTProvider {
    static final Logger LOG = Logger.getLogger(LockGraphBuilder.class.getName());
    private final ThreadInfos threadInfos = new ThreadInfos();
    private Map<Integer, MonitorInfo> monitorInfos = new HashMap<Integer, MonitorInfo>();
    private final TransactionalSupport transaction = new TransactionalSupport();

    @Override
    protected RuntimeCCTNode getAppRootNode() {
        HashMap<ThreadInfo, List<List<ThreadInfo.MonitorDetail>>> threadsCopy = new HashMap<ThreadInfo, List<List<ThreadInfo.MonitorDetail>>>(this.threadInfos.threadInfos.length);
        HashMap<MonitorInfo, List<List<MonitorInfo.ThreadDetail>>> monitorsCopy = new HashMap<MonitorInfo, List<List<MonitorInfo.ThreadDetail>>>(this.monitorInfos.size());
        for (ThreadInfo ti : this.threadInfos.threadInfos) {
            if (ti == null) continue;
            ArrayList<List<ThreadInfo.MonitorDetail>> monitors = new ArrayList<List<ThreadInfo.MonitorDetail>>(2);
            if (ti.isEmpty()) continue;
            monitors.add(ti.cloneWaitMonitorDetails());
            monitors.add(ti.cloneOwnerMonitorDetails());
            threadsCopy.put(ti, monitors);
        }
        for (MonitorInfo mi : this.monitorInfos.values()) {
            ArrayList<List<MonitorInfo.ThreadDetail>> threads = new ArrayList<List<MonitorInfo.ThreadDetail>>(2);
            threads.add(mi.cloneWaitThreadDetails());
            threads.add(mi.cloneOwnerThreadDetails());
            monitorsCopy.put(mi, threads);
        }
        return new LockRuntimeCCTNode(threadsCopy, monitorsCopy);
    }

    @Override
    protected void doBatchStart() {
        this.transaction.beginTrans(true);
    }

    @Override
    protected void doBatchStop() {
        this.transaction.endTrans();
    }

    @Override
    protected void doReset() {
        boolean threadLocked;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Do Reset called");
        }
        if (threadLocked = this.transaction.beginTrans(true, true)) {
            try {
                this.threadInfos.reset();
                this.monitorInfos = new HashMap<Integer, MonitorInfo>();
            }
            finally {
                this.transaction.endTrans();
            }
        }
    }

    @Override
    protected void doShutdown() {
        this.threadInfos.reset();
        this.monitorInfos = new HashMap<Integer, MonitorInfo>();
    }

    @Override
    protected void doStartup(ProfilerClient profilerClient) {
    }

    @Override
    public void monitorEntry(int threadId, long timeStamp0, long timeStamp1, int monitorId, int ownerThreadId) {
        ThreadInfo ti = this.getThreadInfo(threadId);
        if (ti == null) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Monitor entry thread id = {0}, mId = {1}, owner id = {2}", new Object[]{threadId, Integer.toHexString(monitorId), ownerThreadId});
        }
        MonitorInfo m = this.getMonitorInfo(monitorId);
        ThreadInfo ownerTi = this.getThreadInfo(ownerThreadId);
        assert (ownerTi != null);
        ti.openMonitor(ownerTi, m, timeStamp0);
        m.openThread(ti, ownerTi, timeStamp0);
    }

    @Override
    public void monitorExit(int threadId, long timeStamp0, long timeStamp1, int monitorId) {
        ThreadInfo ti = this.getThreadInfo(threadId);
        if (ti == null) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Monitor exit thread id = {0}, mId = {1}", new Object[]{threadId, Integer.toHexString(monitorId)});
        }
        MonitorInfo m = this.getMonitorInfo(monitorId);
        ti.closeMonitor(m, timeStamp0);
        m.closeThread(ti, timeStamp0);
        this.batchNotEmpty = true;
    }

    @Override
    public void newThread(int threadId, String threadName, String threadClassName) {
        if (!this.isReady()) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "New thread creation for thread id = {0}, name = {1}", new Object[]{threadId, threadName});
        }
        this.threadInfos.newThreadInfo(threadId, threadName, threadClassName);
    }

    @Override
    public void newMonitor(int hash, String className) {
        if (!this.isReady()) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "New monitor creation, mId = {0}, className = {1}", new Object[]{Integer.toHexString(hash), className});
        }
        this.registerNewMonitor(hash, className);
    }

    @Override
    public void profilingPoint(int threadId, int ppId, long timeStamp) {
    }

    @Override
    public void timeAdjust(int threadId, long timeDiff0, long timeDiff1) {
        ThreadInfo ti = this.getThreadInfo(threadId);
        if (ti == null) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Time adjust thread id = {0}, time = {1}, CPU time = {2}", new Object[]{threadId, timeDiff0, timeDiff1});
        }
        ti.timeAdjust(timeDiff0);
    }

    private boolean isReady() {
        return this.status != null;
    }

    private ThreadInfo getThreadInfo(int threadId) {
        if (!this.isReady()) {
            return null;
        }
        return this.threadInfos.getThreadInfo(threadId);
    }

    private MonitorInfo getMonitorInfo(int monitorId) {
        Integer mid = new Integer(monitorId);
        MonitorInfo mi = this.monitorInfos.get(mid);
        if (mi == null) {
            mi = new MonitorInfo(monitorId);
            this.monitorInfos.put(mid, mi);
        }
        return mi;
    }

    private void registerNewMonitor(int monitorId, String className) {
        Integer mid = new Integer(monitorId);
        MonitorInfo mi = this.monitorInfos.get(mid);
        if (mi == null) {
            mi = new MonitorInfo(monitorId, className);
            this.monitorInfos.put(mid, mi);
        } else {
            mi.setClassName(className);
        }
    }

    public static final class MemoryLockGraphBuilder
    extends LockGraphBuilder
    implements MemoryProfilingResultsListener {
        @Override
        public void onAllocStackTrace(char classId, long objSize, int[] methodIds) {
        }

        @Override
        public void onGcPerformed(char classId, long objectId, int objEpoch) {
        }

        @Override
        public void onLivenessStackTrace(char classId, long objectId, int objEpoch, long objSize, int[] methodIds) {
        }
    }

    public static final class CPULockGraphBuilder
    extends LockGraphBuilder
    implements CPUProfilingResultListener {
        @Override
        public void methodEntry(int methodId, int threadId, int methodType, long timeStamp0, long timeStamp1, List parameters, int[] methoIds) {
        }

        @Override
        public void methodEntryUnstamped(int methodId, int threadId, int methodType, List parameters, int[] methoIds) {
        }

        @Override
        public void methodExit(int methodId, int threadId, int methodType, long timeStamp0, long timeStamp1, Object retVal) {
        }

        @Override
        public void methodExitUnstamped(int methodId, int threadId, int methodType) {
        }

        @Override
        public void servletRequest(int threadId, int requestType, String servletPath, int sessionId) {
        }

        @Override
        public void sleepEntry(int threadId, long timeStamp0, long timeStamp1) {
        }

        @Override
        public void sleepExit(int threadId, long timeStamp0, long timeStamp1) {
        }

        @Override
        public void threadsResume(long timeStamp0, long timeStamp1) {
        }

        @Override
        public void threadsSuspend(long timeStamp0, long timeStamp1) {
        }

        @Override
        public void waitEntry(int threadId, long timeStamp0, long timeStamp1) {
        }

        @Override
        public void waitExit(int threadId, long timeStamp0, long timeStamp1) {
        }

        @Override
        public void parkEntry(int threadId, long timeStamp0, long timeStamp1) {
        }

        @Override
        public void parkExit(int threadId, long timeStamp0, long timeStamp1) {
        }
    }
}

