/***
*uti.h - C common use utility definitions
*
*Purpose:
*   Defines symbols for PASCAL like boolean expressions and other
*   miscellaneous types including portable data types
*   [ANSI/System V]
*
*******************************************************************************/

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#ifndef _UTI_DEFINED
#define or ||
#define and &&
#define not !
typedef int bool;
typedef char* string;
typedef unsigned char byte;

#if defined (MSDOS) && !defined (__STDC__)
#define __STDC__
#endif

#ifndef VOID

#define VOID void

#ifdef TURBOC
#define FAR far
#define NEAR near
#define PASCAL pascal
#else
#define FAR _far
#define NEAR _near
#define PASCAL _pascal
#endif

typedef int BOOL;
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef long LONG;
typedef unsigned char BYTE;
typedef char *PSTR;

#define LOBYTE(w) ((BYTE)(w))
#define HIBYTE(w) ((BYTE)(((WORD)(w) >> 8) & 0xFF))
#define LOWORD(l) ((WORD)(l))
#define HIWORD(l) ((WORD)(((DWORD)(l) >> 16) & 0xFFFF))

#endif

#define EXPORT _far _pascal _export

#define LONGPTR(ptr) (LONG)(BYTE FAR *)(ptr)
#define LONGPROC(proc) (LONG)(VOID FAR *)(proc)

#define _UTI_DEFINED
#endif
