@echo off
rem **********************************************************************
rem *                                                                    *
rem *  CDTEST.BAT - CDTEST.BAT accepts two command line parameters:      *
rem *     1) the name of the testfile on the CD ROM, and                 *
rem *     2) the name of the output logfile to contain the test results. *
rem *                                                                    *
rem *  CDTEST.BAT then calls BLKTEST.BAT which makes the actual calls     *
rem *  to DOSSPEED.EXE to perform the CDROM tests.  CDTEST.BAT passes    *
rem *  BLKTEST.BAT three variables:                                       *
rem *     1) the name of the CDROM testfile,                             *
rem *     2) the requested data transfer rate, and                       *
rem *     3) the name of the output logfile.                             *
rem *                                                                    *
rem *                                                                    *
rem *  Input variables from command line:                                *
rem *                                                                    *
rem *     %1 = name of test file located on the CDROM                    *
rem *     %2 = name of the output logfile for test data                  *
rem *                                                                    *
rem **********************************************************************



echo Testing CDROM drive...

rem /* Open the log file by redirecting the following headers to the file */
echo Testfile,Req Xfr Rate,Rd Blk Sz,Primer Sz,Bkgnd Cpu,File Sz,Act Xfr Rate,Pcnt Blkd By Rd,  > %2



rem/* Call BLKTEST.BAT for five requested data transfer rates */

call blktest %1 30720 %2
echo Test of 30 KB/sec rate complete

call blktest %1 61440 %2
echo Test of 60 KB/sec rate complete

call blktest %1 92160 %2
echo Test of 90 KB/sec rate complete

call blktest %1 122880 %2
echo Test of 120 KB/sec rate complete

call blktest %1 153600 %2
echo Test of 150 KB/sec rate complete



echo Testing complete.
