* PROGRAM:  FIELDSIZ.PRG
* PURPOSE:  Find the smallest size a character field can be
*           without losing any current data.
*
* REMARKS:  You can call this program either from the dot prompt
*           or from inside another program.
*
* COMMAND:   DO FIELDSIZ WITH 'FILENAME' (dBASE, FoxBASE+...)
*   OR       FIELDSIZ FILENAME if compiled with Clipper

PARAMETERS filename
CLEAR
SET TALK OFF
SET STATUS OFF
CLOSE DATABASES
SELECT 1
USE &filename
? "File: "+filename+".DBF"
? "Optimum structure:"
?
msavtot=0
maux=1
DO WHILE LEN(FIELD(maux))>0
   IF TYPE(FIELD(maux))<>'C'    && Check if the field is of Type "Char"
      maux=maux+1               && If not, goto next field
      LOOP
   ENDIF
   mtotal=0
   mname=FIELD(maux)
   GOTO TOP
   DO WHILE .NOT. EOF()
      IF LEN(TRIM(&mname))>mtotal
         mtotal=LEN(TRIM(&mname))
      ENDIF
      SKIP
   ENDDO
   msaved=(LEN(&mname)-mtotal)*RECCOUNT()
   msavtot=msavtot+msaved
   msg=IIF(msaved>0," bytes to save"," no change on this field")
   ? RIGHT(SPACE(10)+TRIM(FIELD(maux)),11),mtotal,STR(msaved)+msg
   maux=maux+1
ENDDO
?
? "Total number of bytes that can be saved: " + LTRIM(STR(msavtot))
CLOSE DATABASES
RETURN
