DO BROWSE_DB
SET CURSOR ON
QUIT
********************
PROCEDURE BROWSE_DB

CLEAR

STATCOL='W+/N'
HELPCOL='W+/N'
NORM='W/N,N/W,N,,N/W'
REV='N/W'
HI='W+/N'
REVHI='N+/W'
NORMFL='W*/N'
REVFL='N*/W'
NORMHIFL='W+*/N'
REVHIFL='N+*/W'

DO WHILE .T.

    CLEAR
    mdatapat = "\"+ CURDIR()
    filename = SPACE(40)

    SET CURSOR ON
    @ 00,02 SAY "<ESC> Exit to DOS"
    @ 02,02 SAY "Dbase III <drive\path\filename>:" GET filename PICTURE "@!"
    @ 04,02 SAY "(For a selection of *.dbf's from current directory press )"
    READ

    IF LASTKEY() = 27
        CLEAR
        RETURN
    ENDIF

    DO CASE
        CASE EMPTY(filename)
            DO SELECT_DB WITH filename
            filename = RTRIM(mdatapat)+ "\"+ filename
        CASE "." $ filename
            filename = RTRIM(filename)
        OTHERWISE
            filename = RTRIM(filename)+ ".DBF"
    ENDCASE

    IF FILE(filename)
        SELECT 1
        USE &filename
    ELSE
        ?? CHR(7)
        @ 04,00
        @ 04,02 SAY "Sorry, file not found!"
        INKEY(0)
        LOOP
    ENDIF

    SET KEY 28 TO    
    SET CURSOR OFF

    SET COLOR TO &NORM
    CLEAR

    SET COLOR TO &HI
    @ 0,30 SAY "Browse Dbase III File"
    SET COLOR TO &NORM

    @ 01,01 SAY "     View"
    @ 01,01 SAY CHR(25)+CHR(26)+CHR(24)+CHR(27)
    @ 01,14 SAY " Edit"
    @ 01,27 SAY "F1 Status"
    @ 01,39 SAY "F2 Add"
    @ 01,48 SAY "F3 Delete"
    @ 01,60 SAY "F4 Pack"
    @ 01,71 SAY "Esc Exit"

    SET COLOR TO &NORMFL
    @ 10,29 SAY "One moment please ..."
    SET COLOR TO &NORM

    PUBLIC f_name[FCOUNT()], f_type[FCOUNT()], f_width[FCOUNT()], f_decimal[FCOUNT()]
    AFIELDS(f_name, f_type, f_width, f_decimal)
    mappend = .F.

    @ 02,00 TO 23,79
    DBEDIT(03,01,22,78,f_name,"BROWSE_KEY",0,f_name,"",0)

    SELECT 1
    USE

ENDDO

RETURN
******************* 
FUNCTION BROWSE_KEY

PARAMETERS mode,field_no

curr_field = FIELDNAME(field_no)

mreturn = 1

DO CASE
    CASE mode == 0  
        mfield_stat = f_name[field_no]+ "  "+ f_type[field_no]+ "  "+;
                      STR(f_width[field_no],4)+ "  "+ STR(f_decimal[field_no],2)
        @ 24,00
        GUY_CENTER(24,mfield_stat)
        @ 24,01 SAY "Record No."+ STR(RECNO(),5)
        IF DELETED()
            @ 24,70 SAY "<deleted>"
        ELSE
            @ 24,70 SAY "         "
        ENDIF
    CASE mode == 1  
        ?? CHR(7)
    CASE mode == 2  
        ?? CHR(7)
    CASE mode == 4  
        DO CASE
            CASE LASTKEY() == 28 
                DO DB_STATUS
            CASE LASTKEY() == -1 
                append blank
                mreturn = 1
            CASE LASTKEY() == -2 
                IF DELETED()
                    RECALL
                    @ 24,70 SAY "         "
                ELSE
                    DELETE
                    @ 24,70 SAY "<deleted>"
                ENDIF
                 
            CASE LASTKEY() == -3 
                @ 24,00
                manswer = "N"
                @ 24,02 SAY "Are you sure? (Y/N)" GET manswer PICTURE "!"
                READ
                IF manswer = "Y"
                    @ 24,00
                    GUY_CENTER(24,"Packing Database ...")
                    PACK
                    mreturn = 2
                     
                ELSE
                    ?? CHR(7)
                ENDIF
            CASE LASTKEY() == 13 
                IF LASTREC()>0 .AND. RECNO() > 0  
                    SET CURSOR ON
                    IF f_type[field_no] = "M"
                        SAVE SCREEN TO memoscrn
                        mtemp = &curr_field
                        mtemp = MEMOEDIT(mtemp)
                        RESTORE SCREEN FROM memoscrn
                        RELEASE memoscrn
                    ELSE
                        mtemp = &curr_field
                        @ ROW(),COL() GET mtemp
                        READ
                    ENDIF

                    IF UPDATED() .AND. LASTKEY()!=27
                        REPLACE &curr_field WITH mtemp
                         
                        mreturn = 2
                    ELSE
                        ?? CHR(7)
                        mreturn = 1
                    ENDIF
                    SET CURSOR OFF
                ELSE
                    ?? CHR(7)
                ENDIF
            CASE LASTKEY() == 27 
                mreturn = 0
            OTHERWISE
                ?? CHR(7)
        ENDCASE
ENDCASE

RETURN mreturn

*******************
PROCEDURE DB_STATUS

SAVE SCREEN TO mdb_status

@ 03,13 TO 16,68 DOUBLE
@ 04,14 CLEAR TO 15,67
@ 05,14 SAY REPLICATE("",54)
SET COLOR TO &HELPCOL
@ 04,29 SAY "Database Status Screen"
@ 17,14 SAY REPLICATE("",56)
FOR I = 4 TO 16
    @ I,69 SAY ""
NEXT
SET COLOR TO &NORM

@ 07,17 SAY "Database Name ......... "+ ALIAS()
@ 08,17 SAY "Last Updated on ....... "+ DTOC(LUPDATE())
@ 09,17 SAY "# of Records .......... "+ STR(LASTREC(),6)
@ 10,17 SAY "# of Fields/Record .... "+ STR(FCOUNT(),4)
@ 11,17 SAY "Header Size ........... "+ STR(HEADER(),6)
@ 12,17 SAY "Record Size ........... "+ STR(RECSIZE(),6)
@ 13,17 SAY "# of Deleted Records... "+ STR(NDELREC(),4)
@ 15,28 SAY "Press any key to continue ..."

INKEY(0)

RESTORE SCREEN FROM mdb_status
RELEASE mdb_status

RETURN
****************
FUNCTION NDELREC

mrecno = RECNO()

COUNT ALL FOR DELETED() TO mtotal

GOTO mrecno

RETURN mtotal
*******************
PROCEDURE SELECT_DB

PARAMETERS filename

SET COLOR TO &NORM

@ 04,00 CLEAR

msrchpath = RTRIM(mdatapat)+"\*.DBF"
mdbf_count = 0
mfile_num = 0

mdbf_count = ADIR(msrchpath)
DECLARE db_files[mdbf_count]

ADIR(msrchpath,db_files)

IF mdbf_count > 0

    SET COLOR TO &HI
    @ 05,27 SAY "Select from the following:"
    SET COLOR TO &NORM

    mfile_num = ACHOICE(07,35,23,46,db_files,"","DB_KEY")
    SET COLOR TO &NORM

ENDIF

IF (mdbf_count > 0) .AND. (mfile_num > 0)
    filename  = RTRIM(db_files[mfile_num])
     
ELSE
    ?? CHR(7)
    filename = ""
ENDIF

RELEASE db_files,mfile_num

RETURN
****************
FUNCTION DB_KEY

PARAMETERS mode,ele_no,rel_pos

mreturn = 2

DO CASE
    CASE mode == 0    

    CASE mode == 3    
        DO CASE
            CASE LASTKEY() == 13 
                mreturn = 1
            CASE LASTKEY() == 27 
                mreturn = 0
            OTHERWISE
                ?? CHR(7)
        ENDCASE
ENDCASE

RETURN mreturn
***********************
FUNCTION GUY_CENTER

PARAMETERS mrow,mstring

merror = 0

mcol = (40 - (LEN(mstring)/2))

IF mcol < 0
    mcol = 0
    merror = -1
ENDIF

@ mrow,mcol SAY mstring

RETURN merror

