// ****************************************************************************
//
//          Aevol - An in silico experimental evolution platform
//
// ****************************************************************************
//
// Copyright: See the AUTHORS file provided with the package or <www.aevol.fr>
// Web: http://www.aevol.fr/
// E-mail: See <http://www.aevol.fr/contact/>
// Original Authors : Guillaume Beslon, Carole Knibbe, David Parsons
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ****************************************************************************

#ifndef AEVOL_FASTA_MODIFIERS_H_
#define AEVOL_FASTA_MODIFIERS_H_

#include <format>
#include <stdexcept>
#include <string>
#include <utility>
#include <vector>

namespace aevol {

struct FastaModifier {
  std::string name;
  std::string value;
};

class FastaModifiers {
 public:
  FastaModifiers()                                 = default;
  FastaModifiers(const FastaModifiers&)            = default;
  FastaModifiers(FastaModifiers&&)                 = default;
  FastaModifiers& operator=(const FastaModifiers&) = default;
  FastaModifiers& operator=(FastaModifiers&&)      = default;
  virtual ~FastaModifiers()                        = default;

  auto at(const std::string& key) const -> const std::string&;

  auto begin() const { return modifiers_.begin(); }
  auto end() const { return modifiers_.end(); }

  auto size() const { return modifiers_.size(); }

  template <class... Args>
  auto emplace_back(Args&&... args) {
    return modifiers_.emplace_back(std::forward<Args>(args)...);
  }

 protected:
  std::vector<FastaModifier> modifiers_;
};

}  // namespace aevol

#endif  // AEVOL_FASTA_MODIFIERS_H_
