/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 *   @(#)if_ether.h 1.28 89/08/04 SMI; from UCB 7.2 12/7/87
 */

/* 
 * $Id: $
 * $DateTime: $
 * $Change: $
 */

#ifndef _netinet_if_ether_h
#define _netinet_if_ether_h

#if !defined(__OpenBSD__)
#include <net/if_arp.h>
#endif

/*
 * Ethernet address - 6 octets
 */
struct ether_addr {
   u_char ether_addr_octet[6];
};

/*
 * Structure of a 10Mb/s Ethernet header.
 */
struct ether_header {
   u_char ether_dhost[6];
   u_char ether_shost[6];
   u_short   ether_type;
};

#define ETHERTYPE_PUP      0x0200      /* PUP protocol */
#define ETHERTYPE_IP       0x0800      /* IP protocol */
#define ETHERTYPE_ARP      0x0806      /* Addr. resolution protocol */
#define ETHERTYPE_REVARP   0x8035      /* Reverse ARP */
#define ETHERTYPE_TRAIL    0x1000

/*
 * Ethernet Address Resolution Protocol.
 *
 * See RFC 826 for protocol description.  Structure below is adapted
 * to resolving internet addresses.  Field names used correspond to
 * RFC 826.
 */
struct   ether_arp {
   struct   arphdr ea_hdr;      /* fixed-size header */
   struct   ether_addr arp_sha;   /* sender hardware address */
   u_char   arp_spa[4];      /* sender protocol address */
   struct   ether_addr arp_tha;   /* target hardware address */
   u_char   arp_tpa[4];      /* target protocol address */
};
#define  arp_hrd  ea_hdr.ar_hrd
#define  arp_pro  ea_hdr.ar_pro
#define  arp_hln  ea_hdr.ar_hln
#define  arp_pln  ea_hdr.ar_pln
#define  arp_op   ea_hdr.ar_op

#define ETHERMTU   1500
#endif 
