+++
title = "Help"
+++

## Community

<!-- Primary Help Channels -->
<div class="not-prose grid grid-cols-1 md:grid-cols-2 gap-6 my-8">
  <a href="/discord" class="scan-lines group relative p-8 flex flex-col gap-4 border border-neutral-200 hover:border-blue-500/40 dark:border-neutral-800 dark:hover:border-blue-500/50 rounded-[3px] transition no-underline">
    <iconify-icon icon="pixel:discord" class="text-6xl text-neutral-700 dark:text-neutral-300"></iconify-icon>
    <div>
      <h3 class="text-2xl font-os9 text-blue-600 dark:text-blue-400 group-hover:underline transition mb-2">
        Discord
      </h3>
      <p class="text-sm text-neutral-600 dark:text-neutral-400">Join the community chat for real-time help and discussions</p>
    </div>
  </a>

  <a href="https://github.com/bigskysoftware/htmx/issues" class="scan-lines group relative p-8 flex flex-col gap-4 border border-neutral-200 hover:border-blue-500/40 dark:border-neutral-800 dark:hover:border-blue-500/50 rounded-[3px] transition no-underline">
    <iconify-icon icon="octicon:issue-opened-24" class="text-6xl text-neutral-700 dark:text-neutral-300"></iconify-icon>
    <div>
      <h3 class="text-2xl font-bold mb-2">
        <span class="text-blue-600 dark:text-blue-400 group-hover:underline transition">GitHub Issues</span>
      </h3>
      <p class="text-sm text-neutral-600 dark:text-neutral-400">Report bugs, request features, and track development</p>
    </div>
  </a>
</div>

<!-- Secondary Links -->
<div class="not-prose grid grid-cols-1 md:grid-cols-2 gap-3 md:gap-6 my-8 text-sm">
    <!-- Left Column -->
    <div class="flex flex-col lg:flex-row items-stretch gap-3">
      <a href="https://x.com/htmx_org" class="scan-lines group inline-flex items-center gap-2 px-4 py-2 border border-neutral-200 hover:border-blue-500/40 dark:border-neutral-800 dark:hover:border-blue-500/50 rounded-[3px] transition no-underline">
        <iconify-icon icon="dinkie-icons:twitter-alt-small" class="text-base"></iconify-icon>
        <span class="font-semibold text-blue-600 dark:text-blue-400 group-hover:underline transition">@htmx_org</span>
      </a>
      <a href="https://www.reddit.com/r/htmx/" class="scan-lines group inline-flex items-center gap-2 px-4 py-2 border border-neutral-200 hover:border-blue-500/40 dark:border-neutral-800 dark:hover:border-blue-500/50 rounded-[3px] transition no-underline">
        <iconify-icon icon="mdi:reddit" class="text-base"></iconify-icon>
        <span class="font-semibold text-blue-600 dark:text-blue-400 group-hover:underline transition">Reddit</span>
      </a>
      <a href="https://github.com/sponsors/bigskysoftware" class="scan-lines group inline-flex items-center gap-2 px-4 py-2 border border-neutral-200 hover:border-blue-500/40 dark:border-neutral-800 dark:hover:border-blue-500/50 rounded-[3px] transition no-underline">
        <iconify-icon icon="tabler:heart-filled" class="text-base"></iconify-icon>
        <span class="font-semibold text-blue-600 dark:text-blue-400 group-hover:underline transition">Sponsor</span>
      </a>
    </div>
    <!-- Right Column -->
    <div class="flex flex-col lg:flex-row items-stretch gap-3">
      <a href="/webring" class="scan-lines group inline-flex items-center gap-2 px-4 py-2 border border-neutral-200 hover:border-blue-500/40 dark:border-neutral-800 dark:hover:border-blue-500/50 rounded-[3px] transition no-underline">
        <iconify-icon icon="mdi:link-variant" class="text-base"></iconify-icon>
        <span class="font-semibold text-blue-600 dark:text-blue-400 group-hover:underline transition">Webring</span>
      </a>
      <a href="mailto:htmx@bigsky.software" class="scan-lines group inline-flex items-center gap-2 px-4 py-2 border border-neutral-200 hover:border-blue-500/40 dark:border-neutral-800 dark:hover:border-blue-500/50 rounded-[3px] transition no-underline">
        <iconify-icon icon="mdi:email" class="text-base"></iconify-icon>
        <span class="font-semibold text-blue-600 dark:text-blue-400 group-hover:underline transition">Email</span>
      </a>
      <a href="/atom.xml" class="scan-lines group inline-flex items-center gap-2 px-4 py-2 border border-neutral-200 hover:border-blue-500/40 dark:border-neutral-800 dark:hover:border-blue-500/50 rounded-[3px] transition no-underline">
        <iconify-icon icon="pixel:rss" class="text-base"></iconify-icon>
        <span class="font-semibold text-blue-600 dark:text-blue-400 group-hover:underline transition">RSS Feed</span>
      </a>
    </div>
</div>

## Books

<div class="font-os9 not-prose grid grid-cols-[repeat(auto-fill,minmax(200px,1fr))] gap-8 my-8">
  <a href="https://www.amazon.com/Hypermedia-Systems-Carson-Gross/dp/B0C9S88QV6/" class="group block text-center no-underline transition-transform duration-200 hover:-translate-y-1.5">
    <img src="/img/hypermedia-systems.png" alt="Hypermedia Systems" class="w-full h-auto rounded mb-4">
    <div class="font-bold text-blue-600 dark:text-blue-400 group-hover:underline text-sm leading-tight">Hypermedia Systems</div>
  </a>

  <a href="https://www.amazon.com/Server-Driven-Web-Apps-htmx-Language/dp/B0D9N35GKP" class="group block text-center no-underline transition-transform duration-200 hover:-translate-y-1.5">
    <img src="/img/server-driven-web-apps.png" alt="Server-Driven Web Apps with htmx" class="w-full h-auto rounded mb-4">
    <div class="font-bold text-blue-600 dark:text-blue-400 group-hover:underline text-sm leading-tight">Server-Driven Web Apps with htmx</div>
  </a>

  <a href="https://www.wimdeblauwe.com/books/modern-frontends-with-htmx/" class="group block text-center no-underline transition-transform duration-200 hover:-translate-y-1.5">
    <img src="/img/modern-frontends-htmx.jpg" alt="Modern frontends with htmx" class="w-full h-auto rounded mb-4">
    <div class="font-bold text-blue-600 dark:text-blue-400 group-hover:underline text-sm leading-tight">Modern frontends with htmx</div>
  </a>

  <a href="https://www.amazon.co.jp/-/en/dp/4297149451/" class="group block text-center no-underline transition-transform duration-200 hover:-translate-y-1.5">
    <img src="/img/hypermedia-systems-japanese.png" alt="ハイパーメディアシステム" class="w-full h-auto rounded mb-4">
    <div class="font-bold text-blue-600 dark:text-blue-400 group-hover:underline text-sm leading-tight">ハイパーメディアシステム (Japanese Edition)</div>
  </a>

  <a href="https://www.amazon.co.jp/-/en/dp/4863544693" class="group block text-center no-underline transition-transform duration-200 hover:-translate-y-1.5">
    <img src="/img/htmx-japanese.png" alt="HTMX" class="w-full h-auto rounded mb-4">
    <div class="font-bold text-blue-600 dark:text-blue-400 group-hover:underline text-sm leading-tight">HTMX (Japanese)</div>
  </a>
</div>


## Team

<div class="not-prose grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 my-8 max-w-6xl mx-auto">
  <div class="scan-lines group flex flex-col items-center p-6 border border-neutral-200 dark:border-neutral-800 hover:border-blue-500/40 dark:hover:border-blue-500/50 rounded-[3px] transition">
    <div class="relative mb-4">
      <img src="/img/team/latent.png" alt="Michael West" class="w-32 h-32 rounded-full object-cover ring-4 ring-neutral-200 dark:ring-neutral-800 group-hover:ring-blue-500/30 transition-all duration-300">
      <div class="absolute inset-0 rounded-full bg-blue-500/0 group-hover:bg-blue-500/10 dark:group-hover:bg-blue-400/5 transition-all duration-300"></div>
    </div>
    <h3 class="font-bold text-xl mb-2 text-neutral-900 dark:text-neutral-100">
        <span class="group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors">Michael West</span>
    </h3>
    <p class="text-sm text-center text-neutral-600 dark:text-neutral-400 leading-relaxed">
        Lorem ipsum dolor sit amet, consectetur adipiscing elit.
    </p>
  </div>

  <div class="scan-lines group flex flex-col items-center p-6 border border-neutral-200 dark:border-neutral-800 hover:border-blue-500/40 dark:hover:border-blue-500/50 rounded-[3px] transition">
    <div class="relative mb-4">
      <img src="/img/team/scriptogre.png" alt="Christian Tanul" class="w-32 h-32 rounded-full object-cover ring-4 ring-neutral-200 dark:ring-neutral-800 group-hover:ring-blue-500/30 transition-all duration-300">
      <div class="absolute inset-0 rounded-full bg-blue-500/0 group-hover:bg-blue-500/10 dark:group-hover:bg-blue-400/5 transition-all duration-300"></div>
    </div>
    <h3 class="font-bold text-xl mb-2 text-neutral-900 dark:text-neutral-100">
        <span class="group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors">Christian Tanul</span>
    </h3>
    <p class="text-sm text-center text-neutral-600 dark:text-neutral-400 leading-relaxed">
        A perfectionist still editing this sentence.
    </p>
  </div>

  <div class="scan-lines group flex flex-col items-center p-6 border border-neutral-200 dark:border-neutral-800 hover:border-blue-500/40 dark:hover:border-blue-500/50 rounded-[3px] transition">
    <div class="relative mb-4">
      <img src="/img/team/telroshan.png" alt="Vincent Thébaudl" class="w-32 h-32 rounded-full object-cover ring-4 ring-neutral-200 dark:ring-neutral-800 group-hover:ring-blue-500/30 transition-all duration-300">
      <div class="absolute inset-0 rounded-full bg-blue-500/0 group-hover:bg-blue-500/10 dark:group-hover:bg-blue-400/5 transition-all duration-300"></div>
    </div>
    <h3 class="font-bold text-xl mb-2 text-neutral-900 dark:text-neutral-100">
        <span class="group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors">Vincent Thébaudl</span>
    </h3>
    <p class="text-sm text-center text-neutral-600 dark:text-neutral-400 leading-relaxed">
        A game developer who hasn't released any game yet.
    </p>
  </div>

<div class="scan-lines group flex flex-col items-center p-6 border border-neutral-200 dark:border-neutral-800 hover:border-blue-500/40 dark:hover:border-blue-500/50 rounded-[3px] transition">
    <div class="relative mb-4">
      <img src="/img/team/scum.png" alt="Stephen Mitchell" class="w-32 h-32 rounded-full object-cover ring-4 ring-neutral-200 dark:ring-neutral-800 group-hover:ring-blue-500/30 transition-all duration-300">
      <div class="absolute inset-0 rounded-full bg-blue-500/0 group-hover:bg-blue-500/10 dark:group-hover:bg-blue-400/5 transition-all duration-300"></div>
    </div>
    <h3 class="font-bold text-xl mb-2 text-neutral-900 dark:text-neutral-100">
        <span class="group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors">Stephen Mitchell</span>
    </h3>
    <p class="text-sm text-center text-neutral-600 dark:text-neutral-400 leading-relaxed">
        Lorem ipsum dolor sit amet, consectetur adipiscing elit.
    </p>
  </div>

  <div class="scan-lines group flex flex-col items-center p-6 border border-neutral-200 dark:border-neutral-800 hover:border-blue-500/40 dark:hover:border-blue-500/50 rounded-[3px] transition">
    <div class="relative mb-4">
      <img src="/img/team/deniz.png" alt="Deniz Akşimşek" class="w-32 h-32 rounded-full object-cover ring-4 ring-neutral-200 dark:ring-neutral-800 group-hover:ring-blue-500/30 transition-all duration-300">
      <div class="absolute inset-0 rounded-full bg-blue-500/0 group-hover:bg-blue-500/10 dark:group-hover:bg-blue-400/5 transition-all duration-300"></div>
    </div>
    <h3 class="font-bold text-xl mb-2 text-neutral-900 dark:text-neutral-100">
        <span class="group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors">Deniz Akşimşek</span>
    </h3>
    <p class="text-sm text-center text-neutral-600 dark:text-neutral-400 leading-relaxed">
        Lorem ipsum dolor sit amet, consectetur adipiscing elit.
    </p>
  </div>

  <div class="scan-lines group flex flex-col items-center p-6 border border-neutral-200 dark:border-neutral-800 hover:border-blue-500/40 dark:hover:border-blue-500/50 rounded-[3px] transition">
    <div class="relative mb-4">
      <img src="/img/team/alex.png" alt="Alex Petros" class="w-32 h-32 rounded-full object-cover ring-4 ring-neutral-200 dark:ring-neutral-800 group-hover:ring-blue-500/30 transition-all duration-300">
      <div class="absolute inset-0 rounded-full bg-blue-500/0 group-hover:bg-blue-500/10 dark:group-hover:bg-blue-400/5 transition-all duration-300"></div>
    </div>
    <h3 class="font-bold text-xl mb-2 text-neutral-900 dark:text-neutral-100">
        <span class="group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors">Alex Petros</span>
    </h3>
    <p class="text-sm text-center text-neutral-600 dark:text-neutral-400 leading-relaxed">
        Lorem ipsum dolor sit amet, consectetur adipiscing elit.
    </p>
  </div>

  <a class="scan-lines group flex flex-col items-center p-6 border border-neutral-200 dark:border-neutral-800 hover:border-blue-500/40 dark:hover:border-blue-500/50 rounded-[3px] transition">
    <div class="relative mb-4">
      <img src="/img/team/stu.png" alt="Stu Kennedy" class="w-32 h-32 rounded-full object-cover ring-4 ring-neutral-200 dark:ring-neutral-800 group-hover:ring-blue-500/30 transition-all duration-300">
      <div class="absolute inset-0 rounded-full bg-blue-500/0 group-hover:bg-blue-500/10 dark:group-hover:bg-blue-400/5 transition-all duration-300"></div>
    </div>
    <h3 class="font-bold text-xl mb-2 text-neutral-900 dark:text-neutral-100">
        <span class="group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors">Stu Kennedy</span>
    </h3>
    <p class="text-sm text-center text-neutral-600 dark:text-neutral-400 leading-relaxed">
        Full-Stack Human, Part-Time AI Whisperer, and HTMX Preacher at Large.
    </p>
  </a>

<a href="https://www.cs.montana.edu/users/grug/" class="scan-lines group flex flex-col items-center p-6 border border-neutral-200 dark:border-neutral-800 hover:border-blue-500/40 dark:hover:border-blue-500/50 rounded-[3px] transition">
    <div class="relative mb-4">
      <img src="/img/team/grug.png" alt="Carson Gross" class="w-32 h-32 rounded-full object-cover ring-4 ring-neutral-200 dark:ring-neutral-800 group-hover:ring-blue-500/30 transition-all duration-300">
      <div class="absolute inset-0 rounded-full bg-blue-500/0 group-hover:bg-blue-500/10 dark:group-hover:bg-blue-400/5 transition-all duration-300"></div>
    </div>
    <h3 class="font-bold text-xl mb-2 text-neutral-900 dark:text-neutral-100">
        <span class="group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors">Carson Gross</span>
    </h3>
    <p class="text-sm text-center text-neutral-600 dark:text-neutral-400 leading-relaxed">
        An <span class="font-semibold text-blue-600 dark:text-blue-400 group-hover:underline transition">academic</span> with no real-world coding experience.
    </p>
  </a>
</div>


## Training

<a href="https://training.talkpython.fm/courses/htmx-flask-modern-python-web-apps-hold-the-javascript" class="scan-lines not-prose group block p-4 text-xs border border-neutral-200 dark:border-neutral-800 hover:border-blue-500/40 dark:hover:border-blue-500/50 rounded-[3px] transition">
    <h3 class="text-base mb-2">
        <span class="font-semibold text-blue-600 dark:text-blue-400 group-hover:underline transition">
            HTMX + Flask: Modern Python Web Apps, Hold the JavaScript
        </span>
    </h3>
    <p class="text-neutral-600 dark:text-neutral-400">
        Course by Michael Kennedy at Talk Python Training
    </p>
</a>

## Feed & Podcasts

Site Atom Feed: [atom.xml](/atom.xml)

## Podcasts

{{ podcasts() }}
