/*
    SPDX-FileCopyrightText: 2012 Miha Čančula <miha@noughmad.eu>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#ifndef KDEVPLATFORM_CODEDESCRIPTIONMETATYPES_H
#define KDEVPLATFORM_CODEDESCRIPTIONMETATYPES_H

#include "codedescription.h"

#include <KTextTemplate/MetaType>

#define KTEXTTEMPLATE_LOOKUP_PROPERTY(name) \
    if (property == QLatin1String(#name)) \
        return QVariant::fromValue(object.name);

#define KTEXTTEMPLATE_LOOKUP_LIST_PROPERTY(name) \
    if (property == QLatin1String(#name)) \
        return QVariant::fromValue(KDevelop::CodeDescription::toVariantList(object.name));

KTEXTTEMPLATE_BEGIN_LOOKUP(KDevelop::VariableDescription)
KTEXTTEMPLATE_LOOKUP_PROPERTY(name)
KTEXTTEMPLATE_LOOKUP_PROPERTY(type)
KTEXTTEMPLATE_LOOKUP_PROPERTY(access)
KTEXTTEMPLATE_LOOKUP_PROPERTY(value)
KTEXTTEMPLATE_END_LOOKUP

KTEXTTEMPLATE_BEGIN_LOOKUP(KDevelop::FunctionDescription)
KTEXTTEMPLATE_LOOKUP_PROPERTY(name)
KTEXTTEMPLATE_LOOKUP_PROPERTY(access)
KTEXTTEMPLATE_LOOKUP_LIST_PROPERTY(arguments)
KTEXTTEMPLATE_LOOKUP_LIST_PROPERTY(returnArguments)
KTEXTTEMPLATE_LOOKUP_PROPERTY(isConstructor)
KTEXTTEMPLATE_LOOKUP_PROPERTY(isDestructor)
KTEXTTEMPLATE_LOOKUP_PROPERTY(isVirtual)
KTEXTTEMPLATE_LOOKUP_PROPERTY(isAbstract)
KTEXTTEMPLATE_LOOKUP_PROPERTY(isOverriding)
KTEXTTEMPLATE_LOOKUP_PROPERTY(isFinal)
KTEXTTEMPLATE_LOOKUP_PROPERTY(isStatic)
KTEXTTEMPLATE_LOOKUP_PROPERTY(isConst)
KTEXTTEMPLATE_LOOKUP_PROPERTY(isSignal)
KTEXTTEMPLATE_LOOKUP_PROPERTY(isSlot)
if (property == QLatin1String("returnType"))
{
    return object.returnType();
}
KTEXTTEMPLATE_END_LOOKUP

KTEXTTEMPLATE_BEGIN_LOOKUP(KDevelop::InheritanceDescription)
KTEXTTEMPLATE_LOOKUP_PROPERTY(inheritanceMode)
KTEXTTEMPLATE_LOOKUP_PROPERTY(baseType)
KTEXTTEMPLATE_END_LOOKUP

KTEXTTEMPLATE_BEGIN_LOOKUP(KDevelop::ClassDescription)
KTEXTTEMPLATE_LOOKUP_PROPERTY(name)
KTEXTTEMPLATE_LOOKUP_LIST_PROPERTY(baseClasses)
KTEXTTEMPLATE_LOOKUP_LIST_PROPERTY(members)
KTEXTTEMPLATE_LOOKUP_LIST_PROPERTY(methods)
KTEXTTEMPLATE_END_LOOKUP

#endif // KDEVPLATFORM_CODEDESCRIPTIONMETATYPES_H
