/*
 * Copyright (C) 2023 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2023 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-dsp-lib
 * Created on: 22 апр. 2023 г.
 *
 * lsp-dsp-lib is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-dsp-lib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-dsp-lib. If not, see <https://www.gnu.org/licenses/>.
 */

#include <lsp-plug.in/common/finally.h>
#include <lsp-plug.in/dsp/dsp.h>
#include <lsp-plug.in/test-fw/ByteBuffer.h>
#include <lsp-plug.in/test-fw/utest.h>

#include <private/utest/dsp/bitmap/util.h>

namespace lsp
{
    namespace generic
    {
        void bitmap_put_b4b8(dsp::bitmap_t *dst, const dsp::bitmap_t *src, ssize_t x, ssize_t y);
        void bitmap_add_b4b8(dsp::bitmap_t *dst, const dsp::bitmap_t *src, ssize_t x, ssize_t y);
        void bitmap_sub_b4b8(dsp::bitmap_t *dst, const dsp::bitmap_t *src, ssize_t x, ssize_t y);
        void bitmap_max_b4b8(dsp::bitmap_t *dst, const dsp::bitmap_t *src, ssize_t x, ssize_t y);
        void bitmap_min_b4b8(dsp::bitmap_t *dst, const dsp::bitmap_t *src, ssize_t x, ssize_t y);
    }
} /* namespace lsp */

namespace lsp
{
    namespace test
    {
        static uint8_t bitmap_data[] =
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00, 0x04, 0xbe, 0xfe, 0xc9, 0x40, 0x00, 0xdf, 0xff, 0xff, 0xd9, 0x20, 0x00,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfe, 0xcd, 0xff, 0xc0, 0x00, 0xdf, 0xdc, 0xcd, 0xff, 0xf5, 0x00,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x04, 0xff, 0x40, 0x00, 0x17, 0x50, 0x00, 0xdf, 0x50, 0x00, 0x1b, 0xff, 0x10,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x08, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0x50, 0x00, 0x00, 0xef, 0x60,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x0a, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0x50, 0x00, 0x00, 0xbf, 0x80,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x08, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0x50, 0x00, 0x00, 0xbf, 0x70,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0xdf, 0x50, 0x00, 0x00, 0xef, 0x40,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xa3, 0x00, 0x00, 0x00, 0xdf, 0x50, 0x00, 0x2b, 0xfc, 0x00,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00, 0x02, 0xbf, 0xff, 0xc3, 0x00, 0x00, 0xdf, 0xdc, 0xce, 0xff, 0xd2, 0x00,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x9f, 0xff, 0x50, 0x00, 0xdf, 0xff, 0xfe, 0xb6, 0x00, 0x00,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xe0, 0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf4, 0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xf5, 0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf3, 0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00,
            0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x07, 0x30, 0x00, 0x01, 0xbf, 0xd0, 0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00,
            0x00, 0xdf, 0xfe, 0xee, 0xee, 0xe4, 0x0d, 0xff, 0xdc, 0xdf, 0xfe, 0x20, 0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00,
            0x00, 0xdf, 0xff, 0xff, 0xff, 0xf5, 0x05, 0xad, 0xef, 0xfc, 0x70, 0x00, 0x00, 0xdf, 0x50, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        };

        static const lsp::dsp::bitmap_t bitmap =
        {
            38, // width
            33, // height
            19, // stride
            bitmap_data // data
        };

        typedef void (* bitmap_func_b1b8_t)(lsp::dsp::bitmap_t *dst, const lsp::dsp::bitmap_t *src, ssize_t x, ssize_t y);

        static const bitmap_pattern_t put_patterns[] =
        {
            {
                0, 0,
                0x88,
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000ddff550000000000000000000044bbeeffeecc9944000000ddffffffffffdd9922000000\n"
                "0000ddff5500000000000000000088ffffeeccddffffcc000000ddffddccccddffffff550000\n"
                "0000ddff55000000000000000044ffff44000000117755000000ddff5500000011bbffff1100\n"
                "0000ddff55000000000000000088ffaa00000000000000000000ddff550000000000eeff6600\n"
                "0000ddff550000000000000000aaff8800000000000000000000ddff550000000000bbff8800\n"
                "0000ddff55000000000000000088ffdd00000000000000000000ddff550000000000bbff7700\n"
                "0000ddff55000000000000000022ffffbb220000000000000000ddff550000000000eeff4400\n"
                "0000ddff5500000000000000000055ffffffaa33000000000000ddff5500000022bbffcc0000\n"
                "0000ddff550000000000000000000022bbffffffcc3300000000ddffddcccceeffffdd220000\n"
                "0000ddff550000000000000000000000002299ffffff55000000ddffffffffeebb6600000000\n"
                "0000ddff55000000000000000000000000000011ccffee000000ddff55000000000000000000\n"
                "0000ddff5500000000000000000000000000000011ffff440000ddff55000000000000000000\n"
                "0000ddff5500000000000000000000000000000000ddff550000ddff55000000000000000000\n"
                "0000ddff5500000000000000000000000000000000ffff330000ddff55000000000000000000\n"
                "0000ddff55000000000000000077330000000011bbffdd000000ddff55000000000000000000\n"
                "0000ddffffeeeeeeeeeeee4400ddffffddccddffffee22000000ddff55000000000000000000\n"
                "0000ddffffffffffffffff550055aaddeeffffcc770000000000ddff55000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
            },
            {
                -8, -8,
                0x88,
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000044bbeeffeecc9944000000ddffffffffffdd99220000008888888888888888\n"
                "00000000000088ffffeeccddffffcc000000ddffddccccddffffff5500008888888888888888\n"
                "000000000044ffff44000000117755000000ddff5500000011bbffff11008888888888888888\n"
                "000000000088ffaa00000000000000000000ddff550000000000eeff66008888888888888888\n"
                "0000000000aaff8800000000000000000000ddff550000000000bbff88008888888888888888\n"
                "000000000088ffdd00000000000000000000ddff550000000000bbff77008888888888888888\n"
                "000000000022ffffbb220000000000000000ddff550000000000eeff44008888888888888888\n"
                "00000000000055ffffffaa33000000000000ddff5500000022bbffcc00008888888888888888\n"
                "0000000000000022bbffffffcc3300000000ddffddcccceeffffdd2200008888888888888888\n"
                "0000000000000000002299ffffff55000000ddffffffffeebb66000000008888888888888888\n"
                "000000000000000000000011ccffee000000ddff550000000000000000008888888888888888\n"
                "00000000000000000000000011ffff440000ddff550000000000000000008888888888888888\n"
                "00000000000000000000000000ddff550000ddff550000000000000000008888888888888888\n"
                "00000000000000000000000000ffff330000ddff550000000000000000008888888888888888\n"
                "000000000077330000000011bbffdd000000ddff550000000000000000008888888888888888\n"
                "eeeeee4400ddffffddccddffffee22000000ddff550000000000000000008888888888888888\n"
                "ffffff550055aaddeeffffcc770000000000ddff550000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
            },
            {
                8, -8,
                0x88,
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "88888888888888880000ddff550000000000000000000044bbeeffeecc9944000000ddffffff\n"
                "88888888888888880000ddff5500000000000000000088ffffeeccddffffcc000000ddffddcc\n"
                "88888888888888880000ddff55000000000000000044ffff44000000117755000000ddff5500\n"
                "88888888888888880000ddff55000000000000000088ffaa00000000000000000000ddff5500\n"
                "88888888888888880000ddff550000000000000000aaff8800000000000000000000ddff5500\n"
                "88888888888888880000ddff55000000000000000088ffdd00000000000000000000ddff5500\n"
                "88888888888888880000ddff55000000000000000022ffffbb220000000000000000ddff5500\n"
                "88888888888888880000ddff5500000000000000000055ffffffaa33000000000000ddff5500\n"
                "88888888888888880000ddff550000000000000000000022bbffffffcc3300000000ddffddcc\n"
                "88888888888888880000ddff550000000000000000000000002299ffffff55000000ddffffff\n"
                "88888888888888880000ddff55000000000000000000000000000011ccffee000000ddff5500\n"
                "88888888888888880000ddff5500000000000000000000000000000011ffff440000ddff5500\n"
                "88888888888888880000ddff5500000000000000000000000000000000ddff550000ddff5500\n"
                "88888888888888880000ddff5500000000000000000000000000000000ffff330000ddff5500\n"
                "88888888888888880000ddff55000000000000000077330000000011bbffdd000000ddff5500\n"
                "88888888888888880000ddffffeeeeeeeeeeee4400ddffffddccddffffee22000000ddff5500\n"
                "88888888888888880000ddffffffffffffffff550055aaddeeffffcc770000000000ddff5500\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
            },
            {
                8, 8,
                0x88,
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "88888888888888880000ddff550000000000000000000044bbeeffeecc9944000000ddffffff\n"
                "88888888888888880000ddff5500000000000000000088ffffeeccddffffcc000000ddffddcc\n"
                "88888888888888880000ddff55000000000000000044ffff44000000117755000000ddff5500\n"
                "88888888888888880000ddff55000000000000000088ffaa00000000000000000000ddff5500\n"
                "88888888888888880000ddff550000000000000000aaff8800000000000000000000ddff5500\n"
                "88888888888888880000ddff55000000000000000088ffdd00000000000000000000ddff5500\n"
                "88888888888888880000ddff55000000000000000022ffffbb220000000000000000ddff5500\n"
                "88888888888888880000ddff5500000000000000000055ffffffaa33000000000000ddff5500\n"
                "88888888888888880000ddff550000000000000000000022bbffffffcc3300000000ddffddcc\n"
                "88888888888888880000ddff550000000000000000000000002299ffffff55000000ddffffff\n"
                "88888888888888880000ddff55000000000000000000000000000011ccffee000000ddff5500\n"
                "88888888888888880000ddff5500000000000000000000000000000011ffff440000ddff5500\n"
                "88888888888888880000ddff5500000000000000000000000000000000ddff550000ddff5500\n"
                "88888888888888880000ddff5500000000000000000000000000000000ffff330000ddff5500\n"
                "88888888888888880000ddff55000000000000000077330000000011bbffdd000000ddff5500\n"
                "88888888888888880000ddffffeeeeeeeeeeee4400ddffffddccddffffee22000000ddff5500\n"
            },
            {
                -8, 8,
                0x88,
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000044bbeeffeecc9944000000ddffffffffffdd99220000008888888888888888\n"
                "00000000000088ffffeeccddffffcc000000ddffddccccddffffff5500008888888888888888\n"
                "000000000044ffff44000000117755000000ddff5500000011bbffff11008888888888888888\n"
                "000000000088ffaa00000000000000000000ddff550000000000eeff66008888888888888888\n"
                "0000000000aaff8800000000000000000000ddff550000000000bbff88008888888888888888\n"
                "000000000088ffdd00000000000000000000ddff550000000000bbff77008888888888888888\n"
                "000000000022ffffbb220000000000000000ddff550000000000eeff44008888888888888888\n"
                "00000000000055ffffffaa33000000000000ddff5500000022bbffcc00008888888888888888\n"
                "0000000000000022bbffffffcc3300000000ddffddcccceeffffdd2200008888888888888888\n"
                "0000000000000000002299ffffff55000000ddffffffffeebb66000000008888888888888888\n"
                "000000000000000000000011ccffee000000ddff550000000000000000008888888888888888\n"
                "00000000000000000000000011ffff440000ddff550000000000000000008888888888888888\n"
                "00000000000000000000000000ddff550000ddff550000000000000000008888888888888888\n"
                "00000000000000000000000000ffff330000ddff550000000000000000008888888888888888\n"
                "000000000077330000000011bbffdd000000ddff550000000000000000008888888888888888\n"
                "eeeeee4400ddffffddccddffffee22000000ddff550000000000000000008888888888888888\n"
            },
            {
                0, 0,
                0,
                NULL
            }
        };

        static const bitmap_pattern_t add_patterns[] =
        {
            {
                0, 0,
                0x11,
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111eeff661111111111111111111155ccffffffddaa55111111eeffffffffffeeaa33111111\n"
                "1111eeff6611111111111111111199ffffffddeeffffdd111111eeffeeddddeeffffff661111\n"
                "1111eeff66111111111111111155ffff55111111228866111111eeff6611111122ccffff2211\n"
                "1111eeff66111111111111111199ffbb11111111111111111111eeff661111111111ffff7711\n"
                "1111eeff661111111111111111bbff9911111111111111111111eeff661111111111ccff9911\n"
                "1111eeff66111111111111111199ffee11111111111111111111eeff661111111111ccff8811\n"
                "1111eeff66111111111111111133ffffcc331111111111111111eeff661111111111ffff5511\n"
                "1111eeff6611111111111111111166ffffffbb44111111111111eeff6611111133ccffdd1111\n"
                "1111eeff661111111111111111111133ccffffffdd4411111111eeffeeddddffffffee331111\n"
                "1111eeff6611111111111111111111111133aaffffff66111111eeffffffffffcc7711111111\n"
                "1111eeff66111111111111111111111111111122ddffff111111eeff66111111111111111111\n"
                "1111eeff6611111111111111111111111111111122ffff551111eeff66111111111111111111\n"
                "1111eeff6611111111111111111111111111111111eeff661111eeff66111111111111111111\n"
                "1111eeff6611111111111111111111111111111111ffff441111eeff66111111111111111111\n"
                "1111eeff66111111111111111188441111111122ccffee111111eeff66111111111111111111\n"
                "1111eeffffffffffffffff5511eeffffeeddeeffffff33111111eeff66111111111111111111\n"
                "1111eeffffffffffffffff661166bbeeffffffdd881111111111eeff66111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
            },
            {
                -9, -9,
                0x11,
                "11111111111155ccffffffddaa55111111eeffffffffffeeaa33111111111111111111111111\n"
                "111111111199ffffffddeeffffdd111111eeffeeddddeeffffff661111111111111111111111\n"
                "1111111155ffff55111111228866111111eeff6611111122ccffff2211111111111111111111\n"
                "1111111199ffbb11111111111111111111eeff661111111111ffff7711111111111111111111\n"
                "11111111bbff9911111111111111111111eeff661111111111ccff9911111111111111111111\n"
                "1111111199ffee11111111111111111111eeff661111111111ccff8811111111111111111111\n"
                "1111111133ffffcc331111111111111111eeff661111111111ffff5511111111111111111111\n"
                "111111111166ffffffbb44111111111111eeff6611111133ccffdd1111111111111111111111\n"
                "11111111111133ccffffffdd4411111111eeffeeddddffffffee331111111111111111111111\n"
                "111111111111111133aaffffff66111111eeffffffffffcc7711111111111111111111111111\n"
                "1111111111111111111122ddffff111111eeff66111111111111111111111111111111111111\n"
                "111111111111111111111122ffff551111eeff66111111111111111111111111111111111111\n"
                "111111111111111111111111eeff661111eeff66111111111111111111111111111111111111\n"
                "111111111111111111111111ffff441111eeff66111111111111111111111111111111111111\n"
                "1111111188441111111122ccffee111111eeff66111111111111111111111111111111111111\n"
                "ffff5511eeffffeeddeeffffff33111111eeff66111111111111111111111111111111111111\n"
                "ffff661166bbeeffffffdd881111111111eeff66111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
            },
            {
                10, -10,
                0x11,
                "111111111111111111111111eeff6611111111111111111199ffffffddeeffffdd111111eeff\n"
                "111111111111111111111111eeff66111111111111111155ffff55111111228866111111eeff\n"
                "111111111111111111111111eeff66111111111111111199ffbb11111111111111111111eeff\n"
                "111111111111111111111111eeff661111111111111111bbff9911111111111111111111eeff\n"
                "111111111111111111111111eeff66111111111111111199ffee11111111111111111111eeff\n"
                "111111111111111111111111eeff66111111111111111133ffffcc331111111111111111eeff\n"
                "111111111111111111111111eeff6611111111111111111166ffffffbb44111111111111eeff\n"
                "111111111111111111111111eeff661111111111111111111133ccffffffdd4411111111eeff\n"
                "111111111111111111111111eeff6611111111111111111111111133aaffffff66111111eeff\n"
                "111111111111111111111111eeff66111111111111111111111111111122ddffff111111eeff\n"
                "111111111111111111111111eeff6611111111111111111111111111111122ffff551111eeff\n"
                "111111111111111111111111eeff6611111111111111111111111111111111eeff661111eeff\n"
                "111111111111111111111111eeff6611111111111111111111111111111111ffff441111eeff\n"
                "111111111111111111111111eeff66111111111111111188441111111122ccffee111111eeff\n"
                "111111111111111111111111eeffffffffffffffff5511eeffffeeddeeffffff33111111eeff\n"
                "111111111111111111111111eeffffffffffffffff661166bbeeffffffdd881111111111eeff\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
            },
            {
                9, 11,
                0x11,
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111eeff661111111111111111111155ccffffffddaa55111111eeffff\n"
                "1111111111111111111111eeff6611111111111111111199ffffffddeeffffdd111111eeffee\n"
                "1111111111111111111111eeff66111111111111111155ffff55111111228866111111eeff66\n"
                "1111111111111111111111eeff66111111111111111199ffbb11111111111111111111eeff66\n"
                "1111111111111111111111eeff661111111111111111bbff9911111111111111111111eeff66\n"
                "1111111111111111111111eeff66111111111111111199ffee11111111111111111111eeff66\n"
                "1111111111111111111111eeff66111111111111111133ffffcc331111111111111111eeff66\n"
                "1111111111111111111111eeff6611111111111111111166ffffffbb44111111111111eeff66\n"
                "1111111111111111111111eeff661111111111111111111133ccffffffdd4411111111eeffee\n"
                "1111111111111111111111eeff6611111111111111111111111133aaffffff66111111eeffff\n"
                "1111111111111111111111eeff66111111111111111111111111111122ddffff111111eeff66\n"
                "1111111111111111111111eeff6611111111111111111111111111111122ffff551111eeff66\n"
                "1111111111111111111111eeff6611111111111111111111111111111111eeff661111eeff66\n"
            },
            {
                -11, 7,
                0x11,
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111155ccffffffddaa55111111eeffffffffffeeaa331111111111111111111111111111\n"
                "11111199ffffffddeeffffdd111111eeffeeddddeeffffff6611111111111111111111111111\n"
                "111155ffff55111111228866111111eeff6611111122ccffff22111111111111111111111111\n"
                "111199ffbb11111111111111111111eeff661111111111ffff77111111111111111111111111\n"
                "1111bbff9911111111111111111111eeff661111111111ccff99111111111111111111111111\n"
                "111199ffee11111111111111111111eeff661111111111ccff88111111111111111111111111\n"
                "111133ffffcc331111111111111111eeff661111111111ffff55111111111111111111111111\n"
                "11111166ffffffbb44111111111111eeff6611111133ccffdd11111111111111111111111111\n"
                "1111111133ccffffffdd4411111111eeffeeddddffffffee3311111111111111111111111111\n"
                "11111111111133aaffffff66111111eeffffffffffcc77111111111111111111111111111111\n"
                "111111111111111122ddffff111111eeff661111111111111111111111111111111111111111\n"
                "11111111111111111122ffff551111eeff661111111111111111111111111111111111111111\n"
                "11111111111111111111eeff661111eeff661111111111111111111111111111111111111111\n"
                "11111111111111111111ffff441111eeff661111111111111111111111111111111111111111\n"
                "111188441111111122ccffee111111eeff661111111111111111111111111111111111111111\n"
                "5511eeffffeeddeeffffff33111111eeff661111111111111111111111111111111111111111\n"
                "661166bbeeffffffdd881111111111eeff661111111111111111111111111111111111111111\n"
            },
            {
                0, 0,
                0,
                NULL
            }
        };

        static const bitmap_pattern_t sub_patterns[] =
        {
            {
                0, 0,
                0xee,
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeee110099eeeeeeeeeeeeeeeeeeeeaa330000002255aaeeeeee1100000000001155cceeeeee\n"
                "eeee110099eeeeeeeeeeeeeeeeee660000002211000022eeeeee11001122221100000099eeee\n"
                "eeee110099eeeeeeeeeeeeeeeeaa0000aaeeeeeedd7799eeeeee110099eeeeeedd330000ddee\n"
                "eeee110099eeeeeeeeeeeeeeee660044eeeeeeeeeeeeeeeeeeee110099eeeeeeeeee000088ee\n"
                "eeee110099eeeeeeeeeeeeeeee440066eeeeeeeeeeeeeeeeeeee110099eeeeeeeeee330066ee\n"
                "eeee110099eeeeeeeeeeeeeeee660011eeeeeeeeeeeeeeeeeeee110099eeeeeeeeee330077ee\n"
                "eeee110099eeeeeeeeeeeeeeeecc000033cceeeeeeeeeeeeeeee110099eeeeeeeeee0000aaee\n"
                "eeee110099eeeeeeeeeeeeeeeeee9900000044bbeeeeeeeeeeee110099eeeeeecc330022eeee\n"
                "eeee110099eeeeeeeeeeeeeeeeeeeecc3300000022bbeeeeeeee110011222200000011cceeee\n"
                "eeee110099eeeeeeeeeeeeeeeeeeeeeeeecc5500000099eeeeee1100000000003388eeeeeeee\n"
                "eeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeedd220000eeeeee110099eeeeeeeeeeeeeeeeee\n"
                "eeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeedd0000aaeeee110099eeeeeeeeeeeeeeeeee\n"
                "eeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee110099eeee110099eeeeeeeeeeeeeeeeee\n"
                "eeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee0000bbeeee110099eeeeeeeeeeeeeeeeee\n"
                "eeee110099eeeeeeeeeeeeeeee77bbeeeeeeeedd330011eeeeee110099eeeeeeeeeeeeeeeeee\n"
                "eeee110000000000000000aaee110000112211000000cceeeeee110099eeeeeeeeeeeeeeeeee\n"
                "eeee11000000000000000099ee9944110000002277eeeeeeeeee110099eeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
            },
            {
                -9, -9,
                0xee,
                "eeeeeeeeeeeeaa330000002255aaeeeeee1100000000001155cceeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeee660000002211000022eeeeee11001122221100000099eeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeaa0000aaeeeeeedd7799eeeeee110099eeeeeedd330000ddeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeee660044eeeeeeeeeeeeeeeeeeee110099eeeeeeeeee000088eeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeee440066eeeeeeeeeeeeeeeeeeee110099eeeeeeeeee330066eeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeee660011eeeeeeeeeeeeeeeeeeee110099eeeeeeeeee330077eeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeecc000033cceeeeeeeeeeeeeeee110099eeeeeeeeee0000aaeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeee9900000044bbeeeeeeeeeeee110099eeeeeecc330022eeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeecc3300000022bbeeeeeeee110011222200000011cceeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeecc5500000099eeeeee1100000000003388eeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeedd220000eeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeedd0000aaeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeee0000bbeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeee77bbeeeeeeeedd330011eeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "0000aaee110000112211000000cceeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "000099ee9944110000002277eeeeeeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
            },
            {
                10, -10,
                0xee,
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeee660000002211000022eeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeaa0000aaeeeeeedd7799eeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeee660044eeeeeeeeeeeeeeeeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeee440066eeeeeeeeeeeeeeeeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeee660011eeeeeeeeeeeeeeeeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeecc000033cceeeeeeeeeeeeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeee9900000044bbeeeeeeeeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeeeeecc3300000022bbeeeeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeeeeeeeeecc5500000099eeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeedd220000eeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeedd0000aaeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee110099eeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee0000bbeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeee77bbeeeeeeeedd330011eeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee110000000000000000aaee110000112211000000cceeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeee11000000000000000099ee9944110000002277eeeeeeeeee1100\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
            },
            {
                9, 11,
                0xee,
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeeeeeaa330000002255aaeeeeee110000\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeee660000002211000022eeeeee110011\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeaa0000aaeeeeeedd7799eeeeee110099\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeee660044eeeeeeeeeeeeeeeeeeee110099\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeee440066eeeeeeeeeeeeeeeeeeee110099\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeee660011eeeeeeeeeeeeeeeeeeee110099\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeecc000033cceeeeeeeeeeeeeeee110099\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeee9900000044bbeeeeeeeeeeee110099\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeeeeecc3300000022bbeeeeeeee110011\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeeeeeeeeecc5500000099eeeeee110000\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeedd220000eeeeee110099\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeedd0000aaeeee110099\n"
                "eeeeeeeeeeeeeeeeeeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee110099eeee110099\n"
            },
            {
                -11, 7,
                0xee,
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeaa330000002255aaeeeeee1100000000001155cceeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeee660000002211000022eeeeee11001122221100000099eeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeaa0000aaeeeeeedd7799eeeeee110099eeeeeedd330000ddeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeee660044eeeeeeeeeeeeeeeeeeee110099eeeeeeeeee000088eeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeee440066eeeeeeeeeeeeeeeeeeee110099eeeeeeeeee330066eeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeee660011eeeeeeeeeeeeeeeeeeee110099eeeeeeeeee330077eeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeecc000033cceeeeeeeeeeeeeeee110099eeeeeeeeee0000aaeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeee9900000044bbeeeeeeeeeeee110099eeeeeecc330022eeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeecc3300000022bbeeeeeeee110011222200000011cceeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeecc5500000099eeeeee1100000000003388eeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeedd220000eeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeedd0000aaeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeee110099eeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeee0000bbeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeee77bbeeeeeeeedd330011eeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "aaee110000112211000000cceeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "99ee9944110000002277eeeeeeeeee110099eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
            },
            {
                0, 0,
                0,
                NULL
            }
        };

        static const bitmap_pattern_t max_patterns[] =
        {
            {
                0, 0,
                0x88,
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888ddff888888888888888888888888bbeeffeecc9988888888ddffffffffffdd9988888888\n"
                "8888ddff8888888888888888888888ffffeeccddffffcc888888ddffddccccddffffff888888\n"
                "8888ddff88888888888888888888ffff88888888888888888888ddff8888888888bbffff8888\n"
                "8888ddff88888888888888888888ffaa88888888888888888888ddff888888888888eeff8888\n"
                "8888ddff888888888888888888aaff8888888888888888888888ddff888888888888bbff8888\n"
                "8888ddff88888888888888888888ffdd88888888888888888888ddff888888888888bbff8888\n"
                "8888ddff88888888888888888888ffffbb888888888888888888ddff888888888888eeff8888\n"
                "8888ddff8888888888888888888888ffffffaa88888888888888ddff8888888888bbffcc8888\n"
                "8888ddff888888888888888888888888bbffffffcc8888888888ddffddcccceeffffdd888888\n"
                "8888ddff888888888888888888888888888899ffffff88888888ddffffffffeebb8888888888\n"
                "8888ddff88888888888888888888888888888888ccffee888888ddff88888888888888888888\n"
                "8888ddff8888888888888888888888888888888888ffff888888ddff88888888888888888888\n"
                "8888ddff8888888888888888888888888888888888ddff888888ddff88888888888888888888\n"
                "8888ddff8888888888888888888888888888888888ffff888888ddff88888888888888888888\n"
                "8888ddff88888888888888888888888888888888bbffdd888888ddff88888888888888888888\n"
                "8888ddffffeeeeeeeeeeee8888ddffffddccddffffee88888888ddff88888888888888888888\n"
                "8888ddffffffffffffffff888888aaddeeffffcc888888888888ddff88888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
            },
            {
                -9, -9,
                0x88,
                "88888888888888bbeeffeecc9988888888ddffffffffffdd9988888888888888888888888888\n"
                "888888888888ffffeeccddffffcc888888ddffddccccddffffff888888888888888888888888\n"
                "8888888888ffff88888888888888888888ddff8888888888bbffff8888888888888888888888\n"
                "8888888888ffaa88888888888888888888ddff888888888888eeff8888888888888888888888\n"
                "88888888aaff8888888888888888888888ddff888888888888bbff8888888888888888888888\n"
                "8888888888ffdd88888888888888888888ddff888888888888bbff8888888888888888888888\n"
                "8888888888ffffbb888888888888888888ddff888888888888eeff8888888888888888888888\n"
                "888888888888ffffffaa88888888888888ddff8888888888bbffcc8888888888888888888888\n"
                "88888888888888bbffffffcc8888888888ddffddcccceeffffdd888888888888888888888888\n"
                "88888888888888888899ffffff88888888ddffffffffeebb8888888888888888888888888888\n"
                "8888888888888888888888ccffee888888ddff88888888888888888888888888888888888888\n"
                "888888888888888888888888ffff888888ddff88888888888888888888888888888888888888\n"
                "888888888888888888888888ddff888888ddff88888888888888888888888888888888888888\n"
                "888888888888888888888888ffff888888ddff88888888888888888888888888888888888888\n"
                "8888888888888888888888bbffdd888888ddff88888888888888888888888888888888888888\n"
                "eeee8888ddffffddccddffffee88888888ddff88888888888888888888888888888888888888\n"
                "ffff888888aaddeeffffcc888888888888ddff88888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
            },
            {
                10, -10,
                0x11,
                "111111111111111111111111ddff5511111111111111111188ffffeeccddffffcc111111ddff\n"
                "111111111111111111111111ddff55111111111111111144ffff44111111117755111111ddff\n"
                "111111111111111111111111ddff55111111111111111188ffaa11111111111111111111ddff\n"
                "111111111111111111111111ddff551111111111111111aaff8811111111111111111111ddff\n"
                "111111111111111111111111ddff55111111111111111188ffdd11111111111111111111ddff\n"
                "111111111111111111111111ddff55111111111111111122ffffbb221111111111111111ddff\n"
                "111111111111111111111111ddff5511111111111111111155ffffffaa33111111111111ddff\n"
                "111111111111111111111111ddff551111111111111111111122bbffffffcc3311111111ddff\n"
                "111111111111111111111111ddff551111111111111111111111112299ffffff55111111ddff\n"
                "111111111111111111111111ddff55111111111111111111111111111111ccffee111111ddff\n"
                "111111111111111111111111ddff5511111111111111111111111111111111ffff441111ddff\n"
                "111111111111111111111111ddff5511111111111111111111111111111111ddff551111ddff\n"
                "111111111111111111111111ddff5511111111111111111111111111111111ffff331111ddff\n"
                "111111111111111111111111ddff55111111111111111177331111111111bbffdd111111ddff\n"
                "111111111111111111111111ddffffeeeeeeeeeeee4411ddffffddccddffffee22111111ddff\n"
                "111111111111111111111111ddffffffffffffffff551155aaddeeffffcc771111111111ddff\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
            },
            {
                9, 11,
                0x55,
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555ddff555555555555555555555555bbeeffeecc9955555555ddffff\n"
                "5555555555555555555555ddff5555555555555555555588ffffeeccddffffcc555555ddffdd\n"
                "5555555555555555555555ddff55555555555555555555ffff55555555557755555555ddff55\n"
                "5555555555555555555555ddff55555555555555555588ffaa55555555555555555555ddff55\n"
                "5555555555555555555555ddff555555555555555555aaff8855555555555555555555ddff55\n"
                "5555555555555555555555ddff55555555555555555588ffdd55555555555555555555ddff55\n"
                "5555555555555555555555ddff55555555555555555555ffffbb555555555555555555ddff55\n"
                "5555555555555555555555ddff5555555555555555555555ffffffaa55555555555555ddff55\n"
                "5555555555555555555555ddff555555555555555555555555bbffffffcc5555555555ddffdd\n"
                "5555555555555555555555ddff555555555555555555555555555599ffffff55555555ddffff\n"
                "5555555555555555555555ddff55555555555555555555555555555555ccffee555555ddff55\n"
                "5555555555555555555555ddff5555555555555555555555555555555555ffff555555ddff55\n"
                "5555555555555555555555ddff5555555555555555555555555555555555ddff555555ddff55\n"
            },
            {
                -11, 7,
                0x11,
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111144bbeeffeecc9944111111ddffffffffffdd99221111111111111111111111111111\n"
                "11111188ffffeeccddffffcc111111ddffddccccddffffff5511111111111111111111111111\n"
                "111144ffff44111111117755111111ddff5511111111bbffff11111111111111111111111111\n"
                "111188ffaa11111111111111111111ddff551111111111eeff66111111111111111111111111\n"
                "1111aaff8811111111111111111111ddff551111111111bbff88111111111111111111111111\n"
                "111188ffdd11111111111111111111ddff551111111111bbff77111111111111111111111111\n"
                "111122ffffbb221111111111111111ddff551111111111eeff44111111111111111111111111\n"
                "11111155ffffffaa33111111111111ddff5511111122bbffcc11111111111111111111111111\n"
                "1111111122bbffffffcc3311111111ddffddcccceeffffdd2211111111111111111111111111\n"
                "1111111111112299ffffff55111111ddffffffffeebb66111111111111111111111111111111\n"
                "111111111111111111ccffee111111ddff551111111111111111111111111111111111111111\n"
                "11111111111111111111ffff441111ddff551111111111111111111111111111111111111111\n"
                "11111111111111111111ddff551111ddff551111111111111111111111111111111111111111\n"
                "11111111111111111111ffff331111ddff551111111111111111111111111111111111111111\n"
                "111177331111111111bbffdd111111ddff551111111111111111111111111111111111111111\n"
                "4411ddffffddccddffffee22111111ddff551111111111111111111111111111111111111111\n"
                "551155aaddeeffffcc771111111111ddff551111111111111111111111111111111111111111\n"
            },
            {
                0, 0,
                0,
                NULL
            }
        };

        static const bitmap_pattern_t min_patterns[] =
        {
            {
                0, 0,
                0xee,
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000ddee550000000000000000000044bbeeeeeecc9944000000ddeeeeeeeeeedd9922000000\n"
                "0000ddee5500000000000000000088eeeeeeccddeeeecc000000ddeeddccccddeeeeee550000\n"
                "0000ddee55000000000000000044eeee44000000117755000000ddee5500000011bbeeee1100\n"
                "0000ddee55000000000000000088eeaa00000000000000000000ddee550000000000eeee6600\n"
                "0000ddee550000000000000000aaee8800000000000000000000ddee550000000000bbee8800\n"
                "0000ddee55000000000000000088eedd00000000000000000000ddee550000000000bbee7700\n"
                "0000ddee55000000000000000022eeeebb220000000000000000ddee550000000000eeee4400\n"
                "0000ddee5500000000000000000055eeeeeeaa33000000000000ddee5500000022bbeecc0000\n"
                "0000ddee550000000000000000000022bbeeeeeecc3300000000ddeeddcccceeeeeedd220000\n"
                "0000ddee550000000000000000000000002299eeeeee55000000ddeeeeeeeeeebb6600000000\n"
                "0000ddee55000000000000000000000000000011cceeee000000ddee55000000000000000000\n"
                "0000ddee5500000000000000000000000000000011eeee440000ddee55000000000000000000\n"
                "0000ddee5500000000000000000000000000000000ddee550000ddee55000000000000000000\n"
                "0000ddee5500000000000000000000000000000000eeee330000ddee55000000000000000000\n"
                "0000ddee55000000000000000077330000000011bbeedd000000ddee55000000000000000000\n"
                "0000ddeeeeeeeeeeeeeeee4400ddeeeeddccddeeeeee22000000ddee55000000000000000000\n"
                "0000ddeeeeeeeeeeeeeeee550055aaddeeeeeecc770000000000ddee55000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
            },
            {
                -9, -9,
                0xee,
                "00000000000044bbeeeeeecc9944000000ddeeeeeeeeeedd9922000000eeeeeeeeeeeeeeeeee\n"
                "000000000088eeeeeeccddeeeecc000000ddeeddccccddeeeeee550000eeeeeeeeeeeeeeeeee\n"
                "0000000044eeee44000000117755000000ddee5500000011bbeeee1100eeeeeeeeeeeeeeeeee\n"
                "0000000088eeaa00000000000000000000ddee550000000000eeee6600eeeeeeeeeeeeeeeeee\n"
                "00000000aaee8800000000000000000000ddee550000000000bbee8800eeeeeeeeeeeeeeeeee\n"
                "0000000088eedd00000000000000000000ddee550000000000bbee7700eeeeeeeeeeeeeeeeee\n"
                "0000000022eeeebb220000000000000000ddee550000000000eeee4400eeeeeeeeeeeeeeeeee\n"
                "000000000055eeeeeeaa33000000000000ddee5500000022bbeecc0000eeeeeeeeeeeeeeeeee\n"
                "00000000000022bbeeeeeecc3300000000ddeeddcccceeeeeedd220000eeeeeeeeeeeeeeeeee\n"
                "00000000000000002299eeeeee55000000ddeeeeeeeeeebb6600000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000011cceeee000000ddee55000000000000000000eeeeeeeeeeeeeeeeee\n"
                "000000000000000000000011eeee440000ddee55000000000000000000eeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000ddee550000ddee55000000000000000000eeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000eeee330000ddee55000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000077330000000011bbeedd000000ddee55000000000000000000eeeeeeeeeeeeeeeeee\n"
                "eeee4400ddeeeeddccddeeeeee22000000ddee55000000000000000000eeeeeeeeeeeeeeeeee\n"
                "eeee550055aaddeeeeeecc770000000000ddee55000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
            },
            {
                10, -10,
                0xaa,
                "aaaaaaaaaaaaaaaaaaaa0000aaaa5500000000000000000088aaaaaaaaaaaaaaaa000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa55000000000000000044aaaa44000000117755000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa55000000000000000088aaaa00000000000000000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa550000000000000000aaaa8800000000000000000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa55000000000000000088aaaa00000000000000000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa55000000000000000022aaaaaa220000000000000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa5500000000000000000055aaaaaaaa33000000000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa550000000000000000000022aaaaaaaaaa3300000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa550000000000000000000000002299aaaaaa55000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa55000000000000000000000000000011aaaaaa000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa5500000000000000000000000000000011aaaa440000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa5500000000000000000000000000000000aaaa550000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa5500000000000000000000000000000000aaaa330000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa55000000000000000077330000000011aaaaaa000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaaaaaaaaaaaaaaaa4400aaaaaaaaaaaaaaaaaa22000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaaaaaaaaaaaaaaaa550055aaaaaaaaaaaa770000000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
            },
            {
                9, 11,
                0xee,
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000ddee550000000000000000000044bbeeeeeecc9944000000ddeeee\n"
                "eeeeeeeeeeeeeeeeee0000ddee5500000000000000000088eeeeeeccddeeeecc000000ddeedd\n"
                "eeeeeeeeeeeeeeeeee0000ddee55000000000000000044eeee44000000117755000000ddee55\n"
                "eeeeeeeeeeeeeeeeee0000ddee55000000000000000088eeaa00000000000000000000ddee55\n"
                "eeeeeeeeeeeeeeeeee0000ddee550000000000000000aaee8800000000000000000000ddee55\n"
                "eeeeeeeeeeeeeeeeee0000ddee55000000000000000088eedd00000000000000000000ddee55\n"
                "eeeeeeeeeeeeeeeeee0000ddee55000000000000000022eeeebb220000000000000000ddee55\n"
                "eeeeeeeeeeeeeeeeee0000ddee5500000000000000000055eeeeeeaa33000000000000ddee55\n"
                "eeeeeeeeeeeeeeeeee0000ddee550000000000000000000022bbeeeeeecc3300000000ddeedd\n"
                "eeeeeeeeeeeeeeeeee0000ddee550000000000000000000000002299eeeeee55000000ddeeee\n"
                "eeeeeeeeeeeeeeeeee0000ddee55000000000000000000000000000011cceeee000000ddee55\n"
                "eeeeeeeeeeeeeeeeee0000ddee5500000000000000000000000000000011eeee440000ddee55\n"
                "eeeeeeeeeeeeeeeeee0000ddee5500000000000000000000000000000000ddee550000ddee55\n"
            },
            {
                -11, 7,
                0xee,
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "0000000044bbeeeeeecc9944000000ddeeeeeeeeeedd9922000000eeeeeeeeeeeeeeeeeeeeee\n"
                "00000088eeeeeeccddeeeecc000000ddeeddccccddeeeeee550000eeeeeeeeeeeeeeeeeeeeee\n"
                "000044eeee44000000117755000000ddee5500000011bbeeee1100eeeeeeeeeeeeeeeeeeeeee\n"
                "000088eeaa00000000000000000000ddee550000000000eeee6600eeeeeeeeeeeeeeeeeeeeee\n"
                "0000aaee8800000000000000000000ddee550000000000bbee8800eeeeeeeeeeeeeeeeeeeeee\n"
                "000088eedd00000000000000000000ddee550000000000bbee7700eeeeeeeeeeeeeeeeeeeeee\n"
                "000022eeeebb220000000000000000ddee550000000000eeee4400eeeeeeeeeeeeeeeeeeeeee\n"
                "00000055eeeeeeaa33000000000000ddee5500000022bbeecc0000eeeeeeeeeeeeeeeeeeeeee\n"
                "0000000022bbeeeeeecc3300000000ddeeddcccceeeeeedd220000eeeeeeeeeeeeeeeeeeeeee\n"
                "0000000000002299eeeeee55000000ddeeeeeeeeeebb6600000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000011cceeee000000ddee55000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "00000000000000000011eeee440000ddee55000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "00000000000000000000ddee550000ddee55000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "00000000000000000000eeee330000ddee55000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000077330000000011bbeedd000000ddee55000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "4400ddeeeeddccddeeeeee22000000ddee55000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "550055aaddeeeeeecc770000000000ddee55000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
            },
            {
                0, 0,
                0,
                NULL
            }
        };


    } /* namespace test */
} /* namespace lsp */

UTEST_BEGIN("dsp.bitmap", b4b8)

    void test_pattern(const char *name, bitmap_func_b1b8_t func, const bitmap_pattern_t *pattern)
    {
        printf("Testing '%s' at point (%d, %d)\n", name, int(pattern->x), int(pattern->y));

        dsp::bitmap_t tmp;
        ByteBuffer bbuf(bitmap.width * bitmap.height);

        tmp.width   = bitmap.width;
        tmp.height  = bitmap.height;
        tmp.stride  = tmp.width;
        tmp.data    = bbuf.data();
        memset(bbuf.data(), pattern->fill, bitmap.width * bitmap.height);

        func(&tmp, &bitmap, pattern->x, pattern->y);

        UTEST_ASSERT(!bbuf.corrupted());

        char *result = rasterize(&tmp);
        UTEST_ASSERT(result != NULL);
        lsp_finally { free(result); };

        if (strcmp(result, pattern->data) != 0)
        {
            UTEST_FAIL_MSG("Faled rasterization:\ngot pattern:\n%s\nexpected pattern:\n%s\n", result, pattern->data);
        }
    }

    void test_patterns(const char *name, bitmap_func_b1b8_t func, const bitmap_pattern_t * list)
    {
        if (!UTEST_SUPPORTED(func))
            return;

        for (; list->data != NULL; ++list)
            test_pattern(name, func, list);
    }


    UTEST_MAIN
    {
        using namespace lsp;

        #define TEST_PATTERNS(func, list) \
            test_patterns(#func, func, list)

        TEST_PATTERNS(generic::bitmap_put_b4b8, put_patterns);
        TEST_PATTERNS(generic::bitmap_add_b4b8, add_patterns);
        TEST_PATTERNS(generic::bitmap_sub_b4b8, sub_patterns);
        TEST_PATTERNS(generic::bitmap_max_b4b8, max_patterns);
        TEST_PATTERNS(generic::bitmap_min_b4b8, min_patterns);
    }

UTEST_END;








