/**********************************************************************
 * Example veriusertfs table that is used by many Verilog simulators
 * to register PLI applications that use the TF and ACC libraries of
 * the IEEE 1364 PLI.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

/* prototypes of the PLI application routines */
extern int PLIbook_ScientificALU_checktf();
extern int PLIbook_ScientificALU_calltf();
extern int PLIbook_ScientificALU_misctf();

/* the veriusertfs table */
s_tfcell veriusertfs[] =
{
    {usertask,                         /* type of PLI routine */
      0,                               /* user_data value */
      PLIbook_ScientificALU_checktf,   /* checktf routine */
      0,                               /* sizetf routine */
      PLIbook_ScientificALU_calltf,    /* calltf routine */
/*      PLIbook_ScientificALU_misctf,    /* misctf routine */
      0,                               /* misctf routine */
      "$scientific_alu",               /* system task/function name */
      1                                /* forward reference = true */
    },                                 /* */

    {0} /*** final entry must be 0 ***/
};

