/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef GNAP_FONTDATA_H
#define GNAP_FONTDATA_H

namespace Gnap {

struct FONT_CHAR_INFO {
  const byte _width;              // width, in bits (or pixels), of the character
  const uint16 _offset;           // offset of the character's bitmap, in bytes, into the FONT_INFO's data array

  FONT_CHAR_INFO(byte width, uint16 offset) : _width(width), _offset(offset) {}
};

/*
**  Font data for DejaVu Sans 9pt
*/

/* Character bitmaps for DejaVu Sans 9pt */
const byte _dejaVuSans9ptCharBitmaps[] = {
	/* @0 ' ' (5 pixels wide) */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */

	/* @10 '!' (1 pixels wide) */
	0x1B, 0xF0, /*    ## ######     */

	/* @12 '"' (3 pixels wide) */
	0x00, 0x70, /*          ###     */
	0x00, 0x00, /*                  */
	0x00, 0x70, /*          ###     */

	/* @18 '#' (8 pixels wide) */
	0x04, 0x00, /*      #           */
	0x14, 0x80, /*    # #  #        */
	0x0F, 0x80, /*     #####        */
	0x04, 0xE0, /*      #  ###      */
	0x1C, 0x80, /*    ###  #        */
	0x07, 0xC0, /*      #####       */
	0x04, 0xA0, /*      #  # #      */
	0x00, 0x80, /*         #        */

	/* @34 '$' (5 pixels wide) */
	0x09, 0xC0, /*     #  ###       */
	0x11, 0x20, /*    #   #  #      */
	0x7F, 0xF0, /*  ###########     */
	0x12, 0x20, /*    #  #   #      */
	0x0E, 0x40, /*     ###  #       */

	/* @44 '%' (10 pixels wide) */
	0x00, 0xE0, /*         ###      */
	0x01, 0x10, /*        #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x0C, 0xE0, /*     ##  ###      */
	0x03, 0x00, /*       ##         */
	0x01, 0x80, /*        ##        */
	0x0E, 0x60, /*     ###  ##      */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x00, /*    #   #         */
	0x0E, 0x00, /*     ###          */

	/* @64 '&' (8 pixels wide) */
	0x0E, 0x00, /*     ###          */
	0x19, 0xE0, /*    ##  ####      */
	0x10, 0x90, /*    #    #  #     */
	0x11, 0x10, /*    #   #   #     */
	0x12, 0x20, /*    #  #   #      */
	0x0C, 0x00, /*     ##           */
	0x14, 0x00, /*    # #           */
	0x13, 0x00, /*    #  ##         */

	/* @80 ''' (1 pixels wide) */
	0x00, 0x70, /*          ###     */

	/* @82 '(' (3 pixels wide) */
	0x07, 0xC0, /*      #####       */
	0x38, 0x38, /*   ###     ###    */
	0x20, 0x08, /*   #         #    */

	/* @88 ')' (3 pixels wide) */
	0x20, 0x08, /*   #         #    */
	0x38, 0x38, /*   ###     ###    */
	0x07, 0xC0, /*      #####       */

	/* @94 '*' (5 pixels wide) */
	0x01, 0x20, /*        #  #      */
	0x00, 0xC0, /*         ##       */
	0x03, 0xF0, /*       ######     */
	0x00, 0xC0, /*         ##       */
	0x01, 0x20, /*        #  #      */

	/* @104 '+' (7 pixels wide) */
	0x02, 0x00, /*       #          */
	0x02, 0x00, /*       #          */
	0x02, 0x00, /*       #          */
	0x1F, 0xC0, /*    #######       */
	0x02, 0x00, /*       #          */
	0x02, 0x00, /*       #          */
	0x02, 0x00, /*       #          */

	/* @118 ',' (1 pixels wide) */
	0x38, 0x00, /*   ###            */

	/* @120 '-' (3 pixels wide) */
	0x02, 0x00, /*       #          */
	0x02, 0x00, /*       #          */
	0x02, 0x00, /*       #          */

	/* @126 '.' (1 pixels wide) */
	0x18, 0x00, /*    ##            */

	/* @128 '/' (4 pixels wide) */
	0x30, 0x00, /*   ##             */
	0x0E, 0x00, /*     ###          */
	0x01, 0xC0, /*        ###       */
	0x00, 0x30, /*           ##     */

	/* @136 '0' (6 pixels wide) */
	0x07, 0xC0, /*      #####       */
	0x18, 0x30, /*    ##     ##     */
	0x10, 0x10, /*    #       #     */
	0x10, 0x10, /*    #       #     */
	0x18, 0x30, /*    ##     ##     */
	0x07, 0xC0, /*      #####       */

	/* @148 '1' (5 pixels wide) */
	0x10, 0x10, /*    #       #     */
	0x10, 0x10, /*    #       #     */
	0x1F, 0xF0, /*    #########     */
	0x10, 0x00, /*    #             */
	0x10, 0x00, /*    #             */

	/* @158 '2' (6 pixels wide) */
	0x10, 0x20, /*    #      #      */
	0x18, 0x10, /*    ##      #     */
	0x14, 0x10, /*    # #     #     */
	0x12, 0x10, /*    #  #    #     */
	0x11, 0x30, /*    #   #  ##     */
	0x10, 0xE0, /*    #    ###      */

	/* @170 '3' (6 pixels wide) */
	0x08, 0x20, /*     #     #      */
	0x10, 0x10, /*    #       #     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x0E, 0xE0, /*     ### ###      */

	/* @182 '4' (6 pixels wide) */
	0x06, 0x00, /*      ##          */
	0x05, 0x80, /*      # ##        */
	0x04, 0x40, /*      #   #       */
	0x04, 0x30, /*      #    ##     */
	0x1F, 0xF0, /*    #########     */
	0x04, 0x00, /*      #           */

	/* @194 '5' (6 pixels wide) */
	0x08, 0xF0, /*     #   ####     */
	0x10, 0x90, /*    #    #  #     */
	0x10, 0x90, /*    #    #  #     */
	0x10, 0x90, /*    #    #  #     */
	0x19, 0x90, /*    ##  ##  #     */
	0x0F, 0x00, /*     ####         */

	/* @206 '6' (6 pixels wide) */
	0x07, 0xC0, /*      #####       */
	0x19, 0x20, /*    ##  #  #      */
	0x10, 0x90, /*    #    #  #     */
	0x10, 0x90, /*    #    #  #     */
	0x19, 0x90, /*    ##  ##  #     */
	0x0F, 0x20, /*     ####  #      */

	/* @218 '7' (6 pixels wide) */
	0x00, 0x10, /*            #     */
	0x10, 0x10, /*    #       #     */
	0x0C, 0x10, /*     ##     #     */
	0x03, 0x10, /*       ##   #     */
	0x00, 0xD0, /*         ## #     */
	0x00, 0x30, /*           ##     */

	/* @230 '8' (6 pixels wide) */
	0x0E, 0xE0, /*     ### ###      */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x0E, 0xE0, /*     ### ###      */

	/* @242 '9' (6 pixels wide) */
	0x09, 0xE0, /*     #  ####      */
	0x13, 0x30, /*    #  ##  ##     */
	0x12, 0x10, /*    #  #    #     */
	0x12, 0x10, /*    #  #    #     */
	0x09, 0x30, /*     #  #  ##     */
	0x07, 0xC0, /*      #####       */

	/* @254 ':' (1 pixels wide) */
	0x19, 0x80, /*    ##  ##        */

	/* @256 ';' (1 pixels wide) */
	0x39, 0x80, /*   ###  ##        */

	/* @258 '<' (8 pixels wide) */
	0x03, 0x00, /*       ##         */
	0x03, 0x00, /*       ##         */
	0x03, 0x00, /*       ##         */
	0x04, 0x80, /*      #  #        */
	0x04, 0x80, /*      #  #        */
	0x04, 0x80, /*      #  #        */
	0x0C, 0xC0, /*     ##  ##       */
	0x08, 0x40, /*     #    #       */

	/* @274 '=' (8 pixels wide) */
	0x05, 0x00, /*      # #         */
	0x05, 0x00, /*      # #         */
	0x05, 0x00, /*      # #         */
	0x05, 0x00, /*      # #         */
	0x05, 0x00, /*      # #         */
	0x05, 0x00, /*      # #         */
	0x05, 0x00, /*      # #         */
	0x05, 0x00, /*      # #         */

	/* @290 '>' (8 pixels wide) */
	0x08, 0x40, /*     #    #       */
	0x0C, 0xC0, /*     ##  ##       */
	0x04, 0x80, /*      #  #        */
	0x04, 0x80, /*      #  #        */
	0x04, 0x80, /*      #  #        */
	0x03, 0x00, /*       ##         */
	0x03, 0x00, /*       ##         */
	0x03, 0x00, /*       ##         */

	/* @306 '?' (5 pixels wide) */
	0x00, 0x20, /*           #      */
	0x00, 0x10, /*            #     */
	0x1B, 0x10, /*    ## ##   #     */
	0x00, 0x90, /*         #  #     */
	0x00, 0x60, /*          ##      */

	/* @316 '@' (11 pixels wide) */
	0x0F, 0x80, /*     #####        */
	0x10, 0x40, /*    #     #       */
	0x20, 0x20, /*   #       #      */
	0x47, 0x10, /*  #   ###   #     */
	0x48, 0x90, /*  #  #   #  #     */
	0x48, 0x90, /*  #  #   #  #     */
	0x48, 0x90, /*  #  #   #  #     */
	0x4F, 0x90, /*  #  #####  #     */
	0x28, 0x20, /*   # #     #      */
	0x04, 0x60, /*      #   ##      */
	0x03, 0x80, /*       ###        */

	/* @338 'A' (8 pixels wide) */
	0x10, 0x00, /*    #             */
	0x0E, 0x00, /*     ###          */
	0x05, 0xC0, /*      # ###       */
	0x04, 0x30, /*      #    ##     */
	0x04, 0x30, /*      #    ##     */
	0x05, 0xC0, /*      # ###       */
	0x0E, 0x00, /*     ###          */
	0x10, 0x00, /*    #             */

	/* @354 'B' (6 pixels wide) */
	0x1F, 0xF0, /*    #########     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x0E, 0xE0, /*     ### ###      */

	/* @366 'C' (6 pixels wide) */
	0x07, 0xC0, /*      #####       */
	0x08, 0x20, /*     #     #      */
	0x10, 0x10, /*    #       #     */
	0x10, 0x10, /*    #       #     */
	0x10, 0x10, /*    #       #     */
	0x08, 0x20, /*     #     #      */

	/* @378 'D' (7 pixels wide) */
	0x1F, 0xF0, /*    #########     */
	0x10, 0x10, /*    #       #     */
	0x10, 0x10, /*    #       #     */
	0x10, 0x10, /*    #       #     */
	0x10, 0x10, /*    #       #     */
	0x08, 0x20, /*     #     #      */
	0x07, 0xC0, /*      #####       */

	/* @392 'E' (6 pixels wide) */
	0x1F, 0xF0, /*    #########     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */

	/* @404 'F' (5 pixels wide) */
	0x1F, 0xF0, /*    #########     */
	0x01, 0x10, /*        #   #     */
	0x01, 0x10, /*        #   #     */
	0x01, 0x10, /*        #   #     */
	0x01, 0x10, /*        #   #     */

	/* @414 'G' (7 pixels wide) */
	0x07, 0xC0, /*      #####       */
	0x08, 0x20, /*     #     #      */
	0x10, 0x10, /*    #       #     */
	0x10, 0x10, /*    #       #     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x0F, 0x20, /*     ####  #      */

	/* @428 'H' (7 pixels wide) */
	0x1F, 0xF0, /*    #########     */
	0x01, 0x00, /*        #         */
	0x01, 0x00, /*        #         */
	0x01, 0x00, /*        #         */
	0x01, 0x00, /*        #         */
	0x01, 0x00, /*        #         */
	0x1F, 0xF0, /*    #########     */

	/* @442 'I' (1 pixels wide) */
	0x1F, 0xF0, /*    #########     */

	/* @444 'J' (3 pixels wide) */
	0x40, 0x00, /*  #               */
	0x40, 0x00, /*  #               */
	0x3F, 0xF0, /*   ##########     */

	/* @450 'K' (6 pixels wide) */
	0x1F, 0xF0, /*    #########     */
	0x01, 0x00, /*        #         */
	0x02, 0x80, /*       # #        */
	0x04, 0x40, /*      #   #       */
	0x08, 0x20, /*     #     #      */
	0x10, 0x10, /*    #       #     */

	/* @462 'L' (5 pixels wide) */
	0x1F, 0xF0, /*    #########     */
	0x10, 0x00, /*    #             */
	0x10, 0x00, /*    #             */
	0x10, 0x00, /*    #             */
	0x10, 0x00, /*    #             */

	/* @472 'M' (8 pixels wide) */
	0x1F, 0xF0, /*    #########     */
	0x00, 0x60, /*          ##      */
	0x01, 0x80, /*        ##        */
	0x06, 0x00, /*      ##          */
	0x06, 0x00, /*      ##          */
	0x01, 0x80, /*        ##        */
	0x00, 0x60, /*          ##      */
	0x1F, 0xF0, /*    #########     */

	/* @488 'N' (7 pixels wide) */
	0x1F, 0xF0, /*    #########     */
	0x00, 0x30, /*           ##     */
	0x00, 0xC0, /*         ##       */
	0x01, 0x00, /*        #         */
	0x06, 0x00, /*      ##          */
	0x18, 0x00, /*    ##            */
	0x1F, 0xF0, /*    #########     */

	/* @502 'O' (7 pixels wide) */
	0x07, 0xC0, /*      #####       */
	0x08, 0x20, /*     #     #      */
	0x10, 0x10, /*    #       #     */
	0x10, 0x10, /*    #       #     */
	0x10, 0x10, /*    #       #     */
	0x08, 0x20, /*     #     #      */
	0x07, 0xC0, /*      #####       */

	/* @516 'P' (6 pixels wide) */
	0x1F, 0xF0, /*    #########     */
	0x01, 0x10, /*        #   #     */
	0x01, 0x10, /*        #   #     */
	0x01, 0x10, /*        #   #     */
	0x01, 0x10, /*        #   #     */
	0x00, 0xE0, /*         ###      */

	/* @528 'Q' (7 pixels wide) */
	0x07, 0xC0, /*      #####       */
	0x08, 0x20, /*     #     #      */
	0x10, 0x10, /*    #       #     */
	0x10, 0x10, /*    #       #     */
	0x30, 0x10, /*   ##       #     */
	0x48, 0x20, /*  #  #     #      */
	0x07, 0xC0, /*      #####       */

	/* @542 'R' (7 pixels wide) */
	0x1F, 0xF0, /*    #########     */
	0x01, 0x10, /*        #   #     */
	0x01, 0x10, /*        #   #     */
	0x01, 0x10, /*        #   #     */
	0x03, 0x10, /*       ##   #     */
	0x0C, 0xE0, /*     ##  ###      */
	0x10, 0x00, /*    #             */

	/* @556 'S' (6 pixels wide) */
	0x08, 0xE0, /*     #   ###      */
	0x11, 0x90, /*    #   ##  #     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x11, 0x10, /*    #   #   #     */
	0x0E, 0x20, /*     ###   #      */

	/* @568 'T' (7 pixels wide) */
	0x00, 0x10, /*            #     */
	0x00, 0x10, /*            #     */
	0x00, 0x10, /*            #     */
	0x1F, 0xF0, /*    #########     */
	0x00, 0x10, /*            #     */
	0x00, 0x10, /*            #     */
	0x00, 0x10, /*            #     */

	/* @582 'U' (7 pixels wide) */
	0x0F, 0xF0, /*     ########     */
	0x18, 0x00, /*    ##            */
	0x10, 0x00, /*    #             */
	0x10, 0x00, /*    #             */
	0x10, 0x00, /*    #             */
	0x18, 0x00, /*    ##            */
	0x0F, 0xF0, /*     ########     */

	/* @596 'V' (8 pixels wide) */
	0x00, 0x30, /*           ##     */
	0x01, 0xC0, /*        ###       */
	0x06, 0x00, /*      ##          */
	0x18, 0x00, /*    ##            */
	0x18, 0x00, /*    ##            */
	0x06, 0x00, /*      ##          */
	0x01, 0xC0, /*        ###       */
	0x00, 0x30, /*           ##     */

	/* @612 'W' (11 pixels wide) */
	0x00, 0x10, /*            #     */
	0x00, 0xE0, /*         ###      */
	0x07, 0x00, /*      ###         */
	0x18, 0x00, /*    ##            */
	0x07, 0x80, /*      ####        */
	0x00, 0x70, /*          ###     */
	0x07, 0x80, /*      ####        */
	0x18, 0x00, /*    ##            */
	0x07, 0x00, /*      ###         */
	0x00, 0xE0, /*         ###      */
	0x00, 0x10, /*            #     */

	/* @634 'X' (7 pixels wide) */
	0x10, 0x10, /*    #       #     */
	0x08, 0x30, /*     #     ##     */
	0x06, 0xC0, /*      ## ##       */
	0x01, 0x00, /*        #         */
	0x06, 0xC0, /*      ## ##       */
	0x08, 0x30, /*     #     ##     */
	0x10, 0x10, /*    #       #     */

	/* @648 'Y' (7 pixels wide) */
	0x00, 0x10, /*            #     */
	0x00, 0x60, /*          ##      */
	0x01, 0x80, /*        ##        */
	0x1E, 0x00, /*    ####          */
	0x01, 0x80, /*        ##        */
	0x00, 0x60, /*          ##      */
	0x00, 0x10, /*            #     */

	/* @662 'Z' (7 pixels wide) */
	0x18, 0x10, /*    ##      #     */
	0x14, 0x10, /*    # #     #     */
	0x12, 0x10, /*    #  #    #     */
	0x11, 0x10, /*    #   #   #     */
	0x10, 0x90, /*    #    #  #     */
	0x10, 0x50, /*    #     # #     */
	0x10, 0x30, /*    #      ##     */

	/* @676 '[' (2 pixels wide) */
	0x7F, 0xF0, /*  ###########     */
	0x40, 0x10, /*  #         #     */

	/* @680 '\' (4 pixels wide) */
	0x00, 0x30, /*           ##     */
	0x01, 0xC0, /*        ###       */
	0x0E, 0x00, /*     ###          */
	0x30, 0x00, /*   ##             */

	/* @688 ']' (2 pixels wide) */
	0x40, 0x10, /*  #         #     */
	0x7F, 0xF0, /*  ###########     */

	/* @692 '^' (6 pixels wide) */
	0x00, 0x40, /*          #       */
	0x00, 0x20, /*           #      */
	0x00, 0x10, /*            #     */
	0x00, 0x10, /*            #     */
	0x00, 0x20, /*           #      */
	0x00, 0x40, /*          #       */

	/* @704 '_' (6 pixels wide) */
	0x80, 0x00, /* #                */
	0x80, 0x00, /* #                */
	0x80, 0x00, /* #                */
	0x80, 0x00, /* #                */
	0x80, 0x00, /* #                */
	0x80, 0x00, /* #                */

	/* @716 '`' (2 pixels wide) */
	0x00, 0x08, /*             #    */
	0x00, 0x10, /*            #     */

	/* @720 'a' (6 pixels wide) */
	0x0C, 0x80, /*     ##  #        */
	0x12, 0x40, /*    #  #  #       */
	0x12, 0x40, /*    #  #  #       */
	0x12, 0x40, /*    #  #  #       */
	0x0A, 0x40, /*     # #  #       */
	0x1F, 0x80, /*    ######        */

	/* @732 'b' (6 pixels wide) */
	0x1F, 0xF8, /*    ##########    */
	0x18, 0xC0, /*    ##   ##       */
	0x10, 0x40, /*    #     #       */
	0x10, 0x40, /*    #     #       */
	0x18, 0xC0, /*    ##   ##       */
	0x0F, 0x80, /*     #####        */

	/* @744 'c' (5 pixels wide) */
	0x0F, 0x80, /*     #####        */
	0x18, 0xC0, /*    ##   ##       */
	0x10, 0x40, /*    #     #       */
	0x10, 0x40, /*    #     #       */
	0x08, 0x80, /*     #   #        */

	/* @754 'd' (6 pixels wide) */
	0x0F, 0x80, /*     #####        */
	0x18, 0xC0, /*    ##   ##       */
	0x10, 0x40, /*    #     #       */
	0x10, 0x40, /*    #     #       */
	0x18, 0xC0, /*    ##   ##       */
	0x1F, 0xF8, /*    ##########    */

	/* @766 'e' (6 pixels wide) */
	0x0F, 0x80, /*     #####        */
	0x0A, 0xC0, /*     # # ##       */
	0x12, 0x40, /*    #  #  #       */
	0x12, 0x40, /*    #  #  #       */
	0x12, 0xC0, /*    #  # ##       */
	0x0B, 0x80, /*     # ###        */

	/* @778 'f' (4 pixels wide) */
	0x00, 0x40, /*          #       */
	0x1F, 0xF0, /*    #########     */
	0x00, 0x48, /*          #  #    */
	0x00, 0x48, /*          #  #    */

	/* @786 'g' (6 pixels wide) */
	0x0F, 0x80, /*     #####        */
	0x58, 0xC0, /*  # ##   ##       */
	0x90, 0x40, /* #  #     #       */
	0x90, 0x40, /* #  #     #       */
	0xD8, 0xC0, /* ## ##   ##       */
	0x7F, 0xC0, /*  #########       */

	/* @798 'h' (6 pixels wide) */
	0x1F, 0xF8, /*    ##########    */
	0x00, 0x80, /*         #        */
	0x00, 0x40, /*          #       */
	0x00, 0x40, /*          #       */
	0x00, 0x40, /*          #       */
	0x1F, 0x80, /*    ######        */

	/* @810 'i' (1 pixels wide) */
	0x1F, 0xD0, /*    ####### #     */

	/* @812 'j' (2 pixels wide) */
	0x80, 0x00, /* #                */
	0xFF, 0xD0, /* ########## #     */

	/* @816 'k' (5 pixels wide) */
	0x1F, 0xF8, /*    ##########    */
	0x02, 0x00, /*       #          */
	0x05, 0x00, /*      # #         */
	0x08, 0x80, /*     #   #        */
	0x10, 0x40, /*    #     #       */

	/* @826 'l' (1 pixels wide) */
	0x1F, 0xF8, /*    ##########    */

	/* @828 'm' (9 pixels wide) */
	0x1F, 0xC0, /*    #######       */
	0x00, 0x40, /*          #       */
	0x00, 0x40, /*          #       */
	0x00, 0x40, /*          #       */
	0x1F, 0x80, /*    ######        */
	0x00, 0x40, /*          #       */
	0x00, 0x40, /*          #       */
	0x00, 0x40, /*          #       */
	0x1F, 0x80, /*    ######        */

	/* @846 'n' (6 pixels wide) */
	0x1F, 0xC0, /*    #######       */
	0x00, 0x80, /*         #        */
	0x00, 0x40, /*          #       */
	0x00, 0x40, /*          #       */
	0x00, 0x40, /*          #       */
	0x1F, 0x80, /*    ######        */

	/* @858 'o' (6 pixels wide) */
	0x0F, 0x80, /*     #####        */
	0x18, 0xC0, /*    ##   ##       */
	0x10, 0x40, /*    #     #       */
	0x10, 0x40, /*    #     #       */
	0x18, 0xC0, /*    ##   ##       */
	0x0F, 0x80, /*     #####        */

	/* @870 'p' (6 pixels wide) */
	0xFF, 0xC0, /* ##########       */
	0x18, 0xC0, /*    ##   ##       */
	0x10, 0x40, /*    #     #       */
	0x10, 0x40, /*    #     #       */
	0x18, 0xC0, /*    ##   ##       */
	0x0F, 0x80, /*     #####        */

	/* @882 'q' (6 pixels wide) */
	0x0F, 0x80, /*     #####        */
	0x18, 0xC0, /*    ##   ##       */
	0x10, 0x40, /*    #     #       */
	0x10, 0x40, /*    #     #       */
	0x18, 0xC0, /*    ##   ##       */
	0xFF, 0xC0, /* ##########       */

	/* @894 'r' (4 pixels wide) */
	0x1F, 0xC0, /*    #######       */
	0x00, 0x80, /*         #        */
	0x00, 0x40, /*          #       */
	0x00, 0x40, /*          #       */

	/* @902 's' (5 pixels wide) */
	0x09, 0x80, /*     #  ##        */
	0x12, 0x40, /*    #  #  #       */
	0x12, 0x40, /*    #  #  #       */
	0x12, 0x40, /*    #  #  #       */
	0x0C, 0x80, /*     ##  #        */

	/* @912 't' (4 pixels wide) */
	0x00, 0x40, /*          #       */
	0x1F, 0xF0, /*    #########     */
	0x10, 0x40, /*    #     #       */
	0x10, 0x40, /*    #     #       */

	/* @920 'u' (6 pixels wide) */
	0x0F, 0xC0, /*     ######       */
	0x10, 0x00, /*    #             */
	0x10, 0x00, /*    #             */
	0x10, 0x00, /*    #             */
	0x08, 0x00, /*     #            */
	0x1F, 0xC0, /*    #######       */

	/* @932 'v' (6 pixels wide) */
	0x00, 0xC0, /*         ##       */
	0x07, 0x00, /*      ###         */
	0x18, 0x00, /*    ##            */
	0x18, 0x00, /*    ##            */
	0x07, 0x00, /*      ###         */
	0x00, 0xC0, /*         ##       */

	/* @944 'w' (9 pixels wide) */
	0x00, 0xC0, /*         ##       */
	0x07, 0x00, /*      ###         */
	0x18, 0x00, /*    ##            */
	0x07, 0x00, /*      ###         */
	0x00, 0xC0, /*         ##       */
	0x07, 0x00, /*      ###         */
	0x18, 0x00, /*    ##            */
	0x07, 0x00, /*      ###         */
	0x00, 0xC0, /*         ##       */

	/* @962 'x' (6 pixels wide) */
	0x10, 0x40, /*    #     #       */
	0x0D, 0x80, /*     ## ##        */
	0x02, 0x00, /*       #          */
	0x02, 0x00, /*       #          */
	0x0D, 0x80, /*     ## ##        */
	0x10, 0x40, /*    #     #       */

	/* @974 'y' (6 pixels wide) */
	0x80, 0xC0, /* #       ##       */
	0x83, 0x00, /* #     ##         */
	0x4C, 0x00, /*  #  ##           */
	0x38, 0x00, /*   ###            */
	0x07, 0x00, /*      ###         */
	0x00, 0xC0, /*         ##       */

	/* @986 'z' (5 pixels wide) */
	0x18, 0x40, /*    ##    #       */
	0x14, 0x40, /*    # #   #       */
	0x12, 0x40, /*    #  #  #       */
	0x11, 0x40, /*    #   # #       */
	0x10, 0xC0, /*    #    ##       */

	/* @996 '{' (5 pixels wide) */
	0x02, 0x00, /*       #          */
	0x02, 0x00, /*       #          */
	0x7D, 0xF0, /*  ##### #####     */
	0x40, 0x10, /*  #         #     */
	0x40, 0x10, /*  #         #     */

	/* @1006 '|' (1 pixels wide) */
	0xFF, 0xF0, /* ############     */

	/* @1008 '}' (5 pixels wide) */
	0x40, 0x10, /*  #         #     */
	0x40, 0x10, /*  #         #     */
	0x7D, 0xF0, /*  ##### #####     */
	0x02, 0x00, /*       #          */
	0x02, 0x00, /*       #          */

	/* @1018 '~' (8 pixels wide) */
	0x02, 0x00, /*       #          */
	0x01, 0x00, /*        #         */
	0x01, 0x00, /*        #         */
	0x01, 0x00, /*        #         */
	0x02, 0x00, /*       #          */
	0x02, 0x00, /*       #          */
	0x02, 0x00, /*       #          */
	0x01, 0x00, /*        #         */
};

/* Character descriptors for DejaVu Sans 9pt */
const byte _dejaVuSans9ptWidth[] = {
	5, /*   */  1, /* ! */  3, /* " */  8, /* # */  5, /* $ */
	10,/* % */  8, /* & */  1, /* ' */  3, /* ( */  3, /* ) */
	5, /* * */  7, /* + */  1, /* , */  3, /* - */  1, /* . */
	4, /* / */  6, /* 0 */  5, /* 1 */  6, /* 2 */  6, /* 3 */
	6, /* 4 */  6, /* 5 */  6, /* 6 */  6, /* 7 */  6, /* 8 */
	6, /* 9 */  1, /* : */  1, /* ; */  8, /* < */  8, /* = */
	8, /* > */  5, /* ? */  11,/* @ */  8, /* A */  6, /* B */
	6, /* C */  7, /* D */  6, /* E */  5, /* F */  7, /* G */
	7, /* H */  1, /* I */  3, /* J */  6, /* K */  5, /* L */
	8, /* M */  7, /* N */  7, /* O */  6, /* P */  7, /* Q */
	7, /* R */  6, /* S */  7, /* T */  7, /* U */  8, /* V */
	11,/* W */  7, /* X */  7, /* Y */  7, /* Z */  2, /* [ */
	4, /* \ */  2, /* ] */  6, /* ^ */  6, /* _ */  2, /* ` */
	6, /* a */  6, /* b */  5, /* c */  6, /* d */  6, /* e */
	4, /* f */  6, /* g */  6, /* h */  1, /* i */  2, /* j */
	5, /* k */  1, /* l */  9, /* m */  6, /* n */  6, /* o */
	6, /* p */  6, /* q */  4, /* r */  5, /* s */  4, /* t */
	6, /* u */  6, /* v */  9, /* w */  6, /* x */  6, /* y */
	5, /* z */  5, /* { */  1, /* | */  5, /* ) */  8  /* ~ */
};

const uint16 _dejaVuSans9ptOffsets[] = {
	0,    /*   */  10,    /* ! */  12,    /* " */  18,    /* # */  34,    /* $ */
	44,   /* % */  64,    /* & */  80,    /* ' */  82,    /* ( */  88,    /*  */
	94,   /* * */  104,   /* + */  118,   /* , */  120,   /* - */  126,   /* . */
	128,  /* / */  136,   /* 0 */  148,   /* 1 */  158,   /* 2 */  170,   /* 3 */
	182,  /* 4 */  194,   /* 5 */  206,   /* 6 */  218,   /* 7 */  230,   /* 8 */
	242,  /* 9 */  254,   /* : */  256,   /* ; */  258,   /* < */  274,   /* = */
	290,  /* > */  306,   /* ? */  316,   /* @ */  338,   /* A */  354,   /* B */
	366,  /* C */  378,   /* D */  392,   /* E */  404,   /* F */  414,   /* G */
	428,  /* H */  442,   /* I */  444,   /* J */  450,   /* K */  462,   /* L */
	472,  /* M */  488,   /* N */  502,   /* O */  516,   /* P */  528,   /* Q */
	542,  /* R */  556,   /* S */  568,   /* T */  582,   /* U */  596,   /* V */
	612,  /* W */  634,   /* X */  648,   /* Y */  662,   /* Z */  676,   /* [ */
	680,  /* \ */  688,   /* ] */  692,   /* ^ */  704,   /* _ */  716,   /* ` */
	720,  /* a */  732,   /* b */  744,   /* c */  754,   /* d */  766,   /* e */
	778,  /* f */  786,   /* g */  798,   /* h */  810,   /* i */  812,   /* j */
	816,  /* k */  826,   /* l */  828,   /* m */  846,   /* n */  858,   /* o */
	870,  /* p */  882,   /* q */  894,   /* r */  902,   /* s */  912,   /* t */
	920,  /* u */  932,   /* v */  944,   /* w */  962,   /* x */  974,   /* y */
	986,  /* z */  996,   /* { */  1006,  /* | */  1008,  /*  */   1018   /* ~ */
};

} // End of namespace Gnap

#endif // GNAP_RESOURCE_H

