/*-
 * Copyright (c) 2015 Nuxi, https://nuxi.nl/
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/11/sys/compat/cloudabi32/cloudabi32_util.h 304564 2016-08-21 16:01:30Z ed $
 */

#ifndef _CLOUDABI32_UTIL_H_
#define	_CLOUDABI32_UTIL_H_

#include <sys/types.h>
#define	__ELF_WORD_SIZE	32
#include <sys/imgact_elf.h>

#include <contrib/cloudabi/cloudabi32_types.h>

struct image_params;
struct thread;

extern Elf32_Brandinfo cloudabi32_brand;

#define	TO_PTR(x)	((void *)(uintptr_t)(x))

/* Stack initialization during process execution. */
register_t *cloudabi32_copyout_strings(struct image_params *);
int	cloudabi32_fixup(register_t **, struct image_params *);

int	cloudabi32_thread_setregs(struct thread *,
    const cloudabi32_threadattr_t *, uint32_t);

#endif
