/*-
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (c) 2017 J.R. Oldroyd, Open Advisors Limited
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _NET80211_IEEE80211_WPS_H_
#define _NET80211_IEEE80211_WPS_H_

/*
 * 802.11 WPS implementation definitions.
 */

#define IEEE80211_WPS_ATTR_AP_CHANNEL		0x1001
#define IEEE80211_WPS_ATTR_ASSOC_STATE		0x1002
#define IEEE80211_WPS_ATTR_AUTH_TYPE		0x1003
#define IEEE80211_WPS_ATTR_AUTH_TYPE_FLAGS	0x1004
#define IEEE80211_WPS_ATTR_AUTHENTICATOR	0x1005
#define IEEE80211_WPS_ATTR_CONFIG_METHODS	0x1008
#define IEEE80211_WPS_ATTR_CONFIG_ERROR		0x1009
#define IEEE80211_WPS_ATTR_CONFIRM_URL4		0x100a
#define IEEE80211_WPS_ATTR_CONFIRM_URL6		0x100b
#define IEEE80211_WPS_ATTR_CONN_TYPE		0x100c
#define IEEE80211_WPS_ATTR_CONN_TYPE_FLAGS	0x100d
#define IEEE80211_WPS_ATTR_CRED			0x100e
#define IEEE80211_WPS_ATTR_ENCR_TYPE		0x100f
#define IEEE80211_WPS_ATTR_ENCR_TYPE_FLAGS	0x1010
#define IEEE80211_WPS_ATTR_DEV_NAME		0x1011
#define IEEE80211_WPS_ATTR_DEV_PASSWORD_ID	0x1012
#define IEEE80211_WPS_ATTR_E_HASH1		0x1014
#define IEEE80211_WPS_ATTR_E_HASH2		0x1015
#define IEEE80211_WPS_ATTR_E_SNONCE1		0x1016
#define IEEE80211_WPS_ATTR_E_SNONCE2		0x1017
#define IEEE80211_WPS_ATTR_ENCR_SETTINGS	0x1018
#define IEEE80211_WPS_ATTR_ENROLLEE_NONCE	0x101a
#define IEEE80211_WPS_ATTR_FEATURE_ID		0x101b
#define IEEE80211_WPS_ATTR_IDENTITY		0x101c
#define IEEE80211_WPS_ATTR_IDENTITY_PROOF	0x101d
#define IEEE80211_WPS_ATTR_KEY_WRAP_AUTH	0x101e
#define IEEE80211_WPS_ATTR_KEY_ID		0x101f
#define IEEE80211_WPS_ATTR_MAC_ADDR		0x1020
#define IEEE80211_WPS_ATTR_MANUFACTURER		0x1021
#define IEEE80211_WPS_ATTR_MSG_TYPE		0x1022
#define IEEE80211_WPS_ATTR_MODEL_NAME		0x1023
#define IEEE80211_WPS_ATTR_MODEL_NUMBER		0x1024
#define IEEE80211_WPS_ATTR_NETWORK_INDEX	0x1026
#define IEEE80211_WPS_ATTR_NETWORK_KEY		0x1027
#define IEEE80211_WPS_ATTR_NETWORK_KEY_INDEX	0x1028
#define IEEE80211_WPS_ATTR_NEW_DEVICE_NAME	0x1029
#define IEEE80211_WPS_ATTR_NEW_PASSWORD		0x102a
#define IEEE80211_WPS_ATTR_OOB_DEVICE_PASSWORD	0x102c
#define IEEE80211_WPS_ATTR_OS_VERSION		0x102d
#define IEEE80211_WPS_ATTR_POWER_LEVEL		0x102f
#define IEEE80211_WPS_ATTR_PSK_CURRENT		0x1030
#define IEEE80211_WPS_ATTR_PSK_MAX		0x1031
#define IEEE80211_WPS_ATTR_PUBLIC_KEY		0x1032
#define IEEE80211_WPS_ATTR_RADIO_ENABLE		0x1033
#define IEEE80211_WPS_ATTR_REBOOT		0x1034
#define IEEE80211_WPS_ATTR_REGISTRAR_CURRENT	0x1035
#define IEEE80211_WPS_ATTR_REGISTRAR_ESTBLSHD	0x1036
#define IEEE80211_WPS_ATTR_REGISTRAR_LIST	0x1037
#define IEEE80211_WPS_ATTR_REGISTRAR_MAX	0x1038
#define IEEE80211_WPS_ATTR_REGISTRAR_NONCE	0x1039
#define IEEE80211_WPS_ATTR_REQUEST_TYPE		0x103a
#define IEEE80211_WPS_ATTR_RESPONSE_TYPE	0x103b
#define IEEE80211_WPS_ATTR_RF_BANDS		0x103c
#define IEEE80211_WPS_ATTR_R_HASH1		0x103d
#define IEEE80211_WPS_ATTR_R_HASH2		0x103e
#define IEEE80211_WPS_ATTR_R_SNONCE1		0x103f
#define IEEE80211_WPS_ATTR_R_SNONCE2		0x1040
#define IEEE80211_WPS_ATTR_SELECTED_REGISTRAR	0x1041
#define IEEE80211_WPS_ATTR_SERIAL_NUMBER	0x1042
#define IEEE80211_WPS_ATTR_WPS_STATE		0x1044
#define IEEE80211_WPS_ATTR_SSID			0x1045
#define IEEE80211_WPS_ATTR_TOTAL_NETWORKS	0x1046
#define IEEE80211_WPS_ATTR_UUID_E		0x1047
#define IEEE80211_WPS_ATTR_UUID_R		0x1048
#define IEEE80211_WPS_ATTR_VENDOR_EXT		0x1049
#define IEEE80211_WPS_ATTR_VERSION		0x104a
#define IEEE80211_WPS_ATTR_X509_CERT_REQ	0x104b
#define IEEE80211_WPS_ATTR_X509_CERT		0x104c
#define IEEE80211_WPS_ATTR_EAP_IDENTITY		0x104d
#define IEEE80211_WPS_ATTR_MSG_COUNTER		0x104e
#define IEEE80211_WPS_ATTR_PUBKEY_HASH		0x104f
#define IEEE80211_WPS_ATTR_REKEY_KEY		0x1050
#define IEEE80211_WPS_ATTR_KEY_LIFETIME		0x1051
#define IEEE80211_WPS_ATTR_PERMITTED_CONFIG_METHODS	0x1052
#define IEEE80211_WPS_ATTR_SELECTED_REGISTRAR_CONFIG_METHODS	0x1053
#define IEEE80211_WPS_ATTR_PRIMARY_DEV_TYPE	0x1054
#define IEEE80211_WPS_ATTR_SECONDARY_DEV_TYPE_LIST	0x1055
#define IEEE80211_WPS_ATTR_PORTABLE_DEV		0x1056
#define IEEE80211_WPS_ATTR_AP_SETUP_LOCKED	0x1057
#define IEEE80211_WPS_ATTR_APPLICATION_EXT	0x1058
#define IEEE80211_WPS_ATTR_EAP_TYPE		0x1059
#define IEEE80211_WPS_ATTR_IV			0x1060
#define IEEE80211_WPS_ATTR_KEY_PROVIDED_AUTO	0x1061
#define IEEE80211_WPS_ATTR_802_1X_ENABLED	0x1062
#define IEEE80211_WPS_ATTR_AP_SESSION_KEY	0x1063
#define IEEE80211_WPS_ATTR_WEP_TRANSMIT_KEY	0x1064
#define IEEE80211_WPS_ATTR_REQUESTED_DEV_TYPE	0x106a
#define IEEE80211_WPS_ATTR_EXTENSIBILITY_TEST	0x10fa /* _NOT_ defined in the spec */

/* RF bands bitmask */
#define IEEE80211_WPS_RF_BAND_24GHZ		0x01
#define IEEE80211_WPS_RF_BAND_50GHZ		0x02
#define IEEE80211_WPS_RF_BAND_600GHZ		0x04

/* Config methods bitmask */
#define IEEE80211_WPS_CONFIG_USBA		0x0001
#define IEEE80211_WPS_CONFIG_ETHERNET		0x0002
#define IEEE80211_WPS_CONFIG_LABEL		0x0004
#define IEEE80211_WPS_CONFIG_DISPLAY		0x0008
#define IEEE80211_WPS_CONFIG_EXT_NFC_TOKEN	0x0010
#define IEEE80211_WPS_CONFIG_INT_NFC_TOKEN	0x0020
#define IEEE80211_WPS_CONFIG_NFC_INTERFACE	0x0040
#define IEEE80211_WPS_CONFIG_PUSHBUTTON		0x0080
#define IEEE80211_WPS_CONFIG_KEYPAD		0x0100
#define IEEE80211_WPS_CONFIG_VIRT_PUSHBUTTON	0x0200
#define IEEE80211_WPS_CONFIG_PHY_PUSHBUTTON	0x0400
#define IEEE80211_WPS_CONFIG_P2PS		0x1000
#define IEEE80211_WPS_CONFIG_VIRT_DISPLAY	0x2000
#define IEEE80211_WPS_CONFIG_PHY_DISPLAY	0x4000

/* Wi-Fi Protected Setup state */
#define IEEE80211_WPS_STATE_NOT_CONFIGURED	0x01
#define IEEE80211_WPS_STATE_CONFIGURED		0x02
#endif /* _NET80211_IEEE80211_WPS_H_ */
