/*
Copyright (C) 1993 Free Software Foundation

This file is part of the GNU IO Library.  This library is free
software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option)
any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

As a special exception, if you link this library with files
compiled with a GNU compiler to produce an executable, this does not cause
the resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why
the executable file might be covered by the GNU General Public License. */

#include <libioP.h>

_IO_pos_t
_IO_seekoff(fp, offset, flags)
     _IO_FILE* fp;
     _IO_off_t offset;
     _IO_seekflags flags;
{
  int dir = flags & 3;

  /* If we have a backup buffer, get rid of it, since the __seekoff
     callback may not know to do the right thing about it.
     This may be over-kill, but it'll do for now. TODO */

  if (_IO_have_backup (fp))
    {
      if (dir == _IO_seek_cur && _IO_in_backup (fp))
	offset -= fp->_IO_read_end - fp->_IO_read_ptr;
      _IO_free_backup_area (fp);
    }

  return fp->_jumps->__seekoff(fp, offset, flags);
}
