/*
 * Copyright (C) 1998 Specialix International.
 *
 * Download code for SI/XIO/SX host cards.
 *
 * Redistribution and use in binary forms (this file is a binary form),
 * with or without modification, are permitted provided that the following
 * conditions are met:
 * 1. Redistributions in binary form must reproduce the above copyright
 *    notices, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 2. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Specialix International.
 * 3. The name of Specialix International may not be used to endorse or
 *    promote products derived from this software without specific prior
 *    written permission.
 * 4. No attempt is made to decompile, reverse engineer or otherwise
 *    discover the source code of the contents of this file. The source
 *    code is regarded as an unpublished trade secret held by Specialix
 *    International.
 *
 * THIS SOFTWARE IS PROVIDED BY ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHORS BE LIABLE.
 *
 * $FreeBSD: stable/2.2/sys/i386/isa/si3_t225.c 50950 1999-09-05 08:39:22Z peter $
 */

/* SI3_T225.C Version, Bootstrap and Download Code Arrays... */

char *si3_t225_ident = "%W%";

/* SI3_T225 embedded version... 

	Copyright (c) Specialix International Ltd 1996-1998.
	JET.BIN Version 3.0.0 Beta VIII Created Mar 17 1998 @ 16:44:33

*/

unsigned char si3_t225_bootstrap[] =
{
	0x28,0x20,0x21,0x02,0x60,0x0a
};
int si3_t225_bsize = sizeof(si3_t225_bootstrap);

unsigned short si3_t225_bootloadaddr = 0x8000 - sizeof(si3_t225_bootstrap);

unsigned char si3_t225_download[] =
{
	0x00,0x00,0xEC,0x47,0x00,0x00,0x00,0x00,	/* 0000: ..G.... */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 0008: ........ */
	0x24,0xF2,0x21,0xF8,0x24,0xF2,0x21,0xFC,	/* 0010: $!$! */
	0x22,0xF9,0x25,0xF7,0x46,0x23,0xFC,0xD4,	/* 0018: "%F# */
	0x40,0x31,0xD1,0x21,0x20,0x20,0x20,0x40,	/* 0020: @1!   @ */
	0x71,0xF4,0xD2,0x23,0x4B,0xD3,0x73,0x72,	/* 0028: q#Ksr */
	0x71,0x24,0xFA,0x74,0x23,0xFC,0x2F,0x2F,	/* 0030: q$t#.. */
	0x2F,0x4E,0xF6,0x20,0x20,0x22,0x04,0x54,	/* 0038: .N  ".T */
	0x75,0x65,0x20,0x4D,0x61,0x72,0x20,0x31,	/* 0040: ue Mar 1 */
	0x37,0x20,0x31,0x36,0x3A,0x34,0x34,0x3A,	/* 0048: 7 16:44: */
	0x33,0x38,0x20,0x31,0x39,0x39,0x38,0x0A,	/* 0050: 38 1998. */
	0x00,0x6A,0x65,0x74,0x2E,0x65,0x70,0x72,	/* 0058: .jet.epr */
	0x00,0x20,0x20,0x22,0xB0,0x21,0x12,0xDD,	/* 0060: .  "!. */
	0x24,0xF2,0x21,0xF8,0x24,0xF2,0x21,0xFC,	/* 0068: $!$! */
	0x22,0xF9,0x25,0xF8,0x40,0xDE,0x4B,0xDF,	/* 0070: "%@K */
	0x24,0xF2,0x7E,0x24,0xF2,0xFA,0xE0,0x1E,	/* 0078: $~$. */
	0x4B,0x22,0xF1,0x40,0x25,0xF4,0x22,0x46,	/* 0080: K"@%"F */
	0x21,0xFB,0xD0,0x24,0xF2,0xD1,0x24,0x4B,	/* 0088: !$$K */
	0x21,0xFB,0xD2,0x72,0x84,0x21,0xD0,0x72,	/* 0090: !r!r */
	0x30,0x21,0x70,0xF2,0x21,0xD1,0x21,0x71,	/* 0098: 0!p!!q */
	0xD2,0x1B,0xD3,0x7D,0xD4,0x40,0xD5,0x1C,	/* 00A0: .}@. */
	0xD6,0x19,0xD7,0x1A,0xD8,0x21,0x70,0xF6,	/* 00A8: ..!p */
	0x60,0xBC,0x7D,0x27,0x88,0xDD,0x22,0x40,	/* 00B0: `}'"@ */
	0x21,0xFB,0xD0,0x44,0x24,0xF2,0xFA,0xD1,	/* 00B8: !D$ */
	0x24,0xF2,0xD2,0x7B,0x83,0x60,0x4C,0x24,	/* 00C0: ${`L$ */
	0xF6,0x21,0x71,0xF2,0xD3,0x7D,0xD4,0x24,	/* 00C8: !q}$ */
	0xF2,0xD5,0x7A,0x7D,0xF2,0xD6,0x79,0x73,	/* 00D0: z}ys */
	0xF2,0xF6,0x21,0xF5,0x20,0x6E,0x03,0x00,	/* 00D8: ! n.. */
	0x00,0x20,0x61,0xBF,0x40,0xD1,0x40,0xDF,	/* 00E0: . a@@ */
	0x21,0x76,0x67,0x88,0xDE,0x40,0x21,0x74,	/* 00E8: !vg@!t */
	0xE0,0x10,0x23,0x24,0x94,0x28,0x45,0x71,	/* 00F0: .#$(Eq */
	0xF4,0x22,0x2B,0xAD,0x71,0x46,0x24,0xF0,	/* 00F8: "+qF$ */
	0x21,0xD0,0x71,0x23,0x4F,0x24,0xF6,0xD5,	/* 0100: !q#O$ */
	0x21,0x70,0xC0,0x23,0xAF,0x7F,0xA7,0x7D,	/* 0108: !p#} */
	0xD6,0x76,0x75,0xF2,0xDD,0x02,0x7E,0xD6,	/* 0110: vu.~ */
	0x75,0xA6,0x75,0x76,0x10,0x22,0x2F,0x94,	/* 0118: uuv.". */
	0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,	/* 0120: @DAr$ */
	0x74,0x24,0xF6,0x21,0xA7,0x11,0x72,0x21,	/* 0128: t$!.r! */
	0x72,0xFA,0x41,0xFB,0x75,0xAE,0x76,0x27,	/* 0130: rAuv' */
	0x88,0xD0,0x70,0x21,0x75,0xF2,0x72,0x21,	/* 0138: p!ur! */
	0x72,0xFA,0x75,0xFB,0x12,0x22,0x45,0x22,	/* 0140: ru."E" */
	0xF1,0x22,0x26,0x07,0x21,0x70,0xC2,0x22,	/* 0148: "&.!p" */
	0x25,0xA7,0x75,0xC0,0xA7,0x41,0xDF,0x40,	/* 0150: %uA@ */
	0xD4,0x22,0x24,0x0C,0x75,0xC9,0xA7,0x41,	/* 0158: "$.uɧA */
	0xDF,0x40,0xD4,0x22,0x24,0x02,0x75,0xC7,	/* 0160: @"$.u */
	0xA7,0x41,0xDF,0x40,0xD4,0x22,0x23,0x08,	/* 0168: A@"#. */
	0x75,0xC1,0xA7,0x40,0xDF,0x40,0xD4,0x22,	/* 0170: u@@" */
	0x22,0x0E,0x75,0xC2,0x22,0xA7,0x41,0xD0,	/* 0178: ".u"A */
	0x70,0x21,0xAF,0x10,0x22,0x2B,0x92,0x71,	/* 0180: p!."+q */
	0x28,0xC2,0xA4,0x70,0x81,0xD0,0x08,0x71,	/* 0188: (¤p.q */
	0x28,0xC3,0xA4,0x70,0x60,0x8F,0xD0,0x70,	/* 0190: (äp`p */
	0xA7,0x11,0x7C,0x21,0x72,0xFA,0x41,0xFB,	/* 0198: .|!rA */
	0x62,0x0E,0x22,0x20,0x03,0x75,0xC4,0xAC,	/* 01A0: b." .uĬ */
	0x1D,0x10,0x22,0x23,0x9D,0x7D,0x21,0x77,	/* 01A8: .."#}!w */
	0xE0,0x21,0x2F,0x04,0x75,0xC6,0xA9,0x21,	/* 01B0: !..uƩ! */
	0x79,0x10,0x22,0x22,0x9D,0x21,0x2E,0x08,	/* 01B8: y.""!.. */
	0x75,0xCB,0xA9,0x21,0x78,0x10,0x22,0x22,	/* 01C0: u˩!x."" */
	0x91,0x21,0x2D,0x0C,0x75,0xC8,0xAC,0x1D,	/* 01C8: !-.uȬ. */
	0x10,0x22,0x21,0x96,0x7D,0x21,0x78,0xE0,	/* 01D0: ."!}!x */
	0x21,0x2C,0x0D,0x75,0xCA,0xAC,0x1D,0x10,	/* 01D8: !,.uʬ.. */
	0x22,0x20,0x97,0x7D,0x21,0x79,0xE0,0x21,	/* 01E0: " }!y! */
	0x2B,0x0E,0x75,0xCC,0x2C,0xAB,0x40,0xD6,	/* 01E8: +.u,@ */
	0x40,0xDA,0x40,0xD8,0x7E,0xD7,0x41,0xD6,	/* 01F0: @@~A */
	0x10,0x22,0x23,0x9D,0x23,0x4F,0x71,0xF9,	/* 01F8: ."##Oq */
	0xC0,0xD6,0x76,0x22,0xA8,0x41,0x7A,0xF2,	/* 0200: v"Az */
	0xDA,0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,	/* 0208: @DAr$ */
	0xF1,0x74,0x24,0xF6,0xA7,0x11,0x72,0x21,	/* 0210: t$.r! */
	0x72,0xFA,0x41,0xFB,0x12,0x21,0x44,0x22,	/* 0218: rA.!D" */
	0xF1,0x10,0x22,0x21,0x94,0x23,0x4F,0x71,	/* 0220: ."!#Oq */
	0xF9,0xC0,0xD6,0x62,0x05,0x71,0x23,0x4F,	/* 0228: b.q#O */
	0x24,0xF6,0xD5,0x7A,0x40,0xF9,0x23,0xA3,	/* 0230: $z@# */
	0x75,0xA6,0x75,0x77,0x10,0x21,0x2D,0x94,	/* 0238: uuw.!- */
	0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,	/* 0240: @DAr$ */
	0x74,0x24,0xF6,0x21,0xA7,0x11,0x72,0x21,	/* 0248: t$!.r! */
	0x72,0xFA,0x41,0xFB,0x75,0xAE,0x77,0x27,	/* 0250: rAuw' */
	0x88,0xD0,0x70,0x21,0x75,0xF2,0x72,0x21,	/* 0258: p!ur! */
	0x72,0xFA,0x75,0xFB,0x12,0x22,0x45,0x22,	/* 0260: ru."E" */
	0xF1,0x24,0x0C,0x41,0xD6,0x76,0x21,0xAF,	/* 0268: $.Av! */
	0x75,0x77,0x10,0x21,0x29,0x9E,0x77,0x75,	/* 0270: uw.!)wu */
	0xF2,0xD7,0x78,0x75,0xF2,0xD8,0x10,0x21,	/* 0278: xu.! */
	0x2B,0x97,0x23,0x4F,0x71,0xF9,0xD6,0x71,	/* 0280: +#Oqq */
	0x23,0x4F,0x24,0xF6,0xD5,0x62,0x0E,0x40,	/* 0288: #O$b.@ */
	0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,0x74,	/* 0290: DAr$t */
	0x24,0xF6,0x21,0xA6,0x72,0x21,0x72,0xFA,	/* 0298: $!r!r */
	0x78,0xFE,0x78,0xAE,0x7E,0x27,0x88,0xD0,	/* 02A0: xx~' */
	0x70,0x21,0x75,0xF2,0x72,0x21,0x72,0xFA,	/* 02A8: p!ur!r */
	0x78,0xFB,0x12,0x22,0x44,0x22,0xF1,0x2E,	/* 02B0: x."D". */
	0x0F,0x75,0xCD,0x22,0xAC,0x40,0xD6,0x7A,	/* 02B8: .u"@z */
	0xD7,0x77,0x22,0xA1,0x10,0x21,0x27,0x91,	/* 02C0: w".!' */
	0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,	/* 02C8: @DAr$ */
	0x74,0x24,0xF6,0xA7,0x11,0x72,0x21,0x72,	/* 02D0: t$.r!r */
	0xFA,0x41,0xFB,0x12,0x21,0x44,0x22,0xF1,	/* 02D8: A.!D" */
	0x16,0x22,0x41,0x22,0xF1,0x40,0xDA,0x2B,	/* 02E0: ."A"@+ */
	0x0F,0x75,0xCE,0x2B,0xAB,0x40,0xD0,0x40,	/* 02E8: .u+@@ */
	0xD2,0x40,0xD3,0x41,0xD0,0x70,0x22,0xA7,	/* 02F0: @Ap" */
	0x73,0x72,0x46,0x23,0xF6,0xD2,0xD3,0x10,	/* 02F8: srF#. */
	0x21,0x23,0x96,0x71,0x23,0x4F,0x24,0xF6,	/* 0300: !#q#O$ */
	0x21,0xFD,0xD8,0xD9,0x40,0x72,0x78,0x23,	/* 0308: !@rx# */
	0xF7,0xD2,0x73,0x79,0x23,0xF7,0xD3,0x2C,	/* 0310: sy#, */
	0x40,0x71,0xF9,0xC0,0xD0,0x62,0x06,0x28,	/* 0318: @qb.( */
	0x20,0x40,0xD6,0x40,0xD7,0x73,0x77,0xF9,	/* 0320:  @@sw */
	0xC0,0xAB,0x73,0x77,0xF4,0xC0,0xA7,0x41,	/* 0328: swA */
	0x72,0x76,0x24,0xFF,0xF0,0xC0,0x27,0xA0,	/* 0330: rv$' */
	0x73,0x77,0xF9,0xC0,0xAB,0x73,0x77,0xF4,	/* 0338: swsw */
	0xC0,0xA7,0x41,0x72,0x76,0x24,0xFF,0xF0,	/* 0340: Arv$ */
	0xC0,0x25,0xAD,0x40,0x72,0x76,0x24,0xFF,	/* 0348: %@rv$ */
	0xD8,0x73,0x77,0x24,0xFF,0xD9,0x79,0x40,	/* 0350: sw$y@ */
	0xF9,0xC0,0xAC,0x79,0xC0,0xAA,0x41,0x78,	/* 0358: yAx */
	0x27,0x2F,0x2F,0x4F,0x24,0xFF,0xF0,0xC0,	/* 0360: '..O$ */
	0x21,0xAF,0x76,0xD0,0x2F,0x4F,0x70,0x24,	/* 0368: !v.Op$ */
	0xF2,0xF2,0x27,0x2F,0x2F,0x4F,0xF0,0x24,	/* 0370: '..O$ */
	0x94,0x40,0x76,0x27,0x2F,0x2F,0x4F,0x23,	/* 0378: @v'..O# */
	0xF7,0xD6,0x77,0x40,0x23,0xF7,0xD7,0x21,	/* 0380: w@#! */
	0x0D,0x76,0xDB,0x40,0x72,0x76,0x24,0xFF,	/* 0388: .v@rv$ */
	0xD8,0x73,0x77,0x24,0xFF,0xD9,0x78,0xD0,	/* 0390: sw$x */
	0x2F,0x4F,0x7B,0x24,0xF2,0xF2,0x70,0xF0,	/* 0398: .O{$p */
	0x21,0x9B,0x72,0xD6,0x73,0xD7,0x66,0x00,	/* 03A0: !rsf. */
	0x0A,0x75,0xDC,0x41,0x7C,0x24,0xF1,0x74,	/* 03A8: .uA|$t */
	0x24,0xFB,0xD4,0x10,0x28,0x93,0x62,0x23,	/* 03B0: $.(b# */
	0x0C,0x21,0xB1,0x22,0xF0,0x60,0xBE,0x41,	/* 03B8: .!"`A */
	0xD0,0x70,0xD1,0x75,0x73,0x23,0xFB,0x74,	/* 03C0: pus#t */
	0x71,0xF9,0x21,0xAB,0x70,0x74,0x71,0xF4,	/* 03C8: q!ptq */
	0xF9,0xA4,0x74,0x71,0xF4,0xD0,0x73,0x71,	/* 03D0: tqsq */
	0x73,0xF2,0x70,0x24,0xFA,0x71,0x70,0xF2,	/* 03D8: sp$qp */
	0xD1,0x70,0x70,0xF2,0xD0,0x61,0x00,0xB2,	/* 03E0: ppa. */
	0x22,0xF0,0x40,0xD3,0x40,0x72,0xE0,0x41,	/* 03E8: "@@rA */
	0xD3,0x73,0x21,0xAE,0x72,0x30,0x46,0x24,	/* 03F0: s!r0F$ */
	0xF1,0x72,0xE0,0x71,0x23,0x9B,0x71,0x31,	/* 03F8: rq#q1 */
	0x23,0x4F,0x24,0xF6,0x72,0x30,0xF2,0x72,	/* 0400: #O$r0r */
	0xE0,0x2C,0x40,0x71,0x31,0xF9,0xC0,0xD3,	/* 0408: ,@q1 */
	0x62,0x0F,0x22,0xF0,0x60,0xBE,0x74,0x27,	/* 0410: b."`t' */
	0x88,0xD0,0x73,0x21,0x34,0x30,0xD1,0x71,	/* 0418: s!40q */
	0x73,0x21,0x33,0xF2,0x70,0x73,0x21,0x35,	/* 0420: s!3ps!5 */
	0xF2,0x75,0x24,0xFA,0x73,0x21,0x34,0x30,	/* 0428: u$s!40 */
	0x75,0xF5,0x73,0x21,0x34,0xE0,0xB2,0x22,	/* 0430: us!4" */
	0xF0,0x71,0x21,0x34,0x30,0x71,0x21,0x33,	/* 0438: q!40q!3 */
	0xF2,0xF1,0x71,0xE1,0x71,0x21,0x34,0x30,	/* 0440: qq!40 */
	0x81,0x71,0x21,0x34,0xE0,0x22,0xF0,0x8A,	/* 0448: q!4" */
	0xF0,0x0C,0x89,0x3C,0x00,0x00,0x07,0x00,	/* 0450: .<.... */
	0x00,0x08,0x00,0x00,0x00,0x81,0x00,0x80,	/* 0458: ...... */
	0xFF,0x7F,0xFF,0x7F,0xA4,0x8D,0x60,0x8D,	/* 0460: ` */
	0x26,0x8D,0xFF,0x80,0x00,0x00,0x02,0x00,	/* 0468: &.... */
	0x01,0x00,0x6E,0x00,0xA4,0x42,0xA5,0x42,	/* 0470: ..n.BB */
	0x10,0x00,0x06,0x00,0x34,0x81,0x00,0x00,	/* 0478: ....4.. */
	0xFF,0x80,0x00,0x00,0xFF,0x80,0x00,0x00,	/* 0480: .... */
	0xFF,0x80,0xFF,0x80,0x0C,0x8D,0x03,0x00,	/* 0488: ... */
	0x3C,0x02,0x00,0x02,0x00,0x11,0x00,0x5C,	/* 0490: <......\ */
	0x8D,0x02,0x00,0x12,0x00,0x26,0x8D,0x02,	/* 0498: ....&. */
	0x00,0x13,0x00,0xFF,0x80,0x60,0xBC,0x21,	/* 04A0: ...`! */
	0xF5,0x00,0x00,0x00,0x00,0xFA,0x41,0x00,	/* 04A8: ....A. */
	0x00,0x50,0x35,0xC6,0x02,0x06,0x00,0xC6,	/* 04B0: .P5... */
	0x83,0x00,0x00,0xFF,0x80,0x3C,0x01,0xD0,	/* 04B8: ..<. */
	0x83,0x00,0x08,0x0C,0x85,0xFF,0x80,0x0C,	/* 04C0: .... */
	0x8D,0x04,0x00,0x04,0x00,0x20,0x02,0x00,	/* 04C8: .... .. */
	0x11,0x00,0xA0,0x8D,0x02,0x00,0x12,0x00,	/* 04D0: ...... */
	0x60,0x8D,0x02,0x00,0x13,0x00,0xFF,0x80,	/* 04D8: `.... */
	0x02,0x00,0x04,0x00,0x9C,0x8D,0x00,0x00,	/* 04E0: ...... */
	0x00,0x00,0x60,0xBC,0x21,0xF5,0x8A,0x34,	/* 04E8: ..`!4 */
	0x89,0x06,0x5C,0x8D,0x26,0x8D,0xFF,0x80,	/* 04F0: .\& */
	0x8A,0xCB,0x06,0x89,0x06,0xA0,0x8D,0x60,	/* 04F8: ..` */
	0x8D,0xFF,0x80,0x86,0xF0,0x0C,0x8B,0xC4,	/* 0500: . */
	0xC7,0x3A,0x85,0x60,0xBC,0x75,0xD3,0x73,	/* 0508: :`us */
	0x27,0x3B,0x2C,0x48,0xF4,0x75,0x2D,0x96,	/* 0510: ';,Hu- */
	0xA5,0x28,0x4E,0x75,0x2F,0x9A,0x26,0x44,	/* 0518: (Nu.&D */
	0xD0,0x73,0x51,0x73,0x75,0x29,0x91,0xA5,	/* 0520: sQsu) */
	0x28,0x41,0x75,0x2E,0x9B,0x73,0x31,0xD0,	/* 0528: (Au.s1 */
	0x26,0x44,0xD1,0x40,0xD2,0x25,0x24,0x4F,	/* 0530: &D@%$O */
	0x21,0xFB,0x73,0x30,0x75,0x23,0x26,0x22,	/* 0538: !s0u#&" */
	0x9A,0xA5,0x29,0x44,0x75,0x2D,0x91,0x2C,	/* 0540: )Du-, */
	0x48,0xD0,0x73,0x53,0x73,0x52,0x75,0x26,	/* 0548: HsSsRu& */
	0x97,0xA5,0x28,0x45,0x75,0x2C,0x91,0x73,	/* 0550: (Eu,s */
	0x33,0xD0,0x2C,0x48,0xD1,0x40,0xD2,0x25,	/* 0558: 3,H@% */
	0x2B,0x4D,0x21,0xFB,0x73,0x32,0x75,0x23,	/* 0560: +M!s2u# */
	0x26,0x20,0x90,0xA5,0x28,0x45,0x75,0x2A,	/* 0568: & (Eu* */
	0x97,0x75,0x24,0x26,0x91,0x40,0xB4,0x22,	/* 0570: u$&@" */
	0xF0,0x03,0x00,0x02,0x00,0x01,0x00,0x00,	/* 0578: ....... */
	0x00,0xA6,0x00,0x71,0xD2,0x72,0x61,0x4F,	/* 0580: ..qraO */
	0x21,0xFB,0x44,0x23,0x2B,0x2D,0x9A,0x22,	/* 0588: !D#+-" */
	0xF0,0x60,0xBE,0x73,0x58,0xD0,0x41,0x74,	/* 0590: `sXAt */
	0x70,0x60,0x3E,0x24,0xFF,0xF0,0x21,0xA3,	/* 0598: p`>$! */
	0x70,0x30,0x74,0x70,0x30,0xF2,0x70,0xE0,	/* 05A0: p0tp0p */
	0x70,0x60,0x3E,0x74,0xF4,0x70,0x60,0xEE,	/* 05A8: p`>tp` */
	0xB2,0x22,0xF0,0x24,0xF2,0xB2,0x22,0xF0,	/* 05B0: "$" */
	0x60,0xBF,0x75,0xC0,0xA4,0x24,0x20,0x40,	/* 05B8: `u$ @ */
	0xD5,0x21,0x40,0x72,0x63,0x9B,0x73,0xE0,	/* 05C0: !@rcs */
	0x75,0x72,0x63,0x95,0x74,0xE0,0x73,0x30,	/* 05C8: urcts0 */
	0x24,0xF2,0xF4,0x21,0xA5,0x74,0x30,0x24,	/* 05D0: $!t0$ */
	0xF2,0xF4,0xAF,0x75,0xD0,0x2A,0x45,0x74,	/* 05D8: u*Et */
	0x30,0x72,0x23,0x2F,0x2C,0x91,0x40,0xB1,	/* 05E0: 0r#.,@ */
	0x22,0xF0,0x41,0xB1,0x22,0xF0,0x60,0xBE,	/* 05E8: "A"` */
	0x73,0x58,0xD0,0x74,0x73,0x23,0x2D,0x28,	/* 05F0: sXts#-( */
	0x91,0xD1,0x71,0x70,0xE0,0x71,0x24,0xF2,	/* 05F8: qpq$ */
	0xF4,0x21,0xA0,0x74,0x70,0xE1,0x74,0x70,	/* 0600: !tptp */
	0x60,0xEE,0x70,0x31,0x70,0x60,0xEF,0x40,	/* 0608: `p1p`@ */
	0xB2,0x22,0xF0,0x28,0x4E,0xB2,0x22,0xF0,	/* 0610: "(N" */
	0x72,0x21,0x20,0x40,0xE0,0x71,0x23,0x26,	/* 0618: r! @q#& */
	0x2A,0x9C,0x22,0xF0,0x20,0x00,0x00,0x88,	/* 0620: *" .. */
	0x00,0x71,0x58,0xD2,0x72,0x60,0x44,0x21,	/* 0628: .qXr`D! */
	0xFB,0x41,0x23,0x2B,0x23,0x93,0x22,0xF0,	/* 0630: A#+#" */
	0x20,0x43,0x6F,0x70,0x79,0x72,0x69,0x67,	/* 0638:  Copyrig */
	0x68,0x74,0x20,0x28,0x63,0x29,0x20,0x53,	/* 0640: ht (c) S */
	0x70,0x65,0x63,0x69,0x61,0x6C,0x69,0x78,	/* 0648: pecialix */
	0x20,0x49,0x6E,0x74,0x65,0x72,0x6E,0x61,	/* 0650:  Interna */
	0x74,0x69,0x6F,0x6E,0x61,0x6C,0x20,0x4C,	/* 0658: tional L */
	0x74,0x64,0x20,0x31,0x39,0x39,0x36,0x2D,	/* 0660: td 1996- */
	0x31,0x39,0x39,0x38,0x2E,0x0D,0x0A,0x4A,	/* 0668: 1998...J */
	0x45,0x54,0x2E,0x42,0x49,0x4E,0x20,0x56,	/* 0670: ET.BIN V */
	0x65,0x72,0x73,0x69,0x6F,0x6E,0x20,0x33,	/* 0678: ersion 3 */
	0x2E,0x30,0x2E,0x30,0x20,0x42,0x65,0x74,	/* 0680: .0.0 Bet */
	0x61,0x20,0x56,0x49,0x49,0x49,0x20,0x43,	/* 0688: a VIII C */
	0x72,0x65,0x61,0x74,0x65,0x64,0x20,0x4D,	/* 0690: reated M */
	0x61,0x72,0x20,0x31,0x37,0x20,0x31,0x39,	/* 0698: ar 17 19 */
	0x39,0x38,0x20,0x40,0x20,0x31,0x36,0x3A,	/* 06A0: 98 @ 16: */
	0x34,0x34,0x3A,0x33,0x33,0x00,0x03,0xC8,	/* 06A8: 44:33.. */
	0x03,0x71,0x5A,0xD2,0x60,0x46,0x21,0xFB,	/* 06B0: .qZ`F! */
	0x72,0x81,0x41,0x24,0xFA,0x68,0x48,0x21,	/* 06B8: rA$hH! */
	0xFB,0x72,0xE1,0x22,0xF0,0x61,0xBD,0x21,	/* 06C0: r"a! */
	0x74,0x5C,0xD9,0x40,0xDA,0x40,0xD8,0x28,	/* 06C8: t\@@( */
	0x40,0xD7,0x28,0x40,0xD2,0x40,0xD6,0x76,	/* 06D0: @(@@v */
	0x47,0x24,0xF1,0x27,0x20,0x20,0x40,0xFA,	/* 06D8: G$'  @ */
	0xD4,0x40,0xD3,0x40,0xD1,0x71,0x44,0x24,	/* 06E0: @@qD$ */
	0xF1,0x76,0x47,0x24,0xF1,0x27,0x20,0x20,	/* 06E8: vG$'   */
	0x40,0xFA,0xFA,0x3D,0x2A,0x40,0x24,0xF6,	/* 06F0: @=*@$ */
	0x2A,0x40,0xF4,0xC0,0xAE,0x71,0x41,0xF2,	/* 06F8: *@qA */
	0xD1,0x41,0x44,0x71,0x24,0xFF,0xF0,0xC0,	/* 0700: ADq$ */
	0xAB,0x62,0x0A,0x41,0xD8,0x41,0xD3,0x7A,	/* 0708: b.AAz */
	0x41,0xF4,0x27,0xAB,0x73,0xC0,0x21,0xA2,	/* 0710: A's! */
	0x74,0x31,0x2F,0x4F,0x24,0xF6,0x2F,0x4F,	/* 0718: t1.O$.O */
	0xF4,0x27,0xA8,0x41,0xDA,0x78,0x41,0xF4,	/* 0720: 'AxA */
	0x26,0xAB,0x76,0x21,0xA7,0x72,0x51,0xF1,	/* 0728: &v!rQ */
	0x21,0x28,0x40,0xF8,0x77,0x28,0x50,0xFA,	/* 0730: !(@w(P */
	0xD7,0x77,0x67,0x20,0x20,0x40,0x24,0xFB,	/* 0738: wg  @$ */
	0x72,0xE0,0x77,0xD2,0x76,0x47,0x24,0xF1,	/* 0740: rwvG$ */
	0x27,0x20,0x20,0x40,0xFA,0xD4,0x40,0x72,	/* 0748: '  @@r */
	0xE0,0x76,0x72,0x83,0x23,0xFB,0x74,0x72,	/* 0750: vr#tr */
	0xE3,0x78,0x2B,0xA5,0x48,0x72,0x51,0x23,	/* 0758: x+HrQ# */
	0xFB,0x40,0x74,0x27,0xEF,0x40,0x74,0x26,	/* 0760: @t'@t& */
	0xE8,0x40,0x74,0x21,0xE8,0x44,0x74,0x27,	/* 0768: @t!Dt' */
	0xEF,0x40,0x74,0x26,0xE8,0x25,0x45,0x74,	/* 0770: @t&%Et */
	0x21,0xE8,0x40,0x74,0x27,0xEF,0x74,0x21,	/* 0778: !@t't! */
	0x38,0x2F,0x4F,0x24,0xF6,0x25,0x45,0xF4,	/* 0780: 8.O$%E */
	0x22,0xAF,0x22,0x48,0xD1,0x22,0x0D,0x2F,	/* 0788: ""H".. */
	0x4F,0x21,0xB3,0x22,0xF0,0x2F,0x4F,0x21,	/* 0790: O!".O! */
	0xB3,0x22,0xF0,0x78,0xC0,0xA4,0x20,0x7A,	/* 0798: "x z */
	0x21,0xA1,0x67,0x21,0x2E,0x40,0x70,0xE0,	/* 07A0: !g!.@p */
	0x21,0x28,0x40,0x70,0x21,0xE7,0x41,0x21,	/* 07A8: !(@p!A! */
	0xB3,0x22,0xF0,0x2F,0x4F,0x21,0xB3,0x22,	/* 07B0: ".O!" */
	0xF0,0x24,0x48,0xD1,0x71,0x72,0x54,0x23,	/* 07B8: $HqrT# */
	0xFB,0x74,0x27,0x3F,0x2F,0x4F,0x24,0xF6,	/* 07C0: t'?.O$ */
	0x72,0x5F,0x23,0xFB,0x74,0x24,0x30,0x2F,	/* 07C8: r_#t$0. */
	0x4F,0x24,0xF6,0x72,0x21,0x8F,0x23,0xFB,	/* 07D0: O$r!# */
	0x44,0x74,0x27,0xEF,0x74,0x24,0x30,0x2F,	/* 07D8: Dt't$0. */
	0x4F,0x24,0xF6,0x72,0x21,0x50,0x23,0xFB,	/* 07E0: O$r!P# */
	0x72,0x54,0xF1,0x24,0x48,0xF4,0xA8,0x79,	/* 07E8: rT$Hy */
	0x32,0x41,0xF2,0x79,0xE2,0x21,0x02,0x74,	/* 07F0: 2Ay!.t */
	0x23,0x39,0x43,0x24,0xF6,0x81,0x72,0x22,	/* 07F8: #9C$r" */
	0x81,0x23,0xFB,0x79,0x33,0x41,0xF2,0x79,	/* 0800: #y3Ay */
	0xE3,0x74,0x21,0x74,0x2F,0x20,0x9C,0x24,	/* 0808: t!t. $ */
	0x0E,0x74,0x24,0x30,0x2F,0x4F,0x24,0xF6,	/* 0810: .t$0.O$ */
	0xD1,0x79,0x31,0x41,0xF2,0x79,0xE1,0x71,	/* 0818: y1Ayq */
	0x41,0x24,0xF6,0x21,0xA8,0x71,0x2A,0x4B,	/* 0820: A$!q*K */
	0xF4,0xA5,0x20,0x44,0xD1,0x03,0x20,0x4A,	/* 0828:  D. J */
	0xD1,0x71,0x72,0x54,0x23,0xFB,0x44,0x72,	/* 0830: qrT#Dr */
	0x51,0x23,0xFB,0x21,0x06,0x71,0x2A,0x4A,	/* 0838: Q#!.q*J */
	0xF4,0xA5,0x20,0x48,0xD1,0x03,0x20,0x4B,	/* 0840:  H. K */
	0xD1,0x71,0x72,0x54,0x23,0xFB,0x48,0x72,	/* 0848: qrT#Hr */
	0x51,0x23,0xFB,0x2F,0x4F,0x74,0x6F,0x40,	/* 0850: Q#.Oto@ */
	0x24,0xF6,0x28,0x40,0x24,0xFB,0xE0,0x77,	/* 0858: $(@$w */
	0x28,0x50,0xD3,0x76,0xAF,0x73,0x23,0x50,	/* 0860: (Pvs#P */
	0x67,0x20,0x20,0x40,0x24,0xFB,0x70,0xE0,	/* 0868: g  @$p */
	0x73,0x70,0x21,0xE7,0x40,0xD1,0x41,0x72,	/* 0870: sp!@Ar */
	0x51,0xF1,0x40,0x24,0xFF,0xF0,0xC0,0x21,	/* 0878: Q@$! */
	0x23,0xA4,0x73,0xD0,0x70,0x71,0x72,0x55,	/* 0880: #spqrU */
	0xFA,0xE0,0x72,0x54,0xF1,0x70,0x53,0x23,	/* 0888: rTpS# */
	0xFB,0x21,0x40,0x70,0x57,0x23,0xFB,0x41,	/* 0890: !@pW#A */
	0x70,0x21,0x8F,0x23,0xFB,0x71,0x70,0x87,	/* 0898: p!#qp */
	0x23,0xFB,0x2F,0x4F,0x70,0x21,0x51,0x23,	/* 08A0: #.Op!Q# */
	0xFB,0x78,0x25,0xAF,0x21,0x2A,0x4C,0x21,	/* 08A8: x%!*L! */
	0xFB,0x1B,0x21,0x40,0x24,0xFA,0x74,0x70,	/* 08B0: .!@$tp */
	0xE1,0x41,0x71,0x43,0x24,0xFF,0xF0,0xA8,	/* 08B8: AqC$ */
	0x74,0x27,0x3F,0x4F,0x24,0xF6,0xD5,0x0B,	/* 08C0: t'?O$. */
	0x74,0x27,0x3F,0x2F,0x4F,0x24,0xF6,0x44,	/* 08C8: t'?.O$D */
	0x24,0xF0,0xD5,0x75,0x2F,0x4F,0x24,0xF6,	/* 08D0: $u.O$ */
	0xD5,0x75,0x70,0x21,0x52,0x23,0xFB,0x75,	/* 08D8: up!R#u */
	0x1B,0xF2,0xF1,0x70,0x21,0x53,0x23,0xFB,	/* 08E0: .p!S# */
	0x75,0x47,0x24,0xF6,0x45,0xF4,0xC0,0xAD,	/* 08E8: uG$E */
	0x71,0xA5,0x71,0x44,0xF4,0xC0,0xA6,0x41,	/* 08F0: qqDA */
	0x70,0x22,0x87,0x23,0xFB,0x4B,0x70,0x21,	/* 08F8: p"#Kp! */
	0x5B,0x23,0xFB,0x4B,0x70,0x23,0x87,0x23,	/* 0900: [#Kp## */
	0xFB,0x27,0x0D,0x21,0x25,0x4D,0x21,0xFB,	/* 0908: '.!%M! */
	0x1B,0x48,0x24,0xFA,0x72,0x54,0xF1,0x48,	/* 0910: .H$rTH */
	0xF4,0x21,0xAD,0x72,0x54,0xF1,0x4B,0xF4,	/* 0918: !rTK */
	0x21,0xA6,0x71,0x1B,0xFA,0x30,0x48,0xF8,	/* 0920: !q.0H */
	0x74,0xFA,0x70,0xE1,0x41,0x71,0x1B,0xFA,	/* 0928: tpAq. */
	0x30,0x24,0xF1,0x70,0x8F,0x23,0xFB,0x0F,	/* 0930: 0$p#. */
	0x71,0x48,0xF8,0x74,0xFA,0x70,0xE1,0x41,	/* 0938: qHtpA */
	0x71,0x24,0xF1,0x70,0x8F,0x23,0xFB,0x71,	/* 0940: q$p#q */
	0x41,0x24,0xF6,0xC0,0xAE,0x72,0x54,0xF1,	/* 0948: A$rT */
	0x44,0xF4,0xA8,0x72,0x54,0xF1,0x4A,0xF4,	/* 0950: DrTJ */
	0xC0,0x22,0xAD,0x70,0x31,0xD5,0x2E,0x40,	/* 0958: "p1.@ */
	0x75,0x61,0x4F,0x24,0xF6,0xE4,0x40,0x75,	/* 0960: uaO$@u */
	0x61,0x4F,0x24,0xF6,0xE5,0x40,0x75,0x61,	/* 0968: aO$@ua */
	0x4F,0x24,0xF6,0xE6,0x42,0x75,0x61,0x4F,	/* 0970: O$BuaO */
	0x24,0xF6,0xE7,0x75,0x61,0x4F,0x24,0xF6,	/* 0978: $uaO$ */
	0x3E,0x40,0x75,0x61,0x4F,0x24,0xF6,0xED,	/* 0980: >@uaO$ */
	0x77,0x67,0x20,0x20,0x40,0x24,0xFB,0x70,	/* 0988: wg  @$p */
	0xE2,0x73,0x21,0x28,0x50,0xD3,0x73,0x23,	/* 0990: s!(Ps# */
	0x50,0x67,0x20,0x20,0x40,0x24,0xFB,0x70,	/* 0998: Pg  @$p */
	0xE0,0x73,0x70,0x21,0xE7,0x71,0x41,0xF2,	/* 09A0: sp!qA */
	0xD1,0x41,0x72,0x51,0xF1,0x71,0x24,0xFF,	/* 09A8: ArQq$ */
	0xF0,0xC0,0xA3,0x61,0x2C,0x0C,0x76,0x41,	/* 09B0: a,.vA */
	0xF2,0xD6,0x41,0x44,0x76,0x24,0xFF,0xF0,	/* 09B8: ADv$ */
	0xC0,0xA3,0x62,0x21,0x02,0x67,0x21,0x2E,	/* 09C0: b!.g!. */
	0x40,0x70,0xE0,0x21,0x28,0x40,0x70,0x21,	/* 09C8: @p!(@p! */
	0xE7,0x41,0x21,0xB3,0x22,0xF0,0x60,0xBE,	/* 09D0: A!"` */
	0x73,0x5C,0xD1,0x40,0x71,0xE0,0x27,0x20,	/* 09D8: s\@q'  */
	0x20,0x40,0xD0,0x40,0x40,0x73,0x23,0x2B,	/* 09E0:  @@@s#+ */
	0x2B,0x9D,0x21,0x20,0x40,0xD0,0x40,0x27,	/* 09E8: +! @@' */
	0x2E,0x20,0x40,0x73,0x23,0x2B,0x2A,0x9F,	/* 09F0: . @s#+* */
	0x24,0x40,0x71,0x30,0x81,0x23,0xFB,0x71,	/* 09F8: $@q0#q */
	0x60,0x3E,0x71,0x30,0xE2,0x26,0x44,0x71,	/* 0A00: `>q0&Dq */
	0x30,0xE1,0x73,0x63,0x2B,0x97,0x71,0x30,	/* 0A08: 0sc+q0 */
	0x23,0xFB,0x71,0x30,0xF1,0x41,0xF4,0xC0,	/* 0A10: #q0A */
	0x23,0xA7,0x71,0x60,0x34,0x73,0x23,0x2C,	/* 0A18: #q`4s#, */
	0x26,0x9F,0x28,0x40,0x54,0xF1,0x2F,0x40,	/* 0A20: &(@T.@ */
	0x24,0xF6,0x21,0xAA,0x41,0x71,0x33,0x40,	/* 0A28: $!Aq3@ */
	0x24,0xFF,0xF0,0xC0,0xA4,0x71,0x32,0x21,	/* 0A30: $q2! */
	0xA3,0x71,0x60,0x36,0x73,0x23,0x2C,0x23,	/* 0A38: q`6s#,# */
	0x92,0x73,0x2D,0x27,0x90,0x0B,0x73,0x22,	/* 0A40: s-'.s" */
	0x2A,0x20,0x9C,0x05,0x73,0x21,0x2D,0x2A,	/* 0A48: * .s!-* */
	0x9E,0x21,0x20,0x40,0x30,0x41,0xF2,0x21,	/* 0A50: ! @0A! */
	0x20,0x40,0xE0,0x60,0x04,0xF0,0xD0,0x00,	/* 0A58:  @`.. */
	0xF0,0x00,0xC0,0x00,0x00,0xF0,0xD0,0x00,	/* 0A60: .... */
	0xF0,0x00,0xC0,0x00,0x00,0x00,0x00,0x03,	/* 0A68: ...... */
	0x00,0x04,0x00,0x07,0x00,0x00,0x00,0xE4,	/* 0A70: ....... */
	0x1C,0x71,0x5C,0xD2,0x72,0x60,0x44,0x21,	/* 0A78: .q\r`D! */
	0xFB,0x41,0x23,0x26,0x2E,0x93,0x22,0xF0,	/* 0A80: A#&." */
	0x20,0x60,0xBC,0x75,0x21,0x50,0xD1,0x71,	/* 0A88:  `u!Pq */
	0x60,0x3C,0x35,0x41,0xF2,0x71,0x60,0x3C,	/* 0A90: `<5Aq`< */
	0xE5,0x71,0x60,0x3C,0x31,0x21,0xA1,0x40,	/* 0A98: q`<1!@ */
	0x23,0x2D,0x20,0x49,0x71,0x60,0x3C,0x31,	/* 0AA0: #- Iq`<1 */
	0x21,0xFA,0x75,0x23,0x22,0x21,0x95,0x07,	/* 0AA8: !u#"!. */
	0x29,0x4C,0x75,0x23,0x22,0x20,0x9D,0x21,	/* 0AB0: )Lu#" ! */
	0x28,0x40,0xD0,0x70,0x53,0xF1,0x2F,0x40,	/* 0AB8: (@pS.@ */
	0x24,0xF6,0xC0,0x23,0xA3,0x70,0x57,0xF1,	/* 0AC0: $#pW */
	0xC0,0x22,0xA1,0x70,0x34,0x22,0x20,0x20,	/* 0AC8: "p4"   */
	0x40,0x24,0xF6,0x21,0xA7,0x70,0x5C,0xF1,	/* 0AD0: @$!p\ */
	0xD3,0x70,0x75,0x22,0x26,0x2D,0x94,0xD2,	/* 0AD8: pu"&- */
	0x72,0x73,0xF4,0xA8,0x72,0x70,0x5C,0x23,	/* 0AE0: rsrp\# */
	0xFB,0x41,0x71,0xE1,0x70,0x21,0x37,0xD0,	/* 0AE8: Aqp!7 */
	0x70,0x21,0x28,0x40,0xF4,0xA2,0x63,0x0D,	/* 0AF0: p!(@c. */
	0x71,0x31,0x71,0x32,0x24,0xFB,0x67,0xAF,	/* 0AF8: q1q2$g */
	0x41,0x71,0x60,0x3C,0xE4,0x71,0x31,0x27,	/* 0B00: Aq`<q1' */
	0x2C,0x28,0x40,0xE0,0x71,0x60,0x3C,0x56,	/* 0B08: ,(@q`<V */
	0xF1,0x81,0x71,0x60,0x3C,0x56,0x23,0xFB,	/* 0B10: q`<V# */
	0x40,0x71,0xE1,0x40,0x71,0xE2,0x69,0x0F,	/* 0B18: @q@qi. */
	0x20,0x60,0xB0,0x21,0x71,0x21,0x53,0xD9,	/* 0B20:  `!q!S */
	0x28,0x40,0xD3,0x40,0xD2,0x24,0xF2,0x58,	/* 0B28: (@@$X */
	0x21,0x71,0x22,0x2F,0x2B,0x9D,0x79,0x60,	/* 0B30: !q".+y` */
	0x39,0x53,0xF1,0x81,0x79,0x60,0x39,0x53,	/* 0B38: 9Sy`9S */
	0x23,0xFB,0x73,0xDA,0x72,0xDF,0x73,0x33,	/* 0B40: #srs3 */
	0xD1,0x72,0x44,0xF8,0x71,0x27,0xEF,0x71,	/* 0B48: rDq'q */
	0x26,0x37,0x2F,0x4F,0x24,0xF6,0xD5,0x75,	/* 0B50: &7.O$u */
	0x41,0x24,0xF6,0x24,0x2F,0xA4,0x71,0x26,	/* 0B58: A$$.q& */
	0x3B,0x2F,0x4F,0x24,0xF6,0xD4,0x71,0x26,	/* 0B60: ;.O$q& */
	0x38,0x2F,0x4F,0x24,0xF6,0xD7,0x74,0x43,	/* 0B68: 8.O$tC */
	0x24,0xF6,0x71,0x26,0xE8,0x71,0x24,0x33,	/* 0B70: $q&q$3 */
	0x47,0x24,0xF6,0xD0,0x70,0x43,0xF4,0x26,	/* 0B78: G$pC& */
	0xAB,0x70,0x47,0xF4,0xC0,0x24,0x2C,0xAA,	/* 0B80: pG$, */
	0x72,0x23,0xF4,0x74,0x43,0x24,0xF6,0xFA,	/* 0B88: r#tC$ */
	0x73,0x55,0xFA,0x30,0xD6,0x71,0x26,0x32,	/* 0B90: sU0q&2 */
	0x2F,0x4F,0x24,0xF6,0xD0,0x70,0x48,0x24,	/* 0B98: .O$pH$ */
	0xF6,0x21,0xA0,0x76,0x21,0x89,0xF1,0x41,	/* 0BA0: !v!A */
	0x24,0xFB,0x76,0x21,0x89,0x23,0xFB,0x41,	/* 0BA8: $v!#A */
	0x79,0x60,0xEE,0x70,0x41,0x24,0xF6,0xA8,	/* 0BB0: y`pA$ */
	0x76,0x21,0x3E,0x41,0xF2,0x76,0x21,0xEE,	/* 0BB8: v!>Av! */
	0x70,0x42,0x24,0xF6,0xA8,0x76,0x21,0x3C,	/* 0BC0: pB$v!< */
	0x41,0xF2,0x76,0x21,0xEC,0x70,0x44,0x24,	/* 0BC8: Av!pD$ */
	0xF6,0xA8,0x76,0x21,0x3D,0x41,0xF2,0x76,	/* 0BD0: v!=Av */
	0x21,0xED,0x71,0x26,0x32,0x74,0x23,0x4F,	/* 0BD8: !q&2t#O */
	0x24,0xF6,0x71,0x26,0xEB,0x77,0x71,0x26,	/* 0BE0: $q&wq& */
	0xE8,0x24,0x26,0x06,0x72,0x23,0xF4,0x74,	/* 0BE8: $&.r#t */
	0x43,0x24,0xF6,0xFA,0x73,0x55,0xFA,0x30,	/* 0BF0: C$sU0 */
	0xD6,0x76,0x22,0x87,0xF1,0xC0,0xAC,0x76,	/* 0BF8: v"v */
	0x21,0x54,0xF1,0x41,0x24,0xFB,0x76,0x21,	/* 0C00: !TA$v! */
	0x54,0x23,0xFB,0x76,0x55,0xF1,0xDB,0x76,	/* 0C08: T#vUv */
	0x8B,0xF1,0xDD,0x76,0x34,0xDE,0x7D,0x7B,	/* 0C10: v4}{ */
	0x41,0xF2,0xF4,0x2F,0x4F,0x24,0xF6,0xDC,	/* 0C18: A.O$ */
	0x41,0x79,0x60,0xEF,0x71,0x3E,0x2F,0x4F,	/* 0C20: Ay`q>.O */
	0x24,0xF6,0xD0,0x41,0x7C,0x70,0x24,0xFF,	/* 0C28: $A|p$ */
	0xF0,0xA3,0x7C,0xD8,0x02,0x70,0xD8,0x78,	/* 0C30: |.px */
	0x23,0x25,0xAC,0x70,0x78,0xF4,0xD0,0x78,	/* 0C38: #%pxx */
	0x41,0xF4,0xD8,0x41,0x22,0x40,0x78,0x24,	/* 0C40: AA"@x$ */
	0xFF,0xF0,0xC0,0x23,0x24,0xA4,0x78,0x44,	/* 0C48: #$xD */
	0xF8,0x42,0x21,0xFB,0xF2,0xF6,0x23,0x22,	/* 0C50: B!#" */
	0x03,0x20,0x23,0x20,0x09,0x20,0x22,0x2E,	/* 0C58: . # . ". */
	0x0F,0x20,0x22,0x2D,0x05,0x20,0x22,0x2B,	/* 0C60: . "-. "+ */
	0x0B,0x20,0x22,0x2A,0x01,0x20,0x22,0x28,	/* 0C68: . "*. "( */
	0x07,0x20,0x22,0x26,0x0D,0x20,0x22,0x25,	/* 0C70: . "&. "% */
	0x03,0x20,0x22,0x23,0x09,0x20,0x22,0x21,	/* 0C78: . "#. "! */
	0x0F,0x20,0x22,0x20,0x05,0x20,0x21,0x2E,	/* 0C80: . " . !. */
	0x0B,0x20,0x21,0x2D,0x01,0x20,0x21,0x2B,	/* 0C88: . !-. !+ */
	0x07,0x20,0x21,0x29,0x0D,0x20,0x21,0x28,	/* 0C90: . !). !( */
	0x03,0x20,0x21,0x26,0x09,0x20,0x21,0x24,	/* 0C98: . !&. !$ */
	0x0F,0x20,0x21,0x23,0x05,0x20,0x21,0x21,	/* 0CA0: . !#. !! */
	0x0B,0x20,0x21,0x20,0x01,0x20,0x2E,0x08,	/* 0CA8: . ! . .. */
	0x20,0x20,0x2C,0x0E,0x20,0x20,0x2B,0x04,	/* 0CB0:   ,.  +. */
	0x20,0x20,0x29,0x0A,0x20,0x20,0x28,0x00,	/* 0CB8:   ).  (. */
	0x20,0x20,0x26,0x06,0x20,0x20,0x24,0x0C,	/* 0CC0:   &.  $. */
	0x20,0x20,0x23,0x02,0x20,0x20,0x21,0x08,	/* 0CC8:   #.  !. */
	0x20,0x20,0x71,0x26,0x32,0x2F,0x4F,0x24,	/* 0CD0:   q&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 0CD8: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 0CE0: P#{A */
	0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 0CE8: q&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,	/* 0CF0: .O$v+P */
	0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,	/* 0CF8: #{Aq& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 0D00: 2.O${.O */
	0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,	/* 0D08: $v+P# */
	0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,	/* 0D10: {Aq&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 0D18: O${.O$ */
	0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,	/* 0D20: v+P#{A */
	0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,	/* 0D28: q&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 0D30: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 0D38: P#{A */
	0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 0D40: q&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,	/* 0D48: .O$v+P */
	0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,	/* 0D50: #{Aq& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 0D58: 2.O${.O */
	0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,	/* 0D60: $v+P# */
	0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,	/* 0D68: {Aq&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 0D70: O${.O$ */
	0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,	/* 0D78: v+P#{A */
	0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,	/* 0D80: q&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 0D88: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 0D90: P#{A */
	0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 0D98: q&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,	/* 0DA0: .O$v+P */
	0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,	/* 0DA8: #{Aq& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 0DB0: 2.O${.O */
	0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,	/* 0DB8: $v+P# */
	0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,	/* 0DC0: {Aq&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 0DC8: O${.O$ */
	0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,	/* 0DD0: v+P#{A */
	0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,	/* 0DD8: q&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 0DE0: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 0DE8: P#{A */
	0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 0DF0: q&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,	/* 0DF8: .O$v+P */
	0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,	/* 0E00: #{Aq& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 0E08: 2.O${.O */
	0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,	/* 0E10: $v+P# */
	0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,	/* 0E18: {Aq&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 0E20: O${.O$ */
	0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,	/* 0E28: v+P#{A */
	0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,	/* 0E30: q&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 0E38: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 0E40: P#{A */
	0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 0E48: q&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,	/* 0E50: .O$v+P */
	0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,	/* 0E58: #{Aq& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 0E60: 2.O${.O */
	0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,	/* 0E68: $v+P# */
	0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,	/* 0E70: {Aq&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 0E78: O${.O$ */
	0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,	/* 0E80: v+P#{A */
	0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,	/* 0E88: q&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 0E90: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 0E98: P#{A */
	0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 0EA0: q&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,	/* 0EA8: .O$v+P */
	0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,	/* 0EB0: #{Aq& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 0EB8: 2.O${.O */
	0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,	/* 0EC0: $v+P# */
	0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,	/* 0EC8: {Aq&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 0ED0: O${.O$ */
	0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,	/* 0ED8: v+P#{A */
	0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,	/* 0EE0: q&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 0EE8: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 0EF0: P#{A */
	0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 0EF8: q&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,	/* 0F00: .O$v+P */
	0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,	/* 0F08: #{Aq& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 0F10: 2.O${.O */
	0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,	/* 0F18: $v+P# */
	0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,	/* 0F20: {Aq&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 0F28: O${.O$ */
	0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,	/* 0F30: v+P#{A */
	0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,	/* 0F38: q&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 0F40: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 0F48: P#{A */
	0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 0F50: q&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,	/* 0F58: .O$v+P */
	0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,	/* 0F60: #{Aq& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 0F68: 2.O${.O */
	0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,	/* 0F70: $v+P# */
	0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,	/* 0F78: {Aq&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 0F80: O${.O$ */
	0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,	/* 0F88: v+P#{A */
	0xF2,0xDB,0x7B,0x76,0x55,0x23,0xFB,0x70,	/* 0F90: {vU#p */
	0x76,0x21,0x3F,0xF2,0x76,0x21,0xEF,0x70,	/* 0F98: v!?v!p */
	0xD8,0x78,0x60,0x4F,0xF2,0xD0,0x78,0xAF,	/* 0FA0: x`Ox */
	0x71,0x26,0x32,0x70,0xD8,0x78,0x60,0x4F,	/* 0FA8: q&2px`O */
	0xF2,0xD0,0x78,0xA3,0x20,0x60,0x01,0x7D,	/* 0FB0: x `.} */
	0x7B,0x41,0xF2,0xF4,0x2F,0x4F,0x24,0xF6,	/* 0FB8: {A.O$ */
	0xD0,0x7E,0x48,0x24,0xF6,0x27,0xAC,0x41,	/* 0FC0: ~H$'A */
	0x7C,0x23,0x4F,0x24,0xFF,0xF0,0xC0,0x27,	/* 0FC8: |#O$' */
	0xA2,0x41,0x24,0x40,0x70,0x24,0xFF,0xF0,	/* 0FD0: A$@p$ */
	0xC0,0x26,0xA8,0x7E,0x21,0x40,0x24,0xFB,	/* 0FD8: &~!@$ */
	0xDE,0x76,0x21,0x58,0xF1,0x48,0x24,0xF6,	/* 0FE0: v!XH$ */
	0x22,0xAD,0x7E,0x22,0x40,0x24,0xF6,0xC0,	/* 0FE8: "~"@$ */
	0x22,0xA5,0x71,0x35,0x2F,0x4F,0x24,0xF6,	/* 0FF0: "q5.O$ */
	0xA8,0x7E,0x2C,0x40,0x24,0xFB,0xDE,0x21,	/* 0FF8: ~,@$! */
	0x06,0x40,0xD0,0x21,0x20,0x40,0x76,0x21,	/* 1000: .@! @v! */
	0x71,0x21,0x23,0x26,0x9C,0x22,0x42,0x71,	/* 1008: q!#&"Bq */
	0xE5,0x7E,0x22,0x40,0x24,0xFB,0xDE,0x76,	/* 1010: ~"@$v */
	0x23,0x81,0xF1,0x28,0x40,0x24,0xF6,0xAD,	/* 1018: #(@$ */
	0x40,0xD0,0x21,0x20,0x20,0x40,0x76,0x21,	/* 1020: @!  @v! */
	0x71,0x21,0x23,0x24,0x9C,0x76,0x21,0x58,	/* 1028: q!#$v!X */
	0xF1,0x24,0x40,0x24,0xF6,0xAD,0x40,0xD0,	/* 1030: $@$@ */
	0x22,0x20,0x20,0x40,0x76,0x21,0x71,0x21,	/* 1038: "  @v!q! */
	0x23,0x23,0x96,0x74,0x23,0x4F,0x24,0xF6,	/* 1040: ##t#O$ */
	0x71,0x26,0xEB,0x77,0x71,0x26,0xE8,0x7E,	/* 1048: q&wq&~ */
	0x76,0xE4,0x75,0x42,0x24,0xF6,0x24,0x20,	/* 1050: vuB$$  */
	0xAF,0x71,0x26,0x3A,0x2F,0x4F,0x24,0xF6,	/* 1058: q&:.O$ */
	0xD4,0x71,0x26,0x38,0x2F,0x4F,0x24,0xF6,	/* 1060: q&8.O$ */
	0xD7,0x74,0x43,0x24,0xF6,0x71,0x26,0xE8,	/* 1068: tC$q& */
	0x72,0x23,0xF4,0x74,0x43,0x24,0xF6,0xFA,	/* 1070: r#tC$ */
	0x73,0x55,0xFA,0x30,0xD0,0x70,0x22,0x87,	/* 1078: sU0p" */
	0xF1,0xC0,0xAC,0x70,0x21,0x54,0xF1,0x42,	/* 1080: p!TB */
	0x24,0xFB,0x70,0x21,0x54,0x23,0xFB,0x70,	/* 1088: $p!T#p */
	0x23,0x85,0xF1,0xAC,0x70,0x21,0x71,0x24,	/* 1090: #p!q$ */
	0x26,0x9B,0x70,0x34,0xD6,0x23,0x2B,0x09,	/* 1098: &p4#+. */
	0x70,0x8D,0xF1,0xDD,0x70,0x56,0xF1,0xD8,	/* 10A0: ppV */
	0x70,0x34,0xD6,0x76,0x21,0x20,0x40,0x24,	/* 10A8: p4v! @$ */
	0xF6,0x21,0xA8,0x76,0x61,0x2F,0x4F,0x24,	/* 10B0: !va.O$ */
	0xF6,0x22,0x20,0x40,0x24,0xFB,0x60,0x4E,	/* 10B8: " @$`N */
	0x24,0xF6,0xD6,0x71,0x36,0x2F,0x49,0x24,	/* 10C0: $q6.I$ */
	0xF6,0x71,0xE6,0x7D,0x78,0xF4,0x2F,0x4F,	/* 10C8: q}x.O */
	0x24,0xF6,0xDC,0x7C,0x23,0x27,0xA4,0x70,	/* 10D0: $|#'p */
	0x53,0xF1,0x24,0x48,0xF4,0xA3,0x4C,0xDB,	/* 10D8: S$HL */
	0x03,0x22,0x40,0xDB,0x41,0x7C,0x7B,0x24,	/* 10E0: ."@A|{$ */
	0xFF,0xF0,0xA4,0x7C,0xDB,0x01,0x20,0x76,	/* 10E8: |. v */
	0x24,0x20,0x40,0x24,0xF6,0x24,0xA9,0x7B,	/* 10F0: $ @$${ */
	0x22,0x2F,0xA8,0x70,0x23,0x50,0x78,0x2F,	/* 10F8: ".p#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x4A,0xF4,0x21,	/* 1100: O$J! */
	0xA8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 1108: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 1110: q&xA */
	0xF2,0xD8,0x7B,0x60,0x4F,0xF2,0xDB,0x21,	/* 1118: {`O! */
	0x09,0x41,0x42,0x7B,0x24,0xFF,0xF0,0x22,	/* 1120: .AB{$" */
	0x2C,0xA9,0x4D,0x71,0x26,0xE3,0x4A,0x71,	/* 1128: ,Mq&Jq */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x7B,0x42,	/* 1130: &xA{B */
	0xF4,0xDB,0x7B,0x22,0x2B,0xA5,0x64,0x0B,	/* 1138: {"+d. */
	0x7B,0x41,0xF4,0xDB,0x41,0x22,0x40,0x7B,	/* 1140: {AA"@{ */
	0x24,0xFF,0xF0,0xC0,0x22,0x2A,0xA4,0x7B,	/* 1148: $"*{ */
	0x44,0xF8,0x42,0x21,0xFB,0xF2,0xF6,0x22,	/* 1150: DB!" */
	0x28,0x08,0x20,0x22,0x27,0x03,0x20,0x22,	/* 1158: (. "'. " */
	0x25,0x0E,0x20,0x22,0x24,0x09,0x20,0x22,	/* 1160: %. "$. " */
	0x23,0x04,0x20,0x22,0x21,0x0F,0x20,0x22,	/* 1168: #. "!. " */
	0x20,0x0A,0x20,0x21,0x2F,0x05,0x20,0x21,	/* 1170:  . !.. ! */
	0x2E,0x00,0x20,0x21,0x2C,0x0B,0x20,0x21,	/* 1178: .. !,. ! */
	0x2B,0x06,0x20,0x21,0x2A,0x01,0x20,0x21,	/* 1180: +. !*. ! */
	0x28,0x0C,0x20,0x21,0x27,0x07,0x20,0x21,	/* 1188: (. !'. ! */
	0x26,0x02,0x20,0x21,0x24,0x0D,0x20,0x21,	/* 1190: &. !$. ! */
	0x23,0x08,0x20,0x21,0x22,0x03,0x20,0x21,	/* 1198: #. !". ! */
	0x20,0x0E,0x20,0x2F,0x0A,0x20,0x20,0x2E,	/* 11A0:  . ..  . */
	0x05,0x20,0x20,0x2D,0x00,0x20,0x20,0x2B,	/* 11A8: .  -.  + */
	0x0B,0x20,0x20,0x2A,0x06,0x20,0x20,0x29,	/* 11B0: .  *.  ) */
	0x01,0x20,0x20,0x27,0x0C,0x20,0x20,0x26,	/* 11B8: .  '.  & */
	0x07,0x20,0x20,0x25,0x02,0x20,0x20,0x23,	/* 11C0: .  %.  # */
	0x0D,0x20,0x20,0x22,0x08,0x20,0x20,0x21,	/* 11C8: .  ".  ! */
	0x03,0x20,0x20,0x70,0x23,0x50,0x78,0x2F,	/* 11D0: .  p#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 11D8: O$q& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 11E0: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,	/* 11E8: .O$q& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 11F0: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 11F8: x.O$q */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 1200: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 1208: Px.O$ */
	0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 1210: q&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 1218: #Px.O$ */
	0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 1220: q&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 1228: p#Px.O$ */
	0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,	/* 1230: q&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 1238: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 1240: q&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 1248: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,	/* 1250: $q&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 1258: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 1260: O$q& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 1268: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,	/* 1270: .O$q& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 1278: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 1280: x.O$q */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 1288: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 1290: Px.O$ */
	0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 1298: q&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 12A0: #Px.O$ */
	0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 12A8: q&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 12B0: p#Px.O$ */
	0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,	/* 12B8: q&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 12C0: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 12C8: q&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 12D0: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,	/* 12D8: $q&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 12E0: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 12E8: O$q& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 12F0: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,	/* 12F8: .O$q& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 1300: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 1308: x.O$q */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 1310: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 1318: Px.O$ */
	0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 1320: q&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 1328: #Px.O$ */
	0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 1330: q&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 1338: p#Px.O$ */
	0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,	/* 1340: q&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 1348: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 1350: q&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 1358: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,	/* 1360: $q&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 1368: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 1370: O$q& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 1378: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,	/* 1380: .O$q& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 1388: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 1390: x.O$q */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 1398: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 13A0: Px.O$ */
	0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 13A8: q&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 13B0: #Px.O$ */
	0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 13B8: q&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 13C0: p#Px.O$ */
	0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,	/* 13C8: q&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 13D0: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 13D8: q&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 13E0: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,	/* 13E8: $q&x */
	0x41,0xF2,0xD8,0x7D,0x78,0x2F,0x4F,0x24,	/* 13F0: A}x.O$ */
	0xF6,0xF4,0x2F,0x4F,0x24,0xF6,0xDB,0x78,	/* 13F8: .O$x */
	0x2F,0x4F,0x24,0xF6,0x70,0x56,0x23,0xFB,	/* 1400: .O$pV# */
	0x41,0x7C,0x2C,0x40,0x24,0xFF,0xF0,0xC0,	/* 1408: A|,@$ */
	0xA9,0x41,0x2C,0x41,0x7B,0x24,0xFF,0xF0,	/* 1410: A,A{$ */
	0x22,0xA9,0x41,0x7C,0x24,0x40,0x24,0xFF,	/* 1418: "A|$@$ */
	0xF0,0xC0,0x23,0xA5,0x41,0x24,0x41,0x7B,	/* 1420: #A$A{ */
	0x24,0xFF,0xF0,0xC0,0x22,0xAB,0x76,0x28,	/* 1428: $"v( */
	0x20,0x40,0x24,0xF6,0x22,0xA3,0x76,0x68,	/* 1430:  @$"vh */
	0x2F,0x4F,0x24,0xF6,0xD6,0x41,0x79,0x60,	/* 1438: .O$Ay` */
	0xEE,0x21,0x06,0x76,0x28,0x20,0x40,0x24,	/* 1440: !.v( @$ */
	0xFB,0xD6,0x0E,0x76,0x60,0x4E,0x24,0xF6,	/* 1448: .v`N$ */
	0xD6,0x71,0x36,0x2F,0x49,0x24,0xF6,0x71,	/* 1450: q6.I$q */
	0xE6,0x74,0x23,0x4F,0x24,0xF6,0x71,0x26,	/* 1458: t#O$q& */
	0xEA,0x77,0x71,0x26,0xE8,0x76,0x70,0xE4,	/* 1460: wq&vp */
	0x75,0x44,0x24,0xF6,0x25,0xA8,0x71,0x26,	/* 1468: uD$%q& */
	0x39,0x2F,0x4F,0x24,0xF6,0xD4,0x71,0x26,	/* 1470: 9.O$q& */
	0x38,0x2F,0x4F,0x24,0xF6,0xD7,0x74,0x43,	/* 1478: 8.O$tC */
	0x24,0xF6,0x71,0x26,0xE8,0x72,0x23,0xF4,	/* 1480: $q&r# */
	0x74,0x43,0x24,0xF6,0xFA,0x73,0x55,0xFA,	/* 1488: tC$sU */
	0x30,0xD0,0x70,0x21,0x71,0x22,0x21,0x9B,	/* 1490: 0p!q"! */
	0x70,0x22,0x87,0xF1,0xC0,0xAC,0x70,0x21,	/* 1498: p"p! */
	0x54,0xF1,0x44,0x24,0xFB,0x70,0x21,0x54,	/* 14A0: TD$p!T */
	0x23,0xFB,0x41,0x79,0x60,0xEE,0x70,0x21,	/* 14A8: #Ay`p! */
	0x89,0xF1,0x42,0x24,0xFB,0x70,0x21,0x89,	/* 14B0: B$p! */
	0x23,0xFB,0x74,0x23,0x4F,0x24,0xF6,0x71,	/* 14B8: #t#O$q */
	0x26,0xE9,0x77,0x71,0x26,0xE8,0x73,0x89,	/* 14C0: &wq&s */
	0xF1,0x71,0x27,0xEF,0x72,0x41,0xF2,0xD2,	/* 14C8: q'rA */
	0x41,0x72,0x41,0x24,0xFF,0xF0,0xC0,0x21,	/* 14D0: ArA$! */
	0xA2,0x40,0xD2,0x73,0x30,0xAA,0x73,0x30,	/* 14D8: @s0s0 */
	0x27,0x2F,0x2F,0x4F,0x24,0xF6,0xD3,0x03,	/* 14E0: '..O$. */
	0x28,0x40,0xD3,0x75,0xC0,0xAE,0x73,0x7A,	/* 14E8: (@usz */
	0xF4,0xC0,0x69,0x25,0xA1,0x72,0x7F,0xF4,	/* 14F0: i%r */
	0xA3,0x69,0x24,0x0A,0x40,0x27,0x28,0x20,	/* 14F8: i$.@'(  */
	0x40,0xE0,0x69,0x22,0x08,0x60,0xBE,0x74,	/* 1500: @i".`t */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x33,	/* 1508: 2'..O$3 */
	0xD1,0x74,0x23,0x85,0xF1,0xD0,0x43,0x70,	/* 1510: t#Cp */
	0xF9,0x21,0xA0,0x70,0x2B,0xAD,0x70,0x41,	/* 1518: !p+pA */
	0xF4,0x21,0xAA,0x70,0x42,0xF4,0xC0,0x2B,	/* 1520: !pB+ */
	0xA2,0x23,0x0A,0x70,0x43,0xF4,0x2A,0xAB,	/* 1528: #.pC* */
	0x70,0x44,0xF4,0x25,0xAA,0x70,0x45,0xF4,	/* 1530: pD%pE */
	0xC0,0x2A,0xA0,0x27,0x0A,0x71,0x35,0x2F,	/* 1538: *'.q5. */
	0x4F,0x24,0xF6,0xC0,0x29,0xA5,0x71,0x39,	/* 1540: O$)q9 */
	0x22,0x40,0x24,0xF6,0xC0,0x21,0xA0,0x71,	/* 1548: "@$!q */
	0x39,0x2F,0x4F,0x24,0xF6,0x22,0x40,0x24,	/* 1550: 9.O$"@$ */
	0xFB,0x71,0xE9,0x24,0x4E,0x71,0xE5,0x42,	/* 1558: q$NqB */
	0x74,0x23,0x85,0x23,0xFB,0x71,0x35,0x2F,	/* 1560: t##q5. */
	0x4F,0x24,0xF6,0xC0,0x26,0xAD,0x40,0x71,	/* 1568: O$&@q */
	0x26,0xE3,0x28,0x41,0x71,0x26,0xE3,0x74,	/* 1570: &(Aq&t */
	0x34,0x60,0x4E,0x24,0xF6,0x74,0xE4,0x71,	/* 1578: 4`N$tq */
	0x36,0x2F,0x49,0x24,0xF6,0x71,0xE6,0x43,	/* 1580: 6.I$qC */
	0x74,0x23,0x85,0x23,0xFB,0x24,0x0C,0x71,	/* 1588: t##$.q */
	0x35,0x2F,0x4F,0x24,0xF6,0xC0,0x24,0xA3,	/* 1590: 5.O$$ */
	0x71,0x39,0x22,0x40,0x24,0xF6,0xC0,0x21,	/* 1598: q9"@$! */
	0xA0,0x71,0x39,0x2F,0x4F,0x24,0xF6,0x22,	/* 15A0: q9.O$" */
	0x40,0x24,0xFB,0x71,0xE9,0x24,0x4E,0x71,	/* 15A8: @$q$Nq */
	0xE5,0x45,0x74,0x23,0x85,0x23,0xFB,0x71,	/* 15B0: Et##q */
	0x35,0x2F,0x4F,0x24,0xF6,0xC0,0x21,0xAB,	/* 15B8: 5.O$! */
	0x40,0x71,0x26,0xE3,0x28,0x43,0x71,0x26,	/* 15C0: @q&(Cq& */
	0xE3,0x71,0x39,0x2D,0x4F,0x24,0xF6,0x71,	/* 15C8: q9-O$q */
	0xE9,0x24,0x4E,0x71,0xE5,0x40,0x74,0x23,	/* 15D0: $Nq@t# */
	0x85,0x23,0xFB,0xB2,0x22,0xF0,0x20,0x60,	/* 15D8: #" ` */
	0xBF,0x41,0x73,0x26,0xE6,0x43,0x73,0x26,	/* 15E0: As&Cs& */
	0xE8,0x40,0x73,0x27,0xE4,0x42,0x73,0x26,	/* 15E8: @s'Bs& */
	0xE8,0x40,0x73,0x27,0xE4,0x41,0x73,0x26,	/* 15F0: @s'As& */
	0xE8,0x40,0x73,0x27,0xE4,0x40,0x73,0x26,	/* 15F8: @s'@s& */
	0xE8,0x40,0x73,0x27,0xE4,0x43,0x73,0x26,	/* 1600: @s'Cs& */
	0xE8,0x40,0x73,0x27,0xEA,0x42,0x73,0x26,	/* 1608: @s'Bs& */
	0xE8,0x40,0x73,0x27,0xEA,0x41,0x73,0x26,	/* 1610: @s'As& */
	0xE8,0x40,0x73,0x27,0xEA,0x40,0x73,0x26,	/* 1618: @s'@s& */
	0xE8,0x40,0x73,0x27,0xEA,0x44,0x73,0x26,	/* 1620: @s'Ds& */
	0xE8,0x2A,0x48,0x73,0x26,0xED,0x40,0x73,	/* 1628: *Hs&@s */
	0x26,0xEE,0x40,0x73,0x26,0xEF,0x41,0x73,	/* 1630: &@s&As */
	0x26,0xEC,0x43,0x73,0x26,0xE6,0x43,0x73,	/* 1638: &Cs&Cs */
	0x26,0xE6,0x43,0x73,0x26,0xE6,0x44,0x73,	/* 1640: &Cs&Ds */
	0x26,0xE8,0x2A,0x48,0x73,0x26,0xED,0x22,	/* 1648: &*Hs&" */
	0x40,0x73,0x26,0xEE,0x40,0x73,0x26,0xEF,	/* 1650: @s&@s& */
	0x43,0x73,0x26,0xE6,0x43,0x73,0x26,0xE6,	/* 1658: Cs&Cs& */
	0x43,0x73,0x26,0xE6,0x40,0x73,0x26,0xEC,	/* 1660: Cs&@s& */
	0x40,0xD0,0x43,0x73,0x26,0xE6,0x70,0x81,	/* 1668: @Cs&p */
	0xD0,0x21,0x40,0x70,0xF9,0xA2,0x60,0x02,	/* 1670: !@p`. */
	0x44,0x73,0x26,0xE8,0x40,0x73,0x26,0xED,	/* 1678: Ds&@s& */
	0x22,0x40,0x73,0x26,0xEE,0x43,0x73,0x26,	/* 1680: "@s&Cs& */
	0xEF,0x41,0x73,0x26,0xEC,0x43,0x73,0x26,	/* 1688: As&Cs& */
	0xE6,0x43,0x73,0x26,0xE6,0x43,0x73,0x26,	/* 1690: Cs&Cs& */
	0xE6,0x43,0x73,0x26,0xE6,0x40,0x73,0x26,	/* 1698: Cs&@s& */
	0xEC,0x40,0x73,0x26,0xE6,0x40,0x73,0x26,	/* 16A0: @s&@s& */
	0xE8,0x26,0x44,0x72,0x22,0x26,0x21,0x94,	/* 16A8: &Dr"&! */
	0xB1,0x22,0xF0,0x60,0xBE,0x40,0xD0,0x74,	/* 16B0: "`@t */
	0x31,0xD1,0x74,0x87,0xF1,0x74,0x32,0x27,	/* 16B8: 1tt2' */
	0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,	/* 16C0: ..O$# */
	0x74,0x87,0xF1,0x71,0x27,0xEF,0x74,0x87,	/* 16C8: tq't */
	0xF1,0x43,0x24,0xF6,0x71,0x26,0xE8,0x71,	/* 16D0: C$q&q */
	0x26,0x3C,0x2F,0x4F,0x24,0xF6,0x74,0x21,	/* 16D8: &<.O$t! */
	0x53,0xF1,0x24,0xF6,0xD1,0x71,0x28,0x40,	/* 16E0: S$q(@ */
	0x24,0xF6,0xA5,0x70,0x44,0x24,0xFB,0xD0,	/* 16E8: $pD$ */
	0x71,0x22,0x40,0x24,0xF6,0xA6,0x70,0x24,	/* 16F0: q"@$p$ */
	0x40,0x24,0xFB,0xD0,0x71,0x21,0x40,0x24,	/* 16F8: @$q!@$ */
	0xF6,0xA6,0x70,0x22,0x40,0x24,0xFB,0xD0,	/* 1700: p"@$ */
	0x71,0x24,0x40,0x24,0xF6,0xA5,0x70,0x42,	/* 1708: q$@$pB */
	0x24,0xFB,0xD0,0x70,0x74,0x5C,0x23,0xFB,	/* 1710: $pt\# */
	0xB2,0x22,0xF0,0x60,0xBD,0x40,0xD1,0x71,	/* 1718: "`@q */
	0x44,0xF8,0x75,0x27,0xEF,0x71,0x74,0x61,	/* 1720: Du'qta */
	0x2B,0x95,0x71,0xAF,0x75,0x27,0x3F,0x2F,	/* 1728: +qu'?. */
	0x4F,0x24,0xF6,0x44,0x24,0xF0,0xD2,0x75,	/* 1730: O$D$u */
	0x27,0x3F,0x0A,0x75,0x27,0x3F,0x47,0x24,	/* 1738: '?.u'?G$ */
	0xF6,0xD2,0x75,0x27,0x3F,0x72,0x45,0xF4,	/* 1740: u'?rE */
	0xA5,0x40,0x75,0x24,0xEB,0x05,0x28,0x40,	/* 1748: @u$.(@ */
	0x75,0x24,0xEB,0x2C,0x43,0x75,0x27,0xEE,	/* 1750: u$,Cu' */
	0x40,0xD0,0x70,0x75,0x26,0xE8,0x70,0xC0,	/* 1758: @pu&p */
	0x22,0xA0,0x72,0x45,0xF4,0xC0,0x21,0xAA,	/* 1760: "rE! */
	0x40,0x75,0x27,0xE6,0x24,0x44,0x75,0x24,	/* 1768: @u'$Du$ */
	0x30,0x2F,0x4F,0x24,0xF6,0xF9,0xA6,0x24,	/* 1770: 0.O$$ */
	0x42,0x75,0x27,0xE2,0x05,0x21,0x4F,0x75,	/* 1778: Bu'.!Ou */
	0x27,0xE2,0x70,0x81,0xD0,0x44,0x70,0xF9,	/* 1780: 'pDp */
	0xA3,0x20,0x63,0x0E,0x40,0x75,0x21,0xE8,	/* 1788:  c.@u! */
	0x40,0x75,0x26,0xEC,0x40,0x75,0x26,0xED,	/* 1790: @u&@u& */
	0x75,0x35,0x2F,0x4F,0x24,0xF6,0xAA,0x75,	/* 1798: u5.O$u */
	0x35,0x2F,0x4F,0x24,0xF6,0xA3,0x20,0x60,	/* 17A0: 5.O$ ` */
	0x06,0x71,0x81,0xD1,0x42,0x71,0xF9,0xA2,	/* 17A8: .qBq */
	0x69,0x0D,0xB3,0x22,0xF0,0x60,0xBB,0x76,	/* 17B0: i."`v */
	0x21,0x53,0xD3,0x21,0x28,0x40,0xD1,0x41,	/* 17B8: !S!(@A */
	0x27,0x28,0x28,0x40,0xE0,0x73,0x60,0x39,	/* 17C0: '((@s`9 */
	0x87,0xF1,0x81,0x73,0x60,0x39,0x87,0x23,	/* 17C8: s`9# */
	0xFB,0x41,0x27,0x28,0x28,0x40,0xE0,0x71,	/* 17D0: A'((@q */
	0x21,0x37,0xD1,0x40,0x27,0x28,0x28,0x40,	/* 17D8: !7@'((@ */
	0xE0,0x71,0x57,0xF1,0xD0,0x70,0xAC,0x70,	/* 17E0: qWpp */
	0x73,0xFA,0x30,0xD2,0x71,0x76,0x2E,0x28,	/* 17E8: s0qv.( */
	0x9F,0x62,0xA2,0x71,0x31,0xD4,0x71,0x34,	/* 17F0: bq1q4 */
	0xD2,0x70,0xC0,0x24,0xA6,0x72,0x41,0x24,	/* 17F8: p$rA$ */
	0xF6,0xC0,0x23,0xAF,0x71,0x8D,0xF1,0x71,	/* 1800: #qq */
	0x56,0xF1,0xF4,0x23,0xA6,0x72,0x41,0x24,	/* 1808: V#rA$ */
	0xFB,0xD2,0x72,0x71,0xE4,0x71,0x87,0xF1,	/* 1810: rqq */
	0x71,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 1818: q2'..O$ */
	0x89,0x23,0xFB,0x71,0x87,0xF1,0x74,0x27,	/* 1820: #qt' */
	0xEF,0x71,0x87,0xF1,0x43,0x24,0xF6,0x74,	/* 1828: qC$t */
	0x26,0xE8,0x74,0x36,0x2F,0x4F,0x24,0xF6,	/* 1830: &t6.O$ */
	0x44,0x24,0xFB,0x74,0xE6,0x41,0x71,0x22,	/* 1838: D$tAq" */
	0x89,0x23,0xFB,0x72,0x21,0x40,0x24,0xF6,	/* 1840: #r!@$ */
	0x2D,0xA8,0x72,0x28,0x40,0x24,0xF6,0x24,	/* 1848: -r(@$$ */
	0xA0,0x71,0x87,0xF1,0x71,0x32,0x27,0x2F,	/* 1850: qq2'. */
	0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,0x71,	/* 1858: .O$#q */
	0x87,0xF1,0x74,0x27,0xEF,0x71,0x87,0xF1,	/* 1860: t'q */
	0x43,0x24,0xF6,0x74,0x26,0xE8,0x74,0x35,	/* 1868: C$t&t5 */
	0x2F,0x4F,0x24,0xF6,0xC0,0x2A,0xA8,0x40,	/* 1870: .O$*@ */
	0xD0,0x21,0x20,0x40,0x71,0x76,0x2A,0x2F,	/* 1878: ! @qv*. */
	0x98,0x22,0x42,0x74,0xE5,0x72,0x22,0x40,	/* 1880: "Btr"@ */
	0x24,0xFB,0x6C,0x4F,0x24,0xF6,0xD2,0x28,	/* 1888: $lO$( */
	0x0E,0x41,0x71,0x55,0xF1,0x71,0x8B,0xF1,	/* 1890: .AqUq */
	0xFC,0x2F,0x4F,0x24,0xF6,0x24,0x40,0xF0,	/* 1898: .O$$@ */
	0x24,0xFF,0xF0,0xC0,0x27,0xA9,0x71,0x87,	/* 18A0: $'q */
	0xF1,0x71,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 18A8: q2'..O$ */
	0xF6,0x89,0x23,0xFB,0x71,0x87,0xF1,0x74,	/* 18B0: #qt */
	0x27,0xEF,0x71,0x87,0xF1,0x43,0x24,0xF6,	/* 18B8: 'qC$ */
	0x74,0x26,0xE8,0x74,0x35,0x2F,0x4F,0x24,	/* 18C0: t&t5.O$ */
	0xF6,0xC0,0x25,0xA3,0x71,0x21,0x58,0xF1,	/* 18C8: %q!X */
	0x48,0x24,0xF6,0x21,0xA6,0x21,0x20,0x40,	/* 18D0: H$!! @ */
	0xD0,0x21,0x20,0x40,0x71,0x76,0x2A,0x29,	/* 18D8: ! @qv*) */
	0x98,0x22,0x41,0x74,0xE5,0x72,0x66,0x4F,	/* 18E0: "AtrfO */
	0x24,0xF6,0xD2,0x71,0x23,0x81,0xF1,0x28,	/* 18E8: $q#( */
	0x40,0x24,0xF6,0xAE,0x21,0x20,0x20,0x40,	/* 18F0: @$!  @ */
	0xD0,0x21,0x20,0x20,0x40,0x71,0x76,0x2A,	/* 18F8: !  @qv* */
	0x27,0x97,0x71,0x21,0x58,0xF1,0x24,0x40,	/* 1900: 'q!X$@ */
	0x24,0xF6,0xAE,0x22,0x20,0x20,0x40,0xD0,	/* 1908: $"  @ */
	0x22,0x20,0x20,0x40,0x71,0x76,0x2A,0x26,	/* 1910: "  @qv*& */
	0x90,0x72,0x61,0x4F,0x24,0xF6,0xD2,0x72,	/* 1918: raO$r */
	0x71,0xE4,0x61,0x2A,0x00,0x60,0xBB,0x77,	/* 1920: qa*.`w */
	0x31,0xD1,0x77,0x34,0xD2,0x77,0x87,0xF1,	/* 1928: 1w4w */
	0x77,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 1930: w2'..O$ */
	0x89,0x23,0xFB,0x77,0x87,0xF1,0x71,0x27,	/* 1938: #wq' */
	0xEF,0x77,0x87,0xF1,0x43,0x24,0xF6,0x71,	/* 1940: wC$q */
	0x26,0xE8,0x77,0x21,0x8F,0xF1,0x23,0xA4,	/* 1948: &w!# */
	0x77,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 1950: w2'..O$ */
	0xD0,0x77,0x87,0xF1,0x43,0xF9,0x21,0xA0,	/* 1958: wC! */
	0x70,0x21,0x8D,0xF1,0x81,0x70,0x21,0x8D,	/* 1960: p!p! */
	0x23,0xFB,0x22,0x44,0x71,0x27,0xEF,0x0C,	/* 1968: #"Dq'. */
	0x70,0x5E,0xF1,0x81,0x70,0x5E,0x23,0xFB,	/* 1970: p^p^# */
	0x48,0x71,0x27,0xEF,0x40,0x77,0x21,0x8F,	/* 1978: Hq'@w! */
	0x23,0xFB,0x23,0x06,0x77,0x21,0x58,0xF1,	/* 1980: ##.w!X */
	0x42,0x24,0xF6,0xA8,0x71,0x3B,0x44,0x24,	/* 1988: B$q;D$ */
	0xF6,0xC0,0x21,0xAF,0x77,0x21,0x59,0xF1,	/* 1990: !w!Y */
	0x21,0x40,0x24,0xF6,0xA8,0x71,0x26,0x3C,	/* 1998: !@$q&< */
	0x24,0x40,0x24,0xF6,0xAE,0x72,0x22,0x20,	/* 19A0: $@$r"  */
	0x40,0x24,0xF6,0xC0,0xA6,0x77,0x22,0x85,	/* 19A8: @$w" */
	0xF1,0x21,0xA3,0x72,0x62,0x2F,0x4F,0x24,	/* 19B0: !rb.O$ */
	0xF6,0xD2,0x71,0x35,0x2F,0x4F,0x24,0xF6,	/* 19B8: q5.O$ */
	0x22,0xA3,0x40,0xB5,0x22,0xF0,0x72,0x21,	/* 19C0: "@"r! */
	0x20,0x40,0x24,0xFB,0x41,0x24,0xFB,0x77,	/* 19C8:  @$A$w */
	0xE4,0x77,0x22,0x87,0xF1,0xA7,0x20,0x28,	/* 19D0: w" ( */
	0x44,0x71,0xE6,0x05,0x20,0x29,0x42,0x71,	/* 19D8: Dq. )Bq */
	0xE6,0x41,0xB5,0x22,0xF0,0x77,0x22,0x85,	/* 19E0: A"w" */
	0xF1,0x21,0xA6,0x77,0x22,0x87,0xF1,0x24,	/* 19E8: !w"$ */
	0x22,0xA9,0x40,0x71,0x21,0xE5,0x40,0x71,	/* 19F0: "@q!@q */
	0x21,0xE6,0x21,0x48,0x71,0xE5,0x24,0x21,	/* 19F8: !!Hq$! */
	0x0E,0x41,0x77,0x22,0x85,0x23,0xFB,0x77,	/* 1A00: .Aw"#w */
	0x22,0x87,0xF1,0x21,0xAF,0x71,0x24,0x30,	/* 1A08: "!q$0 */
	0x2F,0x4F,0x24,0xF6,0x24,0x42,0xF4,0xA8,	/* 1A10: .O$$B */
	0x21,0x4F,0x71,0x27,0xE2,0x22,0x20,0x04,	/* 1A18: !Oq'" . */
	0x40,0x71,0x27,0xE6,0x24,0x42,0x71,0x27,	/* 1A20: @q'$Bq' */
	0xE2,0x21,0x2F,0x08,0x71,0x24,0x30,0x2F,	/* 1A28: !..q$0. */
	0x4F,0x24,0xF6,0x24,0x42,0xF4,0xA7,0x2C,	/* 1A30: O$$B, */
	0x27,0x4F,0x21,0xFB,0xD3,0x06,0x2C,0x24,	/* 1A38: 'O!.,$ */
	0x40,0x21,0xFB,0xD3,0x77,0x5B,0xF1,0x4F,	/* 1A40: @!w[O */
	0x24,0xF6,0xD0,0x77,0x53,0xF1,0x24,0x48,	/* 1A48: $wS$H */
	0xF4,0xC0,0xAA,0x70,0x4F,0xF4,0xC0,0xA5,	/* 1A50: pO */
	0x77,0x23,0x83,0xF1,0xD0,0x77,0x53,0xF1,	/* 1A58: w#wS */
	0x24,0x48,0xF4,0xC0,0xA9,0x41,0x21,0x4E,	/* 1A60: $HA!N */
	0x70,0x24,0xFF,0xF0,0xC0,0xAF,0x77,0x53,	/* 1A68: p$wS */
	0xF1,0x24,0x48,0xF4,0xAD,0x41,0x70,0x4D,	/* 1A70: $HApM */
	0x24,0xFF,0xF0,0xC0,0xA5,0x77,0x21,0x5B,	/* 1A78: $w![ */
	0xF1,0xD0,0x70,0x23,0xF4,0x73,0xFA,0x30,	/* 1A80: p#s0 */
	0x71,0x27,0xE2,0x70,0x23,0xF4,0x73,0xFA,	/* 1A88: q'p#s */
	0x31,0x71,0x27,0xE6,0x77,0x22,0x8D,0xF1,	/* 1A90: 1q'w" */
	0x2F,0x40,0x24,0xF6,0x77,0x5B,0xF1,0x4F,	/* 1A98: .@$w[O */
	0x24,0xF6,0x24,0xFB,0x77,0x22,0x8D,0x23,	/* 1AA0: $$w"# */
	0xFB,0x77,0x23,0x83,0xF1,0x77,0x21,0x5B,	/* 1AA8: w#w![ */
	0x23,0xFB,0x77,0x5B,0xF1,0x44,0x24,0xF0,	/* 1AB0: #w[D$ */
	0xD0,0x77,0x53,0xF1,0x24,0x48,0xF4,0xC0,	/* 1AB8: wS$H */
	0xAA,0x70,0x4F,0xF4,0xC0,0xA5,0x77,0x21,	/* 1AC0: pOw! */
	0x5A,0xF1,0xD0,0x77,0x53,0xF1,0x24,0x48,	/* 1AC8: ZwS$H */
	0xF4,0xC0,0xA9,0x41,0x21,0x4E,0x70,0x24,	/* 1AD0: A!Np$ */
	0xFF,0xF0,0xC0,0xAF,0x77,0x53,0xF1,0x24,	/* 1AD8: wS$ */
	0x48,0xF4,0xAD,0x41,0x70,0x4D,0x24,0xFF,	/* 1AE0: HApM$ */
	0xF0,0xC0,0xA5,0x77,0x23,0x87,0xF1,0xD0,	/* 1AE8: w# */
	0x70,0x23,0xF4,0x73,0xFA,0x30,0x71,0x27,	/* 1AF0: p#s0q' */
	0xE8,0x70,0x23,0xF4,0x73,0xFA,0x31,0x71,	/* 1AF8: p#s1q */
	0x27,0xEC,0x77,0x22,0x8D,0xF1,0x4F,0x24,	/* 1B00: 'w"O$ */
	0xF6,0x77,0x5B,0xF1,0x2F,0x40,0x24,0xF6,	/* 1B08: w[.@$ */
	0x24,0xFB,0x77,0x22,0x8D,0x23,0xFB,0x77,	/* 1B10: $w"#w */
	0x21,0x5A,0xF1,0x77,0x23,0x87,0x23,0xFB,	/* 1B18: !Zw## */
	0x40,0x77,0x21,0xEC,0x40,0x77,0x21,0xED,	/* 1B20: @w!@w! */
	0x40,0x77,0x21,0xEE,0x40,0x77,0x21,0xEF,	/* 1B28: @w!@w! */
	0x77,0x21,0x8D,0xF1,0x71,0x21,0xEA,0x77,	/* 1B30: w!q!w */
	0x5F,0xF1,0x71,0x21,0xEB,0x77,0x21,0x8B,	/* 1B38: _q!w! */
	0xF1,0x71,0x21,0xEC,0x77,0x5E,0xF1,0x71,	/* 1B40: q!w^q */
	0x21,0xED,0x40,0x77,0x21,0x89,0x23,0xFB,	/* 1B48: !@w!# */
	0x77,0x5A,0xF1,0xD0,0x70,0x77,0x23,0x81,	/* 1B50: wZpw# */
	0x23,0xFB,0x70,0x43,0x24,0xF6,0xD3,0x70,	/* 1B58: #pC$p */
	0x21,0x40,0x24,0xF6,0xC0,0x21,0xAD,0x70,	/* 1B60: !@$!p */
	0x48,0x24,0xF6,0xA7,0x73,0x22,0x40,0x24,	/* 1B68: H$s"@$ */
	0xFB,0xD3,0x06,0x73,0x24,0x40,0x24,0xFB,	/* 1B70: .s$@$ */
	0xD3,0x70,0x44,0x24,0xF6,0xA6,0x73,0x28,	/* 1B78: pD$s( */
	0x40,0x24,0xFB,0xD3,0x77,0x5D,0xF1,0x28,	/* 1B80: @$w]( */
	0x40,0x24,0xF6,0xA2,0x20,0x06,0x73,0x21,	/* 1B88: @$ .s! */
	0x40,0x24,0xFB,0xD3,0x77,0x21,0x85,0xF1,	/* 1B90: @$w! */
	0xD0,0x70,0x77,0x21,0x59,0x23,0xFB,0x70,	/* 1B98: pw!Y#p */
	0x4F,0x24,0xF6,0x4F,0xF4,0xA2,0x20,0x05,	/* 1BA0: O$O . */
	0x73,0x48,0x24,0xFB,0xD3,0x73,0x71,0xE8,	/* 1BA8: sH$sq */
	0x40,0xD3,0x70,0x28,0x40,0x24,0xF6,0xA6,	/* 1BB0: @p(@$ */
	0x73,0x21,0x40,0x24,0xFB,0xD3,0x73,0x71,	/* 1BB8: s!@$sq */
	0xE9,0x77,0x53,0xF1,0x24,0x48,0xF4,0xA6,	/* 1BC0: wS$H */
	0x20,0x48,0x71,0xEA,0x05,0x20,0x28,0x44,	/* 1BC8:  Hq. (D */
	0x71,0xEA,0x77,0x21,0x50,0xF1,0xD0,0x70,	/* 1BD0: qw!Pp */
	0x77,0x22,0x81,0x23,0xFB,0x77,0x5D,0xF1,	/* 1BD8: w"#w] */
	0x77,0x21,0x58,0x23,0xFB,0x70,0x28,0x40,	/* 1BE0: w!X#p(@ */
	0x24,0xF6,0xA5,0x20,0x40,0xD3,0x21,0x06,	/* 1BE8: $ @!. */
	0x70,0x48,0x24,0xF6,0xA5,0x20,0x42,0xD3,	/* 1BF0: pH$ B */
	0x0D,0x20,0x70,0x44,0x24,0xF6,0xA5,0x20,	/* 1BF8: . pD$  */
	0x44,0xD3,0x03,0x20,0x43,0xD3,0x70,0x41,	/* 1C00: D. CpA */
	0x24,0xF6,0xA9,0x20,0x73,0x21,0x48,0x24,	/* 1C08: $ s!H$ */
	0xFB,0xD3,0x0D,0x20,0x70,0x42,0x24,0xF6,	/* 1C10: . pB$ */
	0xC0,0xA6,0x20,0x73,0x48,0x24,0xFB,0xD3,	/* 1C18:  sH$ */
	0x73,0x71,0x21,0xEE,0x40,0xD3,0x77,0x5D,	/* 1C20: sq!@w] */
	0xF1,0x44,0x24,0xF6,0x22,0xA9,0x77,0x22,	/* 1C28: D$"w" */
	0x87,0xF1,0xAD,0x20,0x71,0x24,0x30,0x2F,	/* 1C30:  q$0. */
	0x4F,0x24,0xF6,0x24,0x42,0xF4,0xAF,0x20,	/* 1C38: O$$B  */
	0x72,0x64,0x2F,0x4F,0x24,0xF6,0xD2,0x73,	/* 1C40: rd.O$s */
	0x42,0x24,0xFB,0xD3,0x21,0x00,0x72,0x24,	/* 1C48: B$!.r$ */
	0x20,0x40,0x24,0xFB,0xD2,0x08,0x20,0x72,	/* 1C50:  @$. r */
	0x64,0x2F,0x4F,0x24,0xF6,0xD2,0x77,0x21,	/* 1C58: d.O$w! */
	0x51,0xF1,0x2F,0x4F,0xF4,0xAE,0x20,0x77,	/* 1C60: Q.O w */
	0x22,0x87,0xF1,0xC0,0xA7,0x20,0x73,0x28,	/* 1C68: " s( */
	0x40,0x24,0xFB,0xD3,0x73,0x71,0x21,0xEF,	/* 1C70: @$sq! */
	0x77,0x22,0x87,0xF1,0x22,0xA7,0x77,0x22,	/* 1C78: w""w" */
	0x87,0xF1,0x21,0x28,0xA7,0x71,0x24,0x30,	/* 1C80: !(q$0 */
	0x2F,0x4F,0x24,0xF6,0x24,0x42,0xF4,0x21,	/* 1C88: .O$$B! */
	0x27,0xAA,0x77,0x5D,0xF1,0x44,0x24,0xF6,	/* 1C90: 'w]D$ */
	0x21,0x27,0xA1,0x72,0x24,0x20,0x40,0x24,	/* 1C98: !'r$ @$ */
	0xFB,0xD2,0x21,0x26,0x07,0x40,0xD4,0x40,	/* 1CA0: !&.@@ */
	0xD3,0x40,0xD0,0x77,0x5D,0xF1,0x48,0x24,	/* 1CA8: @w]H$ */
	0xF6,0xA7,0x70,0x21,0x20,0x40,0x24,0xFB,	/* 1CB0: p! @$ */
	0xD0,0x77,0x23,0x81,0xF1,0x28,0x40,0x24,	/* 1CB8: w#(@$ */
	0xF6,0xAA,0x70,0x21,0x20,0x20,0x40,0x24,	/* 1CC0: p!  @$ */
	0xFB,0xD0,0x21,0x08,0x73,0x21,0x20,0x20,	/* 1CC8: !.s!   */
	0x40,0x24,0xFB,0xD3,0x77,0x21,0x87,0xF1,	/* 1CD0: @$w! */
	0x41,0x24,0xF6,0xA8,0x74,0x21,0x20,0x20,	/* 1CD8: A$t!   */
	0x40,0x24,0xFB,0xD4,0x77,0x5D,0xF1,0x24,	/* 1CE0: @$w]$ */
	0x40,0x24,0xF6,0xAA,0x70,0x22,0x20,0x20,	/* 1CE8: @$p"   */
	0x40,0x24,0xFB,0xD0,0x21,0x08,0x73,0x22,	/* 1CF0: @$!.s" */
	0x20,0x20,0x40,0x24,0xFB,0xD3,0x77,0x21,	/* 1CF8:   @$w! */
	0x87,0xF1,0x42,0x24,0xF6,0xA8,0x74,0x22,	/* 1D00: B$t" */
	0x20,0x20,0x40,0x24,0xFB,0xD4,0x77,0x5D,	/* 1D08:   @$w] */
	0xF1,0x42,0x24,0xF6,0x21,0xA2,0x77,0x5D,	/* 1D10: B$!w] */
	0xF1,0x41,0x24,0xF6,0xA6,0x70,0x42,0x24,	/* 1D18: A$pB$ */
	0xFB,0xD0,0x05,0x70,0x41,0x24,0xFB,0xD0,	/* 1D20: .pA$ */
	0x77,0x21,0x85,0xF1,0x21,0x40,0x24,0xF6,	/* 1D28: w!!@$ */
	0xA6,0x70,0x21,0x40,0x24,0xFB,0xD0,0x23,	/* 1D30: p!@$# */
	0x21,0x23,0x43,0x77,0x76,0x26,0x23,0x99,	/* 1D38: !#Cwv&# */
	0x74,0xD0,0x73,0x77,0x76,0x28,0x29,0x9C,	/* 1D40: tswv() */
	0x77,0x5D,0xF1,0x22,0x40,0x24,0xF6,0x23,	/* 1D48: w]"@$# */
	0xA3,0x77,0x76,0x66,0x25,0x9D,0x77,0x21,	/* 1D50: wvf%w! */
	0x85,0xF1,0x21,0x40,0x24,0xF6,0xA4,0x2B,	/* 1D58: !@$+ */
	0x40,0xD0,0x03,0x2F,0x40,0xD0,0x77,0x21,	/* 1D60: @..@w! */
	0x53,0xF1,0x70,0x24,0xF6,0xD0,0x70,0x71,	/* 1D68: Sp$pq */
	0x21,0xE6,0x71,0x21,0x35,0x4F,0x24,0xF6,	/* 1D70: !q!5O$ */
	0x70,0x60,0x40,0x24,0xF6,0x24,0xFB,0x71,	/* 1D78: p`@$$q */
	0x21,0xE5,0x21,0x03,0x22,0x44,0x77,0x5C,	/* 1D80: !!."Dw\ */
	0x23,0xFB,0x40,0x71,0x21,0xE6,0x71,0x21,	/* 1D88: #@q!q! */
	0x35,0x4F,0x24,0xF6,0x71,0x21,0xE5,0x72,	/* 1D90: 5O$q!r */
	0x60,0x44,0x24,0xF6,0xD2,0x77,0x5D,0xF1,	/* 1D98: `D$w] */
	0x42,0x24,0xF6,0xA5,0x72,0x42,0x24,0xFB,	/* 1DA0: B$rB$ */
	0xD2,0x77,0x5D,0xF1,0x48,0x24,0xF6,0xA5,	/* 1DA8: w]H$ */
	0x72,0x48,0x24,0xFB,0xD2,0x77,0x5D,0xF1,	/* 1DB0: rH$w] */
	0x41,0x24,0xF6,0xA5,0x72,0x41,0x24,0xFB,	/* 1DB8: A$rA$ */
	0xD2,0x72,0x62,0x2B,0x2F,0x4F,0x24,0xF6,	/* 1DC0: rb+.O$ */
	0xD2,0x77,0x5D,0xF1,0x44,0x24,0xF6,0xA7,	/* 1DC8: w]D$ */
	0x72,0x24,0x20,0x40,0x24,0xFB,0xD2,0x77,	/* 1DD0: r$ @$w */
	0x5D,0xF1,0x22,0x40,0x24,0xF6,0xA8,0x72,	/* 1DD8: ]"@$r */
	0x22,0x20,0x20,0x40,0x24,0xFB,0xD2,0x77,	/* 1DE0: "  @$w */
	0x5A,0xF1,0x28,0x40,0x24,0xF6,0xA5,0x72,	/* 1DE8: Z(@$r */
	0x48,0x24,0xFB,0xD2,0x77,0x5D,0xF1,0x24,	/* 1DF0: H$w]$ */
	0x40,0x24,0xF6,0xA5,0x72,0x48,0x24,0xFB,	/* 1DF8: @$rH$ */
	0xD2,0x72,0x48,0x24,0xF6,0xA6,0x72,0x6F,	/* 1E00: rH$ro */
	0x4F,0x24,0xF6,0xD2,0x42,0x71,0x22,0xE1,	/* 1E08: O$Bq" */
	0x24,0x4E,0x71,0xE5,0x72,0x77,0xE4,0x40,	/* 1E10: $Nqrw@ */
	0xB5,0x22,0xF0,0x21,0x4A,0x71,0xE5,0x72,	/* 1E18: "!Jqr */
	0x60,0x4E,0x24,0xF6,0x77,0xE4,0x29,0x40,	/* 1E20: `N$w)@ */
	0x71,0xE6,0x40,0x77,0x22,0x85,0x23,0xFB,	/* 1E28: q@w"# */
	0x77,0x57,0xF1,0x44,0xF4,0xA6,0x40,0x77,	/* 1E30: wWD@w */
	0x57,0x23,0xFB,0x03,0x77,0x76,0x98,0x41,	/* 1E38: W#.wvA */
	0x76,0x21,0xE1,0x40,0xB5,0x22,0xF0,0x60,	/* 1E40: v!@"` */
	0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,0x73,	/* 1E48: s1ss */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 1E50: 2'..O$ */
	0x23,0xFB,0x73,0x87,0xF1,0x70,0x27,0xEF,	/* 1E58: #sp' */
	0x73,0x87,0xF1,0x43,0x24,0xF6,0x70,0x26,	/* 1E60: sC$p& */
	0xE8,0x70,0x26,0x3C,0x28,0x40,0x24,0xF6,	/* 1E68: p&<(@$ */
	0xA9,0x40,0x73,0x57,0x23,0xFB,0x41,0x72,	/* 1E70: @sW#Ar */
	0x21,0xE1,0x40,0xB1,0x22,0xF0,0x72,0x71,	/* 1E78: !@"rq */
	0x21,0x2E,0x93,0xA3,0x40,0x22,0xF0,0x72,	/* 1E80: !.@"r */
	0x8D,0xF1,0x72,0x56,0xF1,0xF4,0xA3,0x41,	/* 1E88: rVA */
	0x22,0xF0,0x72,0x71,0x28,0x93,0x40,0x22,	/* 1E90: "rq(@" */
	0xF0,0x60,0xBE,0x74,0x31,0xD0,0x74,0x87,	/* 1E98: `t1t */
	0xF1,0x74,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 1EA0: t2'..O$ */
	0xF6,0x89,0x23,0xFB,0x74,0x87,0xF1,0x70,	/* 1EA8: #tp */
	0x27,0xEF,0x74,0x87,0xF1,0x43,0x24,0xF6,	/* 1EB0: 'tC$ */
	0x70,0x26,0xE8,0x74,0x23,0x85,0xF1,0xD1,	/* 1EB8: p&t# */
	0x43,0x71,0xF9,0xAD,0x71,0x21,0xA0,0x71,	/* 1EC0: Cqq!q */
	0x41,0xF4,0x21,0xA1,0x71,0x42,0xF4,0xAD,	/* 1EC8: A!qB */
	0x06,0x71,0x43,0xF4,0x21,0xAD,0x71,0x41,	/* 1ED0: .qC!qA */
	0x74,0x23,0x85,0x23,0xFB,0x74,0x34,0x41,	/* 1ED8: t##t4A */
	0x24,0xFB,0x74,0xE4,0x70,0x36,0x2F,0x4F,	/* 1EE0: $tp6.O */
	0x24,0xF6,0x42,0x24,0xFB,0x70,0xE6,0x40,	/* 1EE8: $B$p@ */
	0xB2,0x22,0xF0,0x74,0x57,0xF1,0x4C,0xF4,	/* 1EF0: "tWL */
	0xC0,0xA6,0x21,0x42,0x74,0x57,0x23,0xFB,	/* 1EF8: !BtW# */
	0x40,0xB2,0x22,0xF0,0x72,0x71,0x21,0x25,	/* 1F00: @"rq!% */
	0x9D,0xC0,0xA5,0x40,0x72,0x57,0x23,0xFB,	/* 1F08: @rW# */
	0x40,0x22,0xF0,0x40,0x22,0xF0,0x41,0x22,	/* 1F10: @"@"A" */
	0xF0,0x60,0xBD,0x75,0x31,0xD1,0x75,0x87,	/* 1F18: `u1u */
	0xF1,0x75,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 1F20: u2'..O$ */
	0xF6,0x89,0x23,0xFB,0x75,0x87,0xF1,0x71,	/* 1F28: #uq */
	0x27,0xEF,0x75,0x87,0xF1,0x43,0x24,0xF6,	/* 1F30: 'uC$ */
	0x71,0x26,0xE8,0x75,0x74,0x21,0x22,0x96,	/* 1F38: q&ut!" */
	0xA4,0x40,0xB3,0x22,0xF0,0x71,0x35,0x2F,	/* 1F40: @"q5. */
	0x4F,0x24,0xF6,0xA4,0x40,0xB3,0x22,0xF0,	/* 1F48: O$@" */
	0x75,0x21,0x8F,0xF1,0xC0,0x24,0xAC,0x75,	/* 1F50: u!$u */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0xD0,	/* 1F58: 2'..O$ */
	0x75,0x34,0x22,0x20,0x40,0x24,0xF6,0x26,	/* 1F60: u4" @$& */
	0xA9,0x75,0x87,0xF1,0x43,0xF9,0x21,0xAC,	/* 1F68: uC! */
	0x70,0x21,0x8D,0xF1,0x60,0x8F,0xD2,0x72,	/* 1F70: p!`r */
	0x70,0x21,0x8D,0x23,0xFB,0x72,0x2F,0x4F,	/* 1F78: p!#r.O */
	0x24,0xF6,0xC0,0x21,0xAE,0x24,0x44,0x71,	/* 1F80: $!$Dq */
	0x27,0xEF,0x21,0x07,0x70,0x5E,0xF1,0x60,	/* 1F88: '!.p^` */
	0x8F,0xD2,0x72,0x70,0x5E,0x23,0xFB,0x72,	/* 1F90: rp^#r */
	0x2F,0x4F,0x24,0xF6,0xC0,0xA5,0x21,0x40,	/* 1F98: .O$!@ */
	0x71,0x27,0xEF,0x40,0x75,0x8D,0x23,0xFB,	/* 1FA0: q'@u# */
	0x40,0x75,0x55,0x23,0xFB,0x40,0x75,0x56,	/* 1FA8: @uU#@uV */
	0x23,0xFB,0x40,0x75,0x8B,0x23,0xFB,0x40,	/* 1FB0: #@u#@ */
	0x75,0x22,0x89,0x23,0xFB,0x75,0x34,0x62,	/* 1FB8: u"#u4b */
	0x2F,0x4F,0x24,0xF6,0x75,0xE4,0x75,0x22,	/* 1FC0: .O$uu" */
	0x87,0xF1,0x24,0xAF,0x21,0x44,0x71,0xE5,	/* 1FC8: $!Dq */
	0x27,0x05,0x75,0x22,0x89,0xF1,0x22,0xA6,	/* 1FD0: '.u"" */
	0x75,0x34,0x21,0x20,0x40,0x24,0xFB,0x75,	/* 1FD8: u4! @$u */
	0xE4,0x40,0x75,0x8D,0x23,0xFB,0x40,0x75,	/* 1FE0: @u#@u */
	0x56,0x23,0xFB,0x75,0x22,0x87,0xF1,0x21,	/* 1FE8: V#u"! */
	0xA7,0x75,0x34,0x41,0x24,0xFB,0x75,0xE4,	/* 1FF0: u4A$u */
	0x28,0x44,0x71,0xE6,0x21,0x05,0x75,0x34,	/* 1FF8: (Dq!.u4 */
	0x22,0x20,0x40,0x24,0xFB,0x75,0xE4,0x0F,	/* 2000: " @$u. */
	0x75,0x34,0x41,0x24,0xFB,0x75,0xE4,0x29,	/* 2008: u4A$u) */
	0x42,0x71,0xE6,0x28,0x42,0x71,0xE5,0x40,	/* 2010: Bq(Bq@ */
	0xB3,0x22,0xF0,0x75,0x21,0x87,0xF1,0x41,	/* 2018: "u!A */
	0x24,0xF6,0xC0,0xAB,0x40,0xD0,0x21,0x20,	/* 2020: $@!  */
	0x20,0x40,0x75,0x74,0x25,0x2B,0x95,0x75,	/* 2028:  @ut%+u */
	0x21,0x87,0xF1,0x42,0x24,0xF6,0xC0,0xAB,	/* 2030: !B$ */
	0x40,0xD0,0x22,0x20,0x20,0x40,0x75,0x74,	/* 2038: @"  @ut */
	0x25,0x2A,0x91,0x28,0x40,0x71,0xE5,0x75,	/* 2040: %*(@qu */
	0x34,0x60,0x4E,0x24,0xF6,0x75,0xE4,0x40,	/* 2048: 4`N$u@ */
	0x71,0xE6,0x41,0x75,0x21,0x8F,0x23,0xFB,	/* 2050: qAu!# */
	0x21,0x40,0x75,0x57,0x23,0xFB,0x41,0x74,	/* 2058: !@uW#At */
	0x21,0xE1,0x40,0xB3,0x22,0xF0,0x60,0xBE,	/* 2060: !@"` */
	0x74,0x31,0xD0,0x74,0x87,0xF1,0x74,0x32,	/* 2068: t1tt2 */
	0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,	/* 2070: '..O$# */
	0xFB,0x74,0x87,0xF1,0x70,0x27,0xEF,0x74,	/* 2078: tp't */
	0x87,0xF1,0x43,0x24,0xF6,0x70,0x26,0xE8,	/* 2080: C$p& */
	0x74,0x23,0x85,0xF1,0xD1,0x43,0x71,0xF9,	/* 2088: t#Cq */
	0xA5,0x71,0x24,0xA0,0x71,0x0E,0x71,0x43,	/* 2090: q$q.qC */
	0xF4,0xAA,0x71,0x44,0xF4,0x21,0xAF,0x71,	/* 2098: qD!q */
	0x45,0xF4,0x21,0xAA,0x74,0x53,0xF1,0x24,	/* 20A0: E!tS$ */
	0x48,0xF4,0xC0,0xAC,0x70,0x35,0x2F,0x4F,	/* 20A8: Hp5.O */
	0x24,0xF6,0xC0,0xAA,0x28,0x42,0x70,0xE5,	/* 20B0: $(Bp */
	0x44,0x74,0x23,0x85,0x23,0xFB,0x74,0x34,	/* 20B8: Dt##t4 */
	0x41,0x24,0xFB,0x74,0xE4,0x70,0x36,0x2F,	/* 20C0: A$tp6. */
	0x4F,0x24,0xF6,0x42,0x24,0xFB,0x70,0xE6,	/* 20C8: O$B$p */
	0x41,0xB2,0x22,0xF0,0x40,0xB2,0x22,0xF0,	/* 20D0: A"@" */
	0x60,0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,	/* 20D8: `s1s */
	0x73,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 20E0: s2'..O$ */
	0x89,0x23,0xFB,0x73,0x87,0xF1,0x70,0x27,	/* 20E8: #sp' */
	0xEF,0x73,0x87,0xF1,0x43,0x24,0xF6,0x70,	/* 20F0: sC$p */
	0x26,0xE8,0x73,0x22,0x87,0xF1,0xC0,0xA8,	/* 20F8: &s" */
	0x70,0x3B,0x2F,0x4B,0x24,0xF6,0x70,0xEB,	/* 2100: p;.K$p */
	0x40,0x73,0x57,0x23,0xFB,0x41,0x72,0x21,	/* 2108: @sW#Ar! */
	0xE1,0x40,0xB1,0x22,0xF0,0x60,0xBF,0x73,	/* 2110: @"`s */
	0x31,0xD0,0x73,0x87,0xF1,0x73,0x32,0x27,	/* 2118: 1ss2' */
	0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,	/* 2120: ..O$# */
	0x73,0x87,0xF1,0x70,0x27,0xEF,0x73,0x87,	/* 2128: sp's */
	0xF1,0x43,0x24,0xF6,0x70,0x26,0xE8,0x70,	/* 2130: C$p&p */
	0x35,0x2F,0x4F,0x24,0xF6,0xA4,0x40,0xB1,	/* 2138: 5.O$@ */
	0x22,0xF0,0x73,0x8D,0xF1,0x73,0x56,0x23,	/* 2140: "ssV# */
	0xFB,0x28,0x42,0x70,0xE5,0x73,0x72,0x67,	/* 2148: (Bpsrg */
	0x97,0x40,0xB1,0x22,0xF0,0x72,0x8B,0xF1,	/* 2150: @"r */
	0x72,0x55,0x23,0xFB,0x41,0x71,0x21,0xE1,	/* 2158: rU#Aq! */
	0x40,0x72,0x57,0x23,0xFB,0x40,0x22,0xF0,	/* 2160: @rW#@" */
	0x60,0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,	/* 2168: `s1s */
	0x73,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 2170: s2'..O$ */
	0x89,0x23,0xFB,0x73,0x87,0xF1,0x70,0x27,	/* 2178: #sp' */
	0xEF,0x73,0x87,0xF1,0x43,0x24,0xF6,0x70,	/* 2180: sC$p */
	0x26,0xE8,0x73,0x22,0x87,0xF1,0xC0,0xAB,	/* 2188: &s" */
	0x70,0x3B,0x2F,0x4F,0x24,0xF6,0x44,0x24,	/* 2190: p;.O$D$ */
	0xFB,0x70,0xEB,0x41,0x72,0x21,0xE1,0x40,	/* 2198: pAr!@ */
	0x73,0x57,0x23,0xFB,0x40,0xB1,0x22,0xF0,	/* 21A0: sW#@" */
	0x60,0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,	/* 21A8: `s1s */
	0x73,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 21B0: s2'..O$ */
	0x89,0x23,0xFB,0x73,0x87,0xF1,0x70,0x27,	/* 21B8: #sp' */
	0xEF,0x73,0x87,0xF1,0x43,0x24,0xF6,0x70,	/* 21C0: sC$p */
	0x26,0xE8,0x74,0x70,0x26,0xEF,0x4F,0x72,	/* 21C8: &tp&Or */
	0x21,0x2A,0x2F,0x90,0x70,0x26,0x3F,0x2F,	/* 21D0: !*.p&?. */
	0x4F,0x24,0xF6,0x75,0x24,0xF6,0x21,0xAA,	/* 21D8: O$u$! */
	0x40,0x70,0x26,0xEF,0x4F,0x72,0x21,0x2A,	/* 21E0: @p&Or!* */
	0x2D,0x9A,0x70,0x26,0x3F,0x2F,0x4F,0x24,	/* 21E8: -p&?.O$ */
	0xF6,0x75,0x24,0xF6,0xA9,0x76,0x81,0xB1,	/* 21F0: u$v */
	0x22,0xF0,0x76,0xB1,0x22,0xF0,0x40,0xB1,	/* 21F8: "v"@ */
	0x22,0xF0,0x60,0xBC,0x76,0x31,0xD2,0x40,	/* 2200: "`v1@ */
	0xD3,0x76,0x87,0xF1,0x76,0x32,0x27,0x2F,	/* 2208: vv2'. */
	0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,0x76,	/* 2210: .O$#v */
	0x87,0xF1,0x72,0x27,0xEF,0x76,0x87,0xF1,	/* 2218: r'v */
	0x43,0x24,0xF6,0x72,0x26,0xE8,0x76,0x22,	/* 2220: C$r&v" */
	0x87,0xF1,0xC0,0xA2,0x4E,0xD3,0x73,0xC0,	/* 2228: Ns */
	0xAB,0x22,0x40,0xD0,0x49,0xD1,0x41,0x76,	/* 2230: "@IAv */
	0x75,0x69,0x9D,0xD3,0x73,0xC0,0xAB,0x21,	/* 2238: uis! */
	0x40,0xD0,0x4B,0xD1,0x44,0x76,0x75,0x6A,	/* 2240: @KDvuj */
	0x9F,0xD3,0x73,0xC0,0x23,0xA2,0x48,0xD0,	/* 2248: s#H */
	0x42,0x72,0x26,0xEF,0x4F,0x75,0x21,0x2A,	/* 2250: Br&Ou!* */
	0x26,0x9A,0x40,0x72,0x26,0xEF,0x4F,0x75,	/* 2258: &@r&Ou */
	0x21,0x2A,0x26,0x90,0x72,0x26,0x3F,0x28,	/* 2260: !*&r&?( */
	0x40,0x24,0xF6,0xD1,0x71,0xAA,0x73,0xC0,	/* 2268: @$qs */
	0xA2,0x70,0xD3,0x71,0x76,0x5C,0x23,0xFB,	/* 2270: pqv\# */
	0x70,0x60,0x8F,0xD0,0x70,0xA2,0x62,0x00,	/* 2278: p`pb. */
	0x73,0xC0,0x23,0xA4,0x42,0x72,0x26,0xEF,	/* 2280: s#Br& */
	0x4F,0x75,0x21,0x2A,0x23,0x96,0x40,0x72,	/* 2288: Ou!*#@r */
	0x26,0xEF,0x22,0x27,0x21,0x40,0xD0,0x72,	/* 2290: &"'!@r */
	0x26,0x3F,0x2F,0x4F,0x24,0xF6,0xD1,0x71,	/* 2298: &?.O$q */
	0x24,0x40,0x24,0xF6,0xC0,0xA8,0x70,0x60,	/* 22A0: $@$p` */
	0x8F,0xD0,0x70,0xA2,0x61,0x09,0x70,0xC0,	/* 22A8: pa.p */
	0xA7,0x71,0x76,0x5C,0x23,0xFB,0x4D,0xD3,	/* 22B0: qv\#M */
	0x4F,0x75,0x21,0x2A,0x20,0x96,0x42,0x72,	/* 22B8: Ou!* Br */
	0x26,0xEF,0x4F,0x75,0x21,0x29,0x2F,0x9C,	/* 22C0: &Ou!). */
	0x40,0x72,0x26,0xEF,0x28,0x42,0x72,0xE5,	/* 22C8: @r&(Br */
	0x73,0x76,0x21,0x54,0x23,0xFB,0x73,0xA4,	/* 22D0: sv!T#s */
	0x45,0x72,0x26,0xEF,0x40,0x76,0x57,0x23,	/* 22D8: Er&@vW# */
	0xFB,0x40,0xB4,0x22,0xF0,0x21,0x40,0x72,	/* 22E0: @"!@r */
	0x71,0x9F,0x22,0xF0,0x42,0x72,0x71,0x99,	/* 22E8: q"Brq */
	0x22,0xF0,0x28,0x40,0x72,0x71,0x92,0x22,	/* 22F0: "(@rq" */
	0xF0,0x60,0xBF,0x73,0x31,0xD0,0x73,0x87,	/* 22F8: `s1s */
	0xF1,0x73,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 2300: s2'..O$ */
	0xF6,0x89,0x23,0xFB,0x73,0x87,0xF1,0x70,	/* 2308: #sp */
	0x27,0xEF,0x73,0x87,0xF1,0x43,0x24,0xF6,	/* 2310: 'sC$ */
	0x70,0x26,0xE8,0x74,0x46,0x24,0xF6,0xA7,	/* 2318: p&tF$ */
	0x73,0x34,0x41,0x24,0xFB,0x73,0xE4,0x70,	/* 2320: s4A$sp */
	0x36,0x2F,0x4F,0x24,0xF6,0x74,0x24,0xFB,	/* 2328: 6.O$t$ */
	0x70,0xE6,0x41,0x72,0x21,0xE1,0x40,0x73,	/* 2330: pAr!@s */
	0x57,0x23,0xFB,0x40,0xB1,0x22,0xF0,0x60,	/* 2338: W#@"` */
	0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,0x73,	/* 2340: s1ss */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 2348: 2'..O$ */
	0x23,0xFB,0x73,0x87,0xF1,0x70,0x27,0xEF,	/* 2350: #sp' */
	0x73,0x87,0xF1,0x43,0x24,0xF6,0x70,0x26,	/* 2358: sC$p& */
	0xE8,0x73,0x34,0x60,0x4E,0x24,0xF6,0x73,	/* 2360: s4`N$s */
	0xE4,0x40,0x70,0xE6,0x41,0x72,0x21,0xE1,	/* 2368: @pAr! */
	0x40,0x73,0x57,0x23,0xFB,0x40,0xB1,0x22,	/* 2370: @sW#@" */
	0xF0,0x60,0xBF,0x73,0x31,0xD0,0x73,0x87,	/* 2378: `s1s */
	0xF1,0x73,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 2380: s2'..O$ */
	0xF6,0x89,0x23,0xFB,0x73,0x87,0xF1,0x70,	/* 2388: #sp */
	0x27,0xEF,0x73,0x87,0xF1,0x43,0x24,0xF6,	/* 2390: 'sC$ */
	0x70,0x26,0xE8,0x74,0x41,0x24,0xF6,0x23,	/* 2398: p&tA$# */
	0xA0,0x75,0x41,0x24,0xF6,0x21,0xAA,0x70,	/* 23A0: uA$!p */
	0x39,0x2F,0x4F,0x24,0xF6,0x24,0x40,0x24,	/* 23A8: 9.O$$@$ */
	0xFB,0x70,0xE9,0x70,0x3A,0x2F,0x4F,0x24,	/* 23B0: pp:.O$ */
	0xF6,0x23,0x40,0x24,0xFB,0x70,0xEA,0x21,	/* 23B8: #@$p! */
	0x00,0x70,0x39,0x2B,0x4F,0x24,0xF6,0x70,	/* 23C0: .p9+O$p */
	0xE9,0x70,0x3A,0x2C,0x4F,0x24,0xF6,0x70,	/* 23C8: p:,O$p */
	0xEA,0x74,0x42,0x24,0xF6,0x21,0xAA,0x75,	/* 23D0: tB$!u */
	0x42,0x24,0xF6,0xAD,0x70,0x39,0x2F,0x4F,	/* 23D8: B$p9.O */
	0x24,0xF6,0x28,0x40,0x24,0xFB,0x70,0xE9,	/* 23E0: $(@$p */
	0x08,0x70,0x39,0x27,0x4F,0x24,0xF6,0x70,	/* 23E8: .p9'O$p */
	0xE9,0x74,0x21,0x40,0x24,0xF6,0x21,0xAA,	/* 23F0: t!@$! */
	0x75,0x21,0x40,0x24,0xF6,0xAC,0x70,0x39,	/* 23F8: u!@$p9 */
	0x2F,0x4F,0x24,0xF6,0x42,0x24,0xFB,0x70,	/* 2400: .O$B$p */
	0xE9,0x08,0x70,0x39,0x2F,0x4D,0x24,0xF6,	/* 2408: .p9.M$ */
	0x70,0xE9,0x74,0x22,0x40,0x24,0xF6,0x21,	/* 2410: pt"@$! */
	0xAA,0x75,0x22,0x40,0x24,0xF6,0xAC,0x70,	/* 2418: u"@$p */
	0x39,0x2F,0x4F,0x24,0xF6,0x41,0x24,0xFB,	/* 2420: 9.O$A$ */
	0x70,0xE9,0x08,0x70,0x39,0x2F,0x4E,0x24,	/* 2428: p.p9.N$ */
	0xF6,0x70,0xE9,0x73,0x53,0xF1,0x24,0x48,	/* 2430: psS$H */
	0xF4,0x23,0xA2,0x74,0x21,0x20,0x20,0x40,	/* 2438: #t!  @ */
	0x24,0xF6,0x21,0x24,0xAB,0x73,0x21,0x52,	/* 2440: $!$s!R */
	0xF1,0x48,0x24,0xF6,0x21,0x22,0xAE,0x75,	/* 2448: H$!"u */
	0x21,0x20,0x20,0x40,0x24,0xF6,0x21,0x21,	/* 2450: !  @$!! */
	0xA4,0x70,0x21,0x35,0x2F,0x40,0x24,0xF6,	/* 2458: p!5.@$ */
	0x49,0x24,0xFB,0x70,0x21,0xE5,0x42,0x70,	/* 2460: I$p!Bp */
	0x26,0xED,0x21,0x22,0x03,0x70,0x21,0x35,	/* 2468: &!".p!5 */
	0x2F,0x40,0x24,0xF6,0x4E,0x24,0xFB,0x70,	/* 2470: .@$N$p */
	0x21,0xE5,0x74,0x21,0x20,0x40,0x24,0xF6,	/* 2478: !t! @$ */
	0x22,0xA1,0x75,0x21,0x20,0x40,0x24,0xF6,	/* 2480: "u! @$ */
	0x20,0xAF,0x70,0x21,0x3F,0x2F,0x4F,0x24,	/* 2488:  p!?.O$ */
	0xF6,0x48,0x24,0xFB,0x70,0x21,0xEF,0x0B,	/* 2490: H$p!. */
	0x20,0x70,0x21,0x3F,0x2F,0x47,0x24,0xF6,	/* 2498:  p!?.G$ */
	0x70,0x21,0xEF,0x74,0x21,0x20,0x20,0x40,	/* 24A0: p!t!  @ */
	0x24,0xF6,0x25,0xAB,0x73,0x21,0x52,0xF1,	/* 24A8: $%s!R */
	0x48,0x24,0xF6,0x22,0xAC,0x75,0x21,0x20,	/* 24B0: H$"u!  */
	0x20,0x40,0x24,0xF6,0x21,0xA0,0x70,0x21,	/* 24B8:  @$!p! */
	0x3F,0x2F,0x4B,0x24,0xF6,0x70,0x21,0xEF,	/* 24C0: ?.K$p! */
	0x42,0x70,0x26,0xED,0x23,0x09,0x70,0x21,	/* 24C8: Bp&#.p! */
	0x3F,0x2F,0x4F,0x24,0xF6,0x44,0x24,0xFB,	/* 24D0: ?.O$D$ */
	0x70,0x21,0xEF,0x40,0x70,0x26,0xED,0x22,	/* 24D8: p!@p&" */
	0x06,0x75,0x21,0x20,0x20,0x40,0x24,0xF6,	/* 24E0: .u!  @$ */
	0x21,0xA1,0x70,0x39,0x2F,0x4F,0x24,0xF6,	/* 24E8: !p9.O$ */
	0x44,0x24,0xFB,0x70,0xE9,0x41,0x70,0x26,	/* 24F0: D$pAp& */
	0xEC,0x0D,0x20,0x70,0x39,0x2F,0x4B,0x24,	/* 24F8: . p9.K$ */
	0xF6,0x70,0xE9,0x40,0x70,0x26,0xEC,0x74,	/* 2500: p@p&t */
	0x22,0x20,0x20,0x40,0x24,0xF6,0x2D,0xA1,	/* 2508: "  @$- */
	0x73,0x21,0x52,0xF1,0x48,0x24,0xF6,0x22,	/* 2510: s!RH$" */
	0xA8,0x75,0x22,0x20,0x20,0x40,0x24,0xF6,	/* 2518: u"  @$ */
	0x21,0xA1,0x70,0x39,0x2F,0x4F,0x24,0xF6,	/* 2520: !p9.O$ */
	0x44,0x24,0xFB,0x70,0xE9,0x41,0x70,0x26,	/* 2528: D$pAp& */
	0xEC,0x2A,0x0E,0x70,0x39,0x2F,0x4B,0x24,	/* 2530: *.p9.K$ */
	0xF6,0x70,0xE9,0x40,0x70,0x26,0xEC,0x2A,	/* 2538: p@p&* */
	0x00,0x75,0x22,0x20,0x20,0x40,0x24,0xF6,	/* 2540: .u"  @$ */
	0x21,0xA0,0x70,0x21,0x3F,0x2F,0x4B,0x24,	/* 2548: !p!?.K$ */
	0xF6,0x70,0x21,0xEF,0x42,0x70,0x26,0xED,	/* 2550: p!Bp& */
	0x28,0x07,0x70,0x21,0x3F,0x2F,0x4F,0x24,	/* 2558: (.p!?.O$ */
	0xF6,0x44,0x24,0xFB,0x70,0x21,0xEF,0x40,	/* 2560: D$p!@ */
	0x70,0x26,0xED,0x27,0x04,0x70,0x21,0x35,	/* 2568: p&'.p!5 */
	0x2F,0x40,0x24,0xF6,0x70,0x21,0xE5,0x40,	/* 2570: .@$p!@ */
	0x70,0x26,0xED,0x21,0x03,0x75,0x21,0x20,	/* 2578: p&!.u!  */
	0x20,0x40,0x24,0xF6,0xA7,0x20,0x41,0x70,	/* 2580:  @$ Ap */
	0x26,0xEC,0x05,0x20,0x40,0x70,0x26,0xEC,	/* 2588: &. @p& */
	0x74,0x22,0x20,0x20,0x40,0x24,0xF6,0x24,	/* 2590: t"  @$$ */
	0xA8,0x73,0x21,0x52,0xF1,0x48,0x24,0xF6,	/* 2598: s!RH$ */
	0x21,0xA5,0x75,0x22,0x20,0x20,0x40,0x24,	/* 25A0: !u"  @$ */
	0xF6,0xA7,0x20,0x41,0x70,0x26,0xEC,0x23,	/* 25A8:  Ap&# */
	0x00,0x40,0x70,0x26,0xEC,0x22,0x0A,0x75,	/* 25B0: .@p&".u */
	0x22,0x20,0x20,0x40,0x24,0xF6,0x21,0xA3,	/* 25B8: "  @$! */
	0x70,0x21,0x35,0x2F,0x40,0x24,0xF6,0x49,	/* 25C0: p!5.@$I */
	0x24,0xFB,0x70,0x21,0xE5,0x42,0x70,0x26,	/* 25C8: $p!Bp& */
	0xED,0x0F,0x20,0x70,0x21,0x35,0x2F,0x40,	/* 25D0: . p!5.@ */
	0x24,0xF6,0x70,0x21,0xE5,0x40,0x70,0x26,	/* 25D8: $p!@p& */
	0xED,0xB1,0x22,0xF0,0x60,0xBF,0x73,0x31,	/* 25E0: "`s1 */
	0xD0,0x73,0x87,0xF1,0x73,0x32,0x27,0x2F,	/* 25E8: ss2'. */
	0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,0x73,	/* 25F0: .O$#s */
	0x87,0xF1,0x70,0x27,0xEF,0x73,0x87,0xF1,	/* 25F8: p's */
	0x43,0x24,0xF6,0x70,0x26,0xE8,0x74,0x21,	/* 2600: C$p&t! */
	0x20,0x20,0x40,0x24,0xF6,0x23,0xA1,0x73,	/* 2608:   @$#s */
	0x21,0x52,0xF1,0x48,0x24,0xF6,0x21,0xA5,	/* 2610: !RH$! */
	0x75,0x21,0x20,0x20,0x40,0x24,0xF6,0xA7,	/* 2618: u!  @$ */
	0x20,0x42,0x70,0x26,0xED,0x21,0x09,0x40,	/* 2620:  Bp&!.@ */
	0x70,0x26,0xED,0x21,0x03,0x75,0x21,0x20,	/* 2628: p&!.u!  */
	0x20,0x40,0x24,0xF6,0xA7,0x20,0x41,0x70,	/* 2630:  @$ Ap */
	0x26,0xEC,0x05,0x20,0x40,0x70,0x26,0xEC,	/* 2638: &. @p& */
	0x74,0x22,0x20,0x20,0x40,0x24,0xF6,0x23,	/* 2640: t"  @$# */
	0xA4,0x73,0x21,0x52,0xF1,0x48,0x24,0xF6,	/* 2648: s!RH$ */
	0x21,0xA7,0x75,0x22,0x20,0x20,0x40,0x24,	/* 2650: !u"  @$ */
	0xF6,0xA8,0x20,0x41,0x70,0x26,0xEC,0xB1,	/* 2658:  Ap& */
	0x22,0xF0,0x40,0x70,0x26,0xEC,0xB1,0x22,	/* 2660: "@p&" */
	0xF0,0x75,0x22,0x20,0x20,0x40,0x24,0xF6,	/* 2668: u"  @$ */
	0xA8,0x20,0x42,0x70,0x26,0xED,0xB1,0x22,	/* 2670:  Bp&" */
	0xF0,0x40,0x70,0x26,0xED,0xB1,0x22,0xF0,	/* 2678: @p&" */
	0x76,0xF6,0x20,0x82,0x00,0x04,0x00,0x16,	/* 2680: v .... */
	0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x41,	/* 2688: ...A...A */
	0x00,0x04,0x00,0x82,0x00,0x03,0x00,0x41,	/* 2690: ......A */
	0x00,0x03,0x00,0x82,0x00,0x02,0x00,0x4E,	/* 2698: ......N */
	0x00,0x02,0x00,0x41,0x00,0x02,0x00,0x82,	/* 26A0: ...A... */
	0x00,0x01,0x00,0x57,0x00,0x02,0x00,0x41,	/* 26A8: ...W...A */
	0x00,0x01,0x00,0x82,0x00,0x00,0x00,0x2B,	/* 26B0: ......+ */
	0x00,0x00,0x00,0xA3,0x00,0x04,0x00,0x1B,	/* 26B8: ....... */
	0x00,0x00,0x00,0x51,0x00,0x00,0x00,0x51,	/* 26C0: ...Q...Q */
	0x00,0x04,0x00,0xA3,0x00,0x03,0x00,0x51,	/* 26C8: ......Q */
	0x00,0x03,0x00,0xA3,0x00,0x02,0x00,0x62,	/* 26D0: ......b */
	0x00,0x02,0x00,0x51,0x00,0x02,0x00,0xA3,	/* 26D8: ...Q... */
	0x00,0x01,0x00,0x6D,0x00,0x02,0x00,0x51,	/* 26E0: ...m...Q */
	0x00,0x01,0x00,0xA3,0x00,0x00,0x00,0x36,	/* 26E8: ......6 */
	0x00,0x00,0x00,0x36,0x00,0x05,0x00,0x1B,	/* 26F0: ...6.... */
	0x00,0x05,0x00,0x0D,0x00,0x05,0x00,0xF4,	/* 26F8: ....... */
	0x00,0x04,0x00,0x6F,0x00,0x04,0x00,0x5B,	/* 2700: ...o...[ */
	0x00,0x04,0x00,0xF4,0x00,0x03,0x00,0x6D,	/* 2708: ......m */
	0x00,0x01,0x00,0x38,0x00,0x00,0x00,0x31,	/* 2710: ...8...1 */
	0x00,0x00,0x00,0x29,0x00,0x00,0x00,0x62,	/* 2718: ...)...b */
	0x00,0x05,0x00,0x53,0x00,0x05,0x00,0xD9,	/* 2720: ...S... */
	0x00,0x00,0x00,0x30,0x00,0x05,0x00,0x6D,	/* 2728: ...0...m */
	0x00,0x00,0x00,0x25,0x00,0x23,0x00,0x21,	/* 2730: ...%.#.! */
	0x00,0x1F,0x00,0x1D,0x00,0x1B,0x00,0x19,	/* 2738: ........ */
	0x00,0x17,0x00,0x15,0x00,0x13,0x00,0x11,	/* 2740: ........ */
	0x00,0x0F,0x00,0x0D,0x00,0x0B,0x00,0x09,	/* 2748: ........ */
	0x00,0x07,0x00,0x05,0x00,0x03,0x00,0x01,	/* 2750: ........ */
	0x00,0x00,0x00,0x48,0x0A,0x71,0x21,0x53,	/* 2758: ...H.q!S */
	0xD2,0x64,0x2D,0x49,0x21,0xFB,0x72,0x22,	/* 2760: d-I!r" */
	0xE6,0x64,0x28,0x44,0x21,0xFB,0x72,0x22,	/* 2768: d(D!r" */
	0xE4,0x64,0x27,0x46,0x21,0xFB,0x72,0x22,	/* 2770: d'F!r" */
	0xE2,0x64,0x26,0x47,0x21,0xFB,0x72,0x22,	/* 2778: d&G!r" */
	0xE0,0x65,0x27,0x4C,0x21,0xFB,0x72,0x21,	/* 2780: e'L!r! */
	0xEE,0x66,0x2D,0x4A,0x21,0xFB,0x72,0x21,	/* 2788: f-J!r! */
	0xEC,0x66,0x2B,0x4F,0x21,0xFB,0x72,0x21,	/* 2790: f+O!r! */
	0xEA,0x66,0x27,0x47,0x21,0xFB,0x72,0x21,	/* 2798: f'G!r! */
	0xE8,0x66,0x23,0x42,0x21,0xFB,0x72,0x21,	/* 27A0: f#B!r! */
	0xE6,0x68,0x26,0x4B,0x21,0xFB,0x72,0x21,	/* 27A8: h&K!r! */
	0xE4,0x68,0x26,0x40,0x21,0xFB,0x72,0x21,	/* 27B0: h&@!r! */
	0xE2,0x68,0x25,0x45,0x21,0xFB,0x72,0x21,	/* 27B8: h%E!r! */
	0xE0,0x68,0x23,0x4E,0x21,0xFB,0x72,0xEE,	/* 27C0: h#N!r */
	0x69,0x2C,0x4C,0x21,0xFB,0x72,0xEC,0x69,	/* 27C8: i,L!ri */
	0x2A,0x4A,0x21,0xFB,0x72,0xEA,0x6E,0x24,	/* 27D0: *J!rn$ */
	0x4A,0x21,0xFB,0x72,0xE8,0x69,0x26,0x45,	/* 27D8: J!ri&E */
	0x21,0xFB,0x72,0xE6,0x6E,0x23,0x4C,0x21,	/* 27E0: !rn#L! */
	0xFB,0x72,0xE4,0x6E,0x23,0x45,0x21,0xFB,	/* 27E8: rn#E! */
	0x72,0xE2,0x72,0x6C,0x4C,0x21,0xFB,0x21,	/* 27F0: rrlL!! */
	0x44,0x21,0x29,0x26,0x9C,0x22,0xF0,0x60,	/* 27F8: D!)&"` */
	0xBD,0x74,0x23,0x5A,0xD1,0x21,0x28,0x40,	/* 2800: t#Z!(@ */
	0xD0,0x71,0x62,0x32,0x87,0xF1,0x81,0x71,	/* 2808: qb2q */
	0x62,0x32,0x87,0x23,0xFB,0x74,0x28,0x97,	/* 2810: b2#t( */
	0x70,0x57,0xF1,0xD2,0x72,0xAE,0x72,0x71,	/* 2818: pWrrq */
	0x62,0x59,0xFA,0x30,0xD2,0x70,0x74,0x29,	/* 2820: bY0pt) */
	0x27,0x95,0x26,0xAD,0x70,0x31,0xD2,0x70,	/* 2828: '&p1p */
	0x34,0x41,0x24,0xF6,0xC0,0x23,0xAE,0x70,	/* 2830: 4A$#p */
	0x8D,0xF1,0x70,0x56,0xF1,0xF4,0x23,0xA5,	/* 2838: pV# */
	0x70,0x34,0x41,0x24,0xFB,0x70,0xE4,0x70,	/* 2840: p4A$pp */
	0x87,0xF1,0x70,0x32,0x27,0x2F,0x2F,0x4F,	/* 2848: p2'..O */
	0x24,0xF6,0x89,0x23,0xFB,0x70,0x87,0xF1,	/* 2850: $#p */
	0x72,0x27,0xEF,0x70,0x87,0xF1,0x43,0x24,	/* 2858: r'pC$ */
	0xF6,0x72,0x26,0xE8,0x72,0x36,0x2F,0x4F,	/* 2860: r&r6.O */
	0x24,0xF6,0x44,0x24,0xFB,0x72,0xE6,0x41,	/* 2868: $D$rA */
	0x70,0x22,0x89,0x23,0xFB,0x70,0x34,0x21,	/* 2870: p"#p4! */
	0x40,0x24,0xF6,0x21,0xAC,0x41,0x70,0x55,	/* 2878: @$!ApU */
	0xF1,0x70,0x8B,0xF1,0xFC,0x2F,0x4F,0x24,	/* 2880: p.O$ */
	0xF6,0x22,0x40,0xF0,0x24,0xFF,0xF0,0xC0,	/* 2888: "@$ */
	0xA8,0x70,0x34,0x61,0x4F,0x24,0xF6,0x70,	/* 2890: p4aO$p */
	0xE4,0x70,0x21,0x37,0xD0,0x69,0x0A,0x60,	/* 2898: p!7i.` */
	0xB4,0x7D,0x23,0x5A,0xD6,0x76,0x30,0xD4,	/* 28A0: }#Zv0 */
	0x76,0x31,0xD1,0x74,0x33,0xD0,0x71,0x44,	/* 28A8: v1t3qD */
	0xF8,0x70,0x27,0xEF,0x70,0x26,0x37,0x2F,	/* 28B0: p'p&7. */
	0x4F,0x24,0xF6,0xD3,0x73,0x41,0x24,0xF6,	/* 28B8: O$sA$ */
	0x24,0x28,0xAF,0x70,0x26,0x3B,0x2F,0x4F,	/* 28C0: $(p&;.O */
	0x24,0xF6,0xD2,0x72,0x43,0x24,0xF6,0x70,	/* 28C8: $rC$p */
	0x26,0xE8,0x71,0x44,0xF8,0x72,0x43,0x24,	/* 28D0: &qDrC$ */
	0xF6,0xF5,0x74,0x55,0xFA,0x30,0xD5,0x70,	/* 28D8: tU0p */
	0x24,0x33,0x47,0x24,0xF6,0x43,0xF4,0x25,	/* 28E0: $3G$C% */
	0xA3,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 28E8: p&2.O$ */
	0xD7,0x77,0x48,0x24,0xF6,0x21,0xA0,0x75,	/* 28F0: wH$!u */
	0x21,0x89,0xF1,0x41,0x24,0xFB,0x75,0x21,	/* 28F8: !A$u! */
	0x89,0x23,0xFB,0x41,0x76,0x62,0xE7,0x77,	/* 2900: #Avbw */
	0x41,0x24,0xF6,0xA8,0x75,0x21,0x3E,0x41,	/* 2908: A$u!>A */
	0xF2,0x75,0x21,0xEE,0x77,0x42,0x24,0xF6,	/* 2910: u!wB$ */
	0xA8,0x75,0x21,0x3C,0x41,0xF2,0x75,0x21,	/* 2918: u!<Au! */
	0xEC,0x77,0x44,0x24,0xF6,0xA8,0x75,0x21,	/* 2920: wD$u! */
	0x3D,0x41,0xF2,0x75,0x21,0xED,0x70,0x26,	/* 2928: =Au!p& */
	0x32,0x72,0x23,0x4F,0x24,0xF6,0x70,0x26,	/* 2930: 2r#O$p& */
	0xEB,0x24,0x21,0x06,0x75,0x34,0x21,0x40,	/* 2938: $!.u4!@ */
	0x24,0xF6,0xC0,0x24,0x20,0xA4,0x75,0x22,	/* 2940: $$ u" */
	0x87,0xF1,0xC0,0xAC,0x75,0x21,0x54,0xF1,	/* 2948: u!T */
	0x41,0x24,0xFB,0x75,0x21,0x54,0x23,0xFB,	/* 2950: A$u!T# */
	0x75,0x55,0xF1,0xD9,0x75,0x8B,0xF1,0xDB,	/* 2958: uUu */
	0x7B,0x79,0x81,0xFC,0x2F,0x4F,0x24,0xF6,	/* 2960: {y.O$ */
	0xDA,0x41,0x76,0x62,0xE8,0x70,0x3E,0x2F,	/* 2968: Avbp>. */
	0x4F,0x24,0xF6,0xD7,0x7A,0x77,0xF9,0xA3,	/* 2970: O$zw */
	0x77,0xD8,0x02,0x7A,0xD8,0x77,0x78,0x2F,	/* 2978: w.zwx. */
	0x4F,0x24,0xF6,0xFC,0x2F,0x4F,0x24,0xF6,	/* 2980: O$.O$ */
	0xD7,0x78,0x2F,0x4F,0x24,0xF6,0x41,0xF4,	/* 2988: x.O$A */
	0xD8,0x41,0x22,0x40,0x78,0x24,0xFF,0xF0,	/* 2990: A"@x$ */
	0xC0,0x23,0x26,0xA4,0x78,0x44,0xF8,0x42,	/* 2998: #&xDB */
	0x21,0xFB,0xF2,0xF6,0x23,0x24,0x02,0x20,	/* 29A0: !#$.  */
	0x23,0x22,0x07,0x20,0x23,0x20,0x0C,0x20,	/* 29A8: #". # .  */
	0x22,0x2F,0x01,0x20,0x22,0x2D,0x06,0x20,	/* 29B0: ".. "-.  */
	0x22,0x2B,0x0B,0x20,0x22,0x2A,0x00,0x20,	/* 29B8: "+. "*.  */
	0x22,0x28,0x05,0x20,0x22,0x26,0x0A,0x20,	/* 29C0: "(. "&.  */
	0x22,0x24,0x0F,0x20,0x22,0x23,0x04,0x20,	/* 29C8: "$. "#.  */
	0x22,0x21,0x09,0x20,0x21,0x2F,0x0E,0x20,	/* 29D0: "!. !..  */
	0x21,0x2E,0x03,0x20,0x21,0x2C,0x08,0x20,	/* 29D8: !.. !,.  */
	0x21,0x2A,0x0D,0x20,0x21,0x29,0x02,0x20,	/* 29E0: !*. !).  */
	0x21,0x27,0x07,0x20,0x21,0x25,0x0C,0x20,	/* 29E8: !'. !%.  */
	0x21,0x24,0x01,0x20,0x21,0x22,0x06,0x20,	/* 29F0: !$. !".  */
	0x21,0x20,0x0B,0x20,0x2F,0x01,0x20,0x20,	/* 29F8: ! . ..   */
	0x2D,0x06,0x20,0x20,0x2B,0x0B,0x20,0x20,	/* 2A00: -.  +.   */
	0x2A,0x00,0x20,0x20,0x28,0x05,0x20,0x20,	/* 2A08: *.  (.   */
	0x26,0x0A,0x20,0x20,0x24,0x0F,0x20,0x20,	/* 2A10: &.  $.   */
	0x23,0x04,0x20,0x20,0x21,0x09,0x20,0x20,	/* 2A18: #.  !.   */
	0x79,0xD8,0x79,0x81,0xD9,0x70,0x26,0x32,	/* 2A20: yyp&2 */
	0x2F,0x4F,0x24,0xF6,0x78,0x2F,0x4F,0x24,	/* 2A28: .O$x.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x79,	/* 2A30: u+P#y */
	0xD8,0x79,0x81,0xD9,0x70,0x26,0x32,0x2F,	/* 2A38: yp&2. */
	0x4F,0x24,0xF6,0x78,0x2F,0x4F,0x24,0xF6,	/* 2A40: O$x.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x79,0xD8,	/* 2A48: u+P#y */
	0x79,0x81,0xD9,0x70,0x26,0x32,0x2F,0x4F,	/* 2A50: yp&2.O */
	0x24,0xF6,0x78,0x2F,0x4F,0x24,0xF6,0x75,	/* 2A58: $x.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x79,0xD8,0x79,	/* 2A60: +P#yy */
	0x81,0xD9,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2A68: p&2.O$ */
	0xF6,0x78,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2A70: x.O$u+ */
	0x50,0xF2,0x23,0xFB,0x79,0xD8,0x79,0x81,	/* 2A78: P#yy */
	0xD9,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2A80: p&2.O$ */
	0x78,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2A88: x.O$u+P */
	0xF2,0x23,0xFB,0x79,0xD8,0x79,0x81,0xD9,	/* 2A90: #yy */
	0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x78,	/* 2A98: p&2.O$x */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2AA0: .O$u+P */
	0x23,0xFB,0x79,0xD8,0x79,0x81,0xD9,0x70,	/* 2AA8: #yyp */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x78,0x2F,	/* 2AB0: &2.O$x. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2AB8: O$u+P# */
	0xFB,0x79,0xD8,0x79,0x81,0xD9,0x70,0x26,	/* 2AC0: yyp& */
	0x32,0x2F,0x4F,0x24,0xF6,0x78,0x2F,0x4F,	/* 2AC8: 2.O$x.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2AD0: $u+P# */
	0x79,0xD8,0x79,0x81,0xD9,0x70,0x26,0x32,	/* 2AD8: yyp&2 */
	0x2F,0x4F,0x24,0xF6,0x78,0x2F,0x4F,0x24,	/* 2AE0: .O$x.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x79,	/* 2AE8: u+P#y */
	0xD8,0x79,0x81,0xD9,0x70,0x26,0x32,0x2F,	/* 2AF0: yp&2. */
	0x4F,0x24,0xF6,0x78,0x2F,0x4F,0x24,0xF6,	/* 2AF8: O$x.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x79,0xD8,	/* 2B00: u+P#y */
	0x79,0x81,0xD9,0x70,0x26,0x32,0x2F,0x4F,	/* 2B08: yp&2.O */
	0x24,0xF6,0x78,0x2F,0x4F,0x24,0xF6,0x75,	/* 2B10: $x.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x79,0xD8,0x79,	/* 2B18: +P#yy */
	0x81,0xD9,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2B20: p&2.O$ */
	0xF6,0x78,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2B28: x.O$u+ */
	0x50,0xF2,0x23,0xFB,0x79,0xD8,0x79,0x81,	/* 2B30: P#yy */
	0xD9,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2B38: p&2.O$ */
	0x78,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2B40: x.O$u+P */
	0xF2,0x23,0xFB,0x79,0xD8,0x79,0x81,0xD9,	/* 2B48: #yy */
	0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x78,	/* 2B50: p&2.O$x */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2B58: .O$u+P */
	0x23,0xFB,0x79,0xD8,0x79,0x81,0xD9,0x70,	/* 2B60: #yyp */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x78,0x2F,	/* 2B68: &2.O$x. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2B70: O$u+P# */
	0xFB,0x79,0xD8,0x79,0x81,0xD9,0x70,0x26,	/* 2B78: yyp& */
	0x32,0x2F,0x4F,0x24,0xF6,0x78,0x2F,0x4F,	/* 2B80: 2.O$x.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2B88: $u+P# */
	0x79,0xD8,0x79,0x81,0xD9,0x70,0x26,0x32,	/* 2B90: yyp&2 */
	0x2F,0x4F,0x24,0xF6,0x78,0x2F,0x4F,0x24,	/* 2B98: .O$x.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x79,	/* 2BA0: u+P#y */
	0xD8,0x79,0x81,0xD9,0x70,0x26,0x32,0x2F,	/* 2BA8: yp&2. */
	0x4F,0x24,0xF6,0x78,0x2F,0x4F,0x24,0xF6,	/* 2BB0: O$x.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x79,0xD8,	/* 2BB8: u+P#y */
	0x79,0x81,0xD9,0x70,0x26,0x32,0x2F,0x4F,	/* 2BC0: yp&2.O */
	0x24,0xF6,0x78,0x2F,0x4F,0x24,0xF6,0x75,	/* 2BC8: $x.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x79,0xD8,0x79,	/* 2BD0: +P#yy */
	0x81,0xD9,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2BD8: p&2.O$ */
	0xF6,0x78,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2BE0: x.O$u+ */
	0x50,0xF2,0x23,0xFB,0x79,0xD8,0x79,0x81,	/* 2BE8: P#yy */
	0xD9,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2BF0: p&2.O$ */
	0x78,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2BF8: x.O$u+P */
	0xF2,0x23,0xFB,0x79,0xD8,0x79,0x81,0xD9,	/* 2C00: #yy */
	0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x78,	/* 2C08: p&2.O$x */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2C10: .O$u+P */
	0x23,0xFB,0x79,0xD8,0x79,0x81,0xD9,0x70,	/* 2C18: #yyp */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x78,0x2F,	/* 2C20: &2.O$x. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2C28: O$u+P# */
	0xFB,0x79,0xD8,0x79,0x81,0xD9,0x70,0x26,	/* 2C30: yyp& */
	0x32,0x2F,0x4F,0x24,0xF6,0x78,0x2F,0x4F,	/* 2C38: 2.O$x.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2C40: $u+P# */
	0x79,0xD8,0x79,0x81,0xD9,0x70,0x26,0x32,	/* 2C48: yyp&2 */
	0x2F,0x4F,0x24,0xF6,0x78,0x2F,0x4F,0x24,	/* 2C50: .O$x.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x79,	/* 2C58: u+P#y */
	0xD8,0x79,0x81,0xD9,0x70,0x26,0x32,0x2F,	/* 2C60: yp&2. */
	0x4F,0x24,0xF6,0x78,0x2F,0x4F,0x24,0xF6,	/* 2C68: O$x.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x79,0xD8,	/* 2C70: u+P#y */
	0x79,0x81,0xD9,0x70,0x26,0x32,0x2F,0x4F,	/* 2C78: yp&2.O */
	0x24,0xF6,0x78,0x2F,0x4F,0x24,0xF6,0x75,	/* 2C80: $x.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x79,0xD8,0x79,	/* 2C88: +P#yy */
	0x81,0xD9,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2C90: p&2.O$ */
	0xF6,0x78,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2C98: x.O$u+ */
	0x50,0xF2,0x23,0xFB,0x79,0xD8,0x79,0x81,	/* 2CA0: P#yy */
	0xD9,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2CA8: p&2.O$ */
	0x78,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2CB0: x.O$u+P */
	0xF2,0x23,0xFB,0x79,0xD8,0x79,0x81,0xD9,	/* 2CB8: #yy */
	0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x78,	/* 2CC0: p&2.O$x */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2CC8: .O$u+P */
	0x23,0xFB,0x79,0xD8,0x79,0x81,0xD9,0x70,	/* 2CD0: #yyp */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x78,0x2F,	/* 2CD8: &2.O$x. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2CE0: O$u+P# */
	0xFB,0x79,0xD8,0x79,0x81,0xD9,0x70,0x26,	/* 2CE8: yyp& */
	0x32,0x2F,0x4F,0x24,0xF6,0x78,0x2F,0x4F,	/* 2CF0: 2.O$x.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2CF8: $u+P# */
	0x79,0x75,0x55,0x23,0xFB,0x77,0x75,0x21,	/* 2D00: yuU#wu! */
	0x3F,0xF2,0x75,0x21,0xEF,0x77,0x77,0x60,	/* 2D08: ?u!ww` */
	0x8F,0xD7,0x2F,0x4F,0x24,0xF6,0x21,0xA0,	/* 2D10: .O$! */
	0x70,0x26,0x32,0x77,0x77,0x60,0x8F,0xD7,	/* 2D18: p&2ww` */
	0x2F,0x4F,0x24,0xF6,0xA3,0x20,0x60,0x00,	/* 2D20: .O$ `. */
	0x7B,0x79,0x81,0xFC,0x2F,0x4F,0x24,0xF6,	/* 2D28: {y.O$ */
	0xD7,0x75,0x34,0x48,0x24,0xF6,0x21,0xA2,	/* 2D30: u4H$! */
	0x7A,0x21,0x4F,0xF9,0xAD,0x22,0x40,0x77,	/* 2D38: z!O"@w */
	0xF9,0xA8,0x75,0x34,0x21,0x40,0x24,0xFB,	/* 2D40: u4!@$ */
	0x75,0xE4,0x72,0x23,0x4F,0x24,0xF6,0x70,	/* 2D48: ur#O$p */
	0x26,0xEB,0x73,0x42,0x24,0xF6,0x23,0x2B,	/* 2D50: &sB$#+ */
	0xA9,0x70,0x26,0x3A,0x2F,0x4F,0x24,0xF6,	/* 2D58: p&:.O$ */
	0xD2,0x72,0x43,0x24,0xF6,0x70,0x26,0xE8,	/* 2D60: rC$p& */
	0x71,0x44,0xF8,0x72,0x43,0x24,0xF6,0xF5,	/* 2D68: qDrC$ */
	0x74,0x55,0xFA,0x30,0xD5,0x75,0x22,0x87,	/* 2D70: tU0u" */
	0xF1,0xC0,0xAC,0x75,0x21,0x54,0xF1,0x42,	/* 2D78: u!TB */
	0x24,0xFB,0x75,0x21,0x54,0x23,0xFB,0x75,	/* 2D80: $u!T#u */
	0x23,0x85,0xF1,0xA9,0x75,0x7D,0x61,0x27,	/* 2D88: #u}a' */
	0x27,0x93,0x23,0x27,0x05,0x75,0x8D,0xF1,	/* 2D90: '#'.u */
	0xD9,0x75,0x56,0xF1,0xD8,0x75,0x34,0x21,	/* 2D98: uVu4! */
	0x20,0x40,0x24,0xF6,0x22,0xA2,0x75,0x34,	/* 2DA0:  @$"u4 */
	0x61,0x2F,0x4F,0x24,0xF6,0x75,0xE4,0x75,	/* 2DA8: a.O$uu */
	0x34,0x22,0x20,0x40,0x24,0xFB,0x75,0xE4,	/* 2DB0: 4" @$u */
	0x75,0x34,0x60,0x4E,0x24,0xF6,0x75,0xE4,	/* 2DB8: u4`N$u */
	0x70,0x36,0x2F,0x49,0x24,0xF6,0x70,0xE6,	/* 2DC0: p6.I$p */
	0x79,0x78,0xFC,0x2F,0x4F,0x24,0xF6,0xD7,	/* 2DC8: yx.O$ */
	0x77,0x22,0x40,0xF9,0xA4,0x22,0x40,0xDA,	/* 2DD0: w"@"@ */
	0x02,0x77,0xDA,0x7A,0x2F,0x4F,0x24,0xF6,	/* 2DD8: .wz.O$ */
	0x41,0xF4,0xDA,0x41,0x22,0x40,0x7A,0x24,	/* 2DE0: AA"@z$ */
	0xFF,0xF0,0xC0,0x22,0x2C,0xA4,0x7A,0x44,	/* 2DE8: ",zD */
	0xF8,0x42,0x21,0xFB,0xF2,0xF6,0x22,0x2A,	/* 2DF0: B!"* */
	0x07,0x20,0x22,0x29,0x01,0x20,0x22,0x27,	/* 2DF8: . "). "' */
	0x0B,0x20,0x22,0x26,0x05,0x20,0x22,0x24,	/* 2E00: . "&. "$ */
	0x0F,0x20,0x22,0x23,0x09,0x20,0x22,0x22,	/* 2E08: . "#. "" */
	0x03,0x20,0x22,0x20,0x0D,0x20,0x21,0x2F,	/* 2E10: . " . !. */
	0x07,0x20,0x21,0x2E,0x01,0x20,0x21,0x2C,	/* 2E18: . !.. !, */
	0x0B,0x20,0x21,0x2B,0x05,0x20,0x21,0x29,	/* 2E20: . !+. !) */
	0x0F,0x20,0x21,0x28,0x09,0x20,0x21,0x27,	/* 2E28: . !(. !' */
	0x03,0x20,0x21,0x25,0x0D,0x20,0x21,0x24,	/* 2E30: . !%. !$ */
	0x07,0x20,0x21,0x23,0x01,0x20,0x21,0x21,	/* 2E38: . !#. !! */
	0x0B,0x20,0x21,0x20,0x05,0x20,0x2F,0x00,	/* 2E40: . ! . .. */
	0x20,0x20,0x2D,0x0A,0x20,0x20,0x2C,0x04,	/* 2E48:   -.  ,. */
	0x20,0x20,0x2A,0x0E,0x20,0x20,0x29,0x08,	/* 2E50:   *.  ). */
	0x20,0x20,0x28,0x02,0x20,0x20,0x26,0x0C,	/* 2E58:   (.  &. */
	0x20,0x20,0x25,0x06,0x20,0x20,0x24,0x00,	/* 2E60:   %.  $. */
	0x20,0x20,0x22,0x0A,0x20,0x20,0x21,0x04,	/* 2E68:   ".  !. */
	0x20,0x20,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 2E70:   xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 2E78: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 2E80: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 2E88: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 2E90: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 2E98: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 2EA0: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 2EA8: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 2EB0: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 2EB8: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 2EC0: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 2EC8: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 2ED0: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 2ED8: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 2EE0: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 2EE8: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 2EF0: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 2EF8: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 2F00: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 2F08: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 2F10: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 2F18: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 2F20: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 2F28: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 2F30: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 2F38: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 2F40: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 2F48: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 2F50: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 2F58: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 2F60: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 2F68: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 2F70: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 2F78: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 2F80: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 2F88: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 2F90: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 2F98: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 2FA0: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 2FA8: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 2FB0: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 2FB8: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 2FC0: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 2FC8: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 2FD0: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 2FD8: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 2FE0: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 2FE8: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 2FF0: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 2FF8: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 3000: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3008: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3010: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3018: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 3020: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3028: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 3030: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 3038: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 3040: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 3048: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3050: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3058: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3060: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 3068: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3070: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 3078: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 3080: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 3088: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 3090: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3098: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 30A0: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 30A8: z.O$p */
	0x26,0xE3,0x79,0x78,0xFC,0x2F,0x4F,0x24,	/* 30B0: &yx.O$ */
	0xF6,0xD9,0x78,0x75,0x56,0x23,0xFB,0x77,	/* 30B8: xuV#w */
	0x2C,0x40,0xF9,0x21,0xA0,0x2C,0x41,0x79,	/* 30C0: ,@!,Ay */
	0xF9,0xAB,0x75,0x34,0x28,0x20,0x40,0x24,	/* 30C8: u4( @$ */
	0xFB,0x75,0xE4,0x22,0x01,0x77,0x24,0x40,	/* 30D0: u".w$@ */
	0xF9,0x21,0xAB,0x24,0x41,0x79,0xF9,0x21,	/* 30D8: !$Ay! */
	0xA5,0x75,0x34,0x28,0x20,0x40,0x24,0xF6,	/* 30E0: u4( @$ */
	0xAD,0x75,0x34,0x68,0x2F,0x4F,0x24,0xF6,	/* 30E8: u4h.O$ */
	0x75,0xE4,0x41,0x76,0x62,0xE7,0x79,0xC0,	/* 30F0: uAvby */
	0x21,0xA0,0x75,0x34,0x60,0x4E,0x24,0xF6,	/* 30F8: !u4`N$ */
	0x75,0xE4,0x70,0x36,0x2F,0x49,0x24,0xF6,	/* 3100: up6.I$ */
	0x70,0xE6,0x72,0x23,0x4F,0x24,0xF6,0x70,	/* 3108: pr#O$p */
	0x26,0xEA,0x73,0x44,0x24,0xF6,0x24,0xAC,	/* 3110: &sD$$ */
	0x70,0x26,0x39,0x2F,0x4F,0x24,0xF6,0xD2,	/* 3118: p&9.O$ */
	0x72,0x43,0x24,0xF6,0x70,0x26,0xE8,0x71,	/* 3120: rC$p&q */
	0x44,0xF8,0x72,0x43,0x24,0xF6,0xF5,0x74,	/* 3128: DrC$t */
	0x55,0xFA,0x30,0xD5,0x75,0x7D,0x61,0x25,	/* 3130: U0u}a% */
	0x27,0x99,0x75,0x22,0x87,0xF1,0xC0,0xAC,	/* 3138: 'u" */
	0x75,0x21,0x54,0xF1,0x44,0x24,0xFB,0x75,	/* 3140: u!TD$u */
	0x21,0x54,0x23,0xFB,0x41,0x76,0x62,0xE7,	/* 3148: !T#Avb */
	0x75,0x21,0x89,0xF1,0x42,0x24,0xFB,0x75,	/* 3150: u!B$u */
	0x21,0x89,0x23,0xFB,0x72,0x23,0x4F,0x24,	/* 3158: !#r#O$ */
	0xF6,0x70,0x26,0xE9,0x71,0x81,0x2F,0x4F,	/* 3160: p&q.O */
	0x24,0xF6,0xD1,0x71,0x41,0xF9,0x21,0xA2,	/* 3168: $qA! */
	0x40,0xD1,0x74,0x30,0xAA,0x74,0x30,0x27,	/* 3170: @t0t0' */
	0x2F,0x2F,0x4F,0x24,0xF6,0xD4,0x03,0x28,	/* 3178: ..O$.( */
	0x40,0xD4,0x73,0xC0,0x21,0xA0,0x74,0x76,	/* 3180: @s!tv */
	0x30,0xF4,0xC0,0x68,0x21,0xAD,0x71,0x76,	/* 3188: 0h!qv */
	0x31,0xF4,0xA3,0x68,0x21,0x05,0x74,0x76,	/* 3190: 1h!.tv */
	0xE0,0x71,0x76,0xE1,0xBC,0x22,0xF0,0x76,	/* 3198: qv"v */
	0xF6,0x80,0x20,0x3A,0x08,0x71,0x23,0x5A,	/* 31A0:  :.q#Z */
	0xD2,0x60,0x44,0x21,0xFB,0x72,0x41,0x24,	/* 31A8: `D!rA$ */
	0xFA,0x22,0xF0,0x60,0xBF,0x73,0x31,0x21,	/* 31B0: "`s1! */
	0x20,0x20,0x40,0x24,0xFB,0xD0,0x70,0x21,	/* 31B8:   @$p! */
	0x40,0x24,0xF6,0x21,0xA2,0x70,0x61,0x4F,	/* 31C0: @$!paO */
	0x24,0xF6,0x3D,0x2F,0x4F,0x24,0xF6,0x23,	/* 31C8: $=.O$# */
	0xF2,0x41,0x24,0xF0,0xB1,0x22,0xF0,0x70,	/* 31D0: A$"p */
	0x61,0x4F,0x24,0xF6,0x3D,0x2F,0x4F,0x24,	/* 31D8: aO$=.O$ */
	0xF6,0x23,0xF2,0x41,0x24,0xF1,0xB1,0x22,	/* 31E0: #A$" */
	0xF0,0x60,0xBE,0x74,0x31,0x21,0x20,0x20,	/* 31E8: `t1!   */
	0x40,0x24,0xFB,0xD1,0x74,0x32,0x27,0x2F,	/* 31F0: @$t2'. */
	0x2F,0x4F,0x24,0xF6,0xD0,0x75,0x41,0xF4,	/* 31F8: .O$uA */
	0xAF,0x74,0x8F,0xF1,0x23,0xF2,0x70,0x52,	/* 3200: t#pR */
	0xF1,0x24,0xF6,0x70,0x52,0x23,0xFB,0x0C,	/* 3208: $pR#. */
	0x70,0x52,0xF1,0x74,0x8F,0xF1,0x24,0xFB,	/* 3210: pRt$ */
	0x70,0x52,0x23,0xFB,0x70,0x52,0xF1,0x23,	/* 3218: pR#pR# */
	0xF2,0x71,0x6F,0x40,0x24,0xF6,0x28,0x40,	/* 3220: qo@$(@ */
	0x24,0xFB,0xE0,0xB2,0x22,0xF0,0x60,0xB8,	/* 3228: $"` */
	0x7A,0x31,0x21,0x20,0x20,0x40,0x24,0xFB,	/* 3230: z1!  @$ */
	0xD2,0x7A,0x55,0xF1,0xD4,0x7A,0x8B,0xF1,	/* 3238: zUz */
	0xD6,0x74,0x76,0xFC,0x2F,0x4F,0x24,0xF6,	/* 3240: tv.O$ */
	0xD7,0x7C,0x30,0xD3,0x7A,0x22,0x81,0xF1,	/* 3248: |0z" */
	0xD5,0x40,0xD1,0x24,0x40,0x72,0xE2,0x72,	/* 3250: @$@rr */
	0x33,0x2F,0x4F,0x24,0xF6,0x7A,0x22,0x83,	/* 3258: 3.O$z" */
	0xF1,0x24,0xF6,0xD0,0x70,0xC0,0x23,0xAD,	/* 3260: $p# */
	0x7B,0x28,0x40,0x24,0xF6,0x23,0xA6,0x75,	/* 3268: {(@$#u */
	0x41,0x24,0xF6,0xA4,0x41,0xD1,0x22,0x0D,	/* 3270: A$A". */
	0x75,0x42,0x24,0xF6,0x21,0xA4,0x7A,0x21,	/* 3278: uB$!z! */
	0x89,0xF1,0x41,0x24,0xFB,0x7A,0x21,0x89,	/* 3280: A$z! */
	0x23,0xFB,0x41,0x79,0x21,0xE1,0x41,0xD1,	/* 3288: #Ay!A */
	0x21,0x03,0x74,0xD1,0x74,0x81,0xD4,0x40,	/* 3290: !.tt@ */
	0x71,0x2F,0x4F,0x24,0xF6,0x7A,0x2B,0x50,	/* 3298: q.O$z+P */
	0xF2,0x23,0xFB,0x41,0xD1,0x73,0x42,0x24,	/* 32A0: #AsB$ */
	0xF6,0x26,0xAE,0x73,0x44,0x24,0xF6,0xAE,	/* 32A8: &sD$ */
	0x73,0x41,0x24,0xF6,0xC0,0x21,0xAB,0x7A,	/* 32B0: sA$!z */
	0x58,0xF1,0x70,0xF4,0x21,0xA4,0x7A,0x58,	/* 32B8: Xp!zX */
	0xF1,0x70,0xF4,0xC0,0x23,0xA5,0x7A,0x21,	/* 32C0: p#z! */
	0x81,0xF1,0x70,0xF4,0x22,0xAD,0x41,0xD1,	/* 32C8: p"A */
	0x22,0x09,0x73,0x60,0x4B,0x24,0xF6,0xD3,	/* 32D0: ".s`K$ */
	0x73,0x24,0x25,0x40,0x24,0xF6,0xC0,0xAA,	/* 32D8: s$%@$ */
	0x7A,0x31,0x21,0x20,0x20,0x40,0x24,0xFB,	/* 32E0: z1!  @$ */
	0x7A,0xE1,0x7A,0x58,0xF1,0x70,0xF4,0xA9,	/* 32E8: zzXp */
	0x7A,0x21,0x81,0xF1,0x70,0xF4,0xC0,0xA3,	/* 32F0: z!p */
	0x20,0x41,0xD1,0x7A,0x21,0x81,0xF1,0x70,	/* 32F8:  Az!p */
	0xF4,0xC0,0x21,0xA5,0x71,0xC0,0x21,0xA1,	/* 3300: !q! */
	0x73,0x44,0x24,0xFB,0xD3,0x7A,0x31,0x61,	/* 3308: sD$z1a */
	0x2F,0x2F,0x4F,0x24,0xF6,0x7A,0xE1,0x41,	/* 3310: ..O$zA */
	0xD1,0x7B,0x27,0x40,0x24,0xF6,0x26,0xA3,	/* 3318: {'@$& */
	0x71,0xC0,0x25,0xAF,0x73,0x67,0x20,0x20,	/* 3320: q%sg   */
	0x40,0x24,0xF6,0x25,0xA6,0x75,0x48,0x24,	/* 3328: @$%uH$ */
	0xF6,0xA5,0x20,0x41,0xD1,0x27,0x0B,0x75,	/* 3330:  A'.u */
	0x44,0x24,0xF6,0x23,0xA1,0x2F,0x4F,0x74,	/* 3338: D$#.Ot */
	0x2F,0x4F,0x24,0xF6,0x7A,0x2B,0x50,0xF2,	/* 3340: .O$z+P */
	0x23,0xFB,0x40,0x74,0x81,0x2F,0x4F,0x24,	/* 3348: #@t.O$ */
	0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,0x74,	/* 3350: z+P#t */
	0x81,0x81,0xD1,0x71,0x81,0xD4,0x70,0x71,	/* 3358: qpq */
	0x2F,0x4F,0x24,0xF6,0x7A,0x2B,0x50,0xF2,	/* 3360: .O$z+P */
	0x23,0xFB,0x41,0xD1,0x24,0x04,0x74,0xD1,	/* 3368: #A$.t */
	0x74,0x81,0xD4,0x40,0x71,0x2F,0x4F,0x24,	/* 3370: t@q.O$ */
	0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,0x41,	/* 3378: z+P#A */
	0xD1,0x22,0x0F,0x70,0x2F,0x4F,0xF4,0xC0,	/* 3380: ".p.O */
	0x22,0xA8,0x75,0x44,0x24,0xF6,0x22,0xA2,	/* 3388: "uD$" */
	0x2F,0x4F,0x74,0x2F,0x4F,0x24,0xF6,0x7A,	/* 3390: .Ot.O$z */
	0x2B,0x50,0xF2,0x23,0xFB,0x74,0x81,0xD1,	/* 3398: +P#t */
	0x71,0x81,0xD4,0x2F,0x4F,0x71,0x2F,0x4F,	/* 33A0: q.Oq.O */
	0x24,0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,	/* 33A8: $z+P# */
	0x41,0xD1,0x71,0xC0,0x22,0xA6,0x41,0x74,	/* 33B0: Aq"At */
	0x76,0xFC,0x2F,0x4F,0x24,0xF6,0x2F,0x4E,	/* 33B8: v.O$.N */
	0xF0,0x24,0xFF,0xF0,0xC0,0x21,0xA5,0x74,	/* 33C0: $!t */
	0xD1,0x74,0x81,0xD4,0x70,0x71,0x2F,0x4F,	/* 33C8: tpq.O */
	0x24,0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,	/* 33D0: $z+P# */
	0x41,0x79,0x21,0xE2,0x72,0x31,0x2F,0x4F,	/* 33D8: Ay!r1.O */
	0x24,0xF6,0xDB,0x7B,0x41,0x24,0xF6,0xA3,	/* 33E0: ${A$ */
	0x61,0x26,0x06,0x2C,0x40,0x77,0xF9,0x25,	/* 33E8: a&.,@w% */
	0xAB,0x41,0x74,0x76,0xFC,0x2F,0x4F,0x24,	/* 33F0: Atv.O$ */
	0xF6,0x2B,0x4F,0x24,0xFF,0xF0,0xC0,0x24,	/* 33F8: +O$$ */
	0xAB,0x73,0x48,0x24,0xF6,0x24,0xA5,0x7A,	/* 3400: sH$$z */
	0x21,0x58,0xF1,0x48,0x24,0xF6,0x21,0xAE,	/* 3408: !XH$! */
	0x73,0x22,0x40,0x24,0xF6,0xA8,0x73,0x64,	/* 3410: s"@$sd */
	0x4F,0x24,0xF6,0xD3,0x21,0x00,0x73,0x2D,	/* 3418: O$!.s- */
	0x40,0x24,0xFB,0xD3,0x7A,0x31,0x61,0x2F,	/* 3420: @$z1a. */
	0x2F,0x4F,0x24,0xF6,0x7A,0xE1,0x7A,0x23,	/* 3428: .O$zz# */
	0x81,0xF1,0x28,0x40,0x24,0xF6,0x21,0xA4,	/* 3430: (@$! */
	0x29,0x40,0x72,0xE2,0x73,0x21,0x40,0x24,	/* 3438: )@rs!@$ */
	0xFB,0xD3,0x7A,0x31,0x61,0x2F,0x2F,0x4F,	/* 3440: z1a..O */
	0x24,0xF6,0x7A,0xE1,0x74,0x7A,0x55,0x23,	/* 3448: $ztzU# */
	0xFB,0x73,0x7C,0xE0,0xB8,0x22,0xF0,0x60,	/* 3450: s|"` */
	0xB8,0x79,0x23,0x5C,0xD5,0x21,0x28,0x40,	/* 3458: y#\!(@ */
	0xD1,0x71,0x21,0x37,0xD1,0x71,0x57,0xF1,	/* 3460: q!7qW */
	0xD0,0x70,0xAC,0x70,0x75,0xFA,0x30,0xD0,	/* 3468: ppu0 */
	0x71,0x79,0x25,0x24,0x95,0x61,0xAA,0x71,	/* 3470: qy%$aq */
	0x31,0xD2,0x72,0x21,0x20,0x20,0x40,0x24,	/* 3478: 1r!  @$ */
	0xF6,0x27,0xA9,0x72,0x31,0x2F,0x4F,0x24,	/* 3480: 'r1.O$ */
	0xF6,0xD3,0x73,0x44,0x24,0xF6,0x25,0xA9,	/* 3488: sD$% */
	0x71,0x56,0xF1,0xD0,0x71,0x8D,0xF1,0x70,	/* 3490: qVqp */
	0xF4,0xD6,0x76,0x24,0xAC,0x70,0x71,0x23,	/* 3498: v$pq# */
	0x50,0xF2,0xF1,0x72,0xE3,0x70,0x41,0xF2,	/* 34A0: PrpA */
	0x71,0x56,0x23,0xFB,0x76,0x23,0x4F,0x24,	/* 34A8: qV#v#O$ */
	0xF6,0xC0,0x23,0xA5,0x76,0x2F,0x4F,0x24,	/* 34B0: #v.O$ */
	0xF6,0x2C,0x40,0xF4,0x22,0xA2,0x76,0x2F,	/* 34B8: ,@"v. */
	0x4F,0x24,0xF6,0x24,0x40,0xF4,0xC0,0x22,	/* 34C0: O$$@" */
	0xA0,0x71,0x34,0x28,0x20,0x40,0x24,0xF6,	/* 34C8: q4( @$ */
	0x21,0xA7,0x71,0x34,0x68,0x2F,0x4F,0x24,	/* 34D0: !q4h.O$ */
	0xF6,0x71,0xE4,0x41,0x75,0x62,0xE5,0x09,	/* 34D8: qAub. */
	0x71,0x34,0x28,0x20,0x40,0x24,0xFB,0x71,	/* 34E0: q4( @$q */
	0xE4,0x73,0x41,0x24,0xF6,0x21,0x25,0xA3,	/* 34E8: sA$!% */
	0x71,0x54,0xD0,0x73,0x71,0x79,0x62,0x23,	/* 34F0: qTsqyb# */
	0x95,0x21,0x24,0x07,0x71,0x34,0xD4,0x72,	/* 34F8: !$.q4r */
	0x21,0x20,0x20,0x40,0x24,0xFB,0xD2,0x72,	/* 3500: !  @$r */
	0x31,0x2F,0x4F,0x24,0xF6,0xD3,0x73,0x44,	/* 3508: 1.O$sD */
	0x24,0xF6,0x2C,0xA6,0x74,0x24,0x40,0x24,	/* 3510: $,t$@$ */
	0xF6,0x22,0xAA,0x74,0x28,0x40,0x24,0xF6,	/* 3518: "t(@$ */
	0x21,0xA6,0x71,0x21,0x83,0xF1,0x72,0xE3,	/* 3520: !q!r */
	0x74,0x22,0x40,0x24,0xFB,0xD0,0x70,0xD4,	/* 3528: t"@$p */
	0x70,0x6C,0x4F,0x24,0xF6,0xD4,0x2A,0x02,	/* 3530: plO$*. */
	0x71,0x59,0xF1,0x72,0xE3,0x74,0x67,0x4F,	/* 3538: qYrtgO */
	0x24,0xF6,0xD4,0x29,0x05,0x74,0x44,0x24,	/* 3540: $).tD$ */
	0xF6,0xC0,0x28,0xAE,0x71,0x56,0xF1,0xD0,	/* 3548: (qV */
	0x71,0x8D,0xF1,0x70,0xF4,0xD6,0x76,0x28,	/* 3550: qpv( */
	0xA1,0x70,0x71,0x23,0x50,0xF2,0xF1,0xD7,	/* 3558: pq#P */
	0x77,0x4A,0xF4,0xC0,0x22,0xAB,0x74,0x24,	/* 3560: wJ"t$ */
	0x20,0x40,0x24,0xF6,0x22,0xA3,0x74,0x21,	/* 3568:  @$"t! */
	0x20,0x40,0x24,0xF6,0x21,0xA0,0x77,0x72,	/* 3570:  @$!wr */
	0xE3,0x74,0x61,0x2F,0x4F,0x24,0xF6,0xD4,	/* 3578: ta.O$ */
	0x70,0x41,0xF2,0xD0,0x21,0x02,0x4D,0x72,	/* 3580: pA!.Mr */
	0xE3,0x74,0x21,0x20,0x40,0x24,0xFB,0xD4,	/* 3588: t! @$ */
	0x07,0x77,0x72,0xE3,0x70,0x41,0xF2,0xD0,	/* 3590: .wrpA */
	0x70,0x71,0x56,0x23,0xFB,0x76,0x23,0x4F,	/* 3598: pqV#v#O */
	0x24,0xF6,0xC0,0x23,0xA5,0x76,0x2F,0x4F,	/* 35A0: $#v.O */
	0x24,0xF6,0x2C,0x40,0xF4,0x22,0xA2,0x76,	/* 35A8: $,@"v */
	0x2F,0x4F,0x24,0xF6,0x24,0x40,0xF4,0xC0,	/* 35B0: .O$$@ */
	0x22,0xA0,0x71,0x34,0x28,0x20,0x40,0x24,	/* 35B8: "q4( @$ */
	0xF6,0x21,0xA7,0x71,0x34,0x68,0x2F,0x4F,	/* 35C0: !q4h.O */
	0x24,0xF6,0x71,0xE4,0x41,0x75,0x62,0xE5,	/* 35C8: $qAub */
	0x09,0x71,0x34,0x28,0x20,0x40,0x24,0xFB,	/* 35D0: .q4( @$ */
	0x71,0xE4,0x73,0x41,0x24,0xF6,0xA8,0x14,	/* 35D8: qsA$. */
	0xD0,0x73,0x71,0x79,0x63,0x24,0x97,0x74,	/* 35E0: sqyc$t */
	0x21,0x40,0x24,0xF6,0x25,0xA2,0x41,0x71,	/* 35E8: !@$%Aq */
	0x55,0xF1,0x71,0x8B,0xF1,0xFC,0x2F,0x4F,	/* 35F0: Uq.O */
	0x24,0xF6,0x24,0x40,0xF0,0x24,0xFF,0xF0,	/* 35F8: $$@$ */
	0xC0,0x23,0xAD,0x74,0x28,0x40,0x24,0xF6,	/* 3600: #t(@$ */
	0xA6,0x74,0x6C,0x4F,0x24,0xF6,0xD4,0x74,	/* 3608: tlO$t */
	0x22,0x40,0x24,0xF6,0xA6,0x74,0x24,0x40,	/* 3610: "@$t$@ */
	0x24,0xFB,0xD4,0x71,0x23,0x81,0xF1,0x28,	/* 3618: $q#( */
	0x40,0x24,0xF6,0xA4,0x28,0x40,0x72,0xE2,	/* 3620: @$(@r */
	0x74,0x61,0x4F,0x24,0xF6,0xD4,0x74,0x24,	/* 3628: taO$t$ */
	0x24,0x44,0x24,0xF6,0xC0,0xAA,0x71,0x31,	/* 3630: $D$q1 */
	0x21,0x20,0x20,0x40,0x24,0xFB,0x71,0xE1,	/* 3638: !  @$q */
	0x74,0x71,0xE4,0x61,0x21,0x0B,0x60,0xBD,	/* 3640: tqa!.` */
	0x75,0x31,0x21,0x20,0x20,0x40,0x24,0xFB,	/* 3648: u1!  @$ */
	0xD1,0x75,0x34,0xD2,0x72,0xD0,0x75,0x21,	/* 3650: u4ru! */
	0x8F,0xF1,0xA7,0x40,0x75,0x21,0x8F,0x23,	/* 3658: @u!# */
	0xFB,0x07,0x71,0x31,0x48,0x24,0xF6,0x27,	/* 3660: .q1H$' */
	0xA4,0x75,0x57,0xF1,0x48,0xF4,0xC0,0x22,	/* 3668: uWH" */
	0xA0,0x75,0x5A,0xF1,0x75,0x23,0x81,0xF1,	/* 3670: uZu# */
	0xF4,0xC0,0x21,0xA5,0x75,0x21,0x85,0xF1,	/* 3678: !u! */
	0x75,0x21,0x59,0xF1,0xF4,0xC0,0xAA,0x75,	/* 3680: u!Yu */
	0x5B,0xF1,0x75,0x22,0x8D,0xF1,0xF4,0x23,	/* 3688: [u"# */
	0xA0,0x21,0x4A,0x71,0xE2,0x75,0x5A,0xF1,	/* 3690: !JquZ */
	0x71,0xE0,0x75,0x21,0x85,0xF1,0x71,0xE0,	/* 3698: qu!q */
	0x75,0x5B,0xF1,0x71,0xE1,0x75,0x5A,0xF1,	/* 36A0: u[quZ */
	0x75,0x23,0x81,0x23,0xFB,0x75,0x21,0x85,	/* 36A8: u##u! */
	0xF1,0x75,0x21,0x59,0x23,0xFB,0x75,0x5B,	/* 36B0: u!Y#u[ */
	0xF1,0x75,0x22,0x8D,0x23,0xFB,0x45,0x71,	/* 36B8: u"#Eq */
	0xE2,0x75,0x21,0x87,0xF1,0x41,0x24,0xF6,	/* 36C0: u!A$ */
	0xAF,0x70,0x21,0x40,0x24,0xF6,0x21,0xA1,	/* 36C8: p!@$! */
	0x75,0x5A,0xF1,0x28,0x40,0x24,0xF6,0xA9,	/* 36D0: uZ(@$ */
	0x29,0x40,0x71,0xE2,0x08,0x40,0xB3,0x22,	/* 36D8: )@q.@" */
	0xF0,0x28,0x40,0x71,0xE2,0x75,0x21,0x87,	/* 36E0: (@qu! */
	0xF1,0x42,0x24,0xF6,0xA7,0x41,0x75,0x74,	/* 36E8: B$Aut */
	0x65,0x2F,0x96,0x06,0x40,0x75,0x74,0x65,	/* 36F0: e..@ute */
	0x2E,0x9F,0x40,0x75,0x21,0x89,0x23,0xFB,	/* 36F8: .@u!# */
	0x75,0x21,0x8B,0xF1,0x75,0x58,0x23,0xFB,	/* 3700: u!uX# */
	0x75,0x21,0x8D,0xF1,0x75,0x59,0x23,0xFB,	/* 3708: u!uY# */
	0x75,0x5E,0xF1,0x75,0x21,0x81,0x23,0xFB,	/* 3710: u^u!# */
	0x75,0x5F,0xF1,0x75,0x21,0x83,0x23,0xFB,	/* 3718: u_u!# */
	0x75,0x21,0x50,0xF1,0x75,0x22,0x81,0x23,	/* 3720: u!Pu"# */
	0xFB,0x75,0x21,0x51,0xF1,0x75,0x22,0x83,	/* 3728: u!Qu" */
	0x23,0xFB,0x75,0x5D,0xF1,0x75,0x21,0x58,	/* 3730: #u]u!X */
	0x23,0xFB,0x70,0x60,0x44,0x24,0xF6,0xD0,	/* 3738: #p`D$ */
	0x75,0x5D,0xF1,0x42,0x24,0xF6,0xA5,0x70,	/* 3740: u]B$p */
	0x42,0x24,0xFB,0xD0,0x75,0x5D,0xF1,0x48,	/* 3748: B$u]H */
	0x24,0xF6,0xA5,0x70,0x48,0x24,0xFB,0xD0,	/* 3750: $pH$ */
	0x75,0x5D,0xF1,0x41,0x24,0xF6,0xA5,0x70,	/* 3758: u]A$p */
	0x41,0x24,0xFB,0xD0,0x70,0x25,0x2B,0x2F,	/* 3760: A$p%+. */
	0x4F,0x24,0xF6,0xD0,0x75,0x5D,0xF1,0x44,	/* 3768: O$u]D */
	0x24,0xF6,0xA7,0x70,0x24,0x20,0x40,0x24,	/* 3770: $p$ @$ */
	0xFB,0xD0,0x75,0x5D,0xF1,0x22,0x40,0x24,	/* 3778: u]"@$ */
	0xF6,0xA8,0x70,0x22,0x20,0x20,0x40,0x24,	/* 3780: p"  @$ */
	0xFB,0xD0,0x75,0x5D,0xF1,0x28,0x40,0x24,	/* 3788: u](@$ */
	0xF6,0xA8,0x70,0x67,0x20,0x20,0x40,0x24,	/* 3790: pg  @$ */
	0xFB,0xD0,0x75,0x5A,0xF1,0x28,0x40,0x24,	/* 3798: uZ(@$ */
	0xF6,0xA5,0x70,0x48,0x24,0xFB,0xD0,0x75,	/* 37A0: pH$u */
	0x5D,0xF1,0x24,0x40,0x24,0xF6,0xA5,0x70,	/* 37A8: ]$@$p */
	0x48,0x24,0xFB,0xD0,0x72,0x24,0x20,0x40,	/* 37B0: H$r$ @ */
	0x24,0xF6,0xAF,0x70,0x24,0x20,0x40,0x24,	/* 37B8: $p$ @$ */
	0xF6,0xC0,0xA7,0x70,0x61,0x2F,0x4F,0x24,	/* 37C0: pa.O$ */
	0xF6,0xD0,0x72,0x42,0x24,0xF6,0xAC,0x70,	/* 37C8: rB$p */
	0x42,0x24,0xF6,0xC0,0xA6,0x70,0x60,0x4B,	/* 37D0: B$p`K */
	0x24,0xF6,0xD0,0x75,0x23,0x81,0xF1,0x28,	/* 37D8: $u#( */
	0x40,0x24,0xF6,0xA5,0x70,0x48,0x24,0xFB,	/* 37E0: @$pH$ */
	0xD0,0x70,0x24,0x25,0x44,0x24,0xF6,0xAB,	/* 37E8: p$%D$ */
	0x75,0x31,0x61,0x2F,0x2F,0x4F,0x24,0xF6,	/* 37F0: u1a..O$ */
	0x75,0xE1,0x0A,0x75,0x31,0x21,0x20,0x20,	/* 37F8: u.u1!   */
	0x40,0x24,0xFB,0x75,0xE1,0x22,0x44,0x75,	/* 3800: @$u"Du */
	0x5C,0x23,0xFB,0x75,0x57,0xF1,0x44,0xF4,	/* 3808: \#uWD */
	0xA6,0x40,0x75,0x57,0x23,0xFB,0x03,0x75,	/* 3810: @uW#.u */
	0x74,0x9B,0x70,0x75,0xE4,0x41,0x74,0x21,	/* 3818: tpuAt! */
	0xE1,0x40,0xB3,0x22,0xF0,0x72,0x71,0x66,	/* 3820: @"rqf */
	0x28,0x99,0x44,0x24,0xF6,0xAA,0x40,0x72,	/* 3828: (D$@r */
	0x57,0x23,0xFB,0x41,0x71,0x21,0xE1,0x05,	/* 3830: W#Aq!. */
	0x46,0x72,0x57,0x23,0xFB,0x40,0x22,0xF0,	/* 3838: FrW#@" */
	0x60,0xBF,0x73,0x31,0x21,0x20,0x20,0x40,	/* 3840: `s1!  @ */
	0x24,0xFB,0xD0,0x73,0x8D,0xF1,0x73,0x56,	/* 3848: $ssV */
	0xF1,0xF4,0xC0,0xAF,0x70,0x30,0x2F,0x4F,	/* 3850: p0.O */
	0x24,0xF6,0xA8,0x73,0x72,0x23,0x95,0x40,	/* 3858: $sr#@ */
	0xB1,0x22,0xF0,0x41,0xB1,0x22,0xF0,0x26,	/* 3860: "A"& */
	0x40,0x72,0x31,0x21,0x20,0x20,0x40,0x24,	/* 3868: @r1!  @$ */
	0xFB,0xE2,0x21,0x42,0x72,0x57,0x23,0xFB,	/* 3870: !BrW# */
	0x40,0x22,0xF0,0x27,0x45,0x72,0x31,0x21,	/* 3878: @"'Er1! */
	0x20,0x20,0x40,0x24,0xFB,0xE2,0x40,0x72,	/* 3880:   @$@r */
	0x57,0x23,0xFB,0x40,0x22,0xF0,0x40,0x22,	/* 3888: W#@"@" */
	0xF0,0x40,0x22,0xF0,0x60,0xBF,0x73,0x31,	/* 3890: @"`s1 */
	0x21,0x20,0x20,0x40,0x24,0xFB,0xD0,0x40,	/* 3898: !  @$@ */
	0x73,0x56,0x23,0xFB,0x40,0x73,0x8D,0x23,	/* 38A0: sV#@s# */
	0xFB,0x40,0x73,0x8B,0x23,0xFB,0x40,0x73,	/* 38A8: @s#@s */
	0x55,0x23,0xFB,0x73,0x21,0x59,0xF1,0x21,	/* 38B0: U#s!Y! */
	0x40,0x24,0xF6,0xAA,0x73,0x21,0x59,0xF1,	/* 38B8: @$s!Y */
	0x61,0x4F,0x24,0xF6,0x70,0xE0,0x70,0x31,	/* 38C0: aO$pp1 */
	0x48,0x24,0xF6,0x23,0xAB,0x73,0x21,0x87,	/* 38C8: H$#s! */
	0xF1,0x41,0x24,0xF6,0xC0,0xA4,0x29,0x40,	/* 38D0: A$)@ */
	0x70,0xE2,0x73,0x21,0x87,0xF1,0x42,0x24,	/* 38D8: ps!B$ */
	0xF6,0xC0,0xA6,0x40,0x73,0x72,0x66,0x20,	/* 38E0: @srf  */
	0x90,0x40,0x73,0xE4,0x23,0x40,0x70,0xE2,	/* 38E8: @s#@p */
	0x22,0x40,0x70,0xE2,0x41,0x73,0x21,0x8F,	/* 38F0: "@pAs! */
	0x23,0xFB,0x21,0x40,0x73,0x57,0x23,0xFB,	/* 38F8: #!@sW# */
	0x41,0x72,0x21,0xE1,0x40,0xB1,0x22,0xF0,	/* 3900: Ar!@" */
	0x40,0xB1,0x22,0xF0,0x72,0x34,0x46,0x24,	/* 3908: @"r4F$ */
	0xF6,0x46,0xF4,0xC0,0x21,0xAB,0x72,0x34,	/* 3910: F!r4 */
	0x60,0x4B,0x24,0xF6,0x72,0xE4,0x72,0x34,	/* 3918: `K$rr4 */
	0x24,0x25,0x40,0x24,0xF6,0xC0,0xAA,0x72,	/* 3920: $%@$r */
	0x31,0x21,0x20,0x20,0x40,0x24,0xFB,0x72,	/* 3928: 1!  @$r */
	0xE1,0x40,0x72,0x57,0x23,0xFB,0x41,0x71,	/* 3930: @rW#Aq */
	0x21,0xE1,0x40,0x22,0xF0,0x60,0xBF,0x73,	/* 3938: !@"`s */
	0x31,0x21,0x20,0x20,0x40,0x24,0xFB,0xD0,	/* 3940: 1!  @$ */
	0x73,0x8D,0xF1,0x73,0x56,0x23,0xFB,0x73,	/* 3948: ssV#s */
	0x34,0x68,0x2F,0x4F,0x24,0xF6,0x73,0xE4,	/* 3950: 4h.O$s */
	0x73,0x21,0x59,0xF1,0x21,0x40,0x24,0xF6,	/* 3958: s!Y!@$ */
	0x21,0xA1,0x73,0x72,0x67,0x24,0x9C,0x42,	/* 3960: !srg$B */
	0x24,0xF6,0xC0,0xA7,0x23,0x40,0x70,0xE2,	/* 3968: $#@p */
	0x44,0x70,0xE2,0x73,0x72,0x66,0x95,0x40,	/* 3970: Dpsrf@ */
	0xB1,0x22,0xF0,0x72,0x8B,0xF1,0x72,0x55,	/* 3978: "rrU */
	0x23,0xFB,0x40,0x72,0x57,0x23,0xFB,0x41,	/* 3980: #@rW#A */
	0x71,0x21,0xE1,0x40,0x22,0xF0,0x72,0x34,	/* 3988: q!@"r4 */
	0x42,0x24,0xF6,0x21,0xA1,0x72,0x34,0x44,	/* 3990: B$!r4D */
	0x24,0xFB,0x72,0xE4,0x72,0x31,0x61,0x2F,	/* 3998: $rr1a. */
	0x2F,0x4F,0x24,0xF6,0x72,0xE1,0x40,0x72,	/* 39A0: .O$r@r */
	0x57,0x23,0xFB,0x41,0x71,0x21,0xE1,0x40,	/* 39A8: W#Aq!@ */
	0x22,0xF0,0x40,0x72,0x57,0x23,0xFB,0x40,	/* 39B0: "@rW#@ */
	0x22,0xF0,0x74,0xF6,0x20,0x1D,0x00,0x1B,	/* 39B8: "t ... */
	0x00,0x19,0x00,0x17,0x00,0x15,0x00,0x13,	/* 39C0: ........ */
	0x00,0x11,0x00,0x0F,0x00,0x0D,0x00,0x0B,	/* 39C8: ........ */
	0x00,0x09,0x00,0x07,0x00,0x05,0x00,0x03,	/* 39D0: ........ */
	0x00,0x01,0x00,0x00,0x00,0xF4,0x00,0x71,	/* 39D8: ......q */
	0x23,0x5C,0xD2,0x63,0x4B,0x21,0xFB,0x72,	/* 39E0: #\cK!r */
	0x21,0xEE,0x65,0x40,0x21,0xFB,0x72,0x21,	/* 39E8: !e@!r! */
	0xEC,0x67,0x46,0x21,0xFB,0x72,0x21,0xEA,	/* 39F0: gF!r! */
	0x6B,0x41,0x21,0xFB,0x72,0x21,0xE8,0x6F,	/* 39F8: kA!r!o */
	0x49,0x21,0xFB,0x72,0x21,0xE6,0x61,0x28,	/* 3A00: I!r!a( */
	0x49,0x21,0xFB,0x72,0x21,0xE4,0x61,0x27,	/* 3A08: I!r!a' */
	0x4E,0x21,0xFB,0x72,0x21,0xE2,0x61,0x27,	/* 3A10: N!r!a' */
	0x43,0x21,0xFB,0x72,0x21,0xE0,0x61,0x25,	/* 3A18: C!r!a% */
	0x48,0x21,0xFB,0x72,0xEE,0x61,0x23,0x4D,	/* 3A20: H!ra#M */
	0x21,0xFB,0x72,0xEC,0x61,0x20,0x4F,0x21,	/* 3A28: !ra O! */
	0xFB,0x72,0xEA,0x63,0x20,0x4E,0x21,0xFB,	/* 3A30: rc N! */
	0x72,0xE8,0x62,0x2E,0x46,0x21,0xFB,0x72,	/* 3A38: rb.F!r */
	0xE6,0x63,0x20,0x40,0x21,0xFB,0x72,0xE4,	/* 3A40: c @!r */
	0x64,0x2F,0x49,0x21,0xFB,0x72,0xE2,0x72,	/* 3A48: d.I!rr */
	0x69,0x49,0x21,0xFB,0x21,0x40,0x27,0x21,	/* 3A50: iI!!@'! */
	0x90,0x22,0xF0,0x60,0xBF,0x72,0x3A,0xD0,	/* 3A58: "`r: */
	0x72,0x3A,0x72,0x3B,0x72,0x3B,0x26,0x2B,	/* 3A60: r:r;r;&+ */
	0x92,0x72,0x72,0x3B,0xD2,0xD3,0xB1,0x60,	/* 3A68: rr;ӱ` */
	0xB8,0x79,0x25,0x5B,0xD5,0x7A,0x37,0x7A,	/* 3A70: y%[z7z */
	0x35,0xF4,0x75,0x21,0xEB,0x7A,0x37,0x75,	/* 3A78: 5u!z7u */
	0x21,0xEC,0x7A,0x3D,0x75,0x21,0xEF,0x7A,	/* 3A80: !z=u!z */
	0x3C,0x75,0x22,0xE0,0x41,0x75,0x22,0xE3,	/* 3A88: <u"Au" */
	0x24,0x20,0x40,0x75,0x22,0xE4,0x7A,0x75,	/* 3A90: $ @u"zu */
	0x21,0xEE,0x75,0x21,0x55,0x79,0x2B,0x26,	/* 3A98: !u!Uy+& */
	0x92,0xC0,0x22,0xA5,0x21,0xFE,0x75,0xEE,	/* 3AA0: "!u */
	0x22,0xF2,0x75,0xED,0x75,0x16,0x44,0x24,	/* 3AA8: "uu.D$ */
	0xFA,0x24,0xF2,0xD0,0x24,0xF2,0xD1,0x40,	/* 3AB0: $$@ */
	0xD2,0x24,0xF2,0xD3,0x40,0xD4,0x16,0x41,	/* 3AB8: $@.A */
	0x79,0x63,0x2A,0x24,0x96,0x79,0x2B,0x2F,	/* 3AC0: yc*$y+. */
	0x9C,0xB8,0x22,0xF0,0x20,0x00,0x20,0x01,	/* 3AC8: " . . */
	0x00,0xD4,0x01,0x71,0x25,0x5B,0xD2,0x60,	/* 3AD0: ..q%[` */
	0x42,0x21,0xFB,0x72,0xE0,0x72,0x61,0x4D,	/* 3AD8: B!rraM */
	0x21,0xFB,0x41,0x26,0x28,0x93,0x22,0xF0,	/* 3AE0: !A&(" */
	0x20,0x74,0xD1,0x23,0x2F,0x05,0x74,0xD1,	/* 3AE8:  t#..t */
	0x24,0x21,0x0C,0x11,0x72,0x42,0x23,0x2E,	/* 3AF0: $!..rB#. */
	0x9A,0x71,0x22,0xF0,0x40,0xD1,0x11,0x72,	/* 3AF8: q"@.r */
	0x41,0x23,0x2D,0x9F,0x71,0x2F,0x4F,0x24,	/* 3B00: A#-q.O$ */
	0xF6,0x22,0xF0,0x13,0x72,0x42,0x23,0x2F,	/* 3B08: ".rB#. */
	0x9E,0x22,0xF0,0x13,0x72,0x41,0x23,0x2F,	/* 3B10: ".rA#. */
	0x96,0x22,0xF0,0x60,0xBE,0x73,0x26,0x3E,	/* 3B18: "`s&> */
	0xD0,0x40,0xD1,0x73,0x27,0x36,0x24,0xF2,	/* 3B20: @s'6$ */
	0xF4,0x21,0xA4,0x73,0x27,0x36,0x74,0xF9,	/* 3B28: !s'6t */
	0xC0,0xAD,0x74,0x73,0x27,0x37,0xF9,0xC0,	/* 3B30: ts'7 */
	0xA6,0x41,0x47,0x73,0x2B,0x2A,0x9E,0x70,	/* 3B38: AGs+*p */
	0x24,0xF2,0xF4,0x21,0xAB,0x70,0x32,0x74,	/* 3B40: $!p2t */
	0xF9,0xC0,0xA9,0x70,0x33,0x70,0x32,0xF2,	/* 3B48: p3p2 */
	0x74,0xF9,0xC0,0xAA,0x70,0x30,0xD0,0x70,	/* 3B50: tp0p */
	0x24,0xF2,0xF4,0xA4,0x61,0x07,0x41,0xD1,	/* 3B58: $a.A */
	0x71,0xA6,0x41,0x47,0x73,0x2B,0x28,0x95,	/* 3B60: qAGs+( */
	0xB2,0x22,0xF0,0x60,0xBF,0x11,0xD0,0x72,	/* 3B68: "`.r */
	0x26,0x3E,0x24,0xF2,0xF4,0xC0,0x21,0xA0,	/* 3B70: &>$! */
	0x21,0x25,0x46,0x21,0xFB,0x72,0x28,0xE0,	/* 3B78: !%F!r( */
	0x22,0x26,0x45,0x21,0xFB,0x72,0x28,0xE1,	/* 3B80: "&E!r( */
	0x75,0x72,0x67,0x9F,0x76,0xA8,0x77,0x23,	/* 3B88: urgvw# */
	0xF4,0x21,0x50,0x76,0xF9,0xA4,0x41,0xB1,	/* 3B90: !PvA */
	0x22,0xF0,0x77,0x81,0xD7,0x73,0x24,0xF2,	/* 3B98: "ws$ */
	0xF4,0x26,0xAB,0x75,0x73,0xE2,0x76,0x73,	/* 3BA0: &usvs */
	0xE3,0x76,0x73,0x32,0xF5,0x60,0x5D,0x77,	/* 3BA8: vs2`]w */
	0x23,0xF4,0xFC,0x73,0xE4,0x74,0x73,0x34,	/* 3BB0: #sts4 */
	0x60,0xEF,0x74,0x73,0xE6,0x2A,0x26,0x4F,	/* 3BB8: `ts*&O */
	0x21,0xFB,0x73,0x34,0xE0,0x70,0x31,0x73,	/* 3BC0: !s4p1s */
	0x34,0xE1,0x73,0x73,0x34,0xE2,0x40,0xD0,	/* 3BC8: 4ss4@ */
	0x77,0x60,0x8F,0x40,0xF9,0x21,0xA5,0x70,	/* 3BD0: w`@!p */
	0x18,0xFA,0x30,0x70,0x83,0x73,0x34,0xFA,	/* 3BD8: .0ps4 */
	0xE0,0x70,0x81,0xD0,0x77,0x60,0x8F,0x70,	/* 3BE0: pw`p */
	0xF9,0xA2,0x61,0x0B,0x77,0x73,0xE5,0x24,	/* 3BE8: a.ws$ */
	0xF2,0x81,0x73,0xE7,0x72,0x25,0x5D,0x72,	/* 3BF0: sr%]r */
	0x2D,0x99,0x72,0x26,0x3E,0x73,0xE0,0x73,	/* 3BF8: -r&>ss */
	0x72,0x26,0xEE,0x72,0x25,0x5D,0x72,0x21,	/* 3C00: r&r%]r! */
	0x2E,0x90,0x40,0xB1,0x22,0xF0,0x41,0xB1,	/* 3C08: .@"A */
	0x22,0xF0,0x60,0xBE,0x73,0x25,0x5D,0xD1,	/* 3C10: "`s%] */
	0x71,0x73,0x2B,0x97,0x74,0x71,0x21,0x31,	/* 3C18: qs+tq!1 */
	0xF4,0xAD,0x71,0x21,0x31,0xD0,0x70,0x30,	/* 3C20: q!1p0 */
	0x24,0xF2,0xF4,0x22,0xA2,0x21,0x00,0x71,	/* 3C28: $"!.q */
	0x21,0x31,0x30,0x71,0x21,0xE1,0x71,0x73,	/* 3C30: !10q!qs */
	0x21,0x2A,0x9F,0x40,0xB2,0x22,0xF0,0x70,	/* 3C38: !*@"p */
	0x30,0x74,0xF4,0xAB,0x70,0x30,0xD0,0x70,	/* 3C40: 0tp0p */
	0x30,0x24,0xF2,0xF4,0xA2,0x60,0x00,0x70,	/* 3C48: 0$`.p */
	0x30,0x24,0xF2,0xF4,0xAD,0x74,0x30,0x70,	/* 3C50: 0$t0p */
	0xE0,0x71,0x73,0x21,0x28,0x9C,0x40,0xB2,	/* 3C58: qs!(@ */
	0x22,0xF0,0x71,0x73,0x21,0x28,0x93,0x41,	/* 3C60: "qs!(A */
	0xB2,0x22,0xF0,0x72,0x71,0x65,0x93,0xA6,	/* 3C68: "rqe */
	0x41,0x48,0x71,0x2A,0x27,0x97,0x22,0xF0,	/* 3C70: AHq*'" */
	0x72,0x71,0x66,0x96,0xA6,0x41,0x48,0x71,	/* 3C78: rqfAHq */
	0x2A,0x26,0x9A,0x72,0x71,0x23,0x2F,0x9B,	/* 3C80: *&rq#. */
	0x22,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,	/* 3C88: "...... */
	0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x0A,	/* 3C90: ........ */
	0x00,0x08,0x00,0x07,0x00,0x05,0x00,0x04,	/* 3C98: ........ */
	0x00,0x02,0x00,0x01,0x00,0xAE,0x02,0x71,	/* 3CA0: ......q */
	0x25,0x5D,0xD2,0x62,0x4B,0x21,0xFB,0x72,	/* 3CA8: %]bK!r */
	0x4D,0x24,0xFA,0x72,0x62,0x4F,0x21,0xFB,	/* 3CB0: M$rbO! */
	0x47,0x24,0x2A,0x9D,0x22,0xF0,0x20,0x72,	/* 3CB8: G$*" r */
	0x22,0xFB,0x22,0xF0,0x22,0xF2,0x72,0xF2,	/* 3CC0: """r */
	0xD2,0x72,0x22,0xFB,0x22,0xF0,0x21,0xF5,	/* 3CC8: r""! */
	0x22,0xF0,0x20,0x60,0xB8,0x40,0xD3,0x24,	/* 3CD0: " `@$ */
	0xF2,0xD0,0x24,0xF2,0xD1,0x21,0xFE,0x41,	/* 3CD8: $!A */
	0xF4,0xA2,0x28,0x01,0x41,0xD4,0x7A,0x33,	/* 3CE0: (.Az3 */
	0xC1,0xA6,0x40,0x7A,0xE3,0x40,0x22,0xA0,	/* 3CE8: @z@" */
	0x24,0xF2,0x24,0xF2,0xD6,0xD7,0x7A,0x34,	/* 3CF0: $$z4 */
	0x24,0xF2,0xF4,0xC0,0xA8,0x16,0x16,0x7A,	/* 3CF8: $..z */
	0xE4,0x7A,0xE5,0x40,0xA7,0x16,0x7A,0x35,	/* 3D00: z@.z5 */
	0xE1,0x16,0x7A,0xE5,0x15,0x16,0x42,0xF7,	/* 3D08: .z..B */
	0x41,0x7A,0xE9,0x41,0x7A,0x30,0x40,0x24,	/* 3D10: AzAz0@$ */
	0xFF,0xF0,0x21,0xA1,0x41,0xD3,0x7A,0x31,	/* 3D18: !Az1 */
	0x24,0xF2,0xF4,0x21,0xA0,0x10,0x7A,0x32,	/* 3D20: $!.z2 */
	0xE1,0x10,0x7A,0xE2,0x0E,0x7A,0x30,0x60,	/* 3D28: .z.z0` */
	0x4F,0xF2,0x7A,0xE0,0x06,0x10,0x7A,0xE1,	/* 3D30: Oz..z */
	0x10,0x7A,0xE2,0x40,0x7A,0xE9,0x7A,0x3A,	/* 3D38: .z@zz: */
	0x24,0xF2,0xF4,0xA5,0x14,0x7A,0x5A,0x42,	/* 3D40: $.zZB */
	0xFB,0x41,0xD5,0x7A,0x34,0x24,0xF2,0xF4,	/* 3D48: Az4$ */
	0xC0,0xA5,0x41,0x7A,0xE3,0x40,0xAC,0x7A,	/* 3D50: Az@z */
	0x34,0x31,0x7A,0x34,0xD6,0x7A,0xE4,0x15,	/* 3D58: 41z4z. */
	0x76,0x42,0xFB,0x27,0x0B,0x7A,0x36,0xC1,	/* 3D60: vB'.z6 */
	0xA7,0x20,0x40,0x7A,0xE6,0x40,0x22,0xA2,	/* 3D68:  @z@" */
	0x24,0xF2,0x24,0xF2,0xD6,0xD7,0x7A,0x37,	/* 3D70: $$z7 */
	0x24,0xF2,0xF4,0xC0,0xAA,0x20,0x16,0x16,	/* 3D78: $ .. */
	0x7A,0xE7,0x7A,0xE8,0x40,0xA8,0x20,0x16,	/* 3D80: zz@ . */
	0x7A,0x38,0xE1,0x16,0x7A,0xE8,0x15,0x16,	/* 3D88: z8.z.. */
	0x42,0xF7,0x7A,0x39,0xA6,0x20,0x14,0x7A,	/* 3D90: Bz9 .z */
	0x5A,0x42,0xF7,0x41,0x7A,0x30,0x40,0x24,	/* 3D98: ZBAz0@$ */
	0xFF,0xF0,0x21,0xA1,0x41,0xD3,0x7A,0x31,	/* 3DA0: !Az1 */
	0x24,0xF2,0xF4,0x21,0xA1,0x10,0x7A,0x32,	/* 3DA8: $!.z2 */
	0xE1,0x10,0x7A,0xE2,0x0F,0x7A,0x30,0x60,	/* 3DB0: .z.z0` */
	0x4F,0xF2,0x7A,0xE0,0x07,0x20,0x10,0x7A,	/* 3DB8: Oz. .z */
	0xE1,0x10,0x7A,0xE2,0x41,0xD5,0x7A,0x37,	/* 3DC0: .zAz7 */
	0x24,0xF2,0xF4,0xC0,0xA7,0x20,0x41,0x7A,	/* 3DC8: $ Az */
	0xE6,0x40,0xAD,0x20,0x7A,0x37,0x31,0x7A,	/* 3DD0: @ z71z */
	0x37,0xD6,0x7A,0xE7,0x15,0x76,0x42,0xFB,	/* 3DD8: 7z.vB */
	0x73,0xA5,0x20,0x12,0x10,0x42,0xF7,0xB8,	/* 3DE0: s ..B */
	0x22,0xF0,0x60,0xBB,0x41,0xD0,0x21,0xFE,	/* 3DE8: "`A! */
	0x41,0xF4,0xA3,0x20,0x27,0x0B,0x77,0x33,	/* 3DF0: A '.w3 */
	0xC1,0xA7,0x20,0x40,0x77,0xE3,0x40,0x22,	/* 3DF8:  @w@" */
	0xA2,0x24,0xF2,0x24,0xF2,0xD2,0xD3,0x77,	/* 3E00: $$w */
	0x34,0x24,0xF2,0xF4,0xC0,0xAA,0x20,0x12,	/* 3E08: 4$ . */
	0x12,0x77,0xE4,0x77,0xE5,0x40,0xA8,0x20,	/* 3E10: .ww@  */
	0x12,0x77,0x35,0xE1,0x12,0x77,0xE5,0x11,	/* 3E18: .w5.w. */
	0x12,0x42,0xF7,0x41,0x77,0xE9,0x77,0x31,	/* 3E20: .BAww1 */
	0x24,0xF2,0xF4,0xAB,0x20,0x77,0x31,0xD1,	/* 3E28: $ w1 */
	0x77,0x31,0x31,0x77,0xE1,0x09,0x20,0x77,	/* 3E30: w11w. w */
	0x30,0x41,0xF2,0x77,0xE0,0x05,0x20,0x10,	/* 3E38: 0Aw. . */
	0x71,0x42,0xFB,0x40,0x77,0xE9,0x77,0x3A,	/* 3E40: qB@ww: */
	0x24,0xF2,0xF4,0xA6,0x20,0x10,0x77,0x5A,	/* 3E48: $ .wZ */
	0x42,0xFB,0x41,0xD1,0x77,0x34,0x24,0xF2,	/* 3E50: BAw4$ */
	0xF4,0xC0,0xA7,0x20,0x41,0x77,0xE3,0x40,	/* 3E58:  Aw@ */
	0xAD,0x20,0x77,0x34,0x31,0x77,0x34,0xD2,	/* 3E60:  w41w4 */
	0x77,0xE4,0x11,0x72,0x42,0xFB,0xB5,0x22,	/* 3E68: w.rB" */
	0xF0,0x77,0x36,0xC1,0xA7,0x20,0x40,0x77,	/* 3E70: w6 @w */
	0xE6,0x40,0x22,0xA2,0x24,0xF2,0x24,0xF2,	/* 3E78: @"$$ */
	0xD3,0xD4,0x77,0x37,0x24,0xF2,0xF4,0xC0,	/* 3E80: w7$ */
	0xAA,0x20,0x13,0x13,0x77,0xE7,0x77,0xE8,	/* 3E88:  ..ww */
	0x40,0xA8,0x20,0x13,0x77,0x38,0xE1,0x13,	/* 3E90: @ .w8. */
	0x77,0xE8,0x12,0x13,0x42,0xF7,0x77,0x39,	/* 3E98: w..Bw9 */
	0xA6,0x20,0x11,0x77,0x5A,0x42,0xF7,0x77,	/* 3EA0:  .wZBw */
	0x31,0x24,0xF2,0xF4,0xAB,0x20,0x77,0x31,	/* 3EA8: 1$ w1 */
	0xD2,0x77,0x31,0x31,0x77,0xE1,0x09,0x20,	/* 3EB0: w11w.  */
	0x77,0x30,0x41,0xF2,0x77,0xE0,0x05,0x20,	/* 3EB8: w0Aw.  */
	0x10,0x72,0x42,0xFB,0x41,0xD2,0x77,0x37,	/* 3EC0: .rBAw7 */
	0x24,0xF2,0xF4,0xC0,0xA7,0x20,0x41,0x77,	/* 3EC8: $ Aw */
	0xE6,0x40,0xAD,0x20,0x77,0x37,0x31,0x77,	/* 3ED0: @ w71w */
	0x37,0xD3,0x77,0xE7,0x12,0x73,0x42,0xFB,	/* 3ED8: 7w.sB */
	0xB5,0x22,0xF0,0x60,0xBF,0x22,0xF9,0x41,	/* 3EE0: "`"A */
	0x73,0x24,0xF6,0x21,0xA5,0x72,0xD0,0x74,	/* 3EE8: s$!rt */
	0x73,0x60,0x8F,0x10,0x25,0xF5,0x21,0x93,	/* 3EF0: s`.%! */
	0x70,0x72,0xF4,0xC0,0x41,0x24,0xFD,0x25,	/* 3EF8: prA$% */
	0xF5,0x04,0x74,0x73,0x72,0xF7,0x22,0xF9,	/* 3F00: .tsr" */
	0xB1,0x22,0xF0,0x27,0x21,0x0A,0x20,0x22,	/* 3F08: "'!. " */
	0xF9,0x41,0x72,0x24,0xF6,0xA9,0x73,0x72,	/* 3F10: Ar$sr */
	0x60,0x8F,0x71,0x25,0xF5,0x99,0x04,0x73,	/* 3F18: `q%.s */
	0x72,0x71,0xFB,0x22,0xF9,0x22,0xF0,0x26,	/* 3F20: rq""& */
	0x2F,0x07,0x20,0x01,0x00,0xFF,0xFF,0xFF,	/* 3F28: .. .. */
	0xFF,0xFF,0xFF,0xEF,0x7F,0x00,0x00,0x00,	/* 3F30: ... */
	0x00,0x00,0x00,0x00,0x00,0x0F,0x27,0x02,	/* 3F38: ......'. */
	0x04,0x15,0x00,0x14,0x00,0x12,0x00,0x11,	/* 3F40: ........ */
	0x00,0x10,0x00,0x0F,0x00,0x0E,0x00,0x0C,	/* 3F48: ........ */
	0x00,0x06,0x00,0x66,0x00,0x71,0x26,0x58,	/* 3F50: ...f.q&X */
	0xD2,0x61,0x43,0x21,0xFB,0x72,0x22,0x8F,	/* 3F58: aC!r" */
	0x41,0x24,0xFA,0x63,0x44,0x21,0xFB,0x72,	/* 3F60: A$cD!r */
	0x82,0x21,0x45,0x24,0xFA,0x72,0x63,0x4F,	/* 3F68: !E$rcO */
	0x21,0xFB,0x49,0x21,0x2F,0x93,0x22,0xF0,	/* 3F70: !I!." */
	0x20,0x73,0x72,0xE0,0x24,0xF2,0x72,0xE1,	/* 3F78:  sr$r */
	0x41,0x72,0xE3,0x24,0xF2,0x72,0xE4,0x41,	/* 3F80: Ar$rA */
	0x72,0xE6,0x24,0xF2,0x72,0xE7,0x40,0x72,	/* 3F88: r$r@r */
	0xE9,0x24,0xF2,0x72,0xEA,0x22,0xF0,0x41,	/* 3F90: $r"A */
	0x72,0x30,0x40,0x24,0xFF,0xF0,0xA8,0x40,	/* 3F98: r0@$@ */
	0x21,0x4B,0xD2,0xD3,0x27,0x24,0x06,0x72,	/* 3FA0: !K'$.r */
	0x30,0x60,0x4F,0xF2,0x72,0xE0,0x22,0xF0,	/* 3FA8: 0`Or" */
	0x72,0x30,0x41,0xF2,0x72,0xE0,0x22,0xF0,	/* 3FB0: r0Ar" */
	0x20,0x42,0x01,0x71,0x28,0x50,0xD2,0x61,	/* 3FB8:  B.q(Pa */
	0x4D,0x21,0xFB,0x72,0xE1,0x63,0x4E,0x21,	/* 3FC0: M!rcN! */
	0xFB,0x72,0xE0,0x22,0xF0,0x60,0xBB,0x77,	/* 3FC8: r"`w */
	0x24,0xF2,0xF4,0x24,0xA0,0x77,0x60,0x5E,	/* 3FD0: $$w`^ */
	0xD1,0x77,0x41,0x24,0xF6,0xC0,0x22,0xA1,	/* 3FD8: wA$" */
	0x76,0x27,0x3A,0x71,0xF9,0xC0,0x21,0xA9,	/* 3FE0: v':q! */
	0x76,0x27,0x3C,0x71,0xF9,0x21,0xA2,0x71,	/* 3FE8: v'<q!q */
	0x30,0x24,0xF2,0x81,0xF4,0xC0,0xAA,0x71,	/* 3FF0: 0$q */
	0x31,0x60,0x4C,0x24,0xF6,0x71,0x31,0xF4,	/* 3FF8: 1`L$q1 */
	0xA6,0x41,0x44,0x76,0x26,0x2E,0x96,0x76,	/* 4000: ADv&.v */
	0x28,0x52,0xD3,0x73,0x30,0xD4,0x74,0xD0,	/* 4008: (Rs0t */
	0x76,0x28,0x33,0xD2,0x06,0xB5,0x22,0xF0,	/* 4010: v(3." */
	0x70,0x30,0xD0,0x70,0x72,0xF4,0xA7,0x71,	/* 4018: p0prq */
	0x70,0x30,0xF9,0xA2,0x60,0x02,0x70,0x30,	/* 4020: p0`.p0 */
	0x74,0xF4,0xA8,0x71,0x71,0x31,0xF2,0x70,	/* 4028: tqq1p */
	0x30,0xF4,0xA6,0x70,0x30,0x71,0xE0,0x21,	/* 4030: 0p0q! */
	0x07,0x70,0x30,0x72,0xF4,0xC0,0xA4,0x20,	/* 4038: .p0r  */
	0x71,0x73,0xE1,0x70,0x30,0x31,0x71,0x31,	/* 4040: qsp01q1 */
	0xF2,0x71,0xE1,0x70,0x30,0x30,0x71,0xE0,	/* 4048: qp00q */
	0x70,0x70,0x31,0xF2,0x71,0xF4,0x21,0xA0,	/* 4050: pp1q! */
	0x71,0x70,0xE0,0x71,0x30,0x73,0x30,0xF4,	/* 4058: qpq0s0 */
	0xC0,0x21,0xA7,0x71,0x73,0xE1,0x21,0x02,	/* 4060: !qs!. */
	0x71,0x31,0x70,0x31,0xF2,0x70,0xE1,0x71,	/* 4068: q1p1pq */
	0x30,0x70,0xE0,0x70,0x30,0x73,0x30,0xF4,	/* 4070: 0pp0s0 */
	0xA4,0x20,0xB5,0x22,0xF0,0x70,0x73,0xE1,	/* 4078:  "ps */
	0xB5,0x22,0xF0,0x60,0xBE,0x73,0x28,0x52,	/* 4080: "`s(R */
	0xD0,0x70,0x32,0x21,0xA8,0x70,0x60,0x3E,	/* 4088: p2!p`> */
	0xD1,0x70,0x53,0x73,0x21,0x92,0x74,0x73,	/* 4090: pSs!ts */
	0x6C,0x93,0x70,0x60,0x3F,0xD1,0x70,0x53,	/* 4098: lp`?pS */
	0x73,0x96,0xB2,0x22,0xF0,0xB2,0x22,0xF0,	/* 40A0: s"" */
	0x75,0xF6,0x20,0x60,0xBE,0x73,0x28,0x52,	/* 40A8: u `s(R */
	0xD0,0x70,0x5E,0xD1,0x71,0x71,0xE0,0x71,	/* 40B0: p^qqq */
	0x70,0xE0,0x71,0x70,0xE1,0x40,0x71,0xE1,	/* 40B8: pqp@q */
	0x41,0x70,0x53,0x73,0x61,0x2B,0x92,0x74,	/* 40C0: ApSsa+t */
	0x70,0x60,0xEA,0x75,0x74,0xF2,0x70,0x60,	/* 40C8: p`utp` */
	0xEB,0x41,0x70,0xE2,0x76,0xA8,0x40,0x70,	/* 40D0: Apv@p */
	0x60,0xE3,0x74,0x70,0x60,0xE8,0xB2,0x22,	/* 40D8: `tp`" */
	0xF0,0x40,0x71,0x28,0xE4,0x22,0xF0,0x0E,	/* 40E0: @q(". */
	0x00,0x0D,0x00,0x0B,0x00,0x0A,0x00,0x08,	/* 40E8: ........ */
	0x00,0x07,0x00,0x05,0x00,0x04,0x00,0x01,	/* 40F0: ........ */
	0x00,0x00,0x00,0x6A,0x00,0x71,0x28,0x52,	/* 40F8: ...j.q(R */
	0xD2,0x72,0x61,0x41,0x21,0xFB,0x4A,0x26,	/* 4100: raA!J& */
	0x90,0x22,0xF0,0x00,0x00,0x00,0x00,0x00,	/* 4108: "..... */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 4110: ........ */
	0x00,0x00,0x00,0x60,0xBE,0x41,0x75,0x76,	/* 4118: ...`Auv */
	0x24,0xFF,0xF0,0x21,0xA7,0x74,0xD0,0x75,	/* 4120: $!tu */
	0x74,0xF2,0xD1,0x71,0x70,0xF9,0x21,0xA0,	/* 4128: tqp! */
	0x40,0x70,0xE0,0x70,0x51,0xD0,0x71,0x70,	/* 4130: @ppQqp */
	0xF9,0xA6,0x60,0x04,0x41,0xB2,0x22,0xF0,	/* 4138: `.A" */
	0x73,0x21,0x9C,0xD0,0x70,0x30,0xAF,0x70,	/* 4140: s!p0p */
	0x30,0x70,0xF2,0xD0,0x70,0x51,0xD1,0x73,	/* 4148: 0ppQs */
	0x99,0x70,0x30,0xA2,0x60,0x01,0x40,0xB2,	/* 4150: p0`.@ */
	0x22,0xF0,0x75,0xF6,0x20,0x24,0xC4,0x60,	/* 4158: "u $` */
	0x4A,0x21,0xFB,0x22,0xF0,0x76,0x02,0x22,	/* 4160: J!"v." */
	0xF0,0x71,0x60,0x8F,0xD1,0x71,0x60,0x4F,	/* 4168: q`q`O */
	0xF9,0x21,0xA4,0x24,0xF2,0x71,0x72,0xFA,	/* 4170: !$qr */
	0x30,0x73,0xFA,0xE0,0x71,0x60,0x8F,0xD1,	/* 4178: 0sq` */
	0x71,0x60,0x4F,0xF9,0xA2,0x61,0x0C,0x22,	/* 4180: q`Oa." */
	0xF0,0x60,0xB4,0x7D,0x29,0x52,0xD0,0x7E,	/* 4188: `})R~ */
	0x7F,0x24,0xFB,0xAE,0x1E,0x2E,0x44,0x21,	/* 4190: $..D! */
	0xFB,0x23,0x2E,0x9A,0xAB,0x60,0x4F,0xBC,	/* 4198: #.`O */
	0x22,0xF0,0x70,0x61,0x3A,0xBC,0x22,0xF0,	/* 41A0: "pa:" */
	0x40,0x7E,0x41,0x23,0xF7,0xD8,0x7F,0x40,	/* 41A8: @~A#@ */
	0x23,0xF7,0xD9,0x78,0x60,0x4E,0x24,0xF6,	/* 41B0: #x`N$ */
	0xD6,0x79,0xD7,0x2C,0x42,0x21,0xFB,0x16,	/* 41B8: y,B!. */
	0x14,0x22,0x24,0x93,0x70,0x61,0x3E,0xDA,	/* 41C0: ."$pa> */
	0x70,0x7D,0x21,0x2E,0x9B,0x10,0xD3,0x70,	/* 41C8: p}!..p */
	0x61,0x33,0x21,0xA8,0x70,0x61,0x34,0x73,	/* 41D0: a3!pa4s */
	0xF9,0xC0,0xA6,0x73,0x70,0x61,0x35,0xF9,	/* 41D8: spa5 */
	0xA5,0x70,0x61,0x32,0xD1,0x02,0x73,0xD1,	/* 41E0: pa2.s */
	0x71,0x69,0x5A,0xD1,0x70,0x61,0x3A,0xD2,	/* 41E8: qiZpa: */
	0x70,0x61,0x3B,0x21,0xFD,0xDA,0xDB,0x70,	/* 41F0: pa;!p */
	0x61,0x3A,0x21,0xFD,0xD8,0xD9,0x40,0x7A,	/* 41F8: a:!@z */
	0x78,0x24,0xFF,0xD6,0x7B,0x79,0x24,0xFF,	/* 4200: x${y$ */
	0xD7,0x16,0x1E,0x23,0x27,0x98,0xC0,0x22,	/* 4208: ..#'" */
	0xAA,0x70,0x61,0x3B,0x24,0xF2,0xF4,0x22,	/* 4210: pa;$" */
	0xA2,0x70,0x61,0x33,0x22,0xAB,0x71,0x21,	/* 4218: pa3"q! */
	0xFD,0xD8,0xD9,0x70,0x61,0x3A,0x21,0xFD,	/* 4220: pa:! */
	0xD6,0xD7,0x40,0x78,0x76,0x24,0xFF,0xDA,	/* 4228: @xv$ */
	0x79,0x77,0x24,0xFF,0xDB,0x1A,0x1E,0x23,	/* 4230: yw$..# */
	0x24,0x9C,0xAE,0x70,0x61,0x3F,0xD6,0x70,	/* 4238: $pa?p */
	0x7D,0x21,0x27,0x96,0x60,0x4F,0xBC,0x22,	/* 4240: }!'`O" */
	0xF0,0x75,0x74,0x41,0x23,0xF6,0xDA,0xDB,	/* 4248: utA# */
	0x70,0x61,0x3A,0x21,0xFD,0xD6,0xD7,0x40,	/* 4250: pa:!@ */
	0x7A,0x76,0x23,0xF7,0xD8,0x7B,0x77,0x23,	/* 4258: zv#{w# */
	0xF7,0xD9,0x78,0x70,0x61,0xEA,0x70,0x61,	/* 4260: xpapa */
	0x33,0xA6,0x70,0x61,0x3A,0x70,0x61,0xE4,	/* 4268: 3pa:pa */
	0x70,0x61,0x3F,0xD6,0x70,0x7D,0x21,0x24,	/* 4270: pa?p}!$ */
	0x91,0x72,0xBC,0x22,0xF0,0x00,0x00,0x00,	/* 4278: r"... */
	0x00,0x02,0x00,0x00,0x00,0x60,0xBD,0x75,	/* 4280: .....`u */
	0xD2,0x41,0x74,0x27,0x3F,0x75,0x24,0xFF,	/* 4288: At'?u$ */
	0xF0,0xC0,0xA4,0x74,0x27,0x3F,0xD5,0x75,	/* 4290: t'?u */
	0xD0,0x40,0xD1,0x71,0x70,0x74,0x61,0x2E,	/* 4298: @qpta. */
	0x98,0xD0,0x70,0x60,0x4F,0xF4,0xC0,0x21,	/* 42A0: p`O! */
	0xAF,0x41,0x75,0x72,0x24,0xFF,0xF0,0xA5,	/* 42A8: Aur$ */
	0x24,0xF2,0xB3,0x22,0xF0,0x72,0xD5,0x75,	/* 42B0: $"ru */
	0xD0,0x40,0xD1,0x71,0x70,0x74,0x61,0x2C,	/* 42B8: @qpta, */
	0x98,0xD0,0x70,0x60,0x4F,0xF4,0x22,0xA3,	/* 42C0: p`O" */
	0x75,0x70,0xE1,0x74,0x28,0x52,0xD1,0x71,	/* 42C8: upt(Rq */
	0x31,0xD2,0x74,0x28,0x33,0x72,0x31,0xF2,	/* 42D0: 1t(3r1 */
	0x70,0xF4,0x21,0xA4,0x70,0x72,0xE0,0x70,	/* 42D8: p!prp */
	0x71,0xE1,0x71,0x30,0x71,0x31,0xE0,0x70,	/* 42E0: qq0q1p */
	0xB3,0x22,0xF0,0x24,0xF2,0xB3,0x22,0xF0,	/* 42E8: "$" */
	0x75,0x72,0x31,0xF2,0x72,0xE1,0x71,0x31,	/* 42F0: ur1rq1 */
	0xB3,0x22,0xF0,0x60,0xBB,0x40,0xD1,0x77,	/* 42F8: "`@w */
	0x21,0xAB,0x77,0x52,0x60,0x4D,0xF4,0x60,	/* 4300: !wR`M` */
	0x4C,0x24,0xF6,0xD7,0x76,0x28,0x52,0xD2,	/* 4308: L$v(R */
	0x72,0x30,0xD3,0x76,0x28,0x32,0x30,0xD0,	/* 4310: r0v(20 */
	0x71,0xC0,0x25,0xAA,0x05,0x24,0xF2,0xB5,	/* 4318: q%.$ */
	0x22,0xF0,0x70,0x72,0x30,0xF4,0x23,0xAA,	/* 4320: "pr0# */
	0x41,0x77,0x70,0x31,0x24,0xFF,0xF0,0x22,	/* 4328: Awp1$" */
	0xAB,0x70,0x31,0x77,0xF4,0xAF,0x70,0x31,	/* 4330: p1wp1 */
	0x77,0xF4,0x70,0xE1,0x70,0x70,0x31,0xF2,	/* 4338: wppp1 */
	0xD0,0x77,0x70,0xE1,0x04,0x70,0x30,0x73,	/* 4340: wp.p0s */
	0xE0,0x24,0xF2,0x81,0x70,0xE0,0x70,0x72,	/* 4348: $ppr */
	0x31,0xF4,0xC0,0xA3,0x73,0x72,0xE1,0x70,	/* 4350: 1srp */
	0x52,0xD4,0x41,0xD1,0x70,0xD3,0x70,0x30,	/* 4358: RApp0 */
	0xD0,0x0A,0x77,0x76,0x6E,0x9F,0xD0,0x70,	/* 4360: .wvnp */
	0x24,0xF2,0xF4,0xA5,0x71,0xC0,0xA7,0x64,	/* 4368: $qd */
	0x01,0x24,0xF2,0xB5,0x22,0xF0,0x74,0xB5,	/* 4370: .$"t */
	0x22,0xF0,0x60,0xBD,0x74,0x29,0x52,0xD1,	/* 4378: "`t)R */
	0x71,0x60,0x32,0xC0,0x21,0xA1,0x71,0x61,	/* 4380: q`2!qa */
	0x3C,0x22,0xA8,0x40,0xD0,0x71,0x61,0x39,	/* 4388: <"@qa9 */
	0x71,0x61,0x38,0x74,0x62,0x21,0x94,0x71,	/* 4390: qa8tb!q */
	0x61,0x3E,0xD0,0x71,0x60,0x53,0x74,0x21,	/* 4398: a>q`St! */
	0x9B,0x75,0x74,0x6A,0x96,0xD0,0x71,0x61,	/* 43A0: utjqa */
	0x3F,0xD2,0x71,0x60,0x53,0x74,0x9F,0x70,	/* 43A8: ?q`Stp */
	0xB3,0x22,0xF0,0x24,0xF2,0xB3,0x22,0xF0,	/* 43B0: "$" */
	0x7E,0xF6,0x7A,0xF6,0x74,0xF6,0x76,0xF6,	/* 43B8: ~ztv */
	0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,	/* 43C0: ........ */
	0x00,0x00,0x00,0x00,0x01,0x0A,0x00,0x08,	/* 43C8: ........ */
	0x00,0x07,0x00,0x05,0x00,0x04,0x00,0x02,	/* 43D0: ........ */
	0x00,0x01,0x00,0xFE,0x02,0x71,0x29,0x52,	/* 43D8: ....q)R */
	0xD2,0x62,0x4B,0x21,0xFB,0x72,0x4D,0x24,	/* 43E0: bK!rM$ */
	0xFA,0x72,0x62,0x4F,0x21,0xFB,0x47,0x62,	/* 43E8: rbO!Gb */
	0x27,0x97,0x22,0xF0,0x20,0x20,0x60,0xBB,	/* 43F0: '"  ` */
	0x78,0xD0,0x77,0x11,0x13,0x23,0x94,0x11,	/* 43F8: xw..#. */
	0x76,0x44,0x24,0xFA,0xB5,0x22,0xF0,0x60,	/* 4400: vD$"` */
	0xBB,0x77,0x30,0x77,0x31,0x24,0xF2,0xF4,	/* 4408: w0w1$ */
	0x24,0xFB,0xC0,0x21,0xA0,0x78,0x30,0x60,	/* 4410: $!x0` */
	0x4F,0xF4,0x78,0x31,0x60,0x4F,0xF4,0x24,	/* 4418: Ox1`O$ */
	0xFB,0xC0,0xA2,0x21,0xF0,0x78,0xD0,0x77,	/* 4420: !xw */
	0x13,0x11,0x98,0x11,0x76,0x44,0x24,0xFA,	/* 4428: ...vD$ */
	0xB5,0x22,0xF0,0x60,0xB4,0x40,0xDA,0x40,	/* 4430: "`@@ */
	0xDB,0x24,0xF2,0x7F,0x31,0x24,0xF6,0x21,	/* 4438: $1$! */
	0xA3,0x41,0xDA,0x40,0x40,0x7F,0x30,0x24,	/* 4440: A@@0$ */
	0xFF,0xD8,0xD1,0x71,0x40,0x7F,0x31,0x24,	/* 4448: q@1$ */
	0xFF,0xD9,0xD1,0x08,0x40,0xDA,0x7F,0x30,	/* 4450: .@0 */
	0xD8,0x7F,0x31,0xD9,0x24,0xF2,0x21,0x70,	/* 4458: 1$!p */
	0x31,0x24,0xF6,0x21,0xA6,0x7A,0xC0,0xDB,	/* 4460: 1$!z */
	0x40,0x40,0x21,0x70,0x30,0x24,0xFF,0xD6,	/* 4468: @@!p0$ */
	0xD1,0x71,0x40,0x21,0x70,0x31,0x24,0xFF,	/* 4470: q@!p1$ */
	0xD7,0xD1,0x0A,0x7A,0xDB,0x21,0x70,0x30,	/* 4478: .z!p0 */
	0xD6,0x21,0x70,0x31,0xD7,0x16,0xD0,0x18,	/* 4480: !p1.. */
	0x12,0x14,0x22,0x9D,0x7B,0xAE,0x40,0x40,	/* 4488: .."{@@ */
	0x74,0x24,0xFF,0xD4,0xD1,0x71,0x40,0x75,	/* 4490: t$q@u */
	0x24,0xFF,0xD5,0xD1,0x7A,0xAE,0x40,0x40,	/* 4498: $z@@ */
	0x72,0x24,0xFF,0xD2,0xD1,0x71,0x40,0x73,	/* 44A0: r$q@s */
	0x24,0xFF,0xD3,0xD1,0x14,0x7D,0x44,0x24,	/* 44A8: $.}D$ */
	0xFA,0x12,0x7E,0x44,0x24,0xFA,0xBC,0x22,	/* 44B0: .~D$" */
	0xF0,0x60,0xB6,0x7E,0x30,0xC0,0xA8,0x7E,	/* 44B8: `~0~ */
	0x31,0xC0,0xA4,0x21,0xF0,0x2B,0x0B,0x7E,	/* 44C0: 1!+.~ */
	0x31,0xC0,0x21,0xAA,0x40,0x7D,0x31,0x7E,	/* 44C8: 1!@}1~ */
	0x30,0x21,0xFA,0x7B,0xE1,0xD2,0x72,0x7D,	/* 44D0: 0!{r} */
	0x30,0x7E,0x30,0x21,0xFA,0x7B,0xE0,0x7C,	/* 44D8: 0~0!{| */
	0xE0,0x40,0x7C,0xE1,0x29,0x0C,0x7E,0x31,	/* 44E0: @|).~1 */
	0x7E,0x30,0x21,0xF9,0xD4,0xD5,0xD6,0x76,	/* 44E8: ~0!v */
	0xC0,0xAA,0x40,0xD3,0x7D,0x31,0xD2,0x7D,	/* 44F0: @}1} */
	0x30,0xD1,0x21,0x01,0x40,0x7D,0x31,0x76,	/* 44F8: 0!.@}1v */
	0x23,0xF6,0xD0,0xD3,0x7D,0x31,0x7D,0x30,	/* 4500: #}1}0 */
	0x76,0x23,0xF6,0xD1,0xD2,0x40,0x7B,0xE1,	/* 4508: v#@{ */
	0x73,0x75,0xF4,0xC0,0xA5,0x60,0x4F,0x7B,	/* 4510: su`O{ */
	0xE0,0x08,0x73,0x72,0x75,0x21,0xFA,0x7B,	/* 4518: .sru!{ */
	0xE0,0xD0,0x7B,0x30,0x24,0xA9,0x40,0x74,	/* 4520: {0$@t */
	0x7B,0x30,0x23,0xF1,0xD7,0xD8,0x78,0x75,	/* 4528: {0#xu */
	0x7B,0x30,0x23,0xF1,0xD8,0xD9,0x40,0x71,	/* 4530: {0#@q */
	0x77,0x24,0xFF,0xD1,0xD0,0x70,0x72,0x78,	/* 4538: w$prx */
	0x24,0xFF,0xD2,0xD0,0x70,0x73,0x79,0x24,	/* 4540: $psy$ */
	0xFF,0xD3,0xD0,0x24,0xF2,0x73,0x24,0xF6,	/* 4548: $s$ */
	0x21,0xAD,0x7B,0x30,0x60,0x8F,0x7B,0xE0,	/* 4550: !{0`{ */
	0x40,0x74,0x71,0x23,0xF7,0xD1,0xD0,0x70,	/* 4558: @tq#p */
	0x75,0x72,0x23,0xF7,0xD2,0xD0,0x70,0x40,	/* 4560: ur#p@ */
	0x73,0x23,0xF7,0xD3,0xD0,0x62,0x0C,0x76,	/* 4568: s#b.v */
	0xC0,0xA7,0x71,0x7C,0xE0,0x72,0x7C,0xE1,	/* 4570: q|r| */
	0x09,0x72,0x71,0x76,0x23,0xF5,0x7C,0xE0,	/* 4578: .rqv#| */
	0x7C,0xE1,0xBA,0x22,0xF0,0x20,0x40,0xD3,	/* 4580: |" @ */
	0x71,0x31,0x72,0x31,0xF4,0xC0,0xAF,0x24,	/* 4588: q1r1$ */
	0xF2,0x71,0x30,0x23,0xF3,0x24,0xF2,0x72,	/* 4590: q0#$r */
	0x30,0x23,0xF3,0xF9,0xD3,0x06,0x71,0x31,	/* 4598: 0#.q1 */
	0x72,0x31,0xF9,0xD3,0x73,0x22,0xF0,0x60,	/* 45A0: r1s"` */
	0xBE,0x74,0xD1,0x76,0x25,0xA0,0x41,0x21,	/* 45A8: tv%A! */
	0x40,0x76,0x24,0xFF,0xF0,0xA4,0x21,0x40,	/* 45B0: @v$!@ */
	0xD3,0x02,0x76,0xD3,0x40,0xD0,0x73,0x40,	/* 45B8: .v@s@ */
	0xF9,0x21,0xA0,0x75,0x70,0x74,0xF2,0x23,	/* 45C0: !upt# */
	0xFB,0x70,0x81,0xD0,0x73,0x70,0xF9,0xA3,	/* 45C8: psp */
	0x20,0x60,0x00,0x73,0xD5,0x76,0x73,0xF4,	/* 45D0:  `.svs */
	0xD6,0x76,0x22,0xA2,0x41,0x75,0x76,0x24,	/* 45D8: v"Auv$ */
	0xFF,0xF0,0xA5,0x20,0x75,0xD3,0x03,0x20,	/* 45E0:  u.  */
	0x76,0xD3,0x74,0x75,0x74,0xF2,0x73,0x24,	/* 45E8: vtuts$ */
	0xFA,0x73,0x75,0xF5,0xD5,0x76,0x73,0xF4,	/* 45F0: suvs */
	0xD6,0x76,0xA3,0x20,0x62,0x0E,0x71,0xB2,	/* 45F8: v b.q */
	0x22,0xF0,0x20,0x70,0x72,0xE0,0x10,0x72,	/* 4600: " pr.r */
	0xE1,0x40,0x22,0xF0,0x72,0x30,0x72,0x31,	/* 4608: @"r0r1 */
	0xE0,0x73,0xC0,0xA2,0x41,0xD3,0x73,0x72,	/* 4610: sAsr */
	0x31,0xE1,0x72,0x31,0x23,0xFC,0x71,0x22,	/* 4618: 1r1#q" */
	0xF0,0x22,0xF9,0x72,0x31,0xF6,0x22,0xF0,	/* 4620: "r1" */
	0x22,0xF9,0x72,0x31,0xF6,0x22,0xF0,0x40,	/* 4628: "r1"@ */
	0x40,0x60,0xBB,0x73,0x36,0x73,0x34,0x60,	/* 4630: @`s6s4` */
	0xEF,0x10,0x73,0x57,0x41,0xFB,0x21,0xF5,	/* 4638: .sWA! */
	0x20,0x60,0xBF,0x73,0x57,0x21,0xF2,0xD0,	/* 4640:  `sW! */
	0x70,0x24,0xF2,0xF4,0xA4,0x40,0xB1,0x22,	/* 4648: p$@" */
	0xF0,0x41,0xB1,0x22,0xF0,0x72,0x71,0x61,	/* 4650: A"rqa */
	0x98,0xA5,0x41,0x4B,0x71,0x28,0x9E,0x63,	/* 4658: AKq(c */
	0x4E,0x21,0xFB,0x72,0x34,0xE0,0x70,0x72,	/* 4660: N!r4pr */
	0xE1,0x72,0x34,0x21,0xFE,0x24,0xFB,0x23,	/* 4668: r4!$# */
	0xF9,0x22,0xF0,0x72,0x71,0x63,0x9A,0xA5,	/* 4670: "rqc */
	0x41,0x4B,0x71,0x27,0x90,0x64,0x40,0x21,	/* 4678: AKq'd@! */
	0xFB,0x72,0x34,0xE0,0x70,0x72,0xE1,0x72,	/* 4680: r4prr */
	0x34,0x60,0x4E,0x24,0xF6,0x23,0xF9,0x22,	/* 4688: 4`N$#" */
	0xF0,0x72,0x71,0x65,0x9C,0xA5,0x41,0x4B,	/* 4690: rqeAK */
	0x71,0x25,0x92,0x66,0x42,0x21,0xFB,0x72,	/* 4698: q%fB!r */
	0x34,0xE0,0x70,0x72,0xE1,0x72,0x34,0x41,	/* 46A0: 4prr4A */
	0x24,0xFB,0x23,0xF9,0x22,0xF0,0x20,0x72,	/* 46A8: $#" r */
	0xA5,0x72,0x71,0x27,0xE2,0x07,0x22,0x27,	/* 46B0: rq'."' */
	0x20,0x4F,0x71,0x27,0xE2,0x72,0x71,0x27,	/* 46B8:  Oq'rq' */
	0x50,0xD2,0xD3,0x6B,0x07,0x71,0x29,0x3D,	/* 46C0: Pk.q)= */
	0x24,0xF2,0xF4,0xA6,0x71,0x29,0x3D,0xD3,	/* 46C8: $q)= */
	0x71,0x92,0x62,0x0B,0x77,0xF6,0x20,0x00,	/* 46D0: qb.w . */
	0x00,0x00,0x00,0x71,0x29,0x5D,0xD2,0x72,	/* 46D8: ...q)]r */
	0x60,0x43,0x21,0xFB,0x41,0x65,0x28,0x91,	/* 46E0: `C!Ae( */
	0x22,0xF0,0x20,0x21,0x02,0x60,0xBE,0x24,	/* 46E8: " !.`$ */
	0xF2,0xD0,0x75,0xD1,0x24,0xF2,0x24,0xF2,	/* 46F0: u$$ */
	0x73,0x60,0x90,0xB2,0x22,0xF0,0x20,0x25,	/* 46F8: s`" % */
	0xF8,0x21,0xF0,0x22,0xF0,0x60,0xBA,0x40,	/* 4700: !"`@ */
	0x21,0xFE,0xF4,0x21,0xAE,0x24,0xF2,0xD4,	/* 4708: !!$ */
	0x10,0xD5,0x4B,0x21,0xFB,0xD2,0x40,0x13,	/* 4710: .K!@. */
	0x25,0xF2,0x23,0xF9,0x10,0x14,0x41,0xFB,	/* 4718: %#..A */
	0x24,0xF3,0x11,0x41,0x24,0xF8,0x24,0xF4,	/* 4720: $.A$$ */
	0x72,0x23,0xFC,0x79,0x7C,0x33,0xF2,0x7C,	/* 4728: r#y|3| */
	0xE3,0x77,0x7C,0xE6,0x78,0x7C,0xE7,0x40,	/* 4730: w|x|@ */
	0xD4,0x42,0xD5,0x74,0xC0,0xA4,0x7C,0x39,	/* 4738: Bt|9 */
	0xD1,0x03,0x7C,0x3A,0xD1,0x71,0x7A,0xF9,	/* 4740: .|:qz */
	0x25,0xAB,0x24,0xF2,0x71,0x23,0xF3,0xD0,	/* 4748: %$q# */
	0x70,0x41,0x24,0xF0,0xD2,0x72,0x24,0xF2,	/* 4750: pA$r$ */
	0xFA,0xD0,0x79,0x70,0x33,0xF2,0x70,0xE3,	/* 4758: yp3p */
	0x79,0x70,0x34,0xF2,0x70,0xE4,0x74,0x23,	/* 4760: yp4pt# */
	0xA5,0x22,0x40,0x70,0x31,0x24,0xF6,0xC0,	/* 4768: "@p1$ */
	0x22,0xAC,0x42,0x70,0x31,0x24,0xF6,0x21,	/* 4770: "Bp1$! */
	0xA4,0x70,0x37,0x4A,0x21,0xFB,0xF0,0xE0,	/* 4778: p7J! */
	0x70,0x34,0x70,0x37,0x23,0xFC,0xD4,0xF6,	/* 4780: p4p7# */
	0x70,0x23,0xFC,0x21,0x01,0x70,0x34,0x70,	/* 4788: p#!.p4p */
	0x37,0x60,0xEF,0x41,0x70,0x31,0x24,0xF6,	/* 4790: 7`Ap1$ */
	0xC0,0x70,0x37,0xF2,0x23,0xF9,0x70,0x3E,	/* 4798: p7#p> */
	0xD3,0x73,0xD1,0x65,0x00,0x14,0x26,0x4F,	/* 47A0: se..&O */
	0x22,0xF1,0x21,0xF5,0xB6,0x22,0xF0,0x20,	/* 47A8: "!"  */
	0x60,0xBA,0x77,0x3F,0xD0,0x24,0xF2,0x70,	/* 47B0: `w?$p */
	0x23,0xF3,0xD1,0x71,0x41,0x24,0xF0,0xD5,	/* 47B8: #qA$ */
	0x75,0x24,0xF2,0xFA,0xD4,0x74,0x39,0xD1,	/* 47C0: u$t9 */
	0x71,0x74,0x34,0xF9,0x24,0xAC,0x24,0xF2,	/* 47C8: qt4$$ */
	0x71,0x23,0xF3,0xD0,0x70,0x41,0x24,0xF0,	/* 47D0: q#pA$ */
	0xD2,0x72,0x24,0xF2,0xFA,0xD0,0x22,0x40,	/* 47D8: r$"@ */
	0x70,0x31,0x24,0xF6,0xC0,0x22,0xAC,0x42,	/* 47E0: p1$"B */
	0x70,0x31,0x24,0xF6,0x21,0xA4,0x70,0x37,	/* 47E8: p1$!p7 */
	0x4A,0x21,0xFB,0xF0,0xE0,0x70,0x34,0x70,	/* 47F0: J!p4p */
	0x37,0x23,0xFC,0xD4,0xF6,0x70,0x23,0xFC,	/* 47F8: 7#p# */
	0x21,0x01,0x70,0x34,0x70,0x37,0x60,0xEF,	/* 4800: !.p4p7` */
	0x41,0x70,0x31,0x24,0xF6,0xC0,0x70,0x37,	/* 4808: Ap1$p7 */
	0xF2,0x23,0xF9,0x70,0x3E,0xD3,0x73,0xD1,	/* 4810: #p>s */
	0x65,0x0E,0xB6,0x22,0xF0,0x20,0x20,0x64,	/* 4818: e."  d */
	0x28,0x21,0x08,0x20,0x20,0x60,0x08      	/* 4820: (!.  `.  */

};
int si3_t225_dsize = sizeof(si3_t225_download);		/* 0x4827 (18471) */

unsigned short si3_t225_downloadaddr = 0x0000;

/* End of SI3_T225.C */
