#!/bin/sh
# $FreeBSD: stable/8/tools/regression/fstest/tests/open/22.t 166065 2007-01-17 01:42:12Z pjd $

desc="open returns EEXIST when O_CREAT and O_EXCL were specified and the file exists"

dir=`dirname $0`
. ${dir}/../misc.sh

echo "1..12"

n0=`namegen`

expect 0 create ${n0} 0644
expect EEXIST open ${n0} O_CREAT,O_EXCL 0644
expect 0 unlink ${n0}

expect 0 mkdir ${n0} 0755
expect EEXIST open ${n0} O_CREAT,O_EXCL 0644
expect 0 rmdir ${n0}

expect 0 mkfifo ${n0} 0644
expect EEXIST open ${n0} O_CREAT,O_EXCL 0644
expect 0 unlink ${n0}

expect 0 symlink test ${n0}
expect EEXIST open ${n0} O_CREAT,O_EXCL 0644
expect 0 unlink ${n0}
