/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.util.MimeType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

class XmlSerializer {
    private static final String FILE_SEPARATOR = "/";
    private static final Pattern CREATE_FILE_PATTERN = Pattern.compile(".*/");
    private final StringBuilder builder_ = new StringBuilder();
    private final StringBuilder indent_ = new StringBuilder();
    private File outputDir_;

    XmlSerializer() {
    }

    public void save(SgmlPage page, File file) throws IOException {
        File outputFile;
        String fileName = file.getName();
        if (!fileName.endsWith(".htm") && !fileName.endsWith(".html")) {
            fileName = fileName + ".html";
        }
        if ((outputFile = new File(file.getParentFile(), fileName)).exists()) {
            throw new IOException("File already exists: " + outputFile);
        }
        fileName = fileName.substring(0, fileName.lastIndexOf(46));
        this.outputDir_ = new File(file.getParentFile(), fileName);
        FileUtils.writeStringToFile(outputFile, this.asXml(page.getDocumentElement()), StandardCharsets.ISO_8859_1);
    }

    public String asXml(DomElement node) throws IOException {
        Charset charsetName;
        this.builder_.setLength(0);
        this.indent_.setLength(0);
        SgmlPage page = node.getPage();
        if (null != page && page.isHtmlPage() && (charsetName = page.getCharset()) != null && node instanceof HtmlHtml) {
            this.builder_.append("<?xml version=\"1.0\" encoding=\"").append(charsetName).append("\"?>").append('\n');
        }
        this.printXml(node);
        String response = this.builder_.toString();
        this.builder_.setLength(0);
        return response;
    }

    protected void printXml(DomElement node) throws IOException {
        if (!this.isExcluded(node)) {
            boolean hasChildren = node.getFirstChild() != null;
            this.builder_.append((CharSequence)this.indent_).append('<');
            this.printOpeningTag(node);
            if (!hasChildren && !node.isEmptyXmlTagExpanded()) {
                this.builder_.append("/>").append('\n');
            } else {
                this.builder_.append(">").append('\n');
                for (DomNode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.indent_.append("  ");
                    if (child instanceof DomElement) {
                        this.printXml((DomElement)child);
                    } else {
                        this.builder_.append(child);
                    }
                    this.indent_.setLength(this.indent_.length() - 2);
                }
                this.builder_.append((CharSequence)this.indent_).append("</").append(node.getTagName()).append('>').append('\n');
            }
        }
    }

    public String asText(DomNode node) {
        this.builder_.setLength(0);
        if (node instanceof DomText) {
            this.builder_.append(((DomText)node).getData());
        } else {
            this.printText(node);
        }
        String response = this.builder_.toString();
        this.builder_.setLength(0);
        return response;
    }

    protected void printText(DomNode node) {
        for (DomNode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof DomText) {
                this.builder_.append(((DomText)child).getData());
                continue;
            }
            this.printText(child);
        }
    }

    protected void printOpeningTag(DomElement node) throws IOException {
        this.builder_.append(node.getTagName());
        Map<String, DomAttr> attributes = this.readAttributes(node);
        for (Map.Entry<String, DomAttr> entry : attributes.entrySet()) {
            this.builder_.append(" ");
            this.builder_.append(entry.getKey());
            this.builder_.append("=\"");
            String value = entry.getValue().getNodeValue();
            this.builder_.append(com.gargoylesoftware.htmlunit.util.StringUtils.escapeXmlAttributeValue(value));
            this.builder_.append('\"');
        }
    }

    private Map<String, DomAttr> readAttributes(DomElement node) throws IOException {
        if (node instanceof HtmlImage) {
            return this.getAttributesFor((HtmlImage)node);
        }
        if (node instanceof HtmlLink) {
            return this.getAttributesFor((HtmlLink)node);
        }
        if (node instanceof BaseFrameElement) {
            return this.getAttributesFor((BaseFrameElement)node);
        }
        Map<String, DomAttr> attributes = node.getAttributesMap();
        if (node instanceof HtmlOption) {
            attributes = new HashMap<String, DomAttr>(attributes);
            HtmlOption option = (HtmlOption)node;
            if (option.isSelected()) {
                if (!attributes.containsKey("selected")) {
                    attributes.put("selected", new DomAttr(node.getPage(), null, "selected", "selected", false));
                }
            } else {
                attributes.remove("selected");
            }
        }
        return attributes;
    }

    private Map<String, DomAttr> getAttributesFor(BaseFrameElement frame) throws IOException {
        Map<String, DomAttr> map = XmlSerializer.createAttributesCopyWithClonedAttribute(frame, "src");
        DomAttr srcAttr = map.get("src");
        if (srcAttr == null) {
            return map;
        }
        Page enclosedPage = frame.getEnclosedPage();
        String suffix = XmlSerializer.getFileExtension(enclosedPage);
        File file = this.createFile(srcAttr.getValue(), "." + suffix);
        if (enclosedPage != null) {
            if (enclosedPage.isHtmlPage()) {
                file.delete();
                ((HtmlPage)enclosedPage).save(file);
            } else {
                try (InputStream is = enclosedPage.getWebResponse().getContentAsStream();
                     FileOutputStream fos = new FileOutputStream(file);){
                    IOUtils.copyLarge(is, fos);
                }
            }
        }
        srcAttr.setValue(file.getParentFile().getName() + FILE_SEPARATOR + file.getName());
        return map;
    }

    private static String getFileExtension(Page enclosedPage) {
        if (enclosedPage != null) {
            if (enclosedPage.isHtmlPage()) {
                return "html";
            }
            URL url = enclosedPage.getUrl();
            if (url.getPath().contains(".")) {
                return StringUtils.substringAfterLast(url.getPath(), ".");
            }
        }
        return ".unknown";
    }

    protected Map<String, DomAttr> getAttributesFor(HtmlLink link) throws IOException {
        String protocol;
        Map<String, DomAttr> map = XmlSerializer.createAttributesCopyWithClonedAttribute(link, "href");
        DomAttr hrefAttr = map.get("href");
        if (hrefAttr != null && StringUtils.isNotBlank(hrefAttr.getValue()) && ("http".equals(protocol = link.getWebRequest().getUrl().getProtocol()) || "https".equals(protocol))) {
            File file = this.createFile(hrefAttr.getValue(), ".css");
            FileUtils.writeStringToFile(file, link.getWebResponse(true).getContentAsString(), StandardCharsets.ISO_8859_1);
            hrefAttr.setValue(this.outputDir_.getName() + FILE_SEPARATOR + file.getName());
        }
        return map;
    }

    protected Map<String, DomAttr> getAttributesFor(HtmlImage image) throws IOException {
        Map<String, DomAttr> map = XmlSerializer.createAttributesCopyWithClonedAttribute(image, "src");
        DomAttr srcAttr = map.get("src");
        if (srcAttr != null && StringUtils.isNotBlank(srcAttr.getValue())) {
            WebResponse response = image.getWebResponse(true);
            File file = this.createFile(srcAttr.getValue(), "." + XmlSerializer.getSuffix(response));
            FileUtils.copyInputStreamToFile(response.getContentAsStream(), file);
            String valueOnFileSystem = this.outputDir_.getName() + FILE_SEPARATOR + file.getName();
            srcAttr.setValue(valueOnFileSystem);
        }
        return map;
    }

    private static String getSuffix(WebResponse response) {
        String url = response.getWebRequest().getUrl().toString();
        String fileName = StringUtils.substringAfterLast(StringUtils.substringBefore(url, "?"), FILE_SEPARATOR);
        String suffix = StringUtils.substringAfterLast(fileName, ".");
        if (suffix.length() > 1 && suffix.length() < 5) {
            return suffix;
        }
        return MimeType.getFileExtension(response.getContentType());
    }

    private static Map<String, DomAttr> createAttributesCopyWithClonedAttribute(HtmlElement elt, String attrName) {
        HashMap<String, DomAttr> newMap = new HashMap<String, DomAttr>(elt.getAttributesMap());
        DomAttr attr = (DomAttr)newMap.get(attrName);
        if (null == attr) {
            return newMap;
        }
        DomAttr clonedAttr = new DomAttr(attr.getPage(), attr.getNamespaceURI(), attr.getQualifiedName(), attr.getValue(), attr.getSpecified());
        newMap.put(attrName, clonedAttr);
        return newMap;
    }

    protected boolean isExcluded(DomElement element) {
        return element instanceof HtmlScript;
    }

    private File createFile(String url, String extension) throws IOException {
        String name = url.replaceFirst("/$", "");
        name = CREATE_FILE_PATTERN.matcher(name).replaceAll("");
        name = StringUtils.substringBefore(name, "?");
        name = StringUtils.substringBefore(name, ";");
        name = StringUtils.substring(name, 0, 30);
        if (!(name = com.gargoylesoftware.htmlunit.util.StringUtils.sanitizeForFileName(name)).endsWith(extension)) {
            name = name + extension;
        }
        int counter = 0;
        while (true) {
            String fileName = counter != 0 ? StringUtils.substringBeforeLast(name, ".") + "_" + counter + "." + StringUtils.substringAfterLast(name, ".") : name;
            this.outputDir_.mkdirs();
            File f = new File(this.outputDir_, fileName);
            if (f.createNewFile()) {
                return f;
            }
            ++counter;
        }
    }
}

