/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.DriverProvider;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonHttpCommandHandler;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.NewSessionPayload;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.SessionFactory;

class InMemorySession
implements ActiveSession {
    private static final Logger LOG = Logger.getLogger(InMemorySession.class.getName());
    private final WebDriver driver;
    private final Map<String, Object> capabilities;
    private final SessionId id;
    private final Dialect downstream;
    private final TemporaryFilesystem filesystem;
    private final JsonHttpCommandHandler handler;

    private InMemorySession(WebDriver driver, Capabilities capabilities, Dialect downstream) throws IOException {
        this.driver = Preconditions.checkNotNull(driver);
        Capabilities caps = driver instanceof HasCapabilities ? ((HasCapabilities)((Object)driver)).getCapabilities() : capabilities;
        this.capabilities = caps.asMap().entrySet().stream().filter(e -> e.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        this.id = new SessionId(UUID.randomUUID().toString());
        this.downstream = Preconditions.checkNotNull(downstream);
        File tempRoot = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value(), this.id.toString());
        Preconditions.checkState(tempRoot.mkdirs());
        this.filesystem = TemporaryFilesystem.getTmpFsBasedOn(tempRoot);
        this.handler = new JsonHttpCommandHandler(new PretendDriverSessions(), LOG);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        this.handler.handleRequest(req, resp);
    }

    @Override
    public SessionId getId() {
        return this.id;
    }

    @Override
    public Dialect getUpstreamDialect() {
        return Dialect.OSS;
    }

    @Override
    public Dialect getDownstreamDialect() {
        return this.downstream;
    }

    @Override
    public Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public TemporaryFilesystem getFileSystem() {
        return this.filesystem;
    }

    @Override
    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    @Override
    public void stop() {
        this.driver.quit();
    }

    private class ActualSession
    implements Session {
        private final KnownElements knownElements = new KnownElements();
        private volatile String screenshot;

        private ActualSession() throws IOException {
        }

        @Override
        public void close() {
            InMemorySession.this.driver.quit();
        }

        @Override
        public WebDriver getDriver() {
            return InMemorySession.this.driver;
        }

        @Override
        public KnownElements getKnownElements() {
            return this.knownElements;
        }

        @Override
        public Map<String, Object> getCapabilities() {
            return InMemorySession.this.capabilities;
        }

        @Override
        public void attachScreenshot(String base64EncodedImage) {
            this.screenshot = base64EncodedImage;
        }

        @Override
        public String getAndClearScreenshot() {
            String toReturn = this.screenshot;
            this.screenshot = null;
            return toReturn;
        }

        @Override
        public SessionId getSessionId() {
            return InMemorySession.this.getId();
        }

        @Override
        public TemporaryFilesystem getTemporaryFileSystem() {
            return InMemorySession.this.getFileSystem();
        }
    }

    private class PretendDriverSessions
    implements DriverSessions {
        private final Session session;

        private PretendDriverSessions() throws IOException {
            this.session = new ActualSession();
        }

        @Override
        public SessionId newSession(Stream<Capabilities> desiredCapabilities) throws Exception {
            throw new UnsupportedOperationException("newSession");
        }

        @Override
        public Session get(SessionId sessionId) {
            return InMemorySession.this.getId().equals(sessionId) ? this.session : null;
        }

        @Override
        public void deleteSession(SessionId sessionId) {
        }

        @Override
        public void registerDriver(Capabilities capabilities, Class<? extends WebDriver> implementation) {
            throw new UnsupportedOperationException("registerDriver");
        }

        @Override
        public Set<SessionId> getSessions() {
            return ImmutableSet.of(InMemorySession.this.getId());
        }
    }

    public static class Factory
    implements SessionFactory {
        private final JsonToBeanConverter toBean = new JsonToBeanConverter();
        private final DriverProvider provider;

        public Factory(DriverProvider provider) {
            this.provider = provider;
        }

        /*
         * Exception decompiling
         */
        @Override
        public ActiveSession apply(NewSessionPayload payload) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public String toString() {
            return this.getClass() + " (provider: " + this.provider + ")";
        }
    }
}

