/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;

public class SafariOptions
extends MutableCapabilities {
    public static final String CAPABILITY = "safari.options";
    private Map<String, Object> options = new TreeMap<String, Object>();

    public SafariOptions() {
        this.setCapability("port", 0);
        this.setCapability("cleanSession", false);
        this.setCapability("technologyPreview", false);
        this.setCapability("browserName", "safari");
        this.setCapability("platform", Platform.MAC);
    }

    public static SafariOptions fromCapabilities(Capabilities capabilities) throws WebDriverException {
        Object cap = capabilities.getCapability(CAPABILITY);
        if (cap instanceof SafariOptions) {
            return (SafariOptions)cap;
        }
        if (cap instanceof Map) {
            try {
                return SafariOptions.fromJsonMap((Map)cap);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
        return new SafariOptions();
    }

    SafariOptions setPort(int port) {
        this.options.put("port", port);
        return this;
    }

    public SafariOptions setUseCleanSession(boolean useCleanSession) {
        this.options.put("cleanSession", useCleanSession);
        return this;
    }

    public SafariOptions setUseTechnologyPreview(boolean useTechnologyPreview) {
        this.options.put("technologyPreview", useTechnologyPreview);
        return this;
    }

    public int getPort() {
        return (Integer)this.options.getOrDefault("port", 0);
    }

    public boolean getUseCleanSession() {
        return (Boolean)this.options.getOrDefault("cleanSession", false);
    }

    public boolean getUseTechnologyPreview() {
        return (Boolean)this.options.getOrDefault("technologyPreview", false);
    }

    private static SafariOptions fromJsonMap(Map<?, ?> options) throws IOException {
        Boolean useTechnologyPreview;
        Boolean useCleanSession;
        SafariOptions safariOptions = new SafariOptions();
        Number port = (Number)options.get("port");
        if (port != null) {
            safariOptions.setPort(port.intValue());
        }
        if ((useCleanSession = (Boolean)options.get("cleanSession")) != null) {
            safariOptions.setUseCleanSession(useCleanSession);
        }
        if ((useTechnologyPreview = (Boolean)options.get("technologyPreview")) != null) {
            safariOptions.setUseTechnologyPreview(useTechnologyPreview);
        }
        return safariOptions;
    }

    @Deprecated
    MutableCapabilities toCapabilities() {
        return this;
    }

    private static class Option {
        private static final String CLEAN_SESSION = "cleanSession";
        private static final String TECHNOLOGY_PREVIEW = "technologyPreview";
        private static final String PORT = "port";

        private Option() {
        }
    }
}

