/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.console;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.utils.HtmlRenderer;
import org.openqa.grid.internal.utils.configuration.GridHubConfiguration;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ConsoleServlet
extends RegistryBasedServlet {
    private static final long serialVersionUID = 8484071790930378855L;
    private static String coreVersion;
    public static final String CONSOLE_PATH_PARAMETER = "webdriver.server.consoleservlet.path";

    public ConsoleServlet() {
        this(null);
    }

    public ConsoleServlet(GridRegistry registry) {
        super(registry);
        coreVersion = new BuildInfo().getReleaseLabel();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int i;
        int refresh = -1;
        if (request.getParameter("refresh") != null) {
            try {
                refresh = Integer.parseInt(request.getParameter("refresh"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append("<head>");
        builder.append("<script src='/grid/resources/org/openqa/grid/images/jquery-3.1.1.min.js'></script>");
        builder.append("<script src='/grid/resources/org/openqa/grid/images/consoleservlet.js'></script>");
        builder.append("<link href='/grid/resources/org/openqa/grid/images/consoleservlet.css' rel='stylesheet' type='text/css' />");
        builder.append("<link href='/grid/resources/org/openqa/grid/images/favicon.ico' rel='icon' type='image/x-icon' />");
        if (refresh != -1) {
            builder.append(String.format("<meta http-equiv='refresh' content='%d' />", refresh));
        }
        builder.append("<title>Grid Console</title>");
        builder.append("<style>");
        builder.append(".busy {");
        builder.append(" opacity : 0.4;");
        builder.append("filter: alpha(opacity=40);");
        builder.append("}");
        builder.append("</style>");
        builder.append("</head>");
        builder.append("<body>");
        builder.append("<div id='main-content'>");
        builder.append(this.getHeader());
        ArrayList<String> nodes = new ArrayList<String>();
        for (RemoteProxy proxy : this.getRegistry().getAllProxies()) {
            HtmlRenderer beta = proxy.getHtmlRender();
            nodes.add(beta.renderSummary());
        }
        int size = nodes.size();
        int rightColumnSize = size / 2;
        int leftColumnSize = size - rightColumnSize;
        builder.append("<div id='left-column'>");
        for (i = 0; i < leftColumnSize; ++i) {
            builder.append((String)nodes.get(i));
        }
        builder.append("</div>");
        builder.append("<div id='right-column'>");
        for (i = leftColumnSize; i < nodes.size(); ++i) {
            builder.append((String)nodes.get(i));
        }
        builder.append("</div>");
        builder.append("<div class='clearfix'></div>");
        builder.append(this.getRequestQueue());
        builder.append(this.getConfigInfo());
        builder.append("</div>");
        builder.append("</body>");
        builder.append("</html>");
        try (ByteArrayInputStream in = new ByteArrayInputStream(builder.toString().getBytes("UTF-8"));){
            ByteStreams.copy(in, response.getOutputStream());
        }
        finally {
            response.getOutputStream().close();
        }
    }

    private Object getRequestQueue() {
        StringBuilder builder = new StringBuilder();
        builder.append("<div>");
        int numUnprocessedRequests = this.getRegistry().getNewSessionRequestCount();
        if (numUnprocessedRequests > 0) {
            builder.append(String.format("%d requests waiting for a slot to be free.", numUnprocessedRequests));
        }
        builder.append("<ul>");
        for (DesiredCapabilities req : this.getRegistry().getDesiredCapabilities()) {
            builder.append("<li>").append(req).append("</li>");
        }
        builder.append("</ul>");
        builder.append("</div>");
        return builder.toString();
    }

    private Object getHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append("<div id='header'>");
        builder.append("<h1><a href='/grid/console'>Selenium</a></h1>");
        builder.append("<h2>Grid Console v.");
        builder.append(coreVersion);
        builder.append("</h2>");
        builder.append("<div><a id='helplink' target='_blank' href='https://github.com/SeleniumHQ/selenium/wiki/Grid2'>Help</a></div>");
        builder.append("</div>");
        return builder.toString();
    }

    private String getConfigInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("<div id='hub-config-container'>");
        GridHubConfiguration config = this.getRegistry().getHub().getConfiguration();
        builder.append("<div id='hub-config-content'>");
        builder.append("<b>Config for the hub :</b><br/>");
        builder.append(this.prettyHtmlPrint(config));
        builder.append(this.getVerboseConfig());
        builder.append("</div>");
        builder.append("<a id='config-view-toggle' href='#'>View Config</a>");
        builder.append("</div>");
        return builder.toString();
    }

    private String getVerboseConfig() {
        StringBuilder builder = new StringBuilder();
        GridHubConfiguration config = this.getRegistry().getHub().getConfiguration();
        builder.append("<div id='verbose-config-container'>");
        builder.append("<a id='verbose-config-view-toggle' href='#'>View Verbose</a>");
        builder.append("<div id='verbose-config-content'>");
        GridHubConfiguration tmp = new GridHubConfiguration();
        builder.append("<br/><b>The final configuration comes from:</b><br/>");
        builder.append("<b>the default :</b><br/>");
        builder.append(this.prettyHtmlPrint(tmp));
        if (config.getRawArgs() != null) {
            builder.append("<b>updated with command line options:</b><br/>");
            builder.append(String.join((CharSequence)" ", config.getRawArgs()));
            if (config.getConfigFile() != null) {
                builder.append("<br/><b>and configuration loaded from ").append(config.getConfigFile()).append(":</b><br/>");
                try {
                    builder.append(String.join((CharSequence)"<br/>", Files.readAllLines(new File(config.getConfigFile()).toPath())));
                }
                catch (IOException e) {
                    builder.append("<b>").append(e.getMessage()).append("</b>");
                }
            }
        }
        builder.append("</div>");
        builder.append("</div>");
        return builder.toString();
    }

    private String prettyHtmlPrint(GridHubConfiguration config) {
        return config.toString("<abbr title='%1$s'>%1$s : </abbr>%2$s</br>");
    }
}

