# Generated by default/object.tt
package Paws::GameLift::LocationAttributes;
  use Moose;
  has LocationState => (is => 'ro', isa => 'Paws::GameLift::LocationState');
  has StoppedActions => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has UpdateStatus => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::LocationAttributes

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::LocationAttributes object:

  $service_obj->Method(Att1 => { LocationState => $value, ..., UpdateStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::LocationAttributes object:

  $result = $service_obj->Method(...);
  $result->Att1->LocationState

=head1 DESCRIPTION

Represents a location in a multi-location fleet.

B<Related actions>

DescribeFleetLocationAttributes

=head1 ATTRIBUTES


=head2 LocationState => L<Paws::GameLift::LocationState>

A fleet location and its current life-cycle state.


=head2 StoppedActions => ArrayRef[Str|Undef]

A list of fleet actions that have been suspended in the fleet location.


=head2 UpdateStatus => Str

The status of fleet activity updates to the location. The status
C<PENDING_UPDATE> indicates that StopFleetActions or StartFleetActions
has been requested but the update has not yet been completed for the
location.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

